# -*- coding: utf-8 -*-
# Auto-generated by Stone, do not modify.
# @generated
# flake8: noqa
# pylint: skip-file
"""
This namespace contains endpoints and data types for file request operations.
"""

try:
    from . import stone_validators as bv
    from . import stone_base as bb
except (ImportError, SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import stone_validators as bv
    import stone_base as bb

try:
    from . import (
        common,
        files,
    )
except (ImportError, SystemError, ValueError):
    import common
    import files

class CreateFileRequestArgs(object):
    """
    Arguments for :meth:`dropbox.dropbox.Dropbox.file_requests_create`.

    :ivar title: The title of the file request. Must not be empty.
    :ivar destination: The path of the folder in the Dropbox where uploaded
        files will be sent. For apps with the app folder permission, this will
        be relative to the app folder.
    :ivar deadline: The deadline for the file request. Deadlines can only be set
        by Pro and Business accounts.
    :ivar open: Whether or not the file request should be open. If the file
        request is closed, it will not accept any file submissions, but it can
        be opened later.
    """

    __slots__ = [
        '_title_value',
        '_title_present',
        '_destination_value',
        '_destination_present',
        '_deadline_value',
        '_deadline_present',
        '_open_value',
        '_open_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 title=None,
                 destination=None,
                 deadline=None,
                 open=None):
        self._title_value = None
        self._title_present = False
        self._destination_value = None
        self._destination_present = False
        self._deadline_value = None
        self._deadline_present = False
        self._open_value = None
        self._open_present = False
        if title is not None:
            self.title = title
        if destination is not None:
            self.destination = destination
        if deadline is not None:
            self.deadline = deadline
        if open is not None:
            self.open = open

    @property
    def title(self):
        """
        The title of the file request. Must not be empty.

        :rtype: str
        """
        if self._title_present:
            return self._title_value
        else:
            raise AttributeError("missing required field 'title'")

    @title.setter
    def title(self, val):
        val = self._title_validator.validate(val)
        self._title_value = val
        self._title_present = True

    @title.deleter
    def title(self):
        self._title_value = None
        self._title_present = False

    @property
    def destination(self):
        """
        The path of the folder in the Dropbox where uploaded files will be sent.
        For apps with the app folder permission, this will be relative to the
        app folder.

        :rtype: str
        """
        if self._destination_present:
            return self._destination_value
        else:
            raise AttributeError("missing required field 'destination'")

    @destination.setter
    def destination(self, val):
        val = self._destination_validator.validate(val)
        self._destination_value = val
        self._destination_present = True

    @destination.deleter
    def destination(self):
        self._destination_value = None
        self._destination_present = False

    @property
    def deadline(self):
        """
        The deadline for the file request. Deadlines can only be set by Pro and
        Business accounts.

        :rtype: FileRequestDeadline
        """
        if self._deadline_present:
            return self._deadline_value
        else:
            return None

    @deadline.setter
    def deadline(self, val):
        if val is None:
            del self.deadline
            return
        self._deadline_validator.validate_type_only(val)
        self._deadline_value = val
        self._deadline_present = True

    @deadline.deleter
    def deadline(self):
        self._deadline_value = None
        self._deadline_present = False

    @property
    def open(self):
        """
        Whether or not the file request should be open. If the file request is
        closed, it will not accept any file submissions, but it can be opened
        later.

        :rtype: bool
        """
        if self._open_present:
            return self._open_value
        else:
            return True

    @open.setter
    def open(self, val):
        val = self._open_validator.validate(val)
        self._open_value = val
        self._open_present = True

    @open.deleter
    def open(self):
        self._open_value = None
        self._open_present = False

    def __repr__(self):
        return 'CreateFileRequestArgs(title={!r}, destination={!r}, deadline={!r}, open={!r})'.format(
            self._title_value,
            self._destination_value,
            self._deadline_value,
            self._open_value,
        )

CreateFileRequestArgs_validator = bv.Struct(CreateFileRequestArgs)

class GeneralFileRequestsError(bb.Union):
    """
    There is an error accessing the file requests functionality.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar disabled_for_team: This user's Dropbox Business team doesn't allow
        file requests.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled_for_team = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled_for_team(self):
        """
        Check if the union tag is ``disabled_for_team``.

        :rtype: bool
        """
        return self._tag == 'disabled_for_team'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'GeneralFileRequestsError(%r, %r)' % (self._tag, self._value)

GeneralFileRequestsError_validator = bv.Union(GeneralFileRequestsError)

class FileRequestError(GeneralFileRequestsError):
    """
    There is an error with the file request.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar not_found: This file request ID was not found.
    :ivar not_a_folder: The specified path is not a folder.
    :ivar app_lacks_access: This file request is not accessible to this app.
        Apps with the app folder permission can only access file requests in
        their app folder.
    :ivar no_permission: This user doesn't have permission to access or modify
        this file request.
    :ivar email_unverified: This user's email address is not verified. File
        requests are only available on accounts with a verified email address.
        Users can verify their email address `here
        <https://www.dropbox.com/help/317>`_.
    :ivar validation_error: There was an error validating the request. For
        example, the title was invalid, or there were disallowed characters in
        the destination path.
    """

    # Attribute is overwritten below the class definition
    not_found = None
    # Attribute is overwritten below the class definition
    not_a_folder = None
    # Attribute is overwritten below the class definition
    app_lacks_access = None
    # Attribute is overwritten below the class definition
    no_permission = None
    # Attribute is overwritten below the class definition
    email_unverified = None
    # Attribute is overwritten below the class definition
    validation_error = None

    def is_not_found(self):
        """
        Check if the union tag is ``not_found``.

        :rtype: bool
        """
        return self._tag == 'not_found'

    def is_not_a_folder(self):
        """
        Check if the union tag is ``not_a_folder``.

        :rtype: bool
        """
        return self._tag == 'not_a_folder'

    def is_app_lacks_access(self):
        """
        Check if the union tag is ``app_lacks_access``.

        :rtype: bool
        """
        return self._tag == 'app_lacks_access'

    def is_no_permission(self):
        """
        Check if the union tag is ``no_permission``.

        :rtype: bool
        """
        return self._tag == 'no_permission'

    def is_email_unverified(self):
        """
        Check if the union tag is ``email_unverified``.

        :rtype: bool
        """
        return self._tag == 'email_unverified'

    def is_validation_error(self):
        """
        Check if the union tag is ``validation_error``.

        :rtype: bool
        """
        return self._tag == 'validation_error'

    def __repr__(self):
        return 'FileRequestError(%r, %r)' % (self._tag, self._value)

FileRequestError_validator = bv.Union(FileRequestError)

class CreateFileRequestError(FileRequestError):
    """
    There was an error creating the file request.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar invalid_location: File requests are not available on the specified
        folder.
    :ivar rate_limit: The user has reached the rate limit for creating file
        requests. The limit is currently 100 file requests per day.
    """

    # Attribute is overwritten below the class definition
    invalid_location = None
    # Attribute is overwritten below the class definition
    rate_limit = None

    def is_invalid_location(self):
        """
        Check if the union tag is ``invalid_location``.

        :rtype: bool
        """
        return self._tag == 'invalid_location'

    def is_rate_limit(self):
        """
        Check if the union tag is ``rate_limit``.

        :rtype: bool
        """
        return self._tag == 'rate_limit'

    def __repr__(self):
        return 'CreateFileRequestError(%r, %r)' % (self._tag, self._value)

CreateFileRequestError_validator = bv.Union(CreateFileRequestError)

class FileRequest(object):
    """
    A `file request <https://www.dropbox.com/help/9090>`_ for receiving files
    into the user's Dropbox account.

    :ivar id: The ID of the file request.
    :ivar url: The URL of the file request.
    :ivar title: The title of the file request.
    :ivar destination: The path of the folder in the Dropbox where uploaded
        files will be sent. This can be None if the destination was removed. For
        apps with the app folder permission, this will be relative to the app
        folder.
    :ivar created: When this file request was created.
    :ivar deadline: The deadline for this file request. Only set if the request
        has a deadline.
    :ivar is_open: Whether or not the file request is open. If the file request
        is closed, it will not accept any more file submissions.
    :ivar file_count: The number of files this file request has received.
    """

    __slots__ = [
        '_id_value',
        '_id_present',
        '_url_value',
        '_url_present',
        '_title_value',
        '_title_present',
        '_destination_value',
        '_destination_present',
        '_created_value',
        '_created_present',
        '_deadline_value',
        '_deadline_present',
        '_is_open_value',
        '_is_open_present',
        '_file_count_value',
        '_file_count_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 id=None,
                 url=None,
                 title=None,
                 created=None,
                 is_open=None,
                 file_count=None,
                 destination=None,
                 deadline=None):
        self._id_value = None
        self._id_present = False
        self._url_value = None
        self._url_present = False
        self._title_value = None
        self._title_present = False
        self._destination_value = None
        self._destination_present = False
        self._created_value = None
        self._created_present = False
        self._deadline_value = None
        self._deadline_present = False
        self._is_open_value = None
        self._is_open_present = False
        self._file_count_value = None
        self._file_count_present = False
        if id is not None:
            self.id = id
        if url is not None:
            self.url = url
        if title is not None:
            self.title = title
        if destination is not None:
            self.destination = destination
        if created is not None:
            self.created = created
        if deadline is not None:
            self.deadline = deadline
        if is_open is not None:
            self.is_open = is_open
        if file_count is not None:
            self.file_count = file_count

    @property
    def id(self):
        """
        The ID of the file request.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def url(self):
        """
        The URL of the file request.

        :rtype: str
        """
        if self._url_present:
            return self._url_value
        else:
            raise AttributeError("missing required field 'url'")

    @url.setter
    def url(self, val):
        val = self._url_validator.validate(val)
        self._url_value = val
        self._url_present = True

    @url.deleter
    def url(self):
        self._url_value = None
        self._url_present = False

    @property
    def title(self):
        """
        The title of the file request.

        :rtype: str
        """
        if self._title_present:
            return self._title_value
        else:
            raise AttributeError("missing required field 'title'")

    @title.setter
    def title(self, val):
        val = self._title_validator.validate(val)
        self._title_value = val
        self._title_present = True

    @title.deleter
    def title(self):
        self._title_value = None
        self._title_present = False

    @property
    def destination(self):
        """
        The path of the folder in the Dropbox where uploaded files will be sent.
        This can be None if the destination was removed. For apps with the app
        folder permission, this will be relative to the app folder.

        :rtype: str
        """
        if self._destination_present:
            return self._destination_value
        else:
            return None

    @destination.setter
    def destination(self, val):
        if val is None:
            del self.destination
            return
        val = self._destination_validator.validate(val)
        self._destination_value = val
        self._destination_present = True

    @destination.deleter
    def destination(self):
        self._destination_value = None
        self._destination_present = False

    @property
    def created(self):
        """
        When this file request was created.

        :rtype: datetime.datetime
        """
        if self._created_present:
            return self._created_value
        else:
            raise AttributeError("missing required field 'created'")

    @created.setter
    def created(self, val):
        val = self._created_validator.validate(val)
        self._created_value = val
        self._created_present = True

    @created.deleter
    def created(self):
        self._created_value = None
        self._created_present = False

    @property
    def deadline(self):
        """
        The deadline for this file request. Only set if the request has a
        deadline.

        :rtype: FileRequestDeadline
        """
        if self._deadline_present:
            return self._deadline_value
        else:
            return None

    @deadline.setter
    def deadline(self, val):
        if val is None:
            del self.deadline
            return
        self._deadline_validator.validate_type_only(val)
        self._deadline_value = val
        self._deadline_present = True

    @deadline.deleter
    def deadline(self):
        self._deadline_value = None
        self._deadline_present = False

    @property
    def is_open(self):
        """
        Whether or not the file request is open. If the file request is closed,
        it will not accept any more file submissions.

        :rtype: bool
        """
        if self._is_open_present:
            return self._is_open_value
        else:
            raise AttributeError("missing required field 'is_open'")

    @is_open.setter
    def is_open(self, val):
        val = self._is_open_validator.validate(val)
        self._is_open_value = val
        self._is_open_present = True

    @is_open.deleter
    def is_open(self):
        self._is_open_value = None
        self._is_open_present = False

    @property
    def file_count(self):
        """
        The number of files this file request has received.

        :rtype: long
        """
        if self._file_count_present:
            return self._file_count_value
        else:
            raise AttributeError("missing required field 'file_count'")

    @file_count.setter
    def file_count(self, val):
        val = self._file_count_validator.validate(val)
        self._file_count_value = val
        self._file_count_present = True

    @file_count.deleter
    def file_count(self):
        self._file_count_value = None
        self._file_count_present = False

    def __repr__(self):
        return 'FileRequest(id={!r}, url={!r}, title={!r}, created={!r}, is_open={!r}, file_count={!r}, destination={!r}, deadline={!r})'.format(
            self._id_value,
            self._url_value,
            self._title_value,
            self._created_value,
            self._is_open_value,
            self._file_count_value,
            self._destination_value,
            self._deadline_value,
        )

FileRequest_validator = bv.Struct(FileRequest)

class FileRequestDeadline(object):
    """
    :ivar deadline: The deadline for this file request.
    :ivar allow_late_uploads: If set, allow uploads after the deadline has
        passed. These     uploads will be marked overdue.
    """

    __slots__ = [
        '_deadline_value',
        '_deadline_present',
        '_allow_late_uploads_value',
        '_allow_late_uploads_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 deadline=None,
                 allow_late_uploads=None):
        self._deadline_value = None
        self._deadline_present = False
        self._allow_late_uploads_value = None
        self._allow_late_uploads_present = False
        if deadline is not None:
            self.deadline = deadline
        if allow_late_uploads is not None:
            self.allow_late_uploads = allow_late_uploads

    @property
    def deadline(self):
        """
        The deadline for this file request.

        :rtype: datetime.datetime
        """
        if self._deadline_present:
            return self._deadline_value
        else:
            raise AttributeError("missing required field 'deadline'")

    @deadline.setter
    def deadline(self, val):
        val = self._deadline_validator.validate(val)
        self._deadline_value = val
        self._deadline_present = True

    @deadline.deleter
    def deadline(self):
        self._deadline_value = None
        self._deadline_present = False

    @property
    def allow_late_uploads(self):
        """
        If set, allow uploads after the deadline has passed. These     uploads
        will be marked overdue.

        :rtype: GracePeriod
        """
        if self._allow_late_uploads_present:
            return self._allow_late_uploads_value
        else:
            return None

    @allow_late_uploads.setter
    def allow_late_uploads(self, val):
        if val is None:
            del self.allow_late_uploads
            return
        self._allow_late_uploads_validator.validate_type_only(val)
        self._allow_late_uploads_value = val
        self._allow_late_uploads_present = True

    @allow_late_uploads.deleter
    def allow_late_uploads(self):
        self._allow_late_uploads_value = None
        self._allow_late_uploads_present = False

    def __repr__(self):
        return 'FileRequestDeadline(deadline={!r}, allow_late_uploads={!r})'.format(
            self._deadline_value,
            self._allow_late_uploads_value,
        )

FileRequestDeadline_validator = bv.Struct(FileRequestDeadline)

class GetFileRequestArgs(object):
    """
    Arguments for :meth:`dropbox.dropbox.Dropbox.file_requests_get`.

    :ivar id: The ID of the file request to retrieve.
    """

    __slots__ = [
        '_id_value',
        '_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 id=None):
        self._id_value = None
        self._id_present = False
        if id is not None:
            self.id = id

    @property
    def id(self):
        """
        The ID of the file request to retrieve.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    def __repr__(self):
        return 'GetFileRequestArgs(id={!r})'.format(
            self._id_value,
        )

GetFileRequestArgs_validator = bv.Struct(GetFileRequestArgs)

class GetFileRequestError(FileRequestError):
    """
    There was an error retrieving the specified file request.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    def __repr__(self):
        return 'GetFileRequestError(%r, %r)' % (self._tag, self._value)

GetFileRequestError_validator = bv.Union(GetFileRequestError)

class GracePeriod(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    one_day = None
    # Attribute is overwritten below the class definition
    two_days = None
    # Attribute is overwritten below the class definition
    seven_days = None
    # Attribute is overwritten below the class definition
    thirty_days = None
    # Attribute is overwritten below the class definition
    always = None
    # Attribute is overwritten below the class definition
    other = None

    def is_one_day(self):
        """
        Check if the union tag is ``one_day``.

        :rtype: bool
        """
        return self._tag == 'one_day'

    def is_two_days(self):
        """
        Check if the union tag is ``two_days``.

        :rtype: bool
        """
        return self._tag == 'two_days'

    def is_seven_days(self):
        """
        Check if the union tag is ``seven_days``.

        :rtype: bool
        """
        return self._tag == 'seven_days'

    def is_thirty_days(self):
        """
        Check if the union tag is ``thirty_days``.

        :rtype: bool
        """
        return self._tag == 'thirty_days'

    def is_always(self):
        """
        Check if the union tag is ``always``.

        :rtype: bool
        """
        return self._tag == 'always'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'GracePeriod(%r, %r)' % (self._tag, self._value)

GracePeriod_validator = bv.Union(GracePeriod)

class ListFileRequestsError(GeneralFileRequestsError):
    """
    There was an error retrieving the file requests.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    def __repr__(self):
        return 'ListFileRequestsError(%r, %r)' % (self._tag, self._value)

ListFileRequestsError_validator = bv.Union(ListFileRequestsError)

class ListFileRequestsResult(object):
    """
    Result for :meth:`dropbox.dropbox.Dropbox.file_requests_list`.

    :ivar file_requests: The file requests owned by this user. Apps with the app
        folder permission will only see file requests in their app folder.
    """

    __slots__ = [
        '_file_requests_value',
        '_file_requests_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 file_requests=None):
        self._file_requests_value = None
        self._file_requests_present = False
        if file_requests is not None:
            self.file_requests = file_requests

    @property
    def file_requests(self):
        """
        The file requests owned by this user. Apps with the app folder
        permission will only see file requests in their app folder.

        :rtype: list of [FileRequest]
        """
        if self._file_requests_present:
            return self._file_requests_value
        else:
            raise AttributeError("missing required field 'file_requests'")

    @file_requests.setter
    def file_requests(self, val):
        val = self._file_requests_validator.validate(val)
        self._file_requests_value = val
        self._file_requests_present = True

    @file_requests.deleter
    def file_requests(self):
        self._file_requests_value = None
        self._file_requests_present = False

    def __repr__(self):
        return 'ListFileRequestsResult(file_requests={!r})'.format(
            self._file_requests_value,
        )

ListFileRequestsResult_validator = bv.Struct(ListFileRequestsResult)

class UpdateFileRequestArgs(object):
    """
    Arguments for :meth:`dropbox.dropbox.Dropbox.file_requests_update`.

    :ivar id: The ID of the file request to update.
    :ivar title: The new title of the file request. Must not be empty.
    :ivar destination: The new path of the folder in the Dropbox where uploaded
        files will be sent. For apps with the app folder permission, this will
        be relative to the app folder.
    :ivar deadline: The new deadline for the file request.
    :ivar open: Whether to set this file request as open or closed.
    """

    __slots__ = [
        '_id_value',
        '_id_present',
        '_title_value',
        '_title_present',
        '_destination_value',
        '_destination_present',
        '_deadline_value',
        '_deadline_present',
        '_open_value',
        '_open_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 id=None,
                 title=None,
                 destination=None,
                 deadline=None,
                 open=None):
        self._id_value = None
        self._id_present = False
        self._title_value = None
        self._title_present = False
        self._destination_value = None
        self._destination_present = False
        self._deadline_value = None
        self._deadline_present = False
        self._open_value = None
        self._open_present = False
        if id is not None:
            self.id = id
        if title is not None:
            self.title = title
        if destination is not None:
            self.destination = destination
        if deadline is not None:
            self.deadline = deadline
        if open is not None:
            self.open = open

    @property
    def id(self):
        """
        The ID of the file request to update.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def title(self):
        """
        The new title of the file request. Must not be empty.

        :rtype: str
        """
        if self._title_present:
            return self._title_value
        else:
            return None

    @title.setter
    def title(self, val):
        if val is None:
            del self.title
            return
        val = self._title_validator.validate(val)
        self._title_value = val
        self._title_present = True

    @title.deleter
    def title(self):
        self._title_value = None
        self._title_present = False

    @property
    def destination(self):
        """
        The new path of the folder in the Dropbox where uploaded files will be
        sent. For apps with the app folder permission, this will be relative to
        the app folder.

        :rtype: str
        """
        if self._destination_present:
            return self._destination_value
        else:
            return None

    @destination.setter
    def destination(self, val):
        if val is None:
            del self.destination
            return
        val = self._destination_validator.validate(val)
        self._destination_value = val
        self._destination_present = True

    @destination.deleter
    def destination(self):
        self._destination_value = None
        self._destination_present = False

    @property
    def deadline(self):
        """
        The new deadline for the file request.

        :rtype: UpdateFileRequestDeadline
        """
        if self._deadline_present:
            return self._deadline_value
        else:
            return UpdateFileRequestDeadline.no_update

    @deadline.setter
    def deadline(self, val):
        self._deadline_validator.validate_type_only(val)
        self._deadline_value = val
        self._deadline_present = True

    @deadline.deleter
    def deadline(self):
        self._deadline_value = None
        self._deadline_present = False

    @property
    def open(self):
        """
        Whether to set this file request as open or closed.

        :rtype: bool
        """
        if self._open_present:
            return self._open_value
        else:
            return None

    @open.setter
    def open(self, val):
        if val is None:
            del self.open
            return
        val = self._open_validator.validate(val)
        self._open_value = val
        self._open_present = True

    @open.deleter
    def open(self):
        self._open_value = None
        self._open_present = False

    def __repr__(self):
        return 'UpdateFileRequestArgs(id={!r}, title={!r}, destination={!r}, deadline={!r}, open={!r})'.format(
            self._id_value,
            self._title_value,
            self._destination_value,
            self._deadline_value,
            self._open_value,
        )

UpdateFileRequestArgs_validator = bv.Struct(UpdateFileRequestArgs)

class UpdateFileRequestDeadline(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar no_update: Do not change the file request's deadline.
    :ivar Optional[FileRequestDeadline] update: If :val:`null`, the file
        request's deadline is cleared.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    no_update = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def update(cls, val):
        """
        Create an instance of this class set to the ``update`` tag with value
        ``val``.

        :param FileRequestDeadline val:
        :rtype: UpdateFileRequestDeadline
        """
        return cls('update', val)

    def is_no_update(self):
        """
        Check if the union tag is ``no_update``.

        :rtype: bool
        """
        return self._tag == 'no_update'

    def is_update(self):
        """
        Check if the union tag is ``update``.

        :rtype: bool
        """
        return self._tag == 'update'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_update(self):
        """
        If None, the file request's deadline is cleared.

        Only call this if :meth:`is_update` is true.

        :rtype: FileRequestDeadline
        """
        if not self.is_update():
            raise AttributeError("tag 'update' not set")
        return self._value

    def __repr__(self):
        return 'UpdateFileRequestDeadline(%r, %r)' % (self._tag, self._value)

UpdateFileRequestDeadline_validator = bv.Union(UpdateFileRequestDeadline)

class UpdateFileRequestError(FileRequestError):
    """
    There is an error updating the file request.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    def __repr__(self):
        return 'UpdateFileRequestError(%r, %r)' % (self._tag, self._value)

UpdateFileRequestError_validator = bv.Union(UpdateFileRequestError)

FileRequestId_validator = bv.String(min_length=1, pattern=u'[-_0-9a-zA-Z]+')
FileRequestValidationError_validator = bv.Nullable(bv.String())
CreateFileRequestArgs._title_validator = bv.String(min_length=1)
CreateFileRequestArgs._destination_validator = files.Path_validator
CreateFileRequestArgs._deadline_validator = bv.Nullable(FileRequestDeadline_validator)
CreateFileRequestArgs._open_validator = bv.Boolean()
CreateFileRequestArgs._all_field_names_ = set([
    'title',
    'destination',
    'deadline',
    'open',
])
CreateFileRequestArgs._all_fields_ = [
    ('title', CreateFileRequestArgs._title_validator),
    ('destination', CreateFileRequestArgs._destination_validator),
    ('deadline', CreateFileRequestArgs._deadline_validator),
    ('open', CreateFileRequestArgs._open_validator),
]

GeneralFileRequestsError._disabled_for_team_validator = bv.Void()
GeneralFileRequestsError._other_validator = bv.Void()
GeneralFileRequestsError._tagmap = {
    'disabled_for_team': GeneralFileRequestsError._disabled_for_team_validator,
    'other': GeneralFileRequestsError._other_validator,
}

GeneralFileRequestsError.disabled_for_team = GeneralFileRequestsError('disabled_for_team')
GeneralFileRequestsError.other = GeneralFileRequestsError('other')

FileRequestError._not_found_validator = bv.Void()
FileRequestError._not_a_folder_validator = bv.Void()
FileRequestError._app_lacks_access_validator = bv.Void()
FileRequestError._no_permission_validator = bv.Void()
FileRequestError._email_unverified_validator = bv.Void()
FileRequestError._validation_error_validator = bv.Void()
FileRequestError._tagmap = {
    'not_found': FileRequestError._not_found_validator,
    'not_a_folder': FileRequestError._not_a_folder_validator,
    'app_lacks_access': FileRequestError._app_lacks_access_validator,
    'no_permission': FileRequestError._no_permission_validator,
    'email_unverified': FileRequestError._email_unverified_validator,
    'validation_error': FileRequestError._validation_error_validator,
}
FileRequestError._tagmap.update(GeneralFileRequestsError._tagmap)

FileRequestError.not_found = FileRequestError('not_found')
FileRequestError.not_a_folder = FileRequestError('not_a_folder')
FileRequestError.app_lacks_access = FileRequestError('app_lacks_access')
FileRequestError.no_permission = FileRequestError('no_permission')
FileRequestError.email_unverified = FileRequestError('email_unverified')
FileRequestError.validation_error = FileRequestError('validation_error')

CreateFileRequestError._invalid_location_validator = bv.Void()
CreateFileRequestError._rate_limit_validator = bv.Void()
CreateFileRequestError._tagmap = {
    'invalid_location': CreateFileRequestError._invalid_location_validator,
    'rate_limit': CreateFileRequestError._rate_limit_validator,
}
CreateFileRequestError._tagmap.update(FileRequestError._tagmap)

CreateFileRequestError.invalid_location = CreateFileRequestError('invalid_location')
CreateFileRequestError.rate_limit = CreateFileRequestError('rate_limit')

FileRequest._id_validator = FileRequestId_validator
FileRequest._url_validator = bv.String(min_length=1)
FileRequest._title_validator = bv.String(min_length=1)
FileRequest._destination_validator = bv.Nullable(files.Path_validator)
FileRequest._created_validator = common.DropboxTimestamp_validator
FileRequest._deadline_validator = bv.Nullable(FileRequestDeadline_validator)
FileRequest._is_open_validator = bv.Boolean()
FileRequest._file_count_validator = bv.Int64()
FileRequest._all_field_names_ = set([
    'id',
    'url',
    'title',
    'destination',
    'created',
    'deadline',
    'is_open',
    'file_count',
])
FileRequest._all_fields_ = [
    ('id', FileRequest._id_validator),
    ('url', FileRequest._url_validator),
    ('title', FileRequest._title_validator),
    ('destination', FileRequest._destination_validator),
    ('created', FileRequest._created_validator),
    ('deadline', FileRequest._deadline_validator),
    ('is_open', FileRequest._is_open_validator),
    ('file_count', FileRequest._file_count_validator),
]

FileRequestDeadline._deadline_validator = common.DropboxTimestamp_validator
FileRequestDeadline._allow_late_uploads_validator = bv.Nullable(GracePeriod_validator)
FileRequestDeadline._all_field_names_ = set([
    'deadline',
    'allow_late_uploads',
])
FileRequestDeadline._all_fields_ = [
    ('deadline', FileRequestDeadline._deadline_validator),
    ('allow_late_uploads', FileRequestDeadline._allow_late_uploads_validator),
]

GetFileRequestArgs._id_validator = FileRequestId_validator
GetFileRequestArgs._all_field_names_ = set(['id'])
GetFileRequestArgs._all_fields_ = [('id', GetFileRequestArgs._id_validator)]

GetFileRequestError._tagmap = {
}
GetFileRequestError._tagmap.update(FileRequestError._tagmap)

GracePeriod._one_day_validator = bv.Void()
GracePeriod._two_days_validator = bv.Void()
GracePeriod._seven_days_validator = bv.Void()
GracePeriod._thirty_days_validator = bv.Void()
GracePeriod._always_validator = bv.Void()
GracePeriod._other_validator = bv.Void()
GracePeriod._tagmap = {
    'one_day': GracePeriod._one_day_validator,
    'two_days': GracePeriod._two_days_validator,
    'seven_days': GracePeriod._seven_days_validator,
    'thirty_days': GracePeriod._thirty_days_validator,
    'always': GracePeriod._always_validator,
    'other': GracePeriod._other_validator,
}

GracePeriod.one_day = GracePeriod('one_day')
GracePeriod.two_days = GracePeriod('two_days')
GracePeriod.seven_days = GracePeriod('seven_days')
GracePeriod.thirty_days = GracePeriod('thirty_days')
GracePeriod.always = GracePeriod('always')
GracePeriod.other = GracePeriod('other')

ListFileRequestsError._tagmap = {
}
ListFileRequestsError._tagmap.update(GeneralFileRequestsError._tagmap)

ListFileRequestsResult._file_requests_validator = bv.List(FileRequest_validator)
ListFileRequestsResult._all_field_names_ = set(['file_requests'])
ListFileRequestsResult._all_fields_ = [('file_requests', ListFileRequestsResult._file_requests_validator)]

UpdateFileRequestArgs._id_validator = FileRequestId_validator
UpdateFileRequestArgs._title_validator = bv.Nullable(bv.String(min_length=1))
UpdateFileRequestArgs._destination_validator = bv.Nullable(files.Path_validator)
UpdateFileRequestArgs._deadline_validator = UpdateFileRequestDeadline_validator
UpdateFileRequestArgs._open_validator = bv.Nullable(bv.Boolean())
UpdateFileRequestArgs._all_field_names_ = set([
    'id',
    'title',
    'destination',
    'deadline',
    'open',
])
UpdateFileRequestArgs._all_fields_ = [
    ('id', UpdateFileRequestArgs._id_validator),
    ('title', UpdateFileRequestArgs._title_validator),
    ('destination', UpdateFileRequestArgs._destination_validator),
    ('deadline', UpdateFileRequestArgs._deadline_validator),
    ('open', UpdateFileRequestArgs._open_validator),
]

UpdateFileRequestDeadline._no_update_validator = bv.Void()
UpdateFileRequestDeadline._update_validator = bv.Nullable(FileRequestDeadline_validator)
UpdateFileRequestDeadline._other_validator = bv.Void()
UpdateFileRequestDeadline._tagmap = {
    'no_update': UpdateFileRequestDeadline._no_update_validator,
    'update': UpdateFileRequestDeadline._update_validator,
    'other': UpdateFileRequestDeadline._other_validator,
}

UpdateFileRequestDeadline.no_update = UpdateFileRequestDeadline('no_update')
UpdateFileRequestDeadline.other = UpdateFileRequestDeadline('other')

UpdateFileRequestError._tagmap = {
}
UpdateFileRequestError._tagmap.update(FileRequestError._tagmap)

create = bb.Route(
    'create',
    1,
    False,
    CreateFileRequestArgs_validator,
    FileRequest_validator,
    CreateFileRequestError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
get = bb.Route(
    'get',
    1,
    False,
    GetFileRequestArgs_validator,
    FileRequest_validator,
    GetFileRequestError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
list = bb.Route(
    'list',
    1,
    False,
    bv.Void(),
    ListFileRequestsResult_validator,
    ListFileRequestsError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
update = bb.Route(
    'update',
    1,
    False,
    UpdateFileRequestArgs_validator,
    FileRequest_validator,
    UpdateFileRequestError_validator,
    {'host': u'api',
     'style': u'rpc'},
)

ROUTES = {
    'create': create,
    'get': get,
    'list': list,
    'update': update,
}

