/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AsyncResult;
import Ice.BooleanHolder;
import Ice.Communicator;
import Ice.CompressBatch;
import Ice.Connection;
import Ice.ConnectionI;
import Ice.Exception;
import IceInternal.CallbackBase;
import IceInternal.Instance;
import IceInternal.OutgoingAsyncBase;
import IceInternal.RetryException;
import java.util.concurrent.Callable;

public class ConnectionFlushBatch
extends OutgoingAsyncBase {
    private ConnectionI _connection;

    public static ConnectionFlushBatch check(AsyncResult r, Connection con, String operation) {
        ConnectionFlushBatch.check(r, operation);
        if (!(r instanceof ConnectionFlushBatch)) {
            throw new IllegalArgumentException("Incorrect AsyncResult object for end_" + operation + " method");
        }
        if (r.getConnection() != con) {
            throw new IllegalArgumentException("Connection for call to end_" + operation + " does not match connection that was used to call corresponding begin_" + operation + " method");
        }
        return (ConnectionFlushBatch)r;
    }

    public ConnectionFlushBatch(ConnectionI con, Communicator communicator, Instance instance, String operation, CallbackBase callback) {
        super(communicator, instance, operation, callback);
        this._connection = con;
    }

    @Override
    public Connection getConnection() {
        return this._connection;
    }

    public void invoke(final CompressBatch compressBatch) {
        block11: {
            try {
                int status;
                final BooleanHolder compress = new BooleanHolder();
                final int batchRequestNum = this._connection.getBatchRequestQueue().swap(this._os, compress);
                if (batchRequestNum == 0) {
                    status = 1;
                    if (this.sent()) {
                        status |= 2;
                    }
                } else if (this._instance.queueRequests()) {
                    status = this._instance.getQueueExecutor().execute(new Callable<Integer>(){

                        @Override
                        public Integer call() throws RetryException {
                            boolean comp = compressBatch == CompressBatch.Yes ? true : (compressBatch == CompressBatch.No ? false : (Boolean)compress.value);
                            return ConnectionFlushBatch.this._connection.sendAsyncRequest(ConnectionFlushBatch.this, comp, false, batchRequestNum);
                        }
                    });
                } else {
                    boolean comp = compressBatch == CompressBatch.Yes ? true : (compressBatch == CompressBatch.No ? false : (Boolean)compress.value);
                    status = this._connection.sendAsyncRequest(this, comp, false, batchRequestNum);
                }
                if ((status & 1) > 0) {
                    this._sentSynchronously = true;
                    if ((status & 2) > 0) {
                        this.invokeSent();
                    }
                }
            }
            catch (RetryException ex) {
                if (this.completed(ex.get())) {
                    this.invokeCompletedAsync();
                }
            }
            catch (Exception ex) {
                if (!this.completed(ex)) break block11;
                this.invokeCompletedAsync();
            }
        }
    }
}

