/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class InputStreamWrapper
extends InputStream {
    private ByteBuffer _buf;
    private int _markPos;

    public InputStreamWrapper(int size, ByteBuffer buf) {
        this._buf = buf;
        this._markPos = 0;
    }

    @Override
    public int read() throws IOException {
        try {
            return this._buf.get();
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int count) throws IOException {
        try {
            this._buf.get(b, offset, count);
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
        return count;
    }

    @Override
    public int available() {
        return this._buf.remaining();
    }

    @Override
    public void mark(int readlimit) {
        this._markPos = this._buf.position();
    }

    @Override
    public void reset() throws IOException {
        ((Buffer)this._buf).position(this._markPos);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

