// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Locator.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Ice;

/**
 * The Ice locator interface. This interface is used by clients to
 * lookup adapters and objects. It is also used by servers to get the
 * locator registry proxy.
 *
 * <p class="Note">The {@link Locator} interface is intended to be used by
 * Ice internals and by locator implementations. Regular user code
 * should not attempt to use any functionality of this interface
 * directly.
 *
 **/
public interface _LocatorOperations
{
    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     *
     * @param cb The callback object for the operation.
     * @param id The identity.
     *
     * @param current The Current object for the invocation.
     * @throws ObjectNotFoundException Raised if the object cannot
     * be found.
     *
     **/
    void findObjectById_async(AMD_Locator_findObjectById cb, Identity id, Current current)
        throws ObjectNotFoundException;

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     *
     * @param cb The callback object for the operation.
     * @param id The adapter id.
     *
     * @param current The Current object for the invocation.
     * @throws AdapterNotFoundException Raised if the adapter cannot be
     * found.
     *
     **/
    void findAdapterById_async(AMD_Locator_findAdapterById cb, String id, Current current)
        throws AdapterNotFoundException;

    /**
     * Get the locator registry.
     *
     * @param current The Current object for the invocation.
     * @return The locator registry.
     *
     **/
    LocatorRegistryPrx getRegistry(Current current);
}
