// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `IceBox.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceBox;

/**
 * Administers a set of {@link Service} instances.
 *
 * @see Service
 *
 **/
public interface _ServiceManagerOperationsNC
{
    /**
     * Returns the checksums for the IceBox Slice definitions.
     *
     * @return A dictionary mapping Slice type ids to their checksums.
     *
     **/
    java.util.Map<java.lang.String, java.lang.String> getSliceChecksums();

    /**
     * Start an individual service.
     *
     * @param service The service name.
     *
     * @throws AlreadyStartedException If the service is already running.
     * @throws NoSuchServiceException If no service could be found with the given name.
     **/
    void startService(String service)
        throws AlreadyStartedException,
               NoSuchServiceException;

    /**
     * Stop an individual service.
     *
     * @param service The service name.
     *
     * @throws AlreadyStoppedException If the service is already stopped.
     * @throws NoSuchServiceException If no service could be found with the given name.
     **/
    void stopService(String service)
        throws AlreadyStoppedException,
               NoSuchServiceException;

    /**
     * Registers a new observer with the ServiceManager.
     *
     * @param observer The new observer
     *
     **/
    void addObserver(ServiceObserverPrx observer);

    /**
     * Shut down all services. This causes stop to be invoked on all configured services.
     *
     **/
    void shutdown();
}
