/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel.desktopintegrationeditor;

import java.io.File;
import java.util.List;
import javax.swing.JList;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import net.sourceforge.jnlp.controlpanel.desktopintegrationeditor.FreeDesktopIntegrationEditorFrame;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

public class PreviewSelectionJTextPane
extends JTextPane {
    private final JList iconsList;
    private final JList menuList;
    private final JList desktopList;
    private final JList generatedList;

    public PreviewSelectionJTextPane(JList iconsList, JList menuList, JList desktopList, JList generatedList) {
        this.iconsList = iconsList;
        this.menuList = menuList;
        this.desktopList = desktopList;
        this.generatedList = generatedList;
        this.setEditorKit(new HTMLEditorKit());
        this.setEditable(false);
    }

    private StringBuilder getMenus() {
        return this.getTextFiles(this.menuList.getSelectedValuesList());
    }

    private StringBuilder getDesktops() {
        return this.getTextFiles(this.desktopList.getSelectedValuesList());
    }

    private StringBuilder getGenerated() {
        return this.getTextFiles(this.generatedList.getSelectedValuesList());
    }

    private StringBuilder getHeader(boolean i, boolean d, boolean m, boolean g) {
        StringBuilder sb = new StringBuilder();
        if (i || d || m || g) {
            sb.append("<tr>");
        }
        if (i) {
            sb.append("<th>").append(Translator.R("DIMicons")).append(":</th>");
        }
        if (d) {
            sb.append("<th>").append(Translator.R("DIMdesktopItems")).append(":</th>");
        }
        if (m) {
            sb.append("<th>").append(Translator.R("DIMmenuItems")).append(":</th>");
        }
        if (g) {
            sb.append("<th>").append(Translator.R("DIMgeneratedJnlps")).append(":</th>");
        }
        if (i || d || m || g) {
            sb.append("</tr>");
        }
        return sb;
    }

    public void generatePreview() {
        try {
            StringBuilder sb = new StringBuilder("<html><table>");
            sb.append((CharSequence)this.getHeader(this.iconsList.getSelectedIndices().length > 0, this.menuList.getSelectedIndices().length > 0, this.desktopList.getSelectedIndices().length > 0, this.generatedList.getSelectedIndices().length > 0)).append("<tr>");
            if (this.iconsList.getSelectedIndices().length > 0) {
                sb.append("<td>").append((CharSequence)this.getIcons()).append("</td>");
            }
            if (this.menuList.getSelectedIndices().length > 0) {
                sb.append("<td>").append((CharSequence)this.getMenus()).append("</td>");
            }
            if (this.desktopList.getSelectedIndices().length > 0) {
                sb.append("<td>").append((CharSequence)this.getDesktops()).append("</td>");
            }
            if (this.generatedList.getSelectedIndices().length > 0) {
                sb.append("<td>").append((CharSequence)this.getGenerated()).append("</td>");
            }
            sb.append("</tr></table></html>");
            this.setText(sb.toString());
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
        }
    }

    private StringBuilder getIcons() {
        StringBuilder s = new StringBuilder();
        try {
            List l = this.iconsList.getSelectedValuesList();
            for (Object l1 : l) {
                File f = (File)l1;
                s.append("<small>").append(f.getAbsolutePath()).append("</small><br>");
                s.append("<img src='").append(f.toURI().toURL()).append("'></img><br>");
            }
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
        }
        return s;
    }

    private StringBuilder getTextFiles(List selectedValuesList) {
        StringBuilder s = new StringBuilder();
        for (Object i : selectedValuesList) {
            File f = (File)i;
            s.append("<small>").append(f.getAbsolutePath()).append("</small><br>");
            s.append("<pre>").append(FreeDesktopIntegrationEditorFrame.fileToString(f, true)).append("</pre><br>");
        }
        return s;
    }
}

