/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.CaseChangeable;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.EgChar;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.Letter;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.NumericExpansion;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.Register;
import com.dickimawbooks.texparserlib.SkippedEols;
import com.dickimawbooks.texparserlib.SkippedSpaces;
import com.dickimawbooks.texparserlib.StackMarker;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXGlue;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.UserDimension;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.generic.MathSymbol;
import com.dickimawbooks.texparserlib.primitives.EndCs;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Vector;

public class TeXObjectList
extends Vector<TeXObject>
implements TeXObject,
Expandable,
CaseChangeable {
    private ArrayDeque<Declaration> declarations = new ArrayDeque();
    public static byte POP_SHORT = 1;
    public static byte POP_RETAIN_IGNOREABLES = (byte)2;
    public static byte POP_IGNORE_LEADING_SPACE = (byte)4;

    public TeXObjectList() {
    }

    public TeXObjectList(int n) {
        super(n);
    }

    public TeXObjectList(TeXParserListener teXParserListener, String string) {
        this(string.length() > 0 ? string.length() : 10);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.add(teXParserListener.getOther(string.codePointAt(i)));
        }
    }

    public TeXObject expandedPopStack(TeXParser teXParser) throws IOException {
        return this.expandedPopStack(teXParser, (byte)0);
    }

    public TeXObject expandedPopStack(TeXParser teXParser, byte by) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject;
        if (this.size() == 0) {
            return null;
        }
        this.flatten();
        TeXObject teXObject2 = this.popStack(teXParser, by);
        if (TeXObjectList.isIgnoreLeadingSpace(by)) {
            by = (byte)(by ^ POP_IGNORE_LEADING_SPACE);
        }
        if (teXObject2 instanceof TeXCsRef && (teXObject2 = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject2).getName())) instanceof EndCs) {
            return teXObject2;
        }
        if (teXObject2 instanceof Group) {
            teXObject = (Group)teXObject2;
            teXObjectList = ((Group)teXObject).expandfully(teXParser, this);
            BgChar bgChar = teXParser.isBeginGroup((TeXObject)teXObjectList.get(0));
            if (bgChar != null) {
                teXObjectList.pop();
                teXObject = bgChar.createGroup(teXParser);
                teXObjectList.popRemainingGroup(teXParser, (Group)teXObject, by, bgChar);
                if (!teXObjectList.isEmpty()) {
                    this.addAll(0, teXObjectList);
                }
                return teXObject;
            }
            this.addAll(0, teXObjectList);
            teXObject2 = this.popStack(teXParser, by);
        }
        if ((teXObject = teXParser.isBeginGroup(teXObject2)) != null) {
            teXObjectList = ((BgChar)teXObject).createGroup(teXParser);
            this.popRemainingGroup(teXParser, (Group)teXObjectList, by, (BgChar)teXObject);
            return teXObjectList;
        }
        if (teXObject2 instanceof NumericExpansion) {
            return ((NumericExpansion)teXObject2).expandToNumber(teXParser, this);
        }
        if (!(teXObject2 instanceof Expandable)) {
            return teXObject2;
        }
        teXObjectList = ((Expandable)((Object)teXObject2)).expandfully(teXParser, this);
        if (teXObjectList == null) {
            return teXObject2;
        }
        return teXObjectList;
    }

    public TeXObject popStack(TeXParser teXParser) throws IOException {
        return this.popStack(teXParser, (byte)0);
    }

    public TeXObject popStack(TeXParser teXParser, byte by) throws IOException {
        TeXObject teXObject;
        boolean bl = !TeXObjectList.isRetainIgnoreables(by);
        boolean bl2 = TeXObjectList.isIgnoreLeadingSpace(by);
        if (bl && bl2) {
            while (this.size() > 0 && ((teXObject = (TeXObject)this.get(0)) instanceof Ignoreable || teXObject instanceof WhiteSpace)) {
                this.pop();
            }
        } else if (bl) {
            while (this.size() > 0 && this.get(0) instanceof Ignoreable) {
                this.pop();
            }
        } else if (bl2) {
            while (this.size() > 0 && this.get(0) instanceof WhiteSpace) {
                this.pop();
            }
        }
        if (this.size() == 0) {
            return null;
        }
        if (TeXObjectList.isIgnoreLeadingSpace(by)) {
            by = (byte)(by ^ POP_IGNORE_LEADING_SPACE);
        }
        teXObject = this.pop();
        if (TeXObjectList.isShort(by) && teXObject.isPar()) {
            throw new TeXSyntaxException(teXParser, "tex.error.par_before_eg", new Object[0]);
        }
        BgChar bgChar = null;
        if (teXParser != null) {
            bgChar = teXParser.isBeginGroup(teXObject);
        }
        if (bgChar != null) {
            Group group = bgChar.createGroup(teXParser);
            this.popRemainingGroup(teXParser, group, by, bgChar);
            return group;
        }
        return teXObject;
    }

    public TeXObject popToken() throws IOException {
        return this.popToken((byte)0);
    }

    public TeXObject popToken(byte by) throws IOException {
        boolean bl = TeXObjectList.isRetainIgnoreables(by);
        boolean bl2 = TeXObjectList.isIgnoreLeadingSpace(by);
        if (!bl && bl2) {
            TeXObject teXObject;
            while (this.size() > 0 && ((teXObject = (TeXObject)this.get(0)) instanceof Ignoreable || teXObject instanceof WhiteSpace)) {
                this.pop();
            }
        } else if (bl2) {
            TeXObject teXObject;
            while (this.size() > 0 && ((teXObject = (TeXObject)this.get(0)) instanceof WhiteSpace || teXObject instanceof SkippedSpaces || teXObject instanceof SkippedEols)) {
                this.pop();
            }
        } else if (!bl) {
            while (this.size() > 0 && this.get(0) instanceof Ignoreable) {
                this.pop();
            }
        }
        if (this.size() == 0) {
            return null;
        }
        return this.pop();
    }

    public TeXObject pop() throws IOException {
        if (this.isEmpty()) {
            return null;
        }
        return (TeXObject)this.remove(0);
    }

    public void popLeadingWhiteSpace() {
        if (this.isEmpty()) {
            return;
        }
        TeXObject teXObject = (TeXObject)this.get(0);
        if (teXObject instanceof Ignoreable || teXObject instanceof WhiteSpace) {
            this.remove(0);
            this.popLeadingWhiteSpace();
        }
    }

    public TeXObjectList popToGroup(TeXParser teXParser, byte by) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        while (true) {
            if (this.size() == 0) {
                throw new TeXSyntaxException(teXParser, "tex.error.syntax", this.toString(teXParser));
            }
            TeXObject teXObject = (TeXObject)this.firstElement();
            BgChar bgChar = teXParser.isBeginGroup(teXObject);
            if (teXObject instanceof Group || bgChar != null) break;
            teXObject = this.pop();
            if (!TeXObjectList.isRetainIgnoreables(by) && teXObject instanceof Ignoreable) {
                teXParser.getListener().skipping((Ignoreable)teXObject);
                continue;
            }
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    public boolean popCsMarker(TeXParser teXParser, String string) throws IOException {
        return this.popCsMarker(teXParser, string, (byte)0);
    }

    public boolean popCsMarker(TeXParser teXParser, String string, byte by) throws IOException {
        TeXObject teXObject = this.popToken(by);
        if (teXObject == null) {
            return false;
        }
        if (!(teXObject instanceof ControlSequence) || !((ControlSequence)teXObject).getName().equals(string)) {
            throw new TeXSyntaxException(teXParser, "tex.error.not_found", String.format("%s%s", new String(Character.toChars(teXParser.getEscChar())), string));
        }
        return true;
    }

    public TeXObjectList popToCsMarker(TeXParser teXParser, String string) throws IOException {
        return this.popToCsMarker(teXParser, string, (byte)0);
    }

    public TeXObjectList popToCsMarker(TeXParser teXParser, String string, byte by) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        TeXObject teXObject = this.popToken(by);
        if (TeXObjectList.isIgnoreLeadingSpace(by)) {
            by = (byte)(by ^ POP_IGNORE_LEADING_SPACE);
        }
        while (teXObject != null) {
            if (teXObject instanceof ControlSequence && ((ControlSequence)teXObject).getName().equals(string)) {
                return teXObjectList;
            }
            teXObjectList.add(teXObject);
            teXObject = this.popToken(by);
        }
        throw new TeXSyntaxException(teXParser, "tex.error.not_found", String.format("%s%s", new String(Character.toChars(teXParser.getEscChar())), string));
    }

    public TeXUnit popUnit(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser, (byte)(POP_SHORT | POP_IGNORE_LEADING_SPACE));
        if (teXObject == null) {
            throw new TeXSyntaxException(teXParser.getCurrentFile(), teXParser.getLineNumber(), "tex.error.missing_unit", new Object[0]);
        }
        if (teXObject instanceof CharObject) {
            int n = ((CharObject)teXObject).getCharCode();
            TeXObject teXObject2 = this.expandedPopStack(teXParser);
            if (teXObject2 == null || !(teXObject2 instanceof CharObject)) {
                this.push(teXObject);
                throw new TeXSyntaxException(teXParser.getCurrentFile(), teXParser.getLineNumber(), "tex.error.missing_unit", new Object[0]);
            }
            int n2 = ((CharObject)teXObject2).getCharCode();
            try {
                return teXParser.getListener().createUnit(String.format("%s%s", new String(Character.toChars(n)), new String(Character.toChars(n2))));
            }
            catch (TeXSyntaxException teXSyntaxException) {
                if (n == 102 && n2 == 105) {
                    TeXObject teXObject3 = this.expandedPopStack(teXParser);
                    if (teXObject3 == null || !(teXObject3 instanceof CharObject) || ((CharObject)teXObject3).getCharCode() != 108) {
                        this.push(teXObject3);
                    } else {
                        TeXObject teXObject4 = this.expandedPopStack(teXParser);
                        if (teXObject4 == null || !(teXObject4 instanceof CharObject) || ((CharObject)teXObject4).getCharCode() != 108) {
                            this.push(teXObject4);
                            return TeXUnit.FIL;
                        }
                        TeXObject teXObject5 = this.expandedPopStack(teXParser);
                        if (teXObject5 == null || teXObject5 instanceof CharObject || ((CharObject)teXObject5).getCharCode() != 108) {
                            this.push(teXObject5);
                            return TeXUnit.FILL;
                        }
                        return TeXUnit.FILLL;
                    }
                }
                this.push(teXObject2);
                this.push(teXObject);
                throw new TeXSyntaxException(teXParser.getCurrentFile(), teXParser.getLineNumber(), "tex.error.missing_unit", new Object[0]);
            }
        }
        this.push(teXObject);
        throw new TeXSyntaxException(teXParser.getCurrentFile(), teXParser.getLineNumber(), "tex.error.missing_unit", new Object[0]);
    }

    public Register popRegister(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = this.popToken(POP_IGNORE_LEADING_SPACE);
        if (teXObject == null) {
            throw new TeXSyntaxException(teXParser, "tex.error.register_expected", new Object[0]);
        }
        if (teXObject instanceof TeXCsRef) {
            teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
        }
        if (teXObject instanceof Register) {
            return (Register)teXObject;
        }
        if (teXObject instanceof Expandable && (teXObjectList = this == teXParser ? ((Expandable)((Object)teXObject)).expandfully(teXParser) : ((Expandable)((Object)teXObject)).expandfully(teXParser, this)) != null) {
            this.addAll(0, teXObjectList);
            teXObject = this.popToken(POP_IGNORE_LEADING_SPACE);
            if (teXObject instanceof Register) {
                return (Register)teXObject;
            }
        }
        throw new TeXSyntaxException(teXParser, "tex.error.register_expected_but_found", teXObject.toString(teXParser));
    }

    public Numerical popNumerical(TeXParser teXParser) throws IOException {
        int n;
        TeXObject teXObject = this.peekStack(POP_IGNORE_LEADING_SPACE);
        if (teXObject instanceof CharObject && ((n = ((CharObject)teXObject).getCharCode()) == 34 || n == 39 || n == 96 || Character.isDigit(n))) {
            return this.popNumber(teXParser);
        }
        teXObject = this.expandedPopStack(teXParser, POP_SHORT);
        if (teXObject instanceof NumericRegister) {
            return (NumericRegister)teXObject;
        }
        if (teXObject instanceof TeXDimension) {
            return (TeXDimension)teXObject;
        }
        this.push(teXObject);
        return this.popNumber(teXParser);
    }

    public TeXDimension popDimension(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser, (byte)(POP_SHORT | POP_IGNORE_LEADING_SPACE));
        if (teXObject instanceof TeXDimension) {
            return (TeXDimension)teXObject;
        }
        this.push(teXObject);
        Float f = this.popFloat(teXParser);
        teXObject = this.expandedPopStack(teXParser);
        if (teXObject instanceof DimenRegister) {
            TeXGlue teXGlue = new TeXGlue(teXParser, (DimenRegister)teXObject);
            teXGlue.multiply(f.floatValue());
            return teXGlue;
        }
        this.push(teXObject);
        TeXUnit teXUnit = this.popUnit(teXParser);
        UserDimension userDimension = new UserDimension(f, teXUnit);
        TeXDimension teXDimension = null;
        TeXDimension teXDimension2 = null;
        teXObject = this.expandedPopStack(teXParser);
        this.push(teXObject);
        if (!(teXObject instanceof CharObject)) {
            return userDimension;
        }
        if (((CharObject)teXObject).getCharCode() == 112) {
            teXDimension = this.popStretch(teXParser);
            if (teXDimension == null) {
                return userDimension;
            }
            teXObject = this.expandedPopStack(teXParser);
            this.push(teXObject);
            if (teXObject instanceof CharObject && ((CharObject)teXObject).getCharCode() == 109) {
                teXDimension2 = this.popShrink(teXParser);
            }
        } else if (((CharObject)teXObject).getCharCode() == 109) {
            teXDimension2 = this.popShrink(teXParser);
            if (teXDimension2 == null) {
                return userDimension;
            }
        } else {
            return userDimension;
        }
        return new TeXGlue(teXParser, userDimension, teXDimension, teXDimension2);
    }

    private TeXDimension popStretch(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser, (byte)(POP_SHORT | POP_IGNORE_LEADING_SPACE));
        if (!(teXObject instanceof CharObject) || ((CharObject)teXObject).getCharCode() != 112) {
            this.push(teXObject);
            return null;
        }
        TeXObject teXObject2 = this.expandedPopStack(teXParser, POP_SHORT);
        if (!(teXObject2 instanceof CharObject) || ((CharObject)teXObject2).getCharCode() != 108) {
            this.push(teXObject2);
            this.push(teXObject);
            return null;
        }
        TeXObject teXObject3 = this.expandedPopStack(teXParser, POP_SHORT);
        if (!(teXObject3 instanceof CharObject) || ((CharObject)teXObject3).getCharCode() != 117) {
            this.push(teXObject3);
            this.push(teXObject2);
            this.push(teXObject);
            return null;
        }
        TeXObject teXObject4 = this.expandedPopStack(teXParser, POP_SHORT);
        if (!(teXObject4 instanceof CharObject) || ((CharObject)teXObject4).getCharCode() != 115) {
            this.push(teXObject4);
            this.push(teXObject3);
            this.push(teXObject2);
            this.push(teXObject);
            return null;
        }
        Float f = this.popFloat(teXParser);
        teXObject = this.expandedPopStack(teXParser, POP_SHORT);
        if (teXObject instanceof DimenRegister) {
            UserDimension userDimension = new UserDimension();
            userDimension.setDimension(teXParser, (DimenRegister)teXObject);
            userDimension.multiply(f.floatValue());
            return userDimension;
        }
        this.push(teXObject);
        TeXUnit teXUnit = this.popUnit(teXParser);
        return new UserDimension(f, teXUnit);
    }

    private TeXDimension popShrink(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser, POP_SHORT);
        if (!(teXObject instanceof CharObject) || ((CharObject)teXObject).getCharCode() != 109) {
            this.push(teXObject);
            return null;
        }
        TeXObject teXObject2 = this.expandedPopStack(teXParser, POP_SHORT);
        if (!(teXObject2 instanceof CharObject) || ((CharObject)teXObject2).getCharCode() != 105) {
            this.push(teXObject2);
            this.push(teXObject);
            return null;
        }
        TeXObject teXObject3 = this.expandedPopStack(teXParser, POP_SHORT);
        if (!(teXObject3 instanceof CharObject) || ((CharObject)teXObject3).getCharCode() != 110) {
            this.push(teXObject3);
            this.push(teXObject2);
            this.push(teXObject);
            return null;
        }
        TeXObject teXObject4 = this.expandedPopStack(teXParser, POP_SHORT);
        if (!(teXObject4 instanceof CharObject) || ((CharObject)teXObject4).getCharCode() != 117) {
            this.push(teXObject4);
            this.push(teXObject3);
            this.push(teXObject2);
            this.push(teXObject);
            return null;
        }
        TeXObject teXObject5 = this.expandedPopStack(teXParser, POP_SHORT);
        if (!(teXObject5 instanceof CharObject) || ((CharObject)teXObject5).getCharCode() != 115) {
            this.push(teXObject5);
            this.push(teXObject4);
            this.push(teXObject3);
            this.push(teXObject2);
            this.push(teXObject);
            return null;
        }
        Float f = this.popFloat(teXParser);
        teXObject = this.expandedPopStack(teXParser, POP_SHORT);
        if (teXObject instanceof DimenRegister) {
            UserDimension userDimension = new UserDimension();
            userDimension.setDimension(teXParser, (DimenRegister)teXObject);
            userDimension.multiply(f.floatValue());
            return userDimension;
        }
        this.push(teXObject);
        TeXUnit teXUnit = this.popUnit(teXParser);
        return new UserDimension(f, teXUnit);
    }

    public Float popFloat(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser);
        StringBuilder stringBuilder = new StringBuilder();
        this.popFloat(teXParser, teXObject, stringBuilder);
        String string = stringBuilder.toString();
        try {
            return Float.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException(teXParser, "tex.error.number_expected", string);
        }
    }

    protected void popFloat(TeXParser teXParser, TeXObject teXObject, StringBuilder stringBuilder) throws IOException {
        if (teXObject == null) {
            return;
        }
        String string = teXObject.toString(teXParser);
        try {
            Float.parseFloat(stringBuilder.toString() + string + "0");
        }
        catch (NumberFormatException numberFormatException) {
            this.push(teXObject);
            return;
        }
        stringBuilder.append(string);
        this.popFloat(teXParser, this.expandedPopStack(teXParser), stringBuilder);
    }

    public TeXNumber popNumber(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.peekStack(POP_IGNORE_LEADING_SPACE);
        int n = 10;
        if (teXObject instanceof CharObject) {
            int n2 = ((CharObject)teXObject).getCharCode();
            if (n2 == 34) {
                this.popStack(teXParser, POP_IGNORE_LEADING_SPACE);
                n = 16;
            }
            if (n2 == 39) {
                this.popStack(teXParser, POP_IGNORE_LEADING_SPACE);
                n = 8;
            } else if (n2 == 96) {
                this.popStack(teXParser, POP_IGNORE_LEADING_SPACE);
                TeXObject teXObject2 = this.peek();
                if (teXObject2 instanceof ControlSequence) {
                    this.popStack(teXParser);
                    String string = ((ControlSequence)teXObject2).getName();
                    n2 = string.codePointAt(0);
                    if (Character.charCount(n2) != string.length()) {
                        throw new TeXSyntaxException(teXParser, "tex.error.improper_alphabetic_constant", teXObject2.toString(teXParser));
                    }
                    this.popLeadingWhiteSpace();
                    return new UserNumber(n2);
                }
                if (teXObject2 instanceof CharObject) {
                    n2 = ((CharObject)teXObject2).getCharCode();
                    this.popStack(teXParser, POP_IGNORE_LEADING_SPACE);
                    this.popLeadingWhiteSpace();
                    return new UserNumber(n2);
                }
                String string = teXObject2.toString(teXParser);
                n2 = string.codePointAt(0);
                if (Character.charCount(n2) != string.length()) {
                    throw new TeXSyntaxException(teXParser, "tex.error.improper_alphabetic_constant", string);
                }
                return new UserNumber(n2);
            }
        }
        this.popLeadingWhiteSpace();
        teXObject = this.expandedPopStack(teXParser);
        if (teXObject instanceof TeXNumber) {
            return (TeXNumber)teXObject;
        }
        if (teXObject instanceof Group) {
            return ((Group)teXObject).toList().popNumber(teXParser);
        }
        if (teXObject instanceof ControlSequence) {
            throw new TeXSyntaxException(teXParser, "tex.error.number_expected", teXObject.toString(teXParser));
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.popNumber(teXParser, teXObject, stringBuilder, n);
        this.popLeadingWhiteSpace();
        if (stringBuilder.length() == 0) {
            throw new TeXSyntaxException(teXParser, "tex.error.number_expected", teXObject.toString(teXParser));
        }
        return new UserNumber(teXParser, stringBuilder.toString(), n);
    }

    protected void popNumber(TeXParser teXParser, TeXObject teXObject, StringBuilder stringBuilder, int n) throws IOException {
        if (teXObject == null) {
            return;
        }
        String string = teXObject instanceof CharObject ? new String(Character.toChars(((CharObject)teXObject).getCharCode())) : teXObject.toString(teXParser);
        try {
            Integer.parseInt(stringBuilder.toString() + string, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.push(teXObject);
            return;
        }
        stringBuilder.append(string);
        this.popNumber(teXParser, this.expandedPopStack(teXParser), stringBuilder, n);
    }

    public ControlSequence popControlSequence(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = this.popArg(teXParser);
        if (teXObject instanceof TeXObjectList && ((teXObject = (teXObjectList = (TeXObjectList)teXObject).popToken()) == null || teXObjectList.peekStack() != null)) {
            throw new TeXSyntaxException(teXParser, "tex.error.cs_expected", teXObject == null ? teXObjectList.toString(teXParser) : String.format("%s%s", teXObject.toString(teXParser), teXObjectList.toString(teXParser)));
        }
        if (!(teXObject instanceof ControlSequence)) {
            throw new TeXSyntaxException(teXParser, "tex.error.cs_expected", teXObject.toString(teXParser));
        }
        return (ControlSequence)teXObject;
    }

    public void push(TeXObject teXObject) {
        if (teXObject == this) {
            throw new IllegalArgumentException("Can't add list to itself");
        }
        if (teXObject != null) {
            this.add(0, teXObject);
        }
    }

    @Override
    public void add(int n, TeXObject teXObject) {
        if (teXObject == null) {
            throw new NullPointerException();
        }
        super.add(n, teXObject);
    }

    @Override
    public boolean add(TeXObject teXObject) {
        if (teXObject == null) {
            throw new NullPointerException();
        }
        if (teXObject == this) {
            throw new IllegalArgumentException("Can't add a list to itself");
        }
        return super.add(teXObject);
    }

    public TeXObject peek() {
        return this.size() == 0 ? null : (TeXObject)this.firstElement();
    }

    public TeXObject peekLast() {
        return this.size() == 0 ? null : (TeXObject)this.lastElement();
    }

    public TeXObject peekStack() throws IOException {
        return this.peekStack((byte)0);
    }

    public TeXObject peekStack(byte by) throws IOException {
        if (this.size() == 0) {
            return null;
        }
        if (TeXObjectList.isIgnoreLeadingSpace(by)) {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                TeXObject teXObject = (TeXObject)this.get(i);
                if (teXObject instanceof Ignoreable || teXObject instanceof WhiteSpace) continue;
                return teXObject;
            }
        } else {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                TeXObject teXObject = (TeXObject)this.get(i);
                if (teXObject instanceof Ignoreable) continue;
                return teXObject;
            }
        }
        return null;
    }

    public static boolean isShort(byte by) {
        return (by & POP_SHORT) == POP_SHORT;
    }

    public static boolean isRetainIgnoreables(byte by) {
        return (by & POP_RETAIN_IGNOREABLES) == POP_RETAIN_IGNOREABLES;
    }

    public static boolean isIgnoreLeadingSpace(byte by) {
        return (by & POP_IGNORE_LEADING_SPACE) == POP_IGNORE_LEADING_SPACE;
    }

    public TeXObject popArg(TeXParser teXParser) throws IOException {
        return this.popArg(teXParser, POP_IGNORE_LEADING_SPACE);
    }

    public TeXObject popArg(TeXParser teXParser, byte by) throws IOException {
        TeXObject teXObject = this.popStack(teXParser, by);
        if (teXObject instanceof Group && !(teXObject instanceof MathGroup)) {
            return ((Group)teXObject).toList();
        }
        return teXObject;
    }

    public TeXObject popArg(TeXParser teXParser, int n, int n2) throws IOException {
        return this.popArg(teXParser, POP_IGNORE_LEADING_SPACE, n, n2);
    }

    public TeXObject popArg(TeXParser teXParser, byte by, int n, int n2) throws IOException {
        TeXObject teXObject = this.popStack(teXParser, by);
        if (!(teXObject instanceof CharObject)) {
            this.push(teXObject);
            return null;
        }
        CharObject charObject = (CharObject)teXObject;
        if (charObject.getCharCode() != n) {
            this.push(teXObject);
            return null;
        }
        TeXObjectList teXObjectList = new TeXObjectList();
        boolean bl = TeXObjectList.isShort(by);
        while ((teXObject = this.pop()) != null) {
            BgChar bgChar = teXParser.isBeginGroup(teXObject);
            if (teXObject instanceof CharObject) {
                charObject = (CharObject)teXObject;
                if (charObject.getCharCode() == n2) {
                    return teXObjectList;
                }
            } else if (bgChar != null) {
                Group group = teXParser.getListener().createGroup();
                this.popRemainingGroup(teXParser, group, by, bgChar);
                teXObject = group;
            } else if (bl && teXObject.isPar()) break;
            teXObjectList.add(teXObject);
        }
        throw new TeXSyntaxException(teXParser, "tex.error.missing_closing", n2);
    }

    public Numerical popNumericalArg(TeXParser teXParser, int n, int n2) throws IOException {
        TeXObject teXObject = this.popArg(teXParser, POP_SHORT, n, n2);
        if (teXObject == null) {
            return null;
        }
        if (teXObject instanceof Numerical) {
            return (Numerical)teXObject;
        }
        TeXObjectList teXObjectList = null;
        if (teXObject instanceof Expandable) {
            teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser, this);
        }
        if (teXObjectList != null) {
            teXObject = teXObjectList;
        }
        if (teXObject instanceof TeXObjectList) {
            return ((TeXObjectList)teXObject).popNumerical(teXParser);
        }
        return new UserNumber(teXParser, teXObject.toString(teXParser));
    }

    @Override
    public TeXObjectList toLowerCase(TeXParser teXParser) {
        TeXObjectList teXObjectList = this.createList();
        for (TeXObject teXObject : this) {
            if (teXObject instanceof TeXCsRef) {
                teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
            }
            if (teXObject instanceof CaseChangeable) {
                teXObjectList.add(((CaseChangeable)((Object)teXObject)).toLowerCase(teXParser));
                continue;
            }
            if (teXObject instanceof ControlSequence) {
                if (teXObject instanceof Primitive || teXObject instanceof MathSymbol) {
                    teXObjectList.add(teXObject);
                    continue;
                }
                teXObjectList.add(new TeXCsRef(((ControlSequence)teXObject).getName().toLowerCase()));
                continue;
            }
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList toUpperCase(TeXParser teXParser) {
        TeXObjectList teXObjectList = this.createList();
        for (TeXObject teXObject : this) {
            if (teXObject instanceof TeXCsRef) {
                teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
            }
            if (teXObject instanceof CaseChangeable) {
                teXObjectList.add(((CaseChangeable)((Object)teXObject)).toUpperCase(teXParser));
                continue;
            }
            if (teXObject instanceof ControlSequence) {
                if (teXObject instanceof Primitive || teXObject instanceof MathSymbol) {
                    teXObjectList.add(teXObject);
                    continue;
                }
                teXObjectList.add(new TeXCsRef(((ControlSequence)teXObject).getName().toUpperCase()));
                continue;
            }
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    public TeXObjectList createList() {
        return new TeXObjectList(this.capacity());
    }

    @Override
    public Object clone() {
        TeXObjectList teXObjectList = this.createList();
        for (TeXObject teXObject : this) {
            teXObjectList.add((TeXObject)teXObject.clone());
        }
        for (Declaration declaration : this.declarations) {
            teXObjectList.declarations.add((Declaration)declaration.clone());
        }
        return teXObjectList;
    }

    protected void flatten() {
        for (int i = this.size() - 1; i >= 0; --i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            if (!(teXObject instanceof TeXObjectList)) continue;
            ((TeXObjectList)teXObject).flatten();
            if (teXObject instanceof Group) continue;
            this.remove(i);
            this.addAll(i, (TeXObjectList)teXObject);
        }
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        this.flatten();
        TeXObjectList teXObjectList = new TeXObjectList(this.size());
        TeXObjectList teXObjectList2 = (TeXObjectList)this.clone();
        while (!teXObjectList2.isEmpty()) {
            TeXObject teXObject = teXObjectList2.pop();
            TeXObjectList teXObjectList3 = null;
            if (teXObject instanceof Expandable) {
                teXObjectList3 = ((Expandable)((Object)teXObject)).expandonce(teXParser, teXObjectList2);
            }
            if (teXObjectList3 == null) {
                teXObjectList.add(teXObject);
                continue;
            }
            teXObjectList.addAll(teXObjectList3);
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        this.flatten();
        TeXObjectList teXObjectList2 = new TeXObjectList(this.size());
        TeXObjectList teXObjectList3 = (TeXObjectList)this.clone();
        StackMarker stackMarker = null;
        if (teXObjectList != null && teXObjectList != teXParser) {
            stackMarker = new StackMarker();
            teXObjectList3.add(stackMarker);
            teXObjectList3.addAll(teXObjectList);
            teXObjectList.clear();
        }
        while (!teXObjectList3.isEmpty() && !(teXObject = teXObjectList3.pop()).equals(stackMarker)) {
            TeXObjectList teXObjectList4 = null;
            if (teXObject instanceof Expandable) {
                teXObjectList4 = ((Expandable)((Object)teXObject)).expandonce(teXParser, teXObjectList3);
            }
            if (teXObjectList4 == null) {
                teXObjectList2.add(teXObject);
                continue;
            }
            teXObjectList2.addAll(teXObjectList4);
        }
        if (!teXObjectList3.isEmpty()) {
            teXObjectList.addAll(teXObjectList3);
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        this.flatten();
        TeXObjectList teXObjectList = new TeXObjectList(this.size());
        TeXObjectList teXObjectList2 = (TeXObjectList)this.clone();
        while (!teXObjectList2.isEmpty()) {
            TeXObject teXObject = teXObjectList2.pop();
            if (teXObject instanceof Ignoreable) continue;
            TeXObjectList teXObjectList3 = null;
            if (teXObject instanceof Expandable) {
                teXObjectList3 = ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList2);
            }
            if (teXObjectList3 == null) {
                teXObjectList.add(teXObject);
                continue;
            }
            teXObjectList.addAll(teXObjectList3);
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        this.flatten();
        TeXObjectList teXObjectList2 = new TeXObjectList(this.size());
        TeXObjectList teXObjectList3 = (TeXObjectList)this.clone();
        StackMarker stackMarker = null;
        if (teXObjectList != null && teXObjectList != teXParser) {
            stackMarker = new StackMarker();
            teXObjectList3.add(stackMarker);
            teXObjectList3.addAll(teXObjectList);
            teXObjectList.clear();
        }
        while (!teXObjectList3.isEmpty() && !(teXObject = teXObjectList3.pop()).equals(stackMarker)) {
            if (teXObject instanceof Ignoreable) continue;
            TeXObjectList teXObjectList4 = null;
            if (teXObject instanceof Expandable) {
                teXObjectList4 = ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList3);
            }
            if (teXObjectList4 == null) {
                teXObjectList2.add(teXObject);
                continue;
            }
            teXObjectList2.addAll(teXObjectList4);
        }
        if (!teXObjectList3.isEmpty()) {
            teXObjectList.addAll(teXObjectList3);
        }
        return teXObjectList2;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        while (this.size() > 0) {
            TeXObject teXObject = (TeXObject)this.remove(0);
            if (teXObject instanceof TeXCsRef) {
                teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
            }
            if (teXObject instanceof Declaration) {
                this.pushDeclaration((Declaration)teXObject);
            }
            if (teXObject instanceof Ignoreable) continue;
            teXObject.process(teXParser, this);
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        StackMarker stackMarker = null;
        if (teXObjectList != teXParser && teXObjectList != null) {
            stackMarker = new StackMarker();
            this.add(stackMarker);
            this.addAll(teXObjectList);
            teXObjectList.clear();
        }
        while (this.size() > 0 && !(teXObject = (TeXObject)this.remove(0)).equals(stackMarker)) {
            if (teXObject instanceof TeXCsRef) {
                teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
            }
            if (teXObject instanceof Declaration) {
                this.pushDeclaration((Declaration)teXObject);
            }
            if (teXObject instanceof Ignoreable) continue;
            teXObject.process(teXParser, this);
        }
        if (!this.isEmpty()) {
            teXObjectList.addAll(this);
            this.clear();
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if (teXObject instanceof CharObject) {
                stringBuilder.append('\'');
                stringBuilder.append(teXObject.toString());
                stringBuilder.append('\'');
                continue;
            }
            stringBuilder.append(teXObject.toString());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            stringBuilder.append(teXObject.format());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString(TeXParser teXParser) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            stringBuilder.append(teXObject.toString(teXParser));
            if (!(teXObject instanceof ControlSequence) || !((ControlSequence)teXObject).isControlWord(teXParser) || i >= n - 1) continue;
            teXObject = (TeXObject)this.get(i + 1);
            if (teXObject instanceof Letter) {
                stringBuilder.append(" ");
                continue;
            }
            if (!(teXObject instanceof TeXObjectList) || teXObject instanceof Group) continue;
            ++i;
            String string = ((TeXObjectList)teXObject).toString(teXParser);
            if (string.isEmpty()) continue;
            if (teXParser.isLetter(string.charAt(0))) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        if (this.size() == 0) {
            return this;
        }
        TeXObjectList teXObjectList = this.pop().string(teXParser);
        this.addAll(0, teXObjectList);
        return this;
    }

    public void pushDeclaration(Declaration declaration) {
        this.declarations.add(declaration);
    }

    public void processEndDeclarations(TeXParser teXParser) throws IOException {
        while (this.declarations.size() > 0) {
            this.declarations.pollLast().end(teXParser);
        }
    }

    @Override
    public boolean isPar() {
        return this.size() == 1 && ((TeXObject)this.firstElement()).isPar();
    }

    public boolean popRemainingGroup(TeXParser teXParser, Group group, byte by, BgChar bgChar) throws IOException {
        while (this.size() > 0) {
            TeXObject teXObject = this.pop();
            EgChar egChar = teXParser.isEndGroup(teXObject);
            if (egChar != null) {
                if (!egChar.matches(bgChar)) {
                    throw new TeXSyntaxException(teXParser, "tex.error.extra_or_forgotten", egChar.toString(teXParser), bgChar.toString(teXParser));
                }
                return true;
            }
            BgChar bgChar2 = teXParser.isBeginGroup(teXObject);
            if (TeXObjectList.isShort(by) && teXObject.isPar()) {
                throw new TeXSyntaxException(teXParser, "tex.error.par_before_eg", new Object[0]);
            }
            if (bgChar2 != null) {
                Group group2 = bgChar2.createGroup(teXParser);
                if (!this.popRemainingGroup(teXParser, group2, by, bgChar2)) {
                    group.add(group2);
                    return false;
                }
                group.add(group2);
                continue;
            }
            group.add(teXObject);
        }
        return false;
    }

    public boolean containsVerbatimCommand(TeXParser teXParser) {
        for (int i = 0; i < this.size(); ++i) {
            ControlSequence controlSequence;
            TeXObject teXObject = (TeXObject)this.get(i);
            if (!(teXObject instanceof ControlSequence ? teXParser.isVerbCommand((controlSequence = (ControlSequence)teXObject).getName()) : teXObject instanceof TeXObjectList && ((TeXObjectList)teXObject).containsVerbatimCommand(teXParser))) continue;
            return true;
        }
        return false;
    }
}

