/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.ErrorState;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.HeadersTooLargeException;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.coyote.http11.filters.ChunkedInputFilter;
import org.apache.coyote.http11.filters.ChunkedOutputFilter;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.coyote.http11.filters.IdentityInputFilter;
import org.apache.coyote.http11.filters.IdentityOutputFilter;
import org.apache.coyote.http11.filters.SavedRequestInputFilter;
import org.apache.coyote.http11.filters.VoidInputFilter;
import org.apache.coyote.http11.filters.VoidOutputFilter;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.servlet31.HttpUpgradeHandler;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.log.UserDataHelper;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractHttp11Processor<S>
extends AbstractProcessor<S> {
    private final UserDataHelper userDataHelper;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    private int pluggableFilterIndex = Integer.MAX_VALUE;
    protected boolean keepAlive = true;
    protected boolean openSocket = false;
    protected boolean keptAlive;
    protected boolean sendfileInProgress = false;
    protected boolean readComplete = true;
    protected boolean http11 = true;
    protected boolean http09 = false;
    protected boolean contentDelimitation = true;
    protected boolean expectation = false;
    protected boolean comet = false;
    protected Pattern restrictedUserAgents = null;
    protected int maxKeepAliveRequests = -1;
    protected int keepAliveTimeout = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected String localName = null;
    protected int localPort = -1;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected int connectionUploadTimeout = 300000;
    protected boolean disableUploadTimeout = false;
    protected int compressionLevel = 0;
    protected int compressionMinSize = 2048;
    protected int socketBuffer = -1;
    protected int maxSavePostSize = 4096;
    protected Pattern noCompressionUserAgents = null;
    protected String[] compressableMimeTypes = new String[]{"text/html", "text/xml", "text/plain"};
    protected char[] hostNameC = new char[0];
    protected String server = null;
    @Deprecated
    protected UpgradeInbound upgradeInbound = null;
    protected HttpUpgradeHandler httpUpgradeHandler = null;

    public AbstractHttp11Processor(AbstractEndpoint<S> endpoint) {
        super(endpoint);
        this.userDataHelper = new UserDataHelper(this.getLog());
    }

    public void setCompression(String compression) {
        if (compression.equals("on")) {
            this.compressionLevel = 1;
        } else if (compression.equals("force")) {
            this.compressionLevel = 2;
        } else if (compression.equals("off")) {
            this.compressionLevel = 0;
        } else {
            try {
                this.compressionMinSize = Integer.parseInt(compression);
                this.compressionLevel = 1;
            }
            catch (Exception e) {
                this.compressionLevel = 0;
            }
        }
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents == null || noCompressionUserAgents.length() == 0 ? null : Pattern.compile(noCompressionUserAgents);
    }

    @Deprecated
    public void addCompressableMimeType(String mimeType) {
        this.addCompressibleMimeType(mimeType);
    }

    @Deprecated
    public void setCompressableMimeTypes(String[] compressibleMimeTypes) {
        this.setCompressibleMimeTypes(compressibleMimeTypes);
    }

    @Deprecated
    public void setCompressableMimeTypes(String compressibleMimeTypes) {
        this.setCompressibleMimeTypes(compressibleMimeTypes);
    }

    public void addCompressibleMimeType(String mimeType) {
        this.compressableMimeTypes = this.addStringArray(this.compressableMimeTypes, mimeType);
    }

    public void setCompressibleMimeTypes(String[] compressibleMimeTypes) {
        this.compressableMimeTypes = compressibleMimeTypes;
    }

    public void setCompressibleMimeTypes(String compressibleMimeTypes) {
        if (compressibleMimeTypes != null) {
            this.compressableMimeTypes = null;
            StringTokenizer st = new StringTokenizer(compressibleMimeTypes, ",");
            while (st.hasMoreTokens()) {
                this.addCompressibleMimeType(st.nextToken().trim());
            }
        }
    }

    public String getCompression() {
        switch (this.compressionLevel) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "force";
            }
        }
        return "off";
    }

    private String[] addStringArray(String[] sArray, String value) {
        String[] result = null;
        if (sArray == null) {
            result = new String[]{value};
        } else {
            result = new String[sArray.length + 1];
            for (int i = 0; i < sArray.length; ++i) {
                result[i] = sArray[i];
            }
            result[sArray.length] = value;
        }
        return result;
    }

    private boolean startsWithStringArray(String[] sArray, String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (!value.startsWith(sArray[i])) continue;
            return true;
        }
        return false;
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents == null || restrictedUserAgents.length() == 0 ? null : Pattern.compile(restrictedUserAgents);
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setKeepAliveTimeout(int timeout) {
        this.keepAliveTimeout = timeout;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setMaxSavePostSize(int msps) {
        this.maxSavePostSize = msps;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setSocketBuffer(int socketBuffer) {
        this.socketBuffer = socketBuffer;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setConnectionUploadTimeout(int timeout) {
        this.connectionUploadTimeout = timeout;
    }

    public int getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    public void setServer(String server) {
        this.server = server == null || server.equals("") ? null : server;
    }

    public String getServer() {
        return this.server;
    }

    private boolean isCompressible() {
        MessageBytes contentEncodingMB = this.response.getMimeHeaders().getValue("Content-Encoding");
        if (contentEncodingMB != null && contentEncodingMB.indexOf("gzip") != -1) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        long contentLength = this.response.getContentLengthLong();
        if ((contentLength == -1L || contentLength > (long)this.compressionMinSize) && this.compressableMimeTypes != null) {
            return this.startsWithStringArray(this.compressableMimeTypes, this.response.getContentType());
        }
        return false;
    }

    private boolean useCompression() {
        String userAgentValue;
        MessageBytes userAgentValueMB;
        MessageBytes acceptEncodingMB = this.request.getMimeHeaders().getValue("accept-encoding");
        if (acceptEncodingMB == null || acceptEncodingMB.indexOf("gzip") == -1) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        return this.noCompressionUserAgents == null || (userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent")) == null || !this.noCompressionUserAgents.matcher(userAgentValue = userAgentValueMB.toString()).matches();
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower(buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }

    protected boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 500 || status == 503 || status == 501;
    }

    protected abstract AbstractInputBuffer<S> getInputBuffer();

    protected abstract AbstractOutputBuffer<S> getOutputBuffer();

    protected void initializeFilters(int maxTrailerSize, Set<String> allowedTrailerHeaders, int maxExtensionSize, int maxSwallowSize) {
        this.getInputBuffer().addFilter(new IdentityInputFilter(maxSwallowSize));
        this.getOutputBuffer().addFilter(new IdentityOutputFilter());
        this.getInputBuffer().addFilter(new ChunkedInputFilter(maxTrailerSize, allowedTrailerHeaders, maxExtensionSize, maxSwallowSize));
        this.getOutputBuffer().addFilter(new ChunkedOutputFilter());
        this.getInputBuffer().addFilter(new VoidInputFilter());
        this.getOutputBuffer().addFilter(new VoidOutputFilter());
        this.getInputBuffer().addFilter(new BufferedInputFilter());
        this.getOutputBuffer().addFilter(new GzipOutputFilter());
        this.pluggableFilterIndex = this.getInputBuffer().getFilters().length;
    }

    private void addInputFilter(InputFilter[] inputFilters, String encodingName) {
        if (!(encodingName = encodingName.trim().toLowerCase(Locale.ENGLISH)).equals("identity")) {
            if (encodingName.equals("chunked")) {
                this.getInputBuffer().addActiveFilter(inputFilters[1]);
                this.contentDelimitation = true;
            } else {
                for (int i = this.pluggableFilterIndex; i < inputFilters.length; ++i) {
                    if (!inputFilters[i].getEncodingName().toString().equals(encodingName)) continue;
                    this.getInputBuffer().addActiveFilter(inputFilters[i]);
                    return;
                }
                this.response.setStatus(501);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)(sm.getString("http11processor.request.prepare") + " Unsupported transfer encoding [" + encodingName + "]"));
                }
            }
        }
    }

    @Override
    public final void action(ActionCode actionCode, Object param) {
        switch (actionCode) {
            case CLOSE: {
                try {
                    this.getOutputBuffer().endRequest();
                }
                catch (IOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
                break;
            }
            case COMMIT: {
                if (this.response.isCommitted()) {
                    return;
                }
                try {
                    this.prepareResponse();
                    this.getOutputBuffer().commit();
                }
                catch (IOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
                break;
            }
            case ACK: {
                if (this.response.isCommitted() || !this.expectation) {
                    return;
                }
                this.getInputBuffer().setSwallowInput(true);
                try {
                    this.getOutputBuffer().sendAck();
                }
                catch (IOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
                break;
            }
            case CLIENT_FLUSH: {
                try {
                    this.getOutputBuffer().flush();
                }
                catch (IOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                    this.response.setErrorException(e);
                }
                break;
            }
            case IS_ERROR: {
                ((AtomicBoolean)param).set(this.getErrorState().isError());
                break;
            }
            case DISABLE_SWALLOW_INPUT: {
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                this.getInputBuffer().setSwallowInput(false);
                break;
            }
            case RESET: {
                this.getOutputBuffer().reset();
                break;
            }
            case CUSTOM: {
                break;
            }
            case REQ_SET_BODY_REPLAY: {
                ByteChunk body = (ByteChunk)param;
                SavedRequestInputFilter savedBody = new SavedRequestInputFilter(body);
                savedBody.setRequest(this.request);
                AbstractInputBuffer internalBuffer = (AbstractInputBuffer)this.request.getInputBuffer();
                internalBuffer.addActiveFilter(savedBody);
                break;
            }
            case ASYNC_START: {
                this.asyncStateMachine.asyncStart((AsyncContextCallback)param);
                this.getSocketWrapper().access();
                break;
            }
            case ASYNC_DISPATCHED: {
                this.asyncStateMachine.asyncDispatched();
                break;
            }
            case ASYNC_TIMEOUT: {
                AtomicBoolean result = (AtomicBoolean)param;
                result.set(this.asyncStateMachine.asyncTimeout());
                break;
            }
            case ASYNC_RUN: {
                this.asyncStateMachine.asyncRun((Runnable)param);
                break;
            }
            case ASYNC_ERROR: {
                this.asyncStateMachine.asyncError();
                break;
            }
            case ASYNC_IS_STARTED: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncStarted());
                break;
            }
            case ASYNC_IS_COMPLETING: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isCompleting());
                break;
            }
            case ASYNC_IS_DISPATCHING: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncDispatching());
                break;
            }
            case ASYNC_IS_ASYNC: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsync());
                break;
            }
            case ASYNC_IS_TIMINGOUT: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncTimingOut());
                break;
            }
            case ASYNC_IS_ERROR: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncError());
                break;
            }
            case UPGRADE_TOMCAT: {
                this.upgradeInbound = (UpgradeInbound)param;
                this.getOutputBuffer().finished = true;
                break;
            }
            case ASYNC_POST_PROCESS: {
                this.asyncStateMachine.asyncPostProcess();
                break;
            }
            case UPGRADE: {
                this.httpUpgradeHandler = (HttpUpgradeHandler)param;
                this.getOutputBuffer().finished = true;
                break;
            }
            case CLOSE_NOW: {
                this.getOutputBuffer().finished = true;
                if (param instanceof Throwable) {
                    this.setErrorState(ErrorState.CLOSE_NOW, (Throwable)param);
                    break;
                }
                this.setErrorState(ErrorState.CLOSE_NOW, null);
                break;
            }
            case END_REQUEST: {
                this.endRequest();
                break;
            }
            default: {
                this.actionInternal(actionCode, param);
            }
        }
    }

    protected abstract void actionInternal(ActionCode var1, Object var2);

    protected abstract boolean disableKeepAlive();

    protected abstract void setRequestLineReadTimeout() throws IOException;

    protected abstract boolean handleIncompleteRequestLineRead();

    protected abstract void setSocketTimeout(int var1) throws IOException;

    @Override
    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<S> socketWrapper) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        rp.setStage(1);
        this.setSocketWrapper(socketWrapper);
        this.getInputBuffer().init(socketWrapper, this.endpoint);
        this.getOutputBuffer().init(socketWrapper, this.endpoint);
        this.keepAlive = true;
        this.comet = false;
        this.openSocket = false;
        this.sendfileInProgress = false;
        this.readComplete = true;
        this.keptAlive = this.endpoint.getUsePolling() ? false : socketWrapper.isKeptAlive();
        if (this.disableKeepAlive()) {
            socketWrapper.setKeepAliveLeft(0);
        }
        while (!(this.getErrorState().isError() || !this.keepAlive || this.comet || this.isAsync() || this.upgradeInbound != null || this.httpUpgradeHandler != null || this.endpoint.isPaused())) {
            try {
                this.setRequestLineReadTimeout();
                if (!this.getInputBuffer().parseRequestLine(this.keptAlive) && this.handleIncompleteRequestLineRead()) break;
                if (this.endpoint.isPaused()) {
                    this.response.setStatus(503);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                } else {
                    this.keptAlive = true;
                    this.request.getMimeHeaders().setLimit(this.endpoint.getMaxHeaderCount());
                    this.request.getCookies().setLimit(this.getMaxCookieCount());
                    if (!this.getInputBuffer().parseHeaders()) {
                        this.openSocket = true;
                        this.readComplete = false;
                        break;
                    }
                    if (!this.disableUploadTimeout) {
                        this.setSocketTimeout(this.connectionUploadTimeout);
                    }
                }
            }
            catch (IOException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)sm.getString("http11processor.header.parse"), (Throwable)e);
                }
                this.setErrorState(ErrorState.CLOSE_NOW, e);
                break;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                UserDataHelper.Mode logMode = this.userDataHelper.getNextMode();
                if (logMode != null) {
                    String message = sm.getString("http11processor.header.parse");
                    switch (logMode) {
                        case INFO_THEN_DEBUG: {
                            message = message + sm.getString("http11processor.fallToDebug");
                        }
                        case INFO: {
                            this.getLog().info((Object)message, t);
                            break;
                        }
                        case DEBUG: {
                            this.getLog().debug((Object)message, t);
                        }
                    }
                }
                this.response.setStatus(400);
                this.setErrorState(ErrorState.CLOSE_CLEAN, t);
                this.getAdapter().log(this.request, this.response, 0L);
            }
            if (!this.getErrorState().isError()) {
                rp.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)sm.getString("http11processor.request.prepare"), t);
                    }
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, t);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            if (this.maxKeepAliveRequests == 1) {
                this.keepAlive = false;
            } else if (this.maxKeepAliveRequests > 0 && socketWrapper.decrementKeepAlive() <= 0) {
                this.keepAlive = false;
            }
            if (!this.getErrorState().isError()) {
                try {
                    rp.setStage(3);
                    this.adapter.service(this.request, this.response);
                    if (this.keepAlive && !this.getErrorState().isError() && (this.response.getErrorException() != null || !this.isAsync() && this.statusDropsConnection(this.response.getStatus()))) {
                        this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    }
                    this.setCometTimeouts(socketWrapper);
                }
                catch (InterruptedIOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
                catch (HeadersTooLargeException e) {
                    this.getLog().error((Object)sm.getString("http11processor.request.process"), (Throwable)e);
                    if (this.response.isCommitted()) {
                        this.setErrorState(ErrorState.CLOSE_NOW, e);
                    } else {
                        this.response.reset();
                        this.response.setStatus(500);
                        this.setErrorState(ErrorState.CLOSE_CLEAN, e);
                        this.response.setHeader("Connection", "close");
                    }
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    this.getLog().error((Object)sm.getString("http11processor.request.process"), t);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, t);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            rp.setStage(4);
            if (!this.isAsync() && !this.comet) {
                if (this.getErrorState().isError()) {
                    this.getInputBuffer().setSwallowInput(false);
                } else {
                    this.checkExpectationAndResponseStatus();
                }
                this.endRequest();
            }
            rp.setStage(5);
            if (this.getErrorState().isError()) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            if ((!this.isAsync() && !this.comet || this.getErrorState().isError()) && this.getErrorState().isIoAllowed()) {
                this.getInputBuffer().nextRequest();
                this.getOutputBuffer().nextRequest();
            }
            if (!this.disableUploadTimeout) {
                if (this.endpoint.getSoTimeout() > 0) {
                    this.setSocketTimeout(this.endpoint.getSoTimeout());
                } else {
                    this.setSocketTimeout(0);
                }
            }
            rp.setStage(6);
            if (!this.breakKeepAliveLoop(socketWrapper)) continue;
        }
        rp.setStage(7);
        if (this.getErrorState().isError() || this.endpoint.isPaused()) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync() || this.comet) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        if (this.isUpgrade()) {
            return AbstractEndpoint.Handler.SocketState.UPGRADING;
        }
        if (this.getUpgradeInbound() != null) {
            return AbstractEndpoint.Handler.SocketState.UPGRADING_TOMCAT;
        }
        if (this.sendfileInProgress) {
            return AbstractEndpoint.Handler.SocketState.SENDFILE;
        }
        if (this.openSocket) {
            if (this.readComplete) {
                return AbstractEndpoint.Handler.SocketState.OPEN;
            }
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    private void checkExpectationAndResponseStatus() {
        if (this.expectation && (this.response.getStatus() < 200 || this.response.getStatus() > 299)) {
            this.getInputBuffer().setSwallowInput(false);
            this.keepAlive = false;
        }
    }

    protected void prepareRequest() {
        long contentLength;
        ByteChunk uriBC;
        String userAgentValue;
        MessageBytes userAgentValueMB;
        MessageBytes protocolMB;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = false;
        this.expectation = false;
        this.prepareRequestInternal();
        if (this.endpoint.isSSLEnabled()) {
            this.request.scheme().setString("https");
        }
        if ((protocolMB = this.request.protocol()).equals("HTTP/1.1")) {
            this.http11 = true;
            protocolMB.setString("HTTP/1.1");
        } else if (protocolMB.equals("HTTP/1.0")) {
            this.http11 = false;
            this.keepAlive = false;
            protocolMB.setString("HTTP/1.0");
        } else if (protocolMB.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http11 = false;
            this.response.setStatus(505);
            this.setErrorState(ErrorState.CLOSE_CLEAN, null);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)(sm.getString("http11processor.request.prepare") + " Unsupported HTTP version \"" + protocolMB + "\""));
            }
        }
        MessageBytes methodMB = this.request.method();
        if (methodMB.equals("GET")) {
            methodMB.setString("GET");
        } else if (methodMB.equals("POST")) {
            methodMB.setString("POST");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("Connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                this.keepAlive = false;
            } else if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                this.keepAlive = true;
            }
        }
        MessageBytes expectMB = null;
        if (this.http11) {
            expectMB = headers.getValue("expect");
        }
        if (expectMB != null) {
            if (expectMB.indexOfIgnoreCase("100-continue", 0) != -1) {
                this.getInputBuffer().setSwallowInput(false);
                this.expectation = true;
            } else {
                this.response.setStatus(417);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
            }
        }
        if (this.restrictedUserAgents != null && (this.http11 || this.keepAlive) && (userAgentValueMB = headers.getValue("user-agent")) != null && this.restrictedUserAgents.matcher(userAgentValue = userAgentValueMB.toString()).matches()) {
            this.http11 = false;
            this.keepAlive = false;
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        InputFilter[] inputFilters = this.getInputBuffer().getFilters();
        MessageBytes transferEncodingValueMB = null;
        if (this.http11) {
            transferEncodingValueMB = headers.getValue("transfer-encoding");
        }
        if (transferEncodingValueMB != null) {
            String transferEncodingValue = transferEncodingValueMB.toString();
            int startPos = 0;
            int commaPos = transferEncodingValue.indexOf(44);
            String encodingName = null;
            while (commaPos != -1) {
                encodingName = transferEncodingValue.substring(startPos, commaPos);
                this.addInputFilter(inputFilters, encodingName);
                startPos = commaPos + 1;
                commaPos = transferEncodingValue.indexOf(44, startPos);
            }
            encodingName = transferEncodingValue.substring(startPos);
            this.addInputFilter(inputFilters, encodingName);
        }
        if ((contentLength = this.request.getContentLengthLong()) >= 0L) {
            if (this.contentDelimitation) {
                headers.removeHeader("content-length");
                this.request.setContentLength(-1L);
            } else {
                this.getInputBuffer().addActiveFilter(inputFilters[0]);
                this.contentDelimitation = true;
            }
        }
        MessageBytes valueMB = headers.getValue("host");
        if (this.http11 && valueMB == null) {
            this.response.setStatus(400);
            this.setErrorState(ErrorState.CLOSE_CLEAN, null);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)(sm.getString("http11processor.request.prepare") + " host header missing"));
            }
        }
        this.parseHost(valueMB);
        if (!this.contentDelimitation) {
            this.getInputBuffer().addActiveFilter(inputFilters[2]);
            this.contentDelimitation = true;
        }
        if (this.endpoint.getUseSendfile()) {
            this.request.setAttribute("org.apache.tomcat.sendfile.support", Boolean.TRUE);
        }
        if (this.endpoint.getUseComet()) {
            this.request.setAttribute("org.apache.tomcat.comet.support", Boolean.TRUE);
        }
        if (this.endpoint.getUseCometTimeout()) {
            this.request.setAttribute("org.apache.tomcat.comet.timeout.support", Boolean.TRUE);
        }
        if (this.getErrorState().isError()) {
            this.adapter.log(this.request, this.response, 0L);
        }
    }

    protected abstract void prepareRequestInternal();

    private void prepareResponse() {
        MessageBytes methodMB;
        boolean entityBody = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilters = this.getOutputBuffer().getFilters();
        if (this.http09) {
            this.getOutputBuffer().addActiveFilter(outputFilters[0]);
            return;
        }
        int statusCode = this.response.getStatus();
        if (statusCode < 200 || statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.getOutputBuffer().addActiveFilter(outputFilters[2]);
            entityBody = false;
            this.contentDelimitation = true;
            if (statusCode == 205) {
                this.response.setContentLength(0L);
            } else {
                this.response.setContentLength(-1L);
            }
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.getOutputBuffer().addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
        }
        boolean sendingWithSendfile = false;
        if (this.getEndpoint().getUseSendfile()) {
            sendingWithSendfile = this.prepareSendfile(outputFilters);
        }
        boolean isCompressible = false;
        boolean useCompression = false;
        if (entityBody && this.compressionLevel > 0 && !sendingWithSendfile) {
            isCompressible = this.isCompressible();
            if (isCompressible) {
                useCompression = this.useCompression();
            }
            if (useCompression) {
                this.response.setContentLength(-1L);
            }
        }
        MimeHeaders headers = this.response.getMimeHeaders();
        if (entityBody || statusCode == 204) {
            String contentLanguage;
            String contentType = this.response.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            }
            if ((contentLanguage = this.response.getContentLanguage()) != null) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
        }
        long contentLength = this.response.getContentLengthLong();
        boolean connectionClosePresent = false;
        if (contentLength != -1L) {
            headers.setValue("Content-Length").setLong(contentLength);
            this.getOutputBuffer().addActiveFilter(outputFilters[0]);
            this.contentDelimitation = true;
        } else {
            connectionClosePresent = this.isConnectionClose(headers);
            if (entityBody && this.http11 && !connectionClosePresent) {
                this.getOutputBuffer().addActiveFilter(outputFilters[1]);
                this.contentDelimitation = true;
                headers.addValue("Transfer-Encoding").setString("chunked");
            } else {
                this.getOutputBuffer().addActiveFilter(outputFilters[0]);
            }
        }
        if (useCompression) {
            this.getOutputBuffer().addActiveFilter(outputFilters[3]);
            headers.setValue("Content-Encoding").setString("gzip");
        }
        if (isCompressible) {
            MessageBytes vary = headers.getValue("Vary");
            if (vary == null) {
                headers.setValue("Vary").setString("Accept-Encoding");
            } else if (!vary.equals("*")) {
                headers.setValue("Vary").setString(vary.getString() + ",Accept-Encoding");
            }
        }
        if (headers.getValue("Date") == null) {
            headers.setValue("Date").setString(FastHttpDateFormat.getCurrentDate());
        }
        if (entityBody && !this.contentDelimitation) {
            this.keepAlive = false;
        }
        this.checkExpectationAndResponseStatus();
        boolean bl = this.keepAlive = this.keepAlive && !this.statusDropsConnection(statusCode);
        if (!this.keepAlive) {
            if (!connectionClosePresent) {
                headers.addValue("Connection").setString("close");
            }
        } else if (!this.http11 && !this.getErrorState().isError()) {
            headers.addValue("Connection").setString("keep-alive");
        }
        this.getOutputBuffer().sendStatus();
        if (this.server != null) {
            headers.setValue("Server").setString(this.server);
        } else if (headers.getValue("Server") == null) {
            this.getOutputBuffer().write(Constants.SERVER_BYTES);
        }
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            this.getOutputBuffer().sendHeader(headers.getName(i), headers.getValue(i));
        }
        this.getOutputBuffer().endHeaders();
    }

    private boolean isConnectionClose(MimeHeaders headers) {
        MessageBytes connection = headers.getValue("Connection");
        if (connection == null) {
            return false;
        }
        return connection.equals("close");
    }

    protected abstract boolean prepareSendfile(OutputFilter[] var1);

    protected void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB.isNull()) {
            this.request.setServerPort(this.endpoint.getPort());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        if (this.hostNameC.length < valueL) {
            this.hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            this.hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (!this.endpoint.isSSLEnabled()) {
                this.request.setServerPort(80);
            } else {
                this.request.setServerPort(443);
            }
            this.request.serverName().setChars(this.hostNameC, 0, valueL);
        } else {
            this.request.serverName().setChars(this.hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.getDec(valueB[i + valueS]);
                if (charValue == -1 || charValue > 9) {
                    this.response.setStatus(400);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            this.request.setServerPort(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketStatus status) {
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            rp.setStage(3);
            if (!this.getAdapter().asyncDispatch(this.request, this.response, status)) {
                this.setErrorState(ErrorState.CLOSE_NOW, null);
            }
            this.resetTimeouts();
        }
        catch (InterruptedIOException e) {
            this.setErrorState(ErrorState.CLOSE_NOW, e);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.setErrorState(ErrorState.CLOSE_NOW, t);
            this.getLog().error((Object)sm.getString("http11processor.request.process"), t);
        }
        finally {
            if (this.getErrorState().isError()) {
                this.response.setStatus(500);
                this.adapter.log(this.request, this.response, 0L);
            }
        }
        rp.setStage(7);
        if (this.getErrorState().isError()) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        if (!this.keepAlive) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        this.endRequest();
        this.getInputBuffer().nextRequest();
        this.getOutputBuffer().nextRequest();
        return AbstractEndpoint.Handler.SocketState.OPEN;
    }

    @Override
    public boolean isComet() {
        return this.comet;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState upgradeDispatch() throws IOException {
        throw new IOException(sm.getString("http11Processor.upgrade"));
    }

    @Override
    @Deprecated
    public UpgradeInbound getUpgradeInbound() {
        return this.upgradeInbound;
    }

    @Override
    public boolean isUpgrade() {
        return this.httpUpgradeHandler != null;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState upgradeDispatch(SocketStatus status) throws IOException {
        throw new IOException(sm.getString("ajpprocessor.httpupgrade.notsupported"));
    }

    @Override
    public HttpUpgradeHandler getHttpUpgradeHandler() {
        return this.httpUpgradeHandler;
    }

    protected abstract void resetTimeouts();

    protected abstract void setCometTimeouts(SocketWrapper<S> var1);

    public void endRequest() {
        if (this.getErrorState().isIoAllowed()) {
            try {
                this.getInputBuffer().endRequest();
            }
            catch (IOException e) {
                this.setErrorState(ErrorState.CLOSE_NOW, e);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                this.response.setStatus(500);
                this.setErrorState(ErrorState.CLOSE_NOW, t);
                this.getLog().error((Object)sm.getString("http11processor.request.finish"), t);
            }
        }
        if (this.getErrorState().isIoAllowed()) {
            try {
                this.getOutputBuffer().endRequest();
            }
            catch (IOException e) {
                this.setErrorState(ErrorState.CLOSE_NOW, e);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                this.setErrorState(ErrorState.CLOSE_NOW, t);
                this.getLog().error((Object)sm.getString("http11processor.response.finish"), t);
            }
        }
    }

    protected abstract boolean breakKeepAliveLoop(SocketWrapper<S> var1);

    @Override
    public final void recycle(boolean isSocketClosing) {
        this.getAdapter().checkRecycled(this.request, this.response);
        if (this.getInputBuffer() != null) {
            this.getInputBuffer().recycle();
        }
        if (this.getOutputBuffer() != null) {
            this.getOutputBuffer().recycle();
        }
        if (this.asyncStateMachine != null) {
            this.asyncStateMachine.recycle();
        }
        this.upgradeInbound = null;
        this.httpUpgradeHandler = null;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.localAddr = null;
        this.localName = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.comet = false;
        this.resetErrorState();
        this.recycleInternal();
    }

    protected abstract void recycleInternal();
}

