"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var RamlWrapper = require("./raml08parser");
function getWrapperConstructor(definition) {
    if (!definition.isBuiltIn())
        return null;
    return classMap[definition.nameId()];
}
/**
 * @hidden
 * Build Wrapper node corresponding to the High Level node
 **/
function buildWrapperNode(node, setAsTopLevel) {
    if (setAsTopLevel === void 0) { setAsTopLevel = true; }
    var definition = node.definition();
    var nodeClassName = definition.nameId();
    var wrapperConstructor = getWrapperConstructor(definition);
    if (!wrapperConstructor) {
        var priorities = determineSuperclassesPriorities(definition);
        var superTypes = definition.allSuperTypes().sort(function (x, y) { return priorities[x.nameId()] - priorities[y.nameId()]; });
        var wr = null;
        for (var i = 0; i < superTypes.length; i++) {
            var superTypeName = superTypes[i].nameId();
            wrapperConstructor = getWrapperConstructor(superTypes[i]);
            if (superTypeName == "DataElement") {
                wr = superTypeName;
                //This is only case of nested hierarchy
                continue;
            }
            if (superTypeName == "hl.BasicNode") {
                //depth first
                continue;
            }
            if (wrapperConstructor) {
                break;
            }
        }
        if (!wrapperConstructor) {
            wr = superTypeName;
        }
    }
    if (!wrapperConstructor) {
        wrapperConstructor = classMap["hl.BasicNode"];
    }
    return wrapperConstructor(node, setAsTopLevel);
}
exports.buildWrapperNode = buildWrapperNode;
function determineSuperclassesPriorities(td, priorities, path) {
    if (priorities === void 0) { priorities = {}; }
    if (path === void 0) { path = {}; }
    var typeName = td.nameId();
    if (path[typeName]) {
        return;
    }
    path[typeName] = true;
    var rank = (priorities[typeName] != null && priorities[typeName] + 1) || 0;
    var superTypes = td.superTypes();
    superTypes.forEach(function (x) {
        var name = x.nameId();
        var r = priorities[name];
        if (r == null || rank > r) {
            priorities[name] = rank;
            determineSuperclassesPriorities(x, priorities, path);
        }
    });
    delete path[typeName];
    return priorities;
}
var classMap = {
    "AbstractSecurityScheme": function (x, y) { return new RamlWrapper.AbstractSecuritySchemeImpl(x, y); },
    "AnyType": function (x) { return new RamlWrapper.AnyTypeImpl(x); },
    "Api": function (x, y) { return new RamlWrapper.ApiImpl(x, y); },
    "BasicSecurityScheme": function (x, y) { return new RamlWrapper.BasicSecuritySchemeImpl(x, y); },
    "BodyLike": function (x, y) { return new RamlWrapper.BodyLikeImpl(x, y); },
    "BooleanType": function (x) { return new RamlWrapper.BooleanTypeImpl(x); },
    "BooleanTypeDeclaration": function (x, y) { return new RamlWrapper.BooleanTypeDeclarationImpl(x, y); },
    "CustomSecurityScheme": function (x, y) { return new RamlWrapper.CustomSecuritySchemeImpl(x, y); },
    "DateTypeDeclaration": function (x, y) { return new RamlWrapper.DateTypeDeclarationImpl(x, y); },
    "DigestSecurityScheme": function (x, y) { return new RamlWrapper.DigestSecuritySchemeImpl(x, y); },
    "DocumentationItem": function (x, y) { return new RamlWrapper.DocumentationItemImpl(x, y); },
    "ExampleString": function (x) { return new RamlWrapper.ExampleStringImpl(x); },
    "FileTypeDeclaration": function (x, y) { return new RamlWrapper.FileTypeDeclarationImpl(x, y); },
    "FixedUri": function (x) { return new RamlWrapper.FixedUriImpl(x); },
    "FullUriTemplateString": function (x) { return new RamlWrapper.FullUriTemplateStringImpl(x); },
    "GlobalSchema": function (x, y) { return new RamlWrapper.GlobalSchemaImpl(x, y); },
    "IntegerTypeDeclaration": function (x, y) { return new RamlWrapper.IntegerTypeDeclarationImpl(x, y); },
    "JSONBody": function (x, y) { return new RamlWrapper.JSONBodyImpl(x, y); },
    "JSONExample": function (x) { return new RamlWrapper.JSONExampleImpl(x); },
    "JSonSchemaString": function (x) { return new RamlWrapper.JSonSchemaStringImpl(x); },
    "MarkdownString": function (x) { return new RamlWrapper.MarkdownStringImpl(x); },
    "Method": function (x, y) { return new RamlWrapper.MethodImpl(x, y); },
    "MethodBase": function (x, y) { return new RamlWrapper.MethodBaseImpl(x, y); },
    "MimeType": function (x) { return new RamlWrapper.MimeTypeImpl(x); },
    "NumberType": function (x) { return new RamlWrapper.NumberTypeImpl(x); },
    "NumberTypeDeclaration": function (x, y) { return new RamlWrapper.NumberTypeDeclarationImpl(x, y); },
    "OAuth1SecurityScheme": function (x, y) { return new RamlWrapper.OAuth1SecuritySchemeImpl(x, y); },
    "OAuth1SecuritySchemeSettings": function (x, y) { return new RamlWrapper.OAuth1SecuritySchemeSettingsImpl(x, y); },
    "OAuth2SecurityScheme": function (x, y) { return new RamlWrapper.OAuth2SecuritySchemeImpl(x, y); },
    "OAuth2SecuritySchemeSettings": function (x, y) { return new RamlWrapper.OAuth2SecuritySchemeSettingsImpl(x, y); },
    "Parameter": function (x, y) { return new RamlWrapper.ParameterImpl(x, y); },
    "ParameterLocation": function (x) { return new RamlWrapper.ParameterLocationImpl(x); },
    "RAMLSimpleElement": function (x, y) { return new RamlWrapper.RAMLSimpleElementImpl(x, y); },
    "Reference": function (x) { return new RamlWrapper.ReferenceImpl(x); },
    "RelativeUriString": function (x) { return new RamlWrapper.RelativeUriStringImpl(x); },
    "Resource": function (x, y) { return new RamlWrapper.ResourceImpl(x, y); },
    "ResourceType": function (x, y) { return new RamlWrapper.ResourceTypeImpl(x, y); },
    "ResourceTypeRef": function (x) { return new RamlWrapper.ResourceTypeRefImpl(x); },
    "Response": function (x, y) { return new RamlWrapper.ResponseImpl(x, y); },
    "SchemaString": function (x) { return new RamlWrapper.SchemaStringImpl(x); },
    "SecuritySchemePart": function (x, y) { return new RamlWrapper.SecuritySchemePartImpl(x, y); },
    "SecuritySchemeRef": function (x) { return new RamlWrapper.SecuritySchemeRefImpl(x); },
    "SecuritySchemeSettings": function (x, y) { return new RamlWrapper.SecuritySchemeSettingsImpl(x, y); },
    "StatusCodeString": function (x) { return new RamlWrapper.StatusCodeStringImpl(x); },
    "StringType": function (x) { return new RamlWrapper.StringTypeImpl(x); },
    "StringTypeDeclaration": function (x, y) { return new RamlWrapper.StringTypeDeclarationImpl(x, y); },
    "Trait": function (x, y) { return new RamlWrapper.TraitImpl(x, y); },
    "TraitRef": function (x) { return new RamlWrapper.TraitRefImpl(x); },
    "UriTemplate": function (x) { return new RamlWrapper.UriTemplateImpl(x); },
    "ValueType": function (x) { return new RamlWrapper.ValueTypeImpl(x); },
    "XMLBody": function (x, y) { return new RamlWrapper.XMLBodyImpl(x, y); },
    "XMLExample": function (x) { return new RamlWrapper.XMLExampleImpl(x); },
    "XMLSchemaString": function (x) { return new RamlWrapper.XMLSchemaStringImpl(x); }
};
//# sourceMappingURL=raml08factory.js.map