/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.pdf.CMapBuilder;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFCMap;

public class PDFToUnicodeCMap
extends PDFCMap {
    protected char[] unicodeCharMap;
    private boolean singleByte;

    public PDFToUnicodeCMap(char[] unicodeCharMap, String name, PDFCIDSystemInfo sysInfo, boolean singleByte) {
        super(name, sysInfo);
        if (singleByte && unicodeCharMap.length > 256) {
            throw new IllegalArgumentException("unicodeCharMap may not contain more than 256 characters for single-byte encodings");
        }
        this.unicodeCharMap = unicodeCharMap;
        this.singleByte = singleByte;
    }

    @Override
    protected CMapBuilder createCMapBuilder(Writer writer) {
        return new ToUnicodeCMapBuilder(writer);
    }

    class ToUnicodeCMapBuilder
    extends CMapBuilder {
        public ToUnicodeCMapBuilder(Writer writer) {
            super(writer, null);
        }

        @Override
        public void writeCMap() throws IOException {
            this.writeCIDInit();
            this.writeCIDSystemInfo("Adobe", "UCS", 0);
            this.writeName("Adobe-Identity-UCS");
            this.writeType("2");
            this.writeCodeSpaceRange(PDFToUnicodeCMap.this.singleByte);
            this.writeBFEntries();
            this.writeWrapUp();
        }

        @Override
        protected void writeBFEntries() throws IOException {
            if (PDFToUnicodeCMap.this.unicodeCharMap != null) {
                this.writeBFCharEntries(PDFToUnicodeCMap.this.unicodeCharMap);
                this.writeBFRangeEntries(PDFToUnicodeCMap.this.unicodeCharMap);
            }
        }

        protected void writeBFCharEntries(char[] charArray) throws IOException {
            int entriesThisSection;
            int totalEntries = 0;
            for (int i = 0; i < charArray.length; ++i) {
                if (this.partOfRange(charArray, i)) continue;
                ++totalEntries;
            }
            if (totalEntries < 1) {
                return;
            }
            int remainingEntries = totalEntries;
            int charIndex = 0;
            do {
                entriesThisSection = Math.min(remainingEntries, 100);
                this.writer.write(entriesThisSection + " beginbfchar\n");
                for (int i = 0; i < entriesThisSection; ++i) {
                    while (this.partOfRange(charArray, charIndex)) {
                        ++charIndex;
                    }
                    this.writer.write("<" + this.padCharIndex(charIndex) + "> ");
                    if (Character.codePointAt(charArray, charIndex) > 65535) {
                        String pairs = Integer.toHexString(charArray[charIndex]) + Integer.toHexString(charArray[++charIndex]);
                        this.writer.write("<" + pairs + ">\n");
                        ++i;
                    } else {
                        this.writer.write("<" + this.padHexString(Integer.toHexString(charArray[charIndex]), 4) + ">\n");
                    }
                    ++charIndex;
                }
                this.writer.write("endbfchar\n");
            } while ((remainingEntries -= entriesThisSection) > 0);
        }

        private String padCharIndex(int charIndex) {
            return this.padHexString(Integer.toHexString(charIndex), PDFToUnicodeCMap.this.singleByte ? 2 : 4);
        }

        protected void writeBFRangeEntries(char[] charArray) throws IOException {
            int entriesThisSection;
            int totalEntries = 0;
            for (int i = 0; i < charArray.length; ++i) {
                if (!this.startOfRange(charArray, i)) continue;
                ++totalEntries;
            }
            if (totalEntries < 1) {
                return;
            }
            int remainingEntries = totalEntries;
            int charIndex = 0;
            do {
                entriesThisSection = Math.min(remainingEntries, 100);
                this.writer.write(entriesThisSection + " beginbfrange\n");
                for (int i = 0; i < entriesThisSection; ++i) {
                    while (!this.startOfRange(charArray, charIndex)) {
                        ++charIndex;
                    }
                    this.writer.write("<" + this.padCharIndex(charIndex) + "> ");
                    this.writer.write("<" + this.padCharIndex(this.endOfRange(charArray, charIndex)) + "> ");
                    this.writer.write("<" + this.padHexString(Integer.toHexString(charArray[charIndex]), 4) + ">\n");
                    ++charIndex;
                }
                this.writer.write("endbfrange\n");
            } while ((remainingEntries -= entriesThisSection) > 0);
        }

        private int endOfRange(char[] charArray, int startOfRange) {
            int i;
            for (i = startOfRange; i < charArray.length - 1 && this.sameRangeEntryAsNext(charArray, i); ++i) {
            }
            return i;
        }

        private boolean partOfRange(char[] charArray, int arrayIndex) {
            if (charArray.length < 2) {
                return false;
            }
            if (arrayIndex == 0) {
                return this.sameRangeEntryAsNext(charArray, 0);
            }
            if (arrayIndex == charArray.length - 1) {
                return this.sameRangeEntryAsNext(charArray, arrayIndex - 1);
            }
            if (this.sameRangeEntryAsNext(charArray, arrayIndex - 1)) {
                return true;
            }
            return this.sameRangeEntryAsNext(charArray, arrayIndex);
        }

        private boolean sameRangeEntryAsNext(char[] charArray, int firstItem) {
            if (charArray[firstItem] + '\u0001' != charArray[firstItem + 1]) {
                return false;
            }
            return firstItem / 256 == (firstItem + 1) / 256;
        }

        private boolean startOfRange(char[] charArray, int arrayIndex) {
            if (!this.partOfRange(charArray, arrayIndex)) {
                return false;
            }
            if (arrayIndex == 0) {
                return true;
            }
            if (arrayIndex == charArray.length - 1) {
                return false;
            }
            return !this.sameRangeEntryAsNext(charArray, arrayIndex - 1);
        }

        private String padHexString(String input, int numChars) {
            int length = input.length();
            if (length >= numChars) {
                return input;
            }
            StringBuffer returnString = new StringBuffer();
            for (int i = 1; i <= numChars - length; ++i) {
                returnString.append("0");
            }
            returnString.append(input);
            return returnString.toString();
        }
    }
}

