/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components.gradientslider;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.gephi.ui.components.gradientslider.MultiThumbSlider;

public abstract class MultiThumbSliderUI
extends ComponentUI
implements MouseListener,
MouseMotionListener {
    protected MultiThumbSlider slider;
    int MAX_LENGTH = 300;
    int MIN_LENGTH = 50;
    int PREF_LENGTH = 140;
    int DEPTH = 15;
    int[] thumbPositions = new int[0];
    protected float[] thumbIndications = new float[0];
    private float indicationGoal = 0.0f;
    float indication = 0.0f;
    protected Rectangle trackRect = new Rectangle(0, 0, 0, 0);
    Thread animatingThread = null;
    Runnable animatingRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean finished = false;
            while (!finished) {
                MultiThumbSliderUI multiThumbSliderUI = MultiThumbSliderUI.this;
                synchronized (multiThumbSliderUI) {
                    finished = true;
                    for (int a = 0; a < MultiThumbSliderUI.this.thumbIndications.length; ++a) {
                        if (a != MultiThumbSliderUI.this.slider.getSelectedThumb()) {
                            if (a == MultiThumbSliderUI.this.currentIndicatedThumb) {
                                if (!(MultiThumbSliderUI.this.thumbIndications[a] < 1.0f)) continue;
                                MultiThumbSliderUI.this.thumbIndications[a] = Math.min(1.0f, MultiThumbSliderUI.this.thumbIndications[a] + 0.025f);
                                finished = false;
                                continue;
                            }
                            if (!(MultiThumbSliderUI.this.thumbIndications[a] > 0.0f)) continue;
                            MultiThumbSliderUI.this.thumbIndications[a] = Math.max(0.0f, MultiThumbSliderUI.this.thumbIndications[a] - 0.025f);
                            finished = false;
                            continue;
                        }
                        MultiThumbSliderUI.this.thumbIndications[a] = a == MultiThumbSliderUI.this.currentIndicatedThumb ? 1.0f : 0.0f;
                    }
                    if (MultiThumbSliderUI.this.indicationGoal > MultiThumbSliderUI.this.indication + 0.01f) {
                        if (MultiThumbSliderUI.this.indication < 0.99f) {
                            MultiThumbSliderUI.this.indication = Math.min(1.0f, MultiThumbSliderUI.this.indication + 0.1f);
                            finished = false;
                        }
                    } else if (MultiThumbSliderUI.this.indicationGoal < MultiThumbSliderUI.this.indication - 0.01f && MultiThumbSliderUI.this.indication > 0.01f) {
                        MultiThumbSliderUI.this.indication = Math.max(0.0f, MultiThumbSliderUI.this.indication - 0.1f);
                        finished = false;
                    }
                }
                if (!finished) {
                    MultiThumbSliderUI.this.slider.repaint();
                }
                long t = System.currentTimeMillis();
                while (System.currentTimeMillis() - t < 20L) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception e) {
                        Thread.yield();
                    }
                }
            }
        }
    };
    private int currentIndicatedThumb = -1;
    private boolean mouseInside = false;
    private boolean mouseIsDown = false;
    private State pressedState;
    private int dx;
    private int dy;
    FocusListener focusListener = new FocusListener(){

        @Override
        public void focusLost(FocusEvent e) {
            Component c = (Component)e.getSource();
            if (MultiThumbSliderUI.getProperty(MultiThumbSliderUI.this.slider, "MultiThumbSlider.indicateComponent", "true").toString().equals("true")) {
                MultiThumbSliderUI.this.slider.setSelectedThumb(-1);
            }
            MultiThumbSliderUI.this.updateIndication();
            c.repaint();
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component c = (Component)e.getSource();
            int i = MultiThumbSliderUI.this.slider.getSelectedThumb(false);
            if (i == -1) {
                int direction = 1;
                if (MultiThumbSliderUI.this.slider.getOrientation() == 1) {
                    direction *= -1;
                }
                if (MultiThumbSliderUI.this.slider.isInverted()) {
                    direction *= -1;
                }
                MultiThumbSliderUI.this.slider.setSelectedThumb(direction == 1 ? 0 : MultiThumbSliderUI.this.slider.getThumbCount() - 1);
            }
            MultiThumbSliderUI.this.updateIndication();
            c.repaint();
        }
    };
    KeyListener keyListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent e) {
            int y;
            int x;
            if (!MultiThumbSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (e.getSource() != MultiThumbSliderUI.this.slider) {
                throw new RuntimeException("only install this UI on the GradientSlider it was constructed with");
            }
            int i = MultiThumbSliderUI.this.slider.getSelectedThumb();
            int code = e.getKeyCode();
            int orientation = MultiThumbSliderUI.this.slider.getOrientation();
            if (i != -1 && (code == 39 || code == 37) && orientation == 0 && e.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                int i2 = code == 39 && !MultiThumbSliderUI.this.slider.isInverted() || code == 37 && MultiThumbSliderUI.this.slider.isInverted() ? i + 1 : i - 1;
                MultiThumbSliderUI.this.addThumb(i, i2);
                e.consume();
                return;
            }
            if (i != -1 && (code == 38 || code == 40) && orientation == 1 && e.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                int i2 = code == 38 && !MultiThumbSliderUI.this.slider.isInverted() || code == 40 && MultiThumbSliderUI.this.slider.isInverted() ? i + 1 : i - 1;
                MultiThumbSliderUI.this.addThumb(i, i2);
                e.consume();
                return;
            }
            if (code == 40 && orientation == 0 && i != -1) {
                int y2;
                int x2 = MultiThumbSliderUI.this.slider.isInverted() ? (int)((float)MultiThumbSliderUI.this.trackRect.x + (float)MultiThumbSliderUI.this.trackRect.width * (1.0f - MultiThumbSliderUI.this.slider.getThumbPositions()[i])) : (int)((float)MultiThumbSliderUI.this.trackRect.x + (float)MultiThumbSliderUI.this.trackRect.width * MultiThumbSliderUI.this.slider.getThumbPositions()[i]);
                if (MultiThumbSliderUI.this.slider.doPopup(x2, y2 = MultiThumbSliderUI.this.trackRect.y + MultiThumbSliderUI.this.trackRect.height)) {
                    e.consume();
                    return;
                }
            } else if (code == 39 && orientation == 1 && i != -1 && MultiThumbSliderUI.this.slider.doPopup(x = MultiThumbSliderUI.this.trackRect.x + MultiThumbSliderUI.this.trackRect.width, y = MultiThumbSliderUI.this.slider.isInverted() ? (int)((float)MultiThumbSliderUI.this.trackRect.y + (float)MultiThumbSliderUI.this.trackRect.height * MultiThumbSliderUI.this.slider.getThumbPositions()[i]) : (int)((float)MultiThumbSliderUI.this.trackRect.y + (float)MultiThumbSliderUI.this.trackRect.height * (1.0f - MultiThumbSliderUI.this.slider.getThumbPositions()[i])))) {
                e.consume();
                return;
            }
            if (i != -1) {
                if (code == 39 || code == 40) {
                    MultiThumbSliderUI.this.nudge(i, 1);
                    e.consume();
                } else if (code == 37 || code == 38) {
                    MultiThumbSliderUI.this.nudge(i, -1);
                    e.consume();
                } else if (code == 127 || code == 8) {
                    if (MultiThumbSliderUI.this.slider.getThumbCount() > 2) {
                        MultiThumbSliderUI.this.slider.removeThumb(i);
                        e.consume();
                    }
                } else if (code == 32 || code == 10) {
                    MultiThumbSliderUI.this.slider.doDoubleClick(-1, -1);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    };
    PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("values") || name.equals("orientation") || name.equals("inverted")) {
                MultiThumbSliderUI.this.calculateGeometry();
                MultiThumbSliderUI.this.slider.repaint();
            } else if (name.equals("selected thumb") || name.equals("paint ticks")) {
                MultiThumbSliderUI.this.slider.repaint();
            } else if (name.equals("MultiThumbSlider.indicateComponent")) {
                MultiThumbSliderUI.this.setMouseInside(MultiThumbSliderUI.this.mouseInside);
                MultiThumbSliderUI.this.slider.repaint();
            }
        }
    };
    ComponentListener compListener = new ComponentListener(){

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            MultiThumbSliderUI.this.calculateGeometry();
            Component c = (Component)e.getSource();
            c.repaint();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    };

    public MultiThumbSliderUI(MultiThumbSlider slider) {
        this.slider = slider;
    }

    @Override
    public Dimension getMaximumSize(JComponent s) {
        MultiThumbSlider mySlider = (MultiThumbSlider)s;
        if (mySlider.getOrientation() == 0) {
            return new Dimension(this.MAX_LENGTH, this.DEPTH);
        }
        return new Dimension(this.DEPTH, this.MAX_LENGTH);
    }

    @Override
    public Dimension getMinimumSize(JComponent s) {
        MultiThumbSlider mySlider = (MultiThumbSlider)s;
        if (mySlider.getOrientation() == 0) {
            return new Dimension(this.MIN_LENGTH, this.DEPTH);
        }
        return new Dimension(this.DEPTH, this.MIN_LENGTH);
    }

    @Override
    public Dimension getPreferredSize(JComponent s) {
        MultiThumbSlider mySlider = (MultiThumbSlider)s;
        if (mySlider.getOrientation() == 0) {
            return new Dimension(this.PREF_LENGTH, this.DEPTH);
        }
        return new Dimension(this.DEPTH, this.PREF_LENGTH);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dx = 0;
        this.dy = 0;
        if (!this.slider.isEnabled()) {
            return;
        }
        if (e.getClickCount() >= 2) {
            if (this.slider.doDoubleClick(e.getX(), e.getY())) {
                e.consume();
                return;
            }
        } else if (e.isPopupTrigger()) {
            int x = e.getX();
            int y = e.getY();
            if (this.slider.getOrientation() == 0) {
                if (x < this.trackRect.x || x > this.trackRect.x + this.trackRect.width) {
                    return;
                }
                y = this.trackRect.y + this.trackRect.height;
            } else {
                if (y < this.trackRect.y || y > this.trackRect.y + this.trackRect.height) {
                    return;
                }
                x = this.trackRect.x + this.trackRect.width;
            }
            if (this.slider.doPopup(x, y)) {
                e.consume();
                return;
            }
        }
        this.mouseIsDown = true;
        this.mouseMoved(e);
        if (e.getSource() != this.slider) {
            throw new RuntimeException("only install this UI on the GradientSlider it was constructed with");
        }
        this.slider.requestFocus();
        int index = this.getIndex(e);
        if (index != -1) {
            if (this.slider.getOrientation() == 0) {
                this.dx = -e.getX() + this.thumbPositions[index];
            } else {
                this.dy = -e.getY() + this.thumbPositions[index];
            }
        }
        if (index != -1) {
            this.slider.setSelectedThumb(index);
            e.consume();
        } else if (this.slider.isAutoAdding()) {
            float k;
            int v = this.slider.getOrientation() == 0 ? e.getX() : e.getY();
            if (this.slider.getOrientation() == 0) {
                k = (float)(v - this.trackRect.x) / (float)this.trackRect.width;
                if (this.slider.isInverted()) {
                    k = 1.0f - k;
                }
            } else {
                k = (float)(v - this.trackRect.y) / (float)this.trackRect.height;
                if (!this.slider.isInverted()) {
                    k = 1.0f - k;
                }
            }
            if (k > 0.0f && k < 1.0f && !this.slider.isBlocked()) {
                int added = this.slider.addThumb(k);
                this.slider.setSelectedThumb(added);
            }
            e.consume();
        } else if (this.slider.getSelectedThumb() != -1) {
            this.slider.setSelectedThumb(-1);
            e.consume();
        }
        this.pressedState = new State();
    }

    private int getIndex(MouseEvent e) {
        int v;
        if (this.slider.getOrientation() == 0 ? (v = e.getX()) < this.trackRect.x - this.getClickLocationTolerance() + 1 || v > this.trackRect.x + this.trackRect.width + this.getClickLocationTolerance() - 1 : (v = e.getY()) < this.trackRect.y - this.getClickLocationTolerance() + 1 || v > this.trackRect.y + this.trackRect.height + this.getClickLocationTolerance() - 1) {
            return -1;
        }
        if (this.thumbPositions.length == 0) {
            return -1;
        }
        int min = Math.abs(v - this.thumbPositions[0]);
        int minIndex = 0;
        for (int a = 1; a < this.thumbPositions.length; ++a) {
            int distance = Math.abs(v - this.thumbPositions[a]);
            if (distance >= min) continue;
            min = distance;
            minIndex = a;
        }
        if (min < this.getClickLocationTolerance()) {
            return minIndex;
        }
        return -1;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCurrentIndicatedThumb(-1);
        this.setMouseInside(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean b;
        if (!this.slider.isEnabled()) {
            return;
        }
        int i = this.getIndex(e);
        this.setCurrentIndicatedThumb(i);
        boolean bl = b = e.getX() >= 0 && e.getX() < this.slider.getWidth() && e.getY() >= 0 && e.getY() < this.slider.getHeight();
        if (this.mouseIsDown) {
            b = true;
        }
        this.setMouseInside(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentIndicatedThumb(int i) {
        if (MultiThumbSliderUI.getProperty(this.slider, "MultiThumbSlider.indicateThumb", "true").equals("false")) {
            i = -1;
        }
        this.currentIndicatedThumb = i;
        boolean finished = true;
        for (int a = 0; a < this.thumbIndications.length; ++a) {
            if (a == this.currentIndicatedThumb) {
                if (this.thumbIndications[a] == 1.0f) continue;
                finished = false;
                continue;
            }
            if (this.thumbIndications[a] == 0.0f) continue;
            finished = false;
        }
        if (!finished) {
            MultiThumbSliderUI multiThumbSliderUI = this;
            synchronized (multiThumbSliderUI) {
                if (this.animatingThread == null || !this.animatingThread.isAlive()) {
                    this.animatingThread = new Thread(this.animatingRunnable);
                    this.animatingThread.start();
                }
            }
        }
    }

    private void setMouseInside(boolean b) {
        this.mouseInside = b;
        this.updateIndication();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.slider.isEnabled()) {
            return;
        }
        e.translatePoint(this.dx, this.dy);
        this.mouseMoved(e);
        if (this.pressedState != null && this.pressedState.selectedThumb != -1) {
            boolean outside;
            float v;
            this.slider.setValueIsAdjusting(true);
            State newState = new State(this.pressedState);
            if (this.slider.getOrientation() == 0) {
                v = (float)(e.getX() - this.trackRect.x) / (float)this.trackRect.width;
                if (this.slider.isInverted()) {
                    v = 1.0f - v;
                }
                boolean bl = outside = e.getY() < this.trackRect.y - 10 || e.getY() > this.trackRect.y + this.trackRect.height + 10;
                if (e.getX() > this.trackRect.x - 10 && e.getX() < this.trackRect.x + this.trackRect.width + 10) {
                    if (v < 0.0f) {
                        v = 0.0f;
                    }
                    if (v > 1.0f) {
                        v = 1.0f;
                    }
                }
            } else {
                v = (float)(e.getY() - this.trackRect.y) / (float)this.trackRect.height;
                if (!this.slider.isInverted()) {
                    v = 1.0f - v;
                }
                boolean bl = outside = e.getX() < this.trackRect.x - 10 || e.getX() > this.trackRect.x + this.trackRect.width + 10;
                if (e.getY() > this.trackRect.y - 10 && e.getY() < this.trackRect.y + this.trackRect.height + 10) {
                    if (v < 0.0f) {
                        v = 0.0f;
                    }
                    if (v > 1.0f) {
                        v = 1.0f;
                    }
                }
            }
            if (newState.positions.length <= 2) {
                outside = false;
            }
            newState.positions[newState.selectedThumb] = v;
            if (outside) {
                newState.removeThumb(newState.selectedThumb);
            }
            if (MultiThumbSliderUI.validatePositions(newState)) {
                newState.install();
            }
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.slider.isEnabled()) {
            return;
        }
        boolean mousDownFox = this.mouseIsDown;
        this.mouseIsDown = false;
        if (mousDownFox && this.pressedState != null && this.slider.getThumbCount() <= this.pressedState.positions.length) {
            this.mouseDragged(e);
        }
        if (this.slider.isValueAdjusting()) {
            this.slider.setValueIsAdjusting(false);
        }
        if (e.isPopupTrigger() && this.slider.doPopup(e.getX(), e.getY())) {
            e.consume();
            return;
        }
    }

    public static String getProperty(JComponent jc, String propertyName, String defaultValue) {
        Object jcValue = jc.getClientProperty(propertyName);
        if (jcValue != null) {
            return jcValue.toString();
        }
        Object uiValue = UIManager.get(propertyName);
        if (uiValue != null) {
            return uiValue.toString();
        }
        return defaultValue;
    }

    public abstract int getClickLocationTolerance();

    protected static boolean validatePositions(State state) {
        float[] p = state.positions;
        Object[] c = state.values;
        if (p.length <= 2) {
            for (int a = 0; a < p.length; ++a) {
                if (p[a] < 0.0f) {
                    p[a] = 0.0f;
                    continue;
                }
                if (!(p[a] > 1.0f)) continue;
                p[a] = 1.0f;
            }
        }
        boolean checkAgain = true;
        while (checkAgain) {
            checkAgain = false;
            for (int a = 0; a < p.length - 1; ++a) {
                if (p[a] == p[a + 1]) {
                    return false;
                }
                if (!(p[a] > p[a + 1])) continue;
                checkAgain = true;
                float swap1 = p[a];
                p[a] = p[a + 1];
                p[a + 1] = swap1;
                Object swap2 = c[a];
                c[a] = c[a + 1];
                c[a + 1] = swap2;
                if (a == state.selectedThumb) {
                    state.selectedThumb = a + 1;
                    continue;
                }
                if (a + 1 != state.selectedThumb) continue;
                state.selectedThumb = a;
            }
        }
        return true;
    }

    protected boolean addThumb(int index1, int index2) {
        int max;
        int min;
        float pos1 = 0.0f;
        float pos2 = 1.0f;
        if (index1 < index2) {
            min = index1;
            max = index2;
        } else {
            min = index2;
            max = index1;
        }
        float[] positions = this.slider.getThumbPositions();
        if (min >= 0) {
            pos1 = positions[min];
        }
        if (max < positions.length) {
            pos2 = positions[max];
        }
        if ((double)(pos2 - pos1) < 0.05) {
            return false;
        }
        float newPosition = (pos1 + pos2) / 2.0f;
        this.slider.setSelectedThumb(this.slider.addThumb(newPosition));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIndication() {
        MultiThumbSliderUI multiThumbSliderUI = this;
        synchronized (multiThumbSliderUI) {
            this.indicationGoal = this.slider.isEnabled() && (this.slider.hasFocus() || this.mouseInside) ? 1.0f : 0.0f;
            if (MultiThumbSliderUI.getProperty(this.slider, "MultiThumbSlider.indicateComponent", "true").equals("false")) {
                this.indicationGoal = 1.0f;
                if (!this.slider.isVisible()) {
                    this.indication = 1.0f;
                }
            }
            if (!(this.indication == this.indicationGoal || this.animatingThread != null && this.animatingThread.isAlive())) {
                this.animatingThread = new Thread(this.animatingRunnable);
                this.animatingThread.start();
            }
        }
    }

    protected synchronized void calculateGeometry() {
        this.trackRect = this.calculateTrackRect();
        float[] pos = this.slider.getThumbPositions();
        if (this.thumbPositions.length != pos.length) {
            this.thumbPositions = new int[pos.length];
            this.thumbIndications = new float[pos.length];
        }
        if (this.slider.getOrientation() == 0) {
            for (int a = 0; a < this.thumbPositions.length; ++a) {
                this.thumbPositions[a] = !this.slider.isInverted() ? this.trackRect.x + (int)((float)this.trackRect.width * pos[a]) : this.trackRect.x + (int)((float)this.trackRect.width * (1.0f - pos[a]));
                this.thumbIndications[a] = 0.0f;
            }
        } else {
            for (int a = 0; a < this.thumbPositions.length; ++a) {
                this.thumbPositions[a] = this.slider.isInverted() ? this.trackRect.y + (int)((float)this.trackRect.height * pos[a]) : this.trackRect.y + (int)((float)this.trackRect.height * (1.0f - pos[a]));
                this.thumbIndications[a] = 0.0f;
            }
        }
    }

    protected Rectangle calculateTrackRect() {
        int h;
        int w;
        Insets i = new Insets(5, 5, 5, 5);
        if (this.slider.getOrientation() == 0) {
            w = this.slider.getWidth() - i.left - i.right;
            h = Math.min(this.DEPTH, this.slider.getHeight() - i.top - i.bottom);
        } else {
            h = this.slider.getHeight() - i.top - i.bottom;
            w = Math.min(this.DEPTH, this.slider.getWidth() - i.left - i.right);
        }
        return new Rectangle(this.slider.getWidth() / 2 - w / 2, this.slider.getHeight() / 2 - h / 2, w, h);
    }

    private void nudge(int thumbIndex, int direction) {
        float pixelFraction = this.slider.getOrientation() == 0 ? 1.0f / (float)this.trackRect.width : 1.0f / (float)this.trackRect.height;
        if (direction < 0) {
            pixelFraction *= -1.0f;
        }
        if (this.slider.isInverted()) {
            pixelFraction *= -1.0f;
        }
        if (this.slider.getOrientation() == 1) {
            pixelFraction *= -1.0f;
        }
        State state = new State();
        while (state.positions[thumbIndex] >= 0.0f && state.positions[thumbIndex] <= 1.0f) {
            int n = thumbIndex;
            state.positions[n] = state.positions[n] + pixelFraction;
            if (!MultiThumbSliderUI.validatePositions(state)) continue;
            state.install();
            return;
        }
    }

    @Override
    public void installUI(JComponent slider) {
        slider.addMouseListener(this);
        slider.addMouseMotionListener(this);
        slider.addFocusListener(this.focusListener);
        slider.addKeyListener(this.keyListener);
        slider.addComponentListener(this.compListener);
        slider.addPropertyChangeListener(this.propertyListener);
    }

    @Override
    public void paint(Graphics g, JComponent slider2) {
        if (slider2 != this.slider) {
            throw new RuntimeException("only use this UI on the GradientSlider it was constructed with");
        }
        Graphics2D g2 = (Graphics2D)g;
        int w = this.slider.getWidth();
        int h = this.slider.getHeight();
        if (this.slider.isOpaque()) {
            g.setColor(this.slider.getBackground());
            g.fillRect(0, 0, w, h);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.paintTrack(g2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintFocus(g2);
        this.paintThumbs(g2);
    }

    protected abstract void paintTrack(Graphics2D var1);

    protected abstract void paintFocus(Graphics2D var1);

    protected abstract void paintThumbs(Graphics2D var1);

    @Override
    public void uninstallUI(JComponent slider) {
        slider.removeMouseListener(this);
        slider.removeMouseMotionListener(this);
        slider.removeFocusListener(this.focusListener);
        slider.removeKeyListener(this.keyListener);
        slider.removeComponentListener(this.compListener);
        slider.removePropertyChangeListener(this.propertyListener);
        super.uninstallUI(slider);
    }

    class State {
        Object[] values;
        float[] positions;
        int selectedThumb;

        public State() {
            this.values = MultiThumbSliderUI.this.slider.getValues();
            this.positions = MultiThumbSliderUI.this.slider.getThumbPositions();
            this.selectedThumb = MultiThumbSliderUI.this.slider.getSelectedThumb(false);
        }

        public State(State s) {
            this.selectedThumb = s.selectedThumb;
            this.positions = new float[s.positions.length];
            this.values = new Object[s.values.length];
            System.arraycopy(s.positions, 0, this.positions, 0, this.positions.length);
            System.arraycopy(s.values, 0, this.values, 0, this.values.length);
        }

        private void polish() {
            Object[] c2;
            float[] f2;
            while (this.positions[0] < 0.0f) {
                f2 = new float[this.positions.length - 1];
                System.arraycopy(this.positions, 1, f2, 0, this.positions.length - 1);
                c2 = new Object[this.values.length - 1];
                System.arraycopy(this.values, 1, c2, 0, this.positions.length - 1);
                this.positions = f2;
                this.values = c2;
                ++this.selectedThumb;
            }
            while (this.positions[this.positions.length - 1] > 1.0f) {
                f2 = new float[this.positions.length - 1];
                System.arraycopy(this.positions, 0, f2, 0, this.positions.length - 1);
                c2 = new Object[this.values.length - 1];
                System.arraycopy(this.values, 0, c2, 0, this.positions.length - 1);
                this.positions = f2;
                this.values = c2;
                --this.selectedThumb;
            }
            if (this.selectedThumb >= this.positions.length) {
                this.selectedThumb = -1;
            }
        }

        public void install() {
            this.polish();
            MultiThumbSliderUI.this.slider.setValues(this.positions, this.values);
            MultiThumbSliderUI.this.slider.setSelectedThumb(this.selectedThumb);
        }

        public void removeThumb(int index) {
            float[] f = new float[this.positions.length - 1];
            Object[] c = new Object[this.values.length - 1];
            System.arraycopy(this.positions, 0, f, 0, index);
            System.arraycopy(this.values, 0, c, 0, index);
            System.arraycopy(this.positions, index + 1, f, index, f.length - index);
            System.arraycopy(this.values, index + 1, c, index, f.length - index);
            this.positions = f;
            this.values = c;
            this.selectedThumb = -1;
        }
    }
}

