/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.cache;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.internal.id.UniqueId;
import org.gradle.kotlin.dsl.cache.PackMetadata;
import org.gradle.kotlin.dsl.support.ZipKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a$\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0000\u001a\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a$\u0010\u000f\u001a\u00020\u0010*\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u0003*\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0018\u001a\u00020\u0010*\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u0003*\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u001a\f\u0010\u001b\u001a\u00020\u0007*\u00020\u001aH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"packFormatVersion", "", "pack", "", "inputDir", "Ljava/io/File;", "metadata", "Lorg/gradle/kotlin/dsl/cache/PackMetadata;", "outputStream", "Ljava/io/OutputStream;", "unpack", "Lkotlin/Pair;", "inputStream", "Ljava/io/InputStream;", "outputDir", "copyTo", "", "out", "buffer", "", "file", "length", "packFilesFrom", "Ljava/io/DataOutputStream;", "packMetadata", "unpackFilesTo", "Ljava/io/DataInputStream;", "unpackMetadata", "gradle-kotlin-dsl"})
public final class BuildCacheFormatKt {
    private static final int packFormatVersion = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long pack(@NotNull File inputDir, @NotNull PackMetadata metadata, @NotNull OutputStream outputStream) {
        long l;
        AutoCloseable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)inputDir, (String)"inputDir");
        Intrinsics.checkParameterIsNotNull((Object)metadata, (String)"metadata");
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        AutoCloseable autoCloseable = $receiver$iv = (AutoCloseable)new DataOutputStream(new GZIPOutputStream(outputStream));
        Throwable throwable = null;
        try {
            AutoCloseable it$iv = autoCloseable;
            AutoCloseable autoCloseable2 = $receiver$iv;
            DataOutputStream $receiver = (DataOutputStream)autoCloseable2;
            $receiver.writeInt(1);
            BuildCacheFormatKt.packMetadata($receiver, metadata);
            l = BuildCacheFormatKt.packFilesFrom($receiver, inputDir);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Pair<PackMetadata, Long> unpack(@NotNull InputStream inputStream, @NotNull File outputDir) {
        Pair pair;
        AutoCloseable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        AutoCloseable autoCloseable = $receiver$iv = (AutoCloseable)new DataInputStream(new GZIPInputStream(inputStream));
        Throwable throwable = null;
        try {
            boolean bl;
            AutoCloseable it$iv = autoCloseable;
            AutoCloseable autoCloseable2 = $receiver$iv;
            DataInputStream $receiver = (DataInputStream)autoCloseable2;
            int packedVersion = $receiver.readInt();
            boolean bl2 = bl = packedVersion == 1;
            if (!bl) {
                String string2 = "Unsupported cache format version, expected version 1, got version " + packedVersion + '.';
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            pair = TuplesKt.to((Object)BuildCacheFormatKt.unpackMetadata($receiver), (Object)BuildCacheFormatKt.unpackFilesTo($receiver, outputDir));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return pair;
    }

    private static final void packMetadata(@NotNull DataOutputStream $receiver, PackMetadata metadata) {
        $receiver.writeUTF(metadata.getBuildInvocationId().asString());
        $receiver.writeLong(metadata.getExecutionTimeMillis());
    }

    private static final PackMetadata unpackMetadata(@NotNull DataInputStream $receiver) {
        UniqueId buildInvocationId = UniqueId.from((String)$receiver.readUTF());
        long executionTimeMillis = $receiver.readLong();
        UniqueId uniqueId = buildInvocationId;
        Intrinsics.checkExpressionValueIsNotNull((Object)uniqueId, (String)"buildInvocationId");
        return new PackMetadata(uniqueId, executionTimeMillis);
    }

    private static final long packFilesFrom(@NotNull DataOutputStream $receiver, File inputDir) {
        long entryCount = 0L;
        byte[] buffer = new byte[8192];
        Sequence $receiver$iv = SequencesKt.drop((Sequence)((Sequence)FilesKt.walkTopDown((File)inputDir)), (int)1);
        for (Object element$iv : $receiver$iv) {
            File file = (File)element$iv;
            String path = ZipKt.normalisedPathRelativeTo(file, inputDir);
            boolean isFile = file.isFile();
            $receiver.writeUTF(path);
            $receiver.writeBoolean(isFile);
            if (isFile) {
                $receiver.writeLong(file.length());
                BuildCacheFormatKt.copyTo(file, $receiver, buffer);
            }
            ++entryCount;
        }
        $receiver.writeUTF("");
        return entryCount;
    }

    private static final long unpackFilesTo(@NotNull DataInputStream $receiver, File outputDir) {
        byte[] buffer = new byte[8192];
        long entryCount = 0L;
        while (true) {
            String path;
            String string2 = path = $receiver.readUTF();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
            CharSequence charSequence = string2;
            if (charSequence.length() == 0) break;
            boolean isFile = $receiver.readBoolean();
            File file = new File(outputDir, path);
            if (isFile) {
                long length = $receiver.readLong();
                BuildCacheFormatKt.copyTo($receiver, file, length, buffer);
            } else {
                file.mkdir();
            }
            ++entryCount;
        }
        return entryCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void copyTo(@NotNull File $receiver, OutputStream out, byte[] buffer) {
        Object object = $receiver;
        object = new FileInputStream((File)object);
        Throwable throwable = null;
        try {
            FileInputStream input = (FileInputStream)object;
            int read = input.read(buffer);
            while (read >= 0) {
                out.write(buffer, 0, read);
                read = input.read(buffer);
            }
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void copyTo(@NotNull InputStream $receiver, File file, long length, byte[] buffer) {
        Object object = file;
        object = new FileOutputStream((File)object);
        Throwable throwable = null;
        try {
            int read;
            FileOutputStream output = (FileOutputStream)object;
            long bufferSize = buffer.length;
            for (long remaining = length; remaining > 0L; remaining -= (long)read) {
                read = $receiver.read(buffer, 0, (int)RangesKt.coerceAtMost((long)remaining, (long)bufferSize));
                output.write(buffer, 0, read);
            }
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }
}

