/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.CU;
import javajs.util.P3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class Ras3DReader
extends PolygonFileReader {
    private String pmeshError;
    private String type;
    private boolean asQuads;
    private int nPolygons;
    Map<String, Integer> htVertices;

    Ras3DReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2PR(surfaceGenerator, bufferedReader);
    }

    protected void init2PR(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2PFR(surfaceGenerator, bufferedReader);
        String string = (String)((Object[])surfaceGenerator.getReaderData())[0];
        if (string == null) {
            return;
        }
        this.type = "ras3d";
        this.setHeader();
    }

    protected void setHeader() {
        this.jvxlFileHeaderBuffer.append(String.valueOf(this.type) + " file format\nvertices and triangles only\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    @Override
    void getSurfaceData() throws Exception {
        if (this.readVerticesAndPolygons()) {
            Logger.info(String.valueOf(this.type) + " file contains " + this.nVertices + " vertices and " + this.nPolygons + " polygons for " + this.nTriangles + " triangles");
        } else {
            Logger.error(String.valueOf(this.params.fileName) + ": " + (this.pmeshError == null ? "Error reading pmesh data " : this.pmeshError));
        }
    }

    protected boolean readVerticesAndPolygons() {
        block3: {
            try {
                if (this.readVertices()) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (this.pmeshError != null) break block3;
                this.pmeshError = String.valueOf(this.type) + " ERROR: " + exception;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readVertices() throws Exception {
        this.htVertices = new Hashtable<String, Integer>();
        var1_1 = new int[3];
        var2_2 = new int[3];
        var4_3 = 0;
        var5_4 = 0;
        if (this.rd().indexOf("DSSR") < 0) ** GOTO lbl38
        this.asQuads = true;
        ** GOTO lbl38
        {
            this.rd();
            do {
                if (!this.line.equals("1")) continue block0;
                this.rd();
                var7_7 = this.getTokens();
                var1_1[0] = this.getPoint(var7_7, 0);
                var1_1[1] = this.getPoint(var7_7, 3);
                var1_1[2] = this.getPoint(var7_7, 6);
                ++this.nTriangles;
                var4_3 = CU.colorTriadToFFRGB(this.parseFloatStr(var7_7[9]), this.parseFloatStr(var7_7[10]), this.parseFloatStr(var7_7[11]));
                if (this.asQuads) {
                    if (this.nTriangles % 2 == 1) {
                        var3_5 = var2_2;
                        var2_2 = var1_1;
                        var1_1 = var3_5;
                        var6_6 = var5_4;
                        var5_4 = var4_3;
                        var4_3 = var6_6;
                        continue;
                    }
                    this.addTriangleCheck(var1_1[0], var1_1[1], var1_1[2], 6, 0, false, var4_3);
                    this.addTriangleCheck(var2_2[0], var2_2[1], var2_2[2], 3, 0, false, var5_4);
                } else {
                    this.addTriangleCheck(var1_1[0], var1_1[1], var1_1[2], 7, 0, false, var4_3);
                }
                ++this.nPolygons;
lbl38:
                // 4 sources

            } while (this.rd() != null);
        }
        return true;
    }

    private int getPoint(String[] stringArray, int n) {
        String string = String.valueOf(stringArray[n]) + ";" + stringArray[n + 1] + ";" + stringArray[n + 2];
        Integer n2 = this.htVertices.get(string);
        if (n2 == null) {
            this.addVertexCopy(P3.new3(this.parseFloatStr(stringArray[n]), this.parseFloatStr(stringArray[n + 1]), this.parseFloatStr(stringArray[n + 2])), 0.0f, this.nVertices, false);
            n2 = this.nVertices++;
            this.htVertices.put(string, n2);
        }
        return n2;
    }
}

