"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util = require("util");
const proxy_1 = require("../utils/proxy");
const httpWrapper_1 = require("../wrapper/httpWrapper");
const debug_1 = require("debug");
const debug = debug_1.default('axm:tracing');
const configuration_1 = require("../configuration");
const metricConfig_1 = require("../utils/metricConfig");
const serviceManager_1 = require("../serviceManager");
class Transaction {
    constructor(metricFeature) {
        this.defaultConf = {
            http: true
        };
        this.metricFeature = metricFeature;
        serviceManager_1.ServiceManager.set('wrapper', {});
    }
    init(config) {
        config = metricConfig_1.default.getConfig(config, this.defaultConf);
        if (config.http) {
            const opts = typeof config.http === 'object' ? config.http : {};
            this.http(opts);
        }
        if (config.tracing) {
            const opts = typeof config.tracing === 'object' ? config.tracing : {};
            this.tracing(opts);
        }
    }
    destroy() {
        debug('Transaction destroyed !');
    }
    tracing(opts) {
        if (Array.isArray(opts.ignore_routes) && opts.ignore_routes.length > 0) {
            opts.ignoreFilter = { url: opts.ignore_routes };
        }
        // we should never enable tracing agent two time
        if (require('vxx').get().isActive())
            return;
        this.tracer = require('vxx').start(opts);
        configuration_1.default.configureModule({
            tracing_enabled: true
        });
        // broadcast to pm2 aggregator
        this.tracer.getBus().on('transaction', (data) => {
            serviceManager_1.ServiceManager.get('transport').send('axm:trace', data);
        });
    }
    http(opts) {
        const Module = require('module');
        debug('Wrapping HTTP routes');
        if (Array.isArray(opts)) {
            const routes = JSON.parse(JSON.stringify(opts));
            opts = {
                http: true,
                http_latency: 200,
                http_code: 500,
                ignore_routes: routes
            };
        }
        opts = util['_extend']({
            http: true,
            http_latency: 200,
            http_code: 500,
            ignore_routes: []
        }, opts);
        const self = this;
        proxy_1.default.wrap(Module, '_load', (load) => {
            if (load.__axm_original) {
                debug('HTTP routes have already been wrapped before');
                configuration_1.default.configureModule({
                    latency: opts.http
                });
                if (opts.http === false) {
                    return function (file) {
                        return load.__axm_original.apply(this, arguments);
                    };
                }
                else {
                    return function (file) {
                        if (file === 'http' || file === 'https') {
                            // initialize transaction metrics only once
                            if (!serviceManager_1.ServiceManager.get('wrapper')[file]) {
                                opts.name = file;
                                serviceManager_1.ServiceManager.get('wrapper')[file] = new httpWrapper_1.default(self.metricFeature).init(opts, load.__axm_original.apply(this, arguments));
                            }
                            return serviceManager_1.ServiceManager.get('wrapper')[file];
                        }
                        else {
                            return load.__axm_original.apply(this, arguments);
                        }
                    };
                }
            }
            return function (file) {
                if (opts.http &&
                    (file === 'http' || file === 'https')) {
                    debug('http module being required');
                    configuration_1.default.configureModule({
                        latency: true
                    });
                    // initialize transaction metrics only once
                    if (!serviceManager_1.ServiceManager.get('wrapper')[file]) {
                        opts.name = file;
                        serviceManager_1.ServiceManager.get('wrapper')[file] = new httpWrapper_1.default(self.metricFeature).init(opts, load.apply(this, arguments));
                    }
                    return serviceManager_1.ServiceManager.get('wrapper')[file];
                }
                else {
                    return load.apply(this, arguments);
                }
            };
        });
    }
}
exports.default = Transaction;
//# sourceMappingURL=data:application/json;base64,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