"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const debug_1 = require("debug");
const semver = require("semver");
const stringify = require("json-stringify-safe");
const debug = debug_1.default('axm:transportService');
class TransportConfig {
}
exports.TransportConfig = TransportConfig;
class Actions {
}
exports.Actions = Actions;
class Process {
}
exports.Process = Process;
class Transport {
}
exports.Transport = Transport;
class Agent {
}
exports.Agent = Agent;
class TransportService {
    constructor() {
        this.isStandalone = false;
        this.initiated = false; // tslint:disable-line
    }
    init() {
        this.initiated = true;
        this.isStandalone = false;
    }
    initStandalone(config) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (!semver.satisfies(process.version, '>= 6.0.0')) {
                this.init();
                console.error('[STANDALONE MODE] Unable to set standalone mode with node < 6.0.0');
                return process.exit(1);
            }
            const AgentNode = require('@pm2/agent-node');
            this.isStandalone = true;
            this.initiated = true;
            debug('Init new transport service');
            this.config = config;
            this.process = {
                axm_actions: [],
                axm_options: {},
                axm_monitor: {}
            };
            this.agent = new AgentNode({
                publicKey: this.config.publicKey,
                secretKey: this.config.secretKey,
                appName: this.config.appName,
                serverName: this.config.serverName
            }, this.process);
            this.agent.sendLogs = config.sendLogs || false;
            try {
                yield this.agent.start();
            }
            catch (err) {
                console.error(err);
                process.exit(1);
            }
            this.transport = this.agent.transport;
            return debug('Agent launched');
        });
    }
    setMetrics(metrics) {
        if (this.isStandalone) {
            return this.process.axm_monitor = metrics;
        }
        this.send('axm:monitor', metrics);
    }
    addAction(action) {
        debug(`Add action: ${action.action_name}:${action.action_type}`);
        if (this.isStandalone) {
            return this.process.axm_actions.push(action);
        }
        return this.send('axm:action', action);
    }
    setOptions(options) {
        debug(`Set options: [${Object.keys(options).join(',')}]`);
        if (this.isStandalone) {
            return this.process.axm_options = Object.assign(this.process.axm_options, options);
        }
        return this.send('axm:option:configuration', options);
    }
    getFormattedPayload(channel, payload) {
        // Reformat for backend
        switch (channel) {
            case 'axm:reply':
                return { data: payload };
            case 'process:exception':
                return { data: payload };
        }
        return payload;
    }
    send(channel, payload) {
        if (this.isStandalone) {
            return this.agent.send(channel, this.getFormattedPayload(channel, payload)) ? 0 : -1;
        }
        if (!process.send)
            return -1;
        try {
            process.send(JSON.parse(stringify({
                type: channel,
                data: payload
            })));
        }
        catch (e) {
            debug('Process disconnected from parent !');
            debug(e.stack || e);
            return process.exit(1);
        }
        return 0;
    }
    destroy() {
        if (!this.isStandalone)
            return;
        this.transport.disconnect();
    }
}
exports.default = TransportService;
//# sourceMappingURL=data:application/json;base64,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