/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public class FontNameComboBox
extends JComboBox {
    public static final String DEFAULT_SYSTEM_FONT_NAME = "DEFAULT_SYSTEM_FONT_NAME";
    private static final String[] availableFontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private UserPreferences preferences;
    private String unavailableFontName;

    public FontNameComboBox(UserPreferences userPreferences) {
        this.preferences = userPreferences;
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(availableFontNames);
        defaultComboBoxModel.insertElementAt(DEFAULT_SYSTEM_FONT_NAME, 0);
        this.setModel(defaultComboBoxModel);
        final String string = userPreferences.getLocalizedString(FontNameComboBox.class, "systemFontName", new Object[0]);
        this.setRenderer(new DefaultListCellRenderer(){
            private Font rendererDefaultFont;
            private Font rendererSpecialFont;

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object == FontNameComboBox.DEFAULT_SYSTEM_FONT_NAME) {
                    object = string;
                } else if (object != null && Arrays.binarySearch(availableFontNames, object) < 0) {
                    object = FontNameComboBox.this.unavailableFontName;
                }
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (this.rendererDefaultFont == null) {
                    this.rendererDefaultFont = this.getFont();
                    this.rendererSpecialFont = new Font(this.rendererDefaultFont.getFontName(), 2, this.rendererDefaultFont.getSize());
                }
                if (object == null || object == string || object == FontNameComboBox.this.unavailableFontName) {
                    this.setFont(this.rendererSpecialFont);
                } else {
                    this.setFont(this.rendererDefaultFont);
                }
                return this;
            }
        });
    }

    public void setSelectedItem(final Object object) {
        final DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.getModel();
        Object e = defaultComboBoxModel.getElementAt(0);
        if (e != null && object == null) {
            if (e != DEFAULT_SYSTEM_FONT_NAME) {
                defaultComboBoxModel.removeElementAt(0);
            }
            defaultComboBoxModel.insertElementAt(null, 0);
        } else if (e == null && object != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    defaultComboBoxModel.removeElementAt(0);
                    FontNameComboBox.super.setSelectedItem(object);
                }
            });
        } else if (e != object && Arrays.binarySearch(availableFontNames, object) < 0 && object != DEFAULT_SYSTEM_FONT_NAME) {
            if (e != DEFAULT_SYSTEM_FONT_NAME) {
                defaultComboBoxModel.removeElementAt(0);
            }
            defaultComboBoxModel.insertElementAt(object, 0);
            this.unavailableFontName = this.preferences.getLocalizedString(FontNameComboBox.class, "unavailableFontName", object);
        }
        super.setSelectedItem(object);
    }

    static {
        Arrays.sort(availableFontNames);
    }
}

