/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.ComponentWithNames;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.SwiftLibrary;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.SwiftSharedLibrary;
import org.gradle.language.swift.SwiftStaticLibrary;
import org.gradle.language.swift.internal.DefaultSwiftLibrary;
import org.gradle.language.swift.internal.DefaultSwiftSharedLibrary;
import org.gradle.language.swift.internal.DefaultSwiftStaticLibrary;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.util.GUtil;

@Incubating
public class SwiftLibraryPlugin
implements Plugin<Project> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;
    private final ImmutableAttributesFactory attributesFactory;

    @Inject
    public SwiftLibraryPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector, ImmutableAttributesFactory attributesFactory) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
        this.attributesFactory = attributesFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        final ConfigurationContainer configurations = project.getConfigurations();
        final ObjectFactory objectFactory = project.getObjects();
        final DefaultSwiftLibrary library = this.componentFactory.newInstance(SwiftLibrary.class, DefaultSwiftLibrary.class, "main");
        project.getExtensions().add(SwiftLibrary.class, "library", (Object)library);
        project.getComponents().add((Object)library);
        Property<String> module = library.getModule();
        module.set((Object)GUtil.toCamelCase((CharSequence)project.getName()));
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(final Project project) {
                library.getOperatingSystems().finalizeValue();
                Set operatingSystemFamilies = (Set)library.getOperatingSystems().get();
                if (operatingSystemFamilies.isEmpty()) {
                    throw new IllegalArgumentException("An operating system needs to be specified for the library.");
                }
                library.getLinkage().finalizeValue();
                Set linkages = (Set)library.getLinkage().get();
                if (linkages.isEmpty()) {
                    throw new IllegalArgumentException("A linkage needs to be specified for the library.");
                }
                Usage runtimeUsage = (Usage)objectFactory.named(Usage.class, "native-runtime");
                Usage linkUsage = (Usage)objectFactory.named(Usage.class, "native-link");
                for (BuildType buildType : BuildType.DEFAULT_BUILD_TYPES) {
                    for (OperatingSystemFamily operatingSystem : operatingSystemFamilies) {
                        for (Linkage linkage : linkages) {
                            String operatingSystemSuffix = SwiftLibraryPlugin.this.createDimensionSuffix((Named)operatingSystem, operatingSystemFamilies);
                            String linkageSuffix = SwiftLibraryPlugin.this.createDimensionSuffix((Named)linkage, linkages);
                            String variantName = buildType.getName() + linkageSuffix + operatingSystemSuffix;
                            Provider group = project.provider((Callable)new Callable<String>(){

                                @Override
                                public String call() throws Exception {
                                    return project.getGroup().toString();
                                }
                            });
                            Provider version = project.provider((Callable)new Callable<String>(){

                                @Override
                                public String call() throws Exception {
                                    return project.getVersion().toString();
                                }
                            });
                            AttributeContainerInternal runtimeAttributes = SwiftLibraryPlugin.this.attributesFactory.mutable();
                            runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                            runtimeAttributes.attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)buildType.isDebuggable());
                            runtimeAttributes.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)buildType.isOptimized());
                            runtimeAttributes.attribute(CppBinary.LINKAGE_ATTRIBUTE, (Object)linkage);
                            runtimeAttributes.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)operatingSystem);
                            AttributeContainerInternal linkAttributes = SwiftLibraryPlugin.this.attributesFactory.mutable();
                            linkAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)linkUsage);
                            linkAttributes.attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)buildType.isDebuggable());
                            linkAttributes.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)buildType.isOptimized());
                            linkAttributes.attribute(CppBinary.LINKAGE_ATTRIBUTE, (Object)linkage);
                            linkAttributes.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)operatingSystem);
                            NativeVariantIdentity variantIdentity = new NativeVariantIdentity(variantName, (Provider<String>)library.getModule(), (Provider<String>)group, (Provider<String>)version, buildType.isDebuggable(), buildType.isOptimized(), operatingSystem, new DefaultUsageContext(variantName + "Link", linkUsage, (AttributeContainer)linkAttributes), new DefaultUsageContext(variantName + "Runtime", runtimeUsage, (AttributeContainer)runtimeAttributes));
                            if (!DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName().equals(operatingSystem.getName())) continue;
                            ToolChainSelector.Result<SwiftPlatform> result = SwiftLibraryPlugin.this.toolChainSelector.select(SwiftPlatform.class);
                            if (linkage == Linkage.SHARED) {
                                SwiftSharedLibrary sharedLibrary = library.addSharedLibrary(variantName, buildType == BuildType.DEBUG, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider(), variantIdentity);
                                if (buildType != BuildType.DEBUG) continue;
                                library.getDevelopmentBinary().set((Object)sharedLibrary);
                                continue;
                            }
                            SwiftStaticLibrary staticLibrary = library.addStaticLibrary(variantName, buildType == BuildType.DEBUG, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider(), variantIdentity);
                            if (linkages.contains(Linkage.SHARED) || buildType != BuildType.DEBUG) continue;
                            library.getDevelopmentBinary().set((Object)staticLibrary);
                        }
                    }
                }
                ((DefaultBinaryCollection)library.getBinaries()).whenElementKnown(SwiftSharedLibrary.class, new Action<SwiftSharedLibrary>(){

                    public void execute(SwiftSharedLibrary sharedLibrary) {
                        Names names = ((ComponentWithNames)((Object)sharedLibrary)).getNames();
                        Configuration apiElements = (Configuration)configurations.create(names.withSuffix("SwiftApiElements"));
                        apiElements.extendsFrom(new Configuration[]{((DefaultSwiftSharedLibrary)sharedLibrary).getImplementationDependencies()});
                        apiElements.setCanBeResolved(false);
                        apiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objectFactory.named(Usage.class, "swift-api")));
                        apiElements.getAttributes().attribute(CppBinary.LINKAGE_ATTRIBUTE, (Object)Linkage.SHARED);
                        apiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)sharedLibrary.isDebuggable());
                        apiElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)sharedLibrary.isOptimized());
                        apiElements.getAttributes().attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)sharedLibrary.getTargetPlatform().getOperatingSystemFamily());
                        apiElements.getOutgoing().artifact(sharedLibrary.getModuleFile());
                    }
                });
                ((DefaultBinaryCollection)library.getBinaries()).whenElementKnown(SwiftStaticLibrary.class, new Action<SwiftStaticLibrary>(){

                    public void execute(SwiftStaticLibrary staticLibrary) {
                        Names names = ((ComponentWithNames)((Object)staticLibrary)).getNames();
                        Configuration apiElements = (Configuration)configurations.create(names.withSuffix("SwiftApiElements"));
                        apiElements.extendsFrom(new Configuration[]{((DefaultSwiftStaticLibrary)staticLibrary).getImplementationDependencies()});
                        apiElements.setCanBeResolved(false);
                        apiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objectFactory.named(Usage.class, "swift-api")));
                        apiElements.getAttributes().attribute(CppBinary.LINKAGE_ATTRIBUTE, (Object)Linkage.STATIC);
                        apiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)staticLibrary.isDebuggable());
                        apiElements.getAttributes().attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)staticLibrary.isOptimized());
                        apiElements.getAttributes().attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)staticLibrary.getTargetPlatform().getOperatingSystemFamily());
                        apiElements.getOutgoing().artifact(staticLibrary.getModuleFile());
                    }
                });
                ((DefaultBinaryCollection)library.getBinaries()).realizeNow();
            }
        });
    }

    private String createDimensionSuffix(Named dimensionValue, Collection<? extends Named> multivalueProperty) {
        if (this.isDimensionVisible(multivalueProperty)) {
            return StringUtils.capitalize((String)dimensionValue.getName().toLowerCase());
        }
        return "";
    }

    private boolean isDimensionVisible(Collection<? extends Named> multivalueProperty) {
        return multivalueProperty.size() > 1;
    }

    private static final class BuildType
    implements Named {
        private static final BuildType DEBUG = new BuildType("debug", true, false);
        private static final BuildType RELEASE = new BuildType("release", true, true);
        public static final Collection<BuildType> DEFAULT_BUILD_TYPES = Arrays.asList(DEBUG, RELEASE);
        private final boolean debuggable;
        private final boolean optimized;
        private final String name;

        private BuildType(String name, boolean debuggable, boolean optimized) {
            this.debuggable = debuggable;
            this.optimized = optimized;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDebuggable() {
            return this.debuggable;
        }

        public boolean isOptimized() {
            return this.optimized;
        }
    }
}

