/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.BuildDependenciesOnlyFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;

public abstract class ImmutableFileCollection
extends AbstractFileCollection {
    private static final ImmutableFileCollection EMPTY = new ImmutableFileCollection(){

        public Set<File> getFiles() {
            return ImmutableSet.of();
        }
    };

    public static ImmutableFileCollection of() {
        return EMPTY;
    }

    public static ImmutableFileCollection of(File ... files) {
        if (files.length == 0) {
            return EMPTY;
        }
        return new FileOnlyImmutableFileCollection((ImmutableSet<File>)ImmutableSet.copyOf((Object[])files));
    }

    public static ImmutableFileCollection of(Iterable<File> files) {
        if (Iterables.isEmpty(files)) {
            return EMPTY;
        }
        return new FileOnlyImmutableFileCollection((ImmutableSet<File>)ImmutableSet.copyOf(files));
    }

    public static ImmutableFileCollection usingResolver(FileResolver fileResolver, Object ... paths) {
        if (paths.length == 0) {
            return EMPTY;
        }
        return new ResolvingImmutableFileCollection(fileResolver, paths);
    }

    private ImmutableFileCollection() {
    }

    @Override
    public String getDisplayName() {
        return "file collection";
    }

    public TaskDependency getBuildDependencies() {
        return TaskDependencyInternal.EMPTY;
    }

    private static class ResolvingImmutableFileCollection
    extends ImmutableFileCollection {
        private final FileResolver resolver;
        private final Set<Object> paths;

        ResolvingImmutableFileCollection(FileResolver fileResolver, Object ... paths) {
            this.resolver = fileResolver;
            this.paths = ImmutableSet.copyOf((Object[])paths);
        }

        public Set<File> getFiles() {
            DefaultFileCollectionResolveContext context = new DefaultFileCollectionResolveContext(this.resolver);
            context.add(this.paths);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            List<FileCollectionInternal> fileCollections = context.resolveAsFileCollections();
            for (FileCollection fileCollection : fileCollections) {
                builder.addAll((Iterable)fileCollection.getFiles());
            }
            return builder.build();
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return new AbstractTaskDependency(){

                public void visitDependencies(TaskDependencyResolveContext context) {
                    BuildDependenciesOnlyFileCollectionResolveContext fileContext = new BuildDependenciesOnlyFileCollectionResolveContext(context);
                    fileContext.add(ResolvingImmutableFileCollection.this.paths);
                }
            };
        }
    }

    private static class FileOnlyImmutableFileCollection
    extends ImmutableFileCollection {
        private final ImmutableSet<File> files;

        FileOnlyImmutableFileCollection(ImmutableSet<File> files) {
            this.files = files;
        }

        public Set<File> getFiles() {
            return this.files;
        }
    }
}

