/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.scriptext;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.JSONEncodable;
import javajs.awt.Font;
import javajs.util.AU;
import javajs.util.BArray;
import javajs.util.BS;
import javajs.util.Base64;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.STER;
import org.jmol.c.VDW;
import org.jmol.i18n.GT;
import org.jmol.minimize.Minimizer;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Text;
import org.jmol.modelset.TickInfo;
import org.jmol.script.SV;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptError;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptInterruption;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.ScriptParam;
import org.jmol.script.T;
import org.jmol.scriptext.ScriptExt;
import org.jmol.util.BSUtil;
import org.jmol.util.BZone;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public class CmdExt
extends ScriptExt {
    static final int ERROR_invalidArgument = 22;

    @Override
    public String dispatch(int n, boolean bl, T[] tArray) throws ScriptException {
        this.chk = this.e.chk;
        this.slen = this.e.slen;
        this.st = tArray;
        switch (n) {
            case 1073741866: {
                tArray[0].value = this.prepareBinaryOutput((SV)tArray[0]);
                return null;
            }
            case 4098: {
                this.assign();
                break;
            }
            case 134221829: {
                this.cache();
                break;
            }
            case 4102: {
                this.calculate();
                break;
            }
            case 4103: {
                this.capture();
                break;
            }
            case 4105: {
                this.centerAt();
                break;
            }
            case 134221831: {
                this.compare();
                break;
            }
            case 528395: {
                this.console();
                break;
            }
            case 4106: {
                this.connect(1);
                break;
            }
            case 1094717448: {
                this.configuration();
                break;
            }
            case 134221834: {
                this.data();
                break;
            }
            case 1613238294: {
                this.connect(0);
                break;
            }
            case 4120: {
                this.image();
                break;
            }
            case 4122: {
                this.invertSelected();
                break;
            }
            case 4124: {
                this.macro();
                break;
            }
            case 4125: {
                this.mapProperty();
                break;
            }
            case 4126: {
                this.minimize();
                break;
            }
            case 1275072532: {
                this.modulation();
                break;
            }
            case 4130: {
                this.mutate();
                break;
            }
            case 4131: {
                this.navigate();
                break;
            }
            case 4133: 
            case 4138: 
            case 134221850: {
                this.plot(tArray);
                break;
            }
            case 134222350: {
                this.show();
                break;
            }
            case 528443: {
                this.stereo();
                break;
            }
            case 1814695966: {
                this.unitcell(bl ? 2 : 1);
                break;
            }
            case 134221856: {
                return this.write((T[])(bl ? tArray : null));
            }
            case 6: {
                this.measure();
                break;
            }
            case 21: {
                this.polyhedra();
                break;
            }
            case 20: {
                this.ellipsoid();
                break;
            }
            case 4: {
                this.struts();
            }
        }
        return null;
    }

    private void macro() throws ScriptException {
        String string = this.e.optParameterAsString(1);
        if (string.length() == 0) {
            return;
        }
        if (this.chk) {
            return;
        }
        String string2 = JC.getMacro(string);
        if (string2 == null) {
            this.showString("macro " + string + " could not be found. Current macros include:\n" + JC.getMacroList());
            return;
        }
        this.showString("running " + string2);
        this.e.cmdScript(4124, string2, null);
    }

    public boolean evalParallel(ScriptContext scriptContext, ShapeManager shapeManager) {
        this.chk = this.e.chk;
        this.slen = this.e.slen;
        ScriptEval scriptEval = new ScriptEval().setViewer(this.vwr);
        scriptEval.historyDisabled = true;
        scriptEval.compiler = new ScriptCompiler(this.vwr);
        scriptEval.sm = shapeManager;
        try {
            scriptEval.restoreScriptContext(scriptContext, true, false, false);
            scriptEval.allowJSThreads = false;
            scriptEval.dispatchCommands(false, false, false);
        }
        catch (Exception exception) {
            this.e.vwr.setStringProperty("_errormessage", "" + exception);
            if (scriptEval.thisContext == null) {
                Logger.error("Error evaluating context " + exception);
                exception.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public Object getBitsetIdent(BS bS, String stringArray, Object object, boolean bl, int n, boolean bl2) {
        Map<String, Object> map;
        int[] nArray;
        boolean bl3;
        boolean bl4;
        boolean bl5 = bl4 = !(object instanceof BondSet);
        if (bl4) {
            if (stringArray == null) {
                stringArray = this.vwr.getStandardLabelFormat(0);
            } else if (stringArray.length() == 0) {
                stringArray = "%[label]";
            }
        }
        int n2 = stringArray == null ? -1 : stringArray.indexOf("%");
        boolean bl6 = bl3 = n != Integer.MAX_VALUE;
        if (bS == null || this.chk || bl4 && n2 < 0) {
            String[] stringArray2;
            if (stringArray == null) {
                stringArray = "";
            }
            if (bl2) {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = stringArray;
            } else {
                stringArray2 = stringArray;
            }
            return stringArray2;
        }
        ModelSet modelSet = this.vwr.ms;
        int n3 = 0;
        LabelToken labelToken = modelSet.getLabeler();
        int[] nArray2 = nArray = bl4 || !bl ? null : ((BondSet)object).associatedAtoms;
        if (nArray == null && stringArray != null && stringArray.indexOf("%D") > 0) {
            nArray = this.vwr.ms.getAtomIndices(bS);
        }
        boolean bl7 = stringArray == null || stringArray.length() == 0;
        Map<String, Object> map2 = map = bl4 || bl7 ? null : LabelToken.getBondLabelValues();
        LabelToken[] labelTokenArray = bl7 ? null : (bl4 ? LabelToken.compile(this.vwr, (String)stringArray, '\u0000', null) : LabelToken.compile(this.vwr, (String)stringArray, '\u0001', map));
        int n4 = bl3 ? 1 : bS.cardinality();
        String[] stringArray4 = new String[n4];
        P3 p3 = new P3();
        int n5 = bl3 ? n : bS.nextSetBit(0);
        while (n5 >= 0) {
            String string;
            if (bl4) {
                string = bl7 ? modelSet.at[n5].getInfo() : LabelToken.formatLabelAtomArray(this.vwr, modelSet.at[n5], labelTokenArray, '\u0000', nArray, p3);
            } else {
                Bond bond = modelSet.bo[n5];
                string = bl7 ? bond.getIdentity() : LabelToken.formatLabelBond(this.vwr, bond, labelTokenArray, map, nArray, p3);
            }
            string = PT.formatStringI(string, "#", n3 + 1);
            stringArray4[n3++] = string;
            if (bl3) break;
            n5 = bS.nextSetBit(n5 + 1);
        }
        return n4 == 1 && !bl2 ? stringArray4[0] : stringArray4;
    }

    public int getLoadSymmetryParams(int n, SB sB, Map<String, Object> map) throws ScriptException {
        ScriptEval scriptEval = this.e;
        this.chk = scriptEval.chk;
        this.slen = scriptEval.slen;
        T3 t3 = null;
        int n2 = this.tokAt(n);
        if (n2 == 1073742332 || n2 == 8) {
            t3 = (T3)scriptEval.getPointOrPlane(n, false, true, false, true, 3, 3, true);
            n = scriptEval.iToken + 1;
            n2 = this.tokAt(n);
        }
        switch (n2) {
            case 1073741938: 
            case 0x40000100: 
            case 1073742114: 
            case 1073742152: 
            case 1073742163: 
            case 1094713350: 
            case 1814695966: {
                if (t3 == null) {
                    t3 = P3.new3(555.0f, 555.0f, -1.0f);
                }
                scriptEval.iToken = n - 1;
            }
        }
        P3 p3 = null;
        if (t3 != null) {
            SymmetryInterface symmetryInterface;
            Object object;
            map.put("lattice", t3);
            n = scriptEval.iToken + 1;
            sB.append(" " + SimpleUnitCell.escapeMultiplier(t3));
            n = this.checkPacked(n, map, sB);
            if (this.tokAt(n) == 1094713350) {
                map.put("centroid", Boolean.TRUE);
                sB.append(" CENTROID");
                ++n;
                n = this.checkPacked(n, map, sB);
            }
            if (this.tokAt(n) == 1073742163) {
                Object object2;
                sB.append(" SUPERCELL ");
                if (scriptEval.isPoint3f(++n)) {
                    object = this.getPoint3f(n, false);
                    if (((P3)object).x != (float)((int)((P3)object).x) || ((P3)object).y != (float)((int)((P3)object).y) || ((P3)object).z != (float)((int)((P3)object).z) || ((P3)object).x < 1.0f || ((P3)object).y < 1.0f || ((P3)object).z < 1.0f) {
                        scriptEval.iToken = n;
                        this.invArg();
                    }
                    object2 = object;
                    n = scriptEval.iToken;
                } else {
                    object2 = this.stringParameter(n);
                }
                sB.append(Escape.e(object2));
                map.put("supercell", object2);
                ++n;
                n = this.checkPacked(n, map, sB);
            }
            float f = 0.0f;
            if (this.tokAt(n) == 1073742114) {
                int n3 = ++n;
                ++n;
                f = this.floatParameter(n3);
                sB.append(" range " + f);
            }
            map.put("symmetryRange", Float.valueOf(f));
            object = null;
            int n4 = Integer.MIN_VALUE;
            if (this.tokAt(n) == 1073742152) {
                int n5 = ++n;
                ++n;
                object = PT.rep(this.paramAsStr(n5), "''", "\"");
                sB.append(" spacegroup " + PT.esc((String)object));
                if (((String)object).equalsIgnoreCase("ignoreOperators")) {
                    n4 = -999;
                } else {
                    if (((String)object).length() == 0) {
                        symmetryInterface = this.vwr.getCurrentUnitCell();
                        if (symmetryInterface != null) {
                            object = symmetryInterface.getSpaceGroupName();
                        }
                    } else if (((String)object).indexOf(",") >= 0 && t3.x < 9.0f && t3.y < 9.0f && t3.z == 0.0f) {
                        object = String.valueOf(object) + "#doNormalize=0";
                    }
                    map.put("spaceGroupName", object);
                    n4 = -2;
                }
            }
            float[] fArray = null;
            if (this.tokAt(n) == 1814695966) {
                String string;
                if ((string = scriptEval.optParameterAsString(++n)).length() == 0) {
                    symmetryInterface = this.vwr.getCurrentUnitCell();
                    if (symmetryInterface != null) {
                        fArray = symmetryInterface.getUnitCellAsArray(true);
                        p3 = symmetryInterface.getCartesianOffset();
                    }
                } else if (this.tokAt(n) == 4) {
                    fArray = new float[6];
                    SimpleUnitCell.setOabc(string, fArray, null);
                } else {
                    fArray = scriptEval.floatParameterSet(n, 6, 9);
                }
                if (fArray == null || fArray.length != 6 && fArray.length != 9) {
                    this.invArg();
                }
                sB.append(" unitcell [");
                int n6 = 0;
                while (n6 < fArray.length) {
                    sB.append(String.valueOf(n6 == 0 ? "" : " ") + fArray[n6]);
                    ++n6;
                }
                sB.append("]");
                map.put("unitcell", fArray);
                if (n4 == Integer.MIN_VALUE) {
                    n4 = -1;
                }
                n = scriptEval.iToken + 1;
            }
            if (n4 != Integer.MIN_VALUE) {
                map.put("spaceGroupIndex", n4);
            }
        }
        if (p3 != null) {
            scriptEval.coordinatesAreFractional = false;
        } else if (this.tokAt(n) == 1073742066) {
            p3 = this.getPoint3f(++n, true);
        }
        if (p3 != null) {
            if (scriptEval.coordinatesAreFractional) {
                p3.setT(scriptEval.fractionalPoint);
                map.put("unitCellOffsetFractional", scriptEval.coordinatesAreFractional ? Boolean.TRUE : Boolean.FALSE);
                sB.append(" offset {" + p3.x + " " + p3.y + " " + p3.z + "/1}");
            } else {
                sB.append(" offset " + Escape.eP(p3));
            }
            map.put("unitCellOffset", p3);
            n = scriptEval.iToken + 1;
        }
        return n;
    }

    private int checkPacked(int n, Map<String, Object> map, SB sB) throws ScriptException {
        switch (this.tokAt(n)) {
            case 1073741938: {
                map.put("packed", Boolean.TRUE);
                T3[] t3Array = null;
                int n2 = this.tokAt(++n);
                switch (n2) {
                    case 1678381065: 
                    case 1814695966: {
                        break;
                    }
                    default: {
                        if (this.e.isArrayParameter(n)) {
                            t3Array = this.e.getPointArray(n, -1, false);
                            n = this.e.iToken;
                            break;
                        }
                        if (this.isFloatParameter(n)) {
                            float f = this.floatParameter(n);
                            t3Array = new P3[]{new P3(), P3.new3(f, f, f)};
                            break;
                        }
                        t3Array = new P3[]{};
                        --n;
                    }
                }
                ++n;
                if (this.e.chk) {
                    return n;
                }
                switch (n2) {
                    case 1814695966: {
                        String string = this.e.optParameterAsString(n++).toLowerCase();
                        if (PT.isOneOf(string, ";conventional;primitive;")) {
                            map.put("fillRange", string);
                            sB.append(" FILL UNITCELL \"" + string + "\"");
                            return n;
                        }
                        SymmetryInterface symmetryInterface = this.vwr.getCurrentUnitCell();
                        if (symmetryInterface != null) {
                            t3Array = BoxInfo.toOABC(symmetryInterface.getUnitCellVerticesNoOffset(), symmetryInterface.getCartesianOffset());
                            break;
                        }
                    }
                    case 1678381065: {
                        t3Array = BoxInfo.toOABC(this.vwr.ms.getBBoxVertices(), null);
                    }
                }
                switch (t3Array.length) {
                    case 2: {
                        P3 p3 = t3Array[1];
                        t3Array = new T3[]{t3Array[0], P3.newP(t3Array[0]), new P3(), new P3()};
                        t3Array[1].x = p3.x;
                        t3Array[2].y = p3.y;
                        t3Array[3].z = p3.z;
                        break;
                    }
                    case 3: {
                        t3Array = new T3[]{new P3(), t3Array[0], t3Array[1], t3Array[2]};
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        t3Array = new T3[]{new P3(), P3.new3(10.0f, 0.0f, 0.0f), P3.new3(0.0f, 10.0f, 0.0f), P3.new3(0.0f, 0.0f, 10.0f)};
                    }
                }
                map.put("fillRange", t3Array);
                sB.append(" FILL [" + t3Array[0] + t3Array[1] + t3Array[2] + t3Array[3] + "]");
                break;
            }
            case 0x40000100: {
                float f = Float.NaN;
                if (this.isFloatParameter(++n)) {
                    f = this.floatParameter(n++);
                }
                if (this.e.chk) break;
                map.put("packed", Boolean.TRUE);
                sB.append(" PACKED");
                if (Float.isNaN(f)) break;
                map.put("packingError", Float.valueOf(f));
                sB.append(" " + f);
            }
        }
        return n;
    }

    private void cache() throws ScriptException {
        int n = this.tokAt(1);
        String string = null;
        int n2 = 2;
        switch (n) {
            case 1073742119: 
            case 1275069441: {
                string = this.e.optParameterAsString(n2++);
            }
            case 1073741882: {
                int n3;
                this.checkLength(n2);
                if (this.chk) break;
                if ("all".equals(string)) {
                    string = null;
                }
                this.showString((n3 = this.vwr.cacheFileByName(string, n == 1275069441)) < 0 ? "cache cleared" : String.valueOf(n3) + " bytes " + (n == 1275069441 ? " cached" : " removed"));
                break;
            }
            default: {
                this.invArg();
            }
        }
    }

    private void calculate() throws ScriptException {
        boolean bl = false;
        boolean bl2 = false;
        BS bS = null;
        BS bS2 = null;
        ScriptEval scriptEval = this.e;
        int n = Integer.MIN_VALUE;
        int n2 = 2;
        scriptEval.iToken = scriptEval.slen;
        if (scriptEval.iToken >= 2) {
            scriptEval.clearDefinedVariableAtomSets();
            switch (this.getToken((int)1).tok) {
                case 0x40000000: {
                    this.checkLength(2);
                    break;
                }
                case 1086324752: {
                    scriptEval.iToken = 1;
                    bS = this.slen == 2 ? null : this.atomExpressionAt(2);
                    scriptEval.checkLast(scriptEval.iToken);
                    if (!this.chk) {
                        scriptEval.showString(this.vwr.calculateChirality(bS));
                    }
                    return;
                }
                case 1631586315: {
                    this.checkLength(2);
                    if (this.chk) {
                        return;
                    }
                    n = this.vwr.calculateFormalCharges(null);
                    this.showString(GT.i(GT.$("{0} charges modified"), n));
                    return;
                }
                case 1075838996: {
                    this.checkLength(2);
                    if (!this.chk) {
                        this.vwr.ms.assignAromaticBondsBs(true, null);
                    }
                    return;
                }
                case 1613238294: {
                    if (scriptEval.slen != 2) {
                        bl2 = this.tokAt(++scriptEval.iToken) == 1639976963;
                        bS = bl2 ? this.vwr.bsA() : this.atomExpressionAt(scriptEval.iToken);
                        if (!bl2 && !(bl2 = this.tokAt(++scriptEval.iToken) == 1639976963)) {
                            bS2 = this.atomExpressionAt(scriptEval.iToken);
                        }
                    }
                    if (this.chk) {
                        return;
                    }
                    n = this.vwr.autoHbond(bS, bS2, false);
                    if (n != Integer.MIN_VALUE) {
                        scriptEval.report(GT.i(GT.$("{0} hydrogen bonds"), Math.abs(n)), false);
                    }
                    return;
                }
                case 1612709900: {
                    boolean bl3;
                    boolean bl4 = bl3 = this.tokAt(2) == 1073742335;
                    if (bl3) {
                        scriptEval.iToken = scriptEval.iToken + 1;
                    }
                    bS = this.slen == (bl3 ? 3 : 2) ? null : this.atomExpressionAt(bl3 ? 3 : 2);
                    scriptEval.checkLast(scriptEval.iToken);
                    if (!this.chk) {
                        this.vwr.addHydrogens(bS, false, false);
                        if (bl3) {
                            if (bS == null) {
                                bS = this.vwr.bsA();
                            }
                            this.vwr.makeConnections(0.1f, 1.0E8f, 515, 1073742025, bS, bS, null, false, false, 0.0f);
                            this.vwr.ms.assignAromaticBondsBs(true, null);
                        }
                    }
                    return;
                }
                case 1111492619: {
                    scriptEval.iToken = 1;
                    bS = this.slen == 2 ? null : this.atomExpressionAt(2);
                    scriptEval.checkLast(scriptEval.iToken);
                    if (!this.chk) {
                        scriptEval.getPartialCharges(bS);
                    }
                    return;
                }
                case 0x8000022: 
                case 1088421903: {
                    if (!this.chk) {
                        if (this.tokAt(2) == 1275203608) {
                            String string = this.tokAt(3) == 4 ? this.stringParameter(3) : null;
                            bS = string != null || this.slen == 3 ? null : this.atomExpressionAt(3);
                            Object[] objectArray = new Object[3];
                            objectArray[0] = string;
                            objectArray[2] = bS;
                            Object[] objectArray2 = objectArray;
                            this.showString(scriptEval.getShapePropertyData(21, "symmetry", objectArray2) ? (String)objectArray2[1] : "");
                        } else {
                            this.showString(this.vwr.ms.calculatePointGroup(this.vwr.bsA()));
                        }
                    }
                    return;
                }
                case 1111490574: {
                    this.checkLength(2);
                    if (!this.chk) {
                        this.vwr.calculateStraightness();
                        this.vwr.addStateScript("set quaternionFrame '" + this.vwr.getQuaternionFrame() + "'; calculate straightness", false, true);
                    }
                    return;
                }
                case 1639976963: {
                    bS = this.slen < 4 || this.isFloatParameter(3) ? null : this.atomExpressionAt(2);
                    switch (this.tokAt(++scriptEval.iToken)) {
                        case 4138: {
                            break;
                        }
                        case 1111490587: {
                            if (this.chk) {
                                return;
                            }
                            scriptEval.showString(this.vwr.getAnnotationParser(true).calculateDSSRStructure(this.vwr, bS));
                            return;
                        }
                        case 1073741915: {
                            bl2 = true;
                            n2 = this.slen == scriptEval.iToken + 1 ? 2 : (int)this.floatParameter(++scriptEval.iToken);
                            break;
                        }
                        case 0: {
                            bl2 = this.vwr.getBoolean(603979826);
                            break;
                        }
                        default: {
                            this.invArg();
                        }
                    }
                    if (!this.chk) {
                        this.showString(this.vwr.calculateStructures(bS, bl2, true, n2));
                    }
                    return;
                }
                case 659482: {
                    bS = scriptEval.iToken + 1 < this.slen ? this.atomExpressionAt(++scriptEval.iToken) : null;
                    bS2 = scriptEval.iToken + 1 < this.slen ? this.atomExpressionAt(++scriptEval.iToken) : null;
                    this.checkLength(++scriptEval.iToken);
                    if (!this.chk) {
                        n = this.vwr.calculateStruts(bS, bS2);
                        if (n > 0) {
                            this.setShapeProperty(1, "type", 32768);
                            scriptEval.setShapePropertyBs(1, "color", 0xFFFFFF, null);
                            scriptEval.setShapeTranslucency(1, "", "translucent", 0.5f, null);
                            this.setShapeProperty(1, "type", 1023);
                        }
                        this.showString(GT.i(GT.$("{0} struts added"), n));
                    }
                    return;
                }
                case 2097180: {
                    bl = true;
                }
                case 1111490575: {
                    boolean bl5 = false;
                    switch (this.tokAt(2)) {
                        case 134217759: {
                            scriptEval.iToken = scriptEval.iToken + 1;
                            break;
                        }
                        case 0: {
                            bl5 = !bl;
                            break;
                        }
                        case 0x40000080: {
                            bl5 = true;
                            scriptEval.iToken = scriptEval.iToken + 1;
                            break;
                        }
                        default: {
                            bl5 = true;
                        }
                    }
                    bS = scriptEval.iToken + 1 < this.slen ? this.atomExpressionAt(++scriptEval.iToken) : this.vwr.bsA();
                    this.checkLength(++scriptEval.iToken);
                    if (!this.chk) {
                        this.vwr.calculateSurface(bS, bl5 ? Float.MAX_VALUE : -1.0f);
                    }
                    return;
                }
            }
        }
        scriptEval.errorStr2(53, "CALCULATE", "aromatic? hbonds? hydrogen? formalCharge? partialCharge? pointgroup? straightness? structure? struts? surfaceDistance FROM? surfaceDistance WITHIN?");
    }

    private void capture() throws ScriptException {
        Object object;
        boolean bl;
        if (!this.chk && !this.vwr.allowCapture()) {
            this.showString("Cannot capture on this platform");
            return;
        }
        Map<String, Object> map = this.vwr.captureParams;
        String string = map == null ? "GIF" : (String)map.get("type");
        float f = 0.0f;
        int n = 0;
        int n2 = this.e.slen;
        String string2 = "";
        boolean bl2 = this.vwr.am.animationReplayMode != 1073742070;
        int n3 = 1;
        int n4 = this.tokAt(n3);
        boolean bl3 = bl = n4 == 603979967;
        if (bl) {
            n4 = this.tokAt(++n3);
        }
        switch (n4 == 0 ? (n4 = 102409) : n4) {
            case 4: {
                int n5;
                string2 = this.e.optParameterAsString(n3++);
                if (string2.length() == 0) {
                    n = 102409;
                    break;
                }
                object = string2.toLowerCase();
                if (((String)object).endsWith(".gift") || ((String)object).endsWith(".pngt")) {
                    bl = true;
                    string2 = string2.substring(0, string2.length() - 1);
                    object = string2.toLowerCase();
                } else if (!((String)object).endsWith(".gif") && !((String)object).contains(".png")) {
                    string2 = String.valueOf(string2) + ".gif";
                }
                if (((String)object).endsWith(".png")) {
                    if (!((String)object).endsWith("0.png")) {
                        string2 = String.valueOf(string2.substring(0, string2.length() - 4)) + "0000.png";
                    }
                    string = "PNG";
                } else {
                    string = "GIF";
                }
                if (bl) {
                    string = String.valueOf(string) + "T";
                }
                boolean bl4 = (n5 = string2.indexOf("0000.")) < 0 || n5 != string2.lastIndexOf(".") - 4;
                boolean bl5 = false;
                if (this.tokAt(n3) == 528411) {
                    bl2 = true;
                    n4 = this.tokAt(++n3);
                }
                switch (this.tokAt(n3)) {
                    case 1073742129: {
                        bl5 = true;
                    }
                    case 1611141175: {
                        int n6;
                        String string3 = null;
                        String string4 = "y";
                        bl2 = true;
                        ++n3;
                        if (bl5) {
                            if (n3 < n2 && this.tokAt(n3) != 2) {
                                string4 = this.e.optParameterAsString(n3++).toLowerCase();
                            }
                            string3 = "rotate Y 10 10;rotate Y -10 -10;rotate Y -10 -10;rotate Y 10 10";
                            int n7 = n6 = n3 < n2 ? this.intParameter(n3++) : 5;
                            string3 = n6 < 0 ? PT.rep(string3, "10;", -n6 + ";") : PT.rep(string3, "10", "" + n6);
                        } else {
                            if (n3 < n2) {
                                string4 = this.e.optParameterAsString(n3++).toLowerCase();
                            }
                            string3 = "rotate Y 360 30;";
                        }
                        if (this.chk) {
                            return;
                        }
                        this.vwr.setNavigationMode(false);
                        if (string4 == "" || "xyz".indexOf(string4) < 0) {
                            string4 = "y";
                        }
                        n6 = this.vwr.g.waitForMoveTo ? 1 : 0;
                        string3 = "set waitformoveto true;" + PT.rep(string3, "Y", string4) + ";set waitformoveto " + (n6 != 0);
                        string3 = "capture " + (bl ? "transparent " : "") + PT.esc(string2) + " LOOP;" + string3 + ";capture end;";
                        this.e.cmdScript(0, null, string3);
                        return;
                    }
                    case 2: 
                    case 3: {
                        f = this.floatParameter(n3++);
                    }
                }
                if (this.chk) {
                    return;
                }
                n = 1073742031;
                map = new Hashtable<String, Object>();
                int n8 = this.vwr.getInt(553648132);
                if (bl4) {
                    map.put("streaming", Boolean.TRUE);
                    if (!bl2) {
                        this.showString(GT.o(GT.$("Note: Enable looping using {0}"), new Object[]{"ANIMATION MODE LOOP"}));
                    }
                    this.showString(GT.o(GT.$("Animation delay based on: {0}"), new Object[]{"ANIMATION FPS " + n8}));
                }
                map.put("captureFps", n8);
                break;
            }
            case 102409: 
            case 1073741874: {
                if (map != null) {
                    map.put("captureSilent", Boolean.TRUE);
                }
            }
            case 1073742334: 
            case 1073742335: {
                this.checkLength(-2);
                n = n4;
                break;
            }
            default: {
                this.invArg();
            }
        }
        if (this.chk || map == null) {
            return;
        }
        map.put("type", string);
        object = this.vwr.getBackgroundArgb();
        map.put("backgroundColor", object);
        map.put("fileName", string2);
        map.put("quality", -1);
        map.put("endTime", f <= 0.0f ? -1L : System.currentTimeMillis() + (long)(f * 1000.0f));
        map.put("captureMode", T.nameOf(n).toLowerCase());
        map.put("captureLooping", bl2 ? Boolean.TRUE : Boolean.FALSE);
        String string5 = this.vwr.processWriteOrCapture(map);
        if (string5 == null) {
            string5 = "canceled";
        }
        Logger.info(string5);
    }

    private void centerAt() throws ScriptException {
        int n = this.getToken((int)1).tok;
        switch (n) {
            case 96: 
            case 0x40000002: 
            case 1678381065: {
                break;
            }
            default: {
                this.invArg();
            }
        }
        P3 p3 = P3.new3(0.0f, 0.0f, 0.0f);
        if (this.slen == 5) {
            p3.x = this.floatParameter(2);
            p3.y = this.floatParameter(3);
            p3.z = this.floatParameter(4);
        } else if (this.e.isCenterParameter(2)) {
            p3 = this.centerParameter(2);
            this.e.checkLast(this.e.iToken);
        } else {
            this.checkLength(2);
        }
        if (!this.chk && !this.vwr.isJmolDataFrame()) {
            this.vwr.tm.setCenterAt(n, p3);
        }
    }

    private void compare() throws ScriptException {
        BS[] bSArray;
        boolean bl;
        ScriptEval scriptEval = this.e;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        Quat[] quatArray = null;
        Quat[] quatArray2 = null;
        BS bS = null;
        BS bS2 = null;
        Lst<Object[]> lst = null;
        Lst<Object[]> lst2 = null;
        scriptEval.iToken = 0;
        float f = this.isFloatParameter(1) ? this.floatParameter(++scriptEval.iToken) : Float.NaN;
        BS bS3 = this.atomExpressionAt(++scriptEval.iToken);
        P3[] p3Array = null;
        BS bS4 = null;
        if (scriptEval.isArrayParameter(++scriptEval.iToken)) {
            p3Array = scriptEval.getPointArray(scriptEval.iToken, -1, false);
        } else if (this.tokAt(scriptEval.iToken) != 0x44000001) {
            bS4 = this.atomExpressionAt(scriptEval.iToken);
        }
        BS bS5 = null;
        boolean bl7 = false;
        String string = null;
        BS bS6 = BSUtil.copy(bS3);
        if (bS4 != null) {
            bS6.or(bS4);
        }
        boolean bl8 = bl = p3Array == null && bS4 != null && bS6.equals(bS3);
        int n = scriptEval.iToken + 1;
        while (n < this.slen) {
            switch (this.getToken((int)n).tok) {
                case 4115: {
                    bl8 = true;
                    break;
                }
                case 134218757: {
                    bl7 = true;
                    if (this.tokAt(n + 1) != 4) {
                        string = "*";
                        break;
                    }
                }
                case 0x8000404: {
                    string = this.stringParameter(++n);
                    break;
                }
                case 1677721602: {
                    bl6 = true;
                    bl3 = true;
                    string = this.paramAsStr(++n);
                    if (!string.equalsIgnoreCase("SMILES")) break;
                    bl7 = true;
                    string = "*";
                    break;
                }
                case 2: 
                case 3: {
                    f = Math.abs(this.floatParameter(n));
                    if (!(f > 0.0f)) break;
                    bl5 = true;
                    break;
                }
                case 0x10000030: {
                    break;
                }
                case 2109448: {
                    bS5 = this.atomExpressionAt(++n);
                    n = scriptEval.iToken;
                    break;
                }
                case 10: 
                case 1073742325: {
                    int n2;
                    if (lst2 != null) {
                        this.invArg();
                    }
                    bS = this.atomExpressionAt(scriptEval.iToken);
                    int n3 = n2 = bl ? 0 : this.tokAt(scriptEval.iToken + 1);
                    BS bS7 = p3Array == null && scriptEval.isArrayParameter(scriptEval.iToken + 1) ? null : (bS2 = n2 == 10 || n2 == 1073742325 ? this.atomExpressionAt(++scriptEval.iToken) : BSUtil.copy(bS));
                    if (bS5 != null) {
                        bS.and(bS5);
                        if (bS2 != null) {
                            bS2.and(bS5);
                        }
                    }
                    if (bS2 == null) {
                        p3Array = scriptEval.getPointArray(++scriptEval.iToken, -1, false);
                    } else if (bS4 != null) {
                        bS2.and(bS4);
                    }
                    if (lst == null) {
                        lst = new Lst<Object[]>();
                    }
                    lst.addLast(new BS[]{bS, bS2});
                    n = scriptEval.iToken;
                    break;
                }
                case 7: {
                    if (lst != null) {
                        this.invArg();
                    }
                    bl2 = true;
                    quatArray = scriptEval.getQuaternionArray(((SV)scriptEval.theToken).getList(), 1073742001);
                    this.getToken(++n);
                    quatArray2 = scriptEval.getQuaternionArray(((SV)scriptEval.theToken).getList(), 1073742001);
                    if (lst2 == null) {
                        lst2 = new Lst<Object[]>();
                    }
                    lst2.addLast(new Object[]{quatArray, quatArray2});
                    break;
                }
                case 1073742077: {
                    bl2 = true;
                    break;
                }
                case 134217751: 
                case 0x44000001: {
                    bl2 = false;
                    break;
                }
                case 528432: {
                    bl3 = true;
                    break;
                }
                case 4160: {
                    bl4 = true;
                    break;
                }
                default: {
                    this.invArg();
                }
            }
            ++n;
        }
        if (this.chk) {
            return;
        }
        if (bl8) {
            f = 0.0f;
        }
        if (Float.isNaN(f) || f < 0.0f) {
            f = 1.0f;
        } else if (!bl3 && !bl4) {
            bl4 = true;
            bl3 = true;
        }
        bl5 = f != 0.0f;
        int n4 = n = (bl2 || string != null) && p3Array == null ? 0 : 1;
        if (n != 0) {
            Interface.getInterface("javajs.util.Eigen", this.vwr, "script");
        }
        if (lst == null && lst2 == null) {
            if (bS5 == null) {
                BS bS8 = bS = n != 0 ? this.vwr.getAtomBitSet("spine") : new BS();
                if (bS.nextSetBit(0) < 0) {
                    bS = bS3;
                    bS2 = bS4;
                } else {
                    bS2 = BSUtil.copy(bS);
                    bS.and(bS3);
                    bS2.and(bS4);
                }
            } else {
                bS = BSUtil.copy(bS3);
                bS2 = BSUtil.copy(bS4);
                bS.and(bS5);
                bS.and(bS3);
                if (bS2 != null) {
                    bS2.and(bS5);
                    bS2.and(bS4);
                }
            }
            lst = new Lst();
            lst.addLast(new BS[]{bS, bS2});
        }
        if (bl8) {
            BS bS9 = this.vwr.ms.getModelBS(bS3, false);
            bSArray = new BS[bS9.cardinality()];
            int n5 = 0;
            int n6 = bS9.nextSetBit(0);
            while (n6 >= 0) {
                bSArray[n5] = this.vwr.getModelUndeletedAtomsBitSet(n6);
                n6 = bS9.nextSetBit(n6 + 1);
                ++n5;
            }
        } else {
            bSArray = new BS[]{bS3};
        }
        int n7 = 0;
        while (n7 < bSArray.length) {
            Object object;
            Serializable serializable;
            Object object2;
            bS3 = bSArray[n7];
            float[] fArray = new float[2];
            Quat quat = null;
            Lst<Quat> lst3 = new Lst<Quat>();
            P3[][] p3Array2 = null;
            Lst<Object[]> lst4 = bl8 ? new Lst<Object[]>() : lst;
            int n8 = 0;
            while (n8 < lst.size()) {
                object2 = (BS[])lst.get(n8);
                if (bl8) {
                    object2 = new BS[]{BSUtil.copy(object2[0]), object2[1]};
                    lst4.addLast((Object[])object2);
                }
                object2[0].and(bS3);
                ++n8;
            }
            P3 p3 = null;
            object2 = null;
            if (n != 0) {
                if (p3Array != null) {
                    lst4.clear();
                    lst4.addLast(new Object[]{bS, p3Array});
                }
                try {
                    p3Array2 = this.vwr.getCenterAndPoints(lst4, true);
                }
                catch (Exception exception) {
                    this.invArg();
                }
                int n9 = p3Array2[0].length - 1;
                int n10 = 1;
                while (n10 <= n9) {
                    P3 p32 = p3Array2[0][n10];
                    serializable = p3Array2[1][n10];
                    if (!(p32 instanceof Atom) || !(serializable instanceof Atom)) break;
                    Logger.info(" atom 1 " + ((Atom)p32).getInfo() + "\tatom 2 " + ((Atom)serializable).getInfo());
                    ++n10;
                }
                quat = Measure.calculateQuaternionRotation(p3Array2, fArray);
                float f2 = Float.isNaN(fArray[1]) ? Float.NaN : (float)Math.round(fArray[0] * 100.0f) / 100.0f;
                float f3 = Float.isNaN(fArray[1]) ? Float.NaN : (float)Math.round(fArray[1] * 100.0f) / 100.0f;
                this.showString("RMSD " + f2 + " --> " + f3 + " Angstroms");
            } else if (bl2) {
                int n11;
                if (lst2 == null) {
                    n11 = 0;
                    while (n11 < lst4.size()) {
                        BS[] bSArray2 = (BS[])lst4.get(n11);
                        quatArray = this.vwr.getAtomGroupQuaternions(bSArray2[0], Integer.MAX_VALUE);
                        quatArray2 = this.vwr.getAtomGroupQuaternions(bSArray2[1], Integer.MAX_VALUE);
                        int n12 = 0;
                        while (n12 < quatArray.length && n12 < quatArray2.length) {
                            lst3.addLast(quatArray2[n12].div(quatArray[n12]));
                            ++n12;
                        }
                        ++n11;
                    }
                } else {
                    n11 = 0;
                    while (n11 < quatArray.length && n11 < quatArray2.length) {
                        lst3.addLast(quatArray2[n11].div(quatArray[n11]));
                        ++n11;
                    }
                }
                fArray[0] = 0.0f;
                quatArray = lst3.toArray(new Quat[lst3.size()]);
                quat = Quat.sphereMean(quatArray, fArray, 1.0E-4f);
                this.showString("RMSD = " + fArray[0] + " degrees");
            } else {
                float f4;
                object = new M4();
                p3 = new P3();
                if (("*".equals(string) || "".equals(string)) && bS3 != null) {
                    try {
                        string = this.vwr.getSmiles(bS3);
                    }
                    catch (Exception exception) {
                        scriptEval.evalError(exception.getMessage(), null);
                    }
                }
                if (bl6) {
                    float[] fArray2;
                    if (bS3 == null || bS4 == null || (fArray2 = scriptEval.getSmilesExt().getFlexFitList(bS3, bS4, string, !bl7)) == null) {
                        return;
                    }
                    this.vwr.setDihedrals(fArray2, null, 1.0f);
                }
                if (Float.isNaN(f4 = scriptEval.getSmilesExt().getSmilesCorrelation(bS3, bS4, string, null, null, (M4)object, null, false, null, p3, false, 0x20 | (bl7 ? 1 : 2)))) {
                    this.showString("structures do not match");
                    return;
                }
                if (bl4) {
                    object2 = new V3();
                    ((M4)object).getTranslation((T3)object2);
                }
                if (bl3) {
                    M3 m3 = new M3();
                    ((M4)object).getRotationScale(m3);
                    quat = Quat.newM(m3);
                }
                this.showString("RMSD = " + f4 + " Angstroms");
            }
            if (p3Array2 != null) {
                p3 = p3Array2[0][0];
            }
            if (p3 == null) {
                p3Array2 = this.vwr.getCenterAndPoints(lst4, true);
                p3 = p3Array2[0][0];
            }
            object = new P3();
            float f5 = Float.NaN;
            if (bl4) {
                if (object2 == null) {
                    object2 = V3.newVsub(p3Array2[1][0], p3);
                }
                f5 = 1.0E10f;
            }
            if (bl3) {
                if (quat == null) {
                    scriptEval.evalError("option not implemented", null);
                }
                ((T3)object).add2(p3, quat.getNormal());
                f5 = quat.getTheta();
                if (f5 == 0.0f && bl4) {
                    if (((T3)object2).length() > 0.01f) {
                        f5 = 1.0E10f;
                    } else {
                        bl5 = false;
                        bl4 = false;
                        bl3 = false;
                    }
                }
            }
            if (!Float.isNaN(f5) && !Float.isNaN(((P3)object).x)) {
                Lst<P3> lst5 = null;
                if (bl3 && bl4 && f != 0.0f) {
                    serializable = this.vwr.ms.getAtomPointVector(bS3);
                    M4 m4 = ScriptMathProcessor.getMatrix4f(quat.getMatrix(), (T3)object2);
                    lst5 = Measure.transformPoints((Lst<P3>)serializable, m4, p3);
                }
                if (!scriptEval.useThreads()) {
                    bl5 = false;
                }
                if (this.vwr.rotateAboutPointsInternal(scriptEval, p3, (P3)object, f5 / f, f5, bl5, bS3, (V3)object2, lst5, null, null) && bl5 && scriptEval.isJS) {
                    throw new ScriptInterruption(scriptEval, "compare", 1);
                }
            }
            ++n7;
        }
    }

    private void configuration() throws ScriptException {
        BS bS = null;
        BS bS2 = this.vwr.bsA();
        if (this.slen == 1) {
            if (this.chk) {
                return;
            }
            bS = this.vwr.ms.setConformation(bS2);
            this.vwr.ms.addStateScript("select", null, bS2, null, "configuration", true, false);
        } else if (this.isFloatParameter(1)) {
            int n = this.intParameter(this.e.checkLast(1));
            if (this.chk) {
                return;
            }
            bS = this.vwr.ms.getConformation(this.vwr.am.cmi, n - 1, true, null);
            this.vwr.addStateScript("configuration " + n + ";", true, false);
        } else {
            bS = this.atomExpressionAt(1);
            if (this.chk) {
                return;
            }
            int n = this.intParameter(this.e.checkLast(this.e.iToken + 1));
            this.vwr.addStateScript("configuration " + Escape.eBS(bS) + " " + n + ";", true, false);
            bS = this.vwr.ms.getConformation(this.vwr.am.cmi, n - 1, true, bS);
        }
        this.setShapeProperty(1, "type", 30720);
        this.e.setShapeSizeBs(1, 0, bS);
        this.vwr.autoHbond(bS, bS, true);
        this.vwr.select(bS, false, 0, this.e.tQuiet);
    }

    private void measure() throws ScriptException {
        ScriptEval scriptEval = this.e;
        String string = null;
        int n = 1;
        short s = 0;
        float[] fArray = null;
        if (this.slen == 2) {
            switch (this.tokAt(1)) {
                case 1073742334: {
                    this.setShapeProperty(6, "hideAll", Boolean.TRUE);
                    return;
                }
                case 12291: {
                    if (!this.chk) {
                        this.vwr.clearAllMeasurements();
                    }
                    return;
                }
            }
        }
        this.vwr.shm.loadShape(6);
        switch (this.tokAt(1)) {
            case 0x8000404: {
                String string2 = this.stringParameter(this.slen == 3 ? 2 : 4);
                if (this.chk) {
                    return;
                }
                Node[] nodeArray = this.vwr.ms.at;
                int n2 = this.vwr.ms.ac;
                int[][] nArray = null;
                try {
                    nArray = this.vwr.getSmilesMatcher().getCorrelationMaps(string2, nodeArray, n2, this.vwr.bsA(), 2);
                }
                catch (Exception exception) {
                    scriptEval.evalError(exception.getMessage(), null);
                }
                if (nArray == null) {
                    return;
                }
                this.setShapeProperty(6, "maps", nArray);
                return;
            }
        }
        switch (this.slen) {
            case 2: {
                switch (this.getToken((int)n).tok) {
                    case 0: 
                    case 1073742335: {
                        this.vwr.shm.loadShape(6);
                        this.setShapeProperty(6, "hideAll", Boolean.FALSE);
                        return;
                    }
                    case 1073742001: {
                        if (!this.chk) {
                            scriptEval.showStringPrint(this.vwr.getMeasurementInfoAsString(), false);
                        }
                        return;
                    }
                    case 4: {
                        this.setShapeProperty(6, "setFormats", this.stringParameter(1));
                        return;
                    }
                }
                scriptEval.errorStr(24, "ON, OFF, DELETE");
                break;
            }
            case 3: {
                switch (this.getToken((int)1).tok) {
                    case 12291: {
                        if (this.getToken((int)2).tok == 1073742327) {
                            if (!this.chk) {
                                this.vwr.clearAllMeasurements();
                            }
                        } else {
                            int n3 = this.intParameter(2) - 1;
                            if (!this.chk) {
                                this.vwr.deleteMeasurement(n3);
                            }
                        }
                        return;
                    }
                }
            }
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int[] nArray = new int[5];
        float[] fArray2 = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        RadiusData radiusData = null;
        Boolean bl5 = null;
        int n9 = 268435538;
        String string3 = null;
        Font font = null;
        Lst<Object> lst = new Lst<Object>();
        BS bS = new BS();
        JSONEncodable jSONEncodable = null;
        TickInfo tickInfo = null;
        int n10 = 0;
        int n11 = 0;
        String string4 = null;
        int n12 = 1;
        while (n12 < this.slen) {
            switch (this.getToken((int)n12).tok) {
                case 1073741974: {
                    if (n12 != 1) {
                        this.invArg();
                    }
                    string = scriptEval.optParameterAsString(++n12);
                    break;
                }
                case 0x40000000: {
                    scriptEval.errorStr(24, "ALL, ALLCONNECTED, DELETE");
                    break;
                }
                default: {
                    this.error(15);
                    break;
                }
                case 0x10000070: {
                    if (this.tokAt(n12 + 1) != 0x8000008) {
                        this.invArg();
                    }
                    ++n12;
                    bl3 = true;
                    break;
                }
                case 0x40000008: {
                    string4 = this.paramAsStr(++n12).toLowerCase();
                    break;
                }
                case 0x8000008: 
                case 0x4000000A: 
                case 1073742327: {
                    bl2 = scriptEval.theTok == 0x4000000A;
                    n7 = -1;
                    bl = true;
                    if (!bl2 || !bl3) break;
                    this.invArg();
                    break;
                }
                case 1765808134: {
                    s = C.getColix(scriptEval.getArgbParam(++n12));
                    n12 = scriptEval.iToken;
                    break;
                }
                case 1073742066: {
                    if (scriptEval.isPoint3f(++n12)) {
                        P3 p3 = this.getPoint3f(n12, false);
                        fArray = new float[]{1.0f, p3.x, p3.y, p3.z, 0.0f, 0.0f, 0.0f};
                    } else {
                        fArray = scriptEval.floatParameterSet(n12, 7, 7);
                    }
                    n12 = scriptEval.iToken;
                    break;
                }
                case 1073741917: 
                case 1665140738: {
                    n11 = (int)((float)(scriptEval.theTok == 1665140738 ? 2000 : 1000) * this.floatParameter(++n12));
                    if (string == null || n11 > 0) break;
                    n11 = -1;
                    break;
                }
                case 3: {
                    if (radiusData != null) {
                        this.invArg();
                    }
                    bl = true;
                    bl4 = true;
                    n8 = (n8 + 1) % 2;
                    fArray2[n8] = this.floatParameter(n12);
                    break;
                }
                case 12291: {
                    if (n9 != 268435538) {
                        this.invArg();
                    }
                    n9 = 12291;
                    break;
                }
                case 4114: {
                    float f = this.floatParameter(++n12);
                    String string5 = this.paramAsStr(++n12);
                    String string6 = this.paramAsStr(++n12);
                    if (this.chk) break;
                    font = this.vwr.getFont3D(string5, string6, f);
                    break;
                }
                case 2: {
                    int n13 = this.intParameter(n12);
                    if (bl) {
                        bl4 = true;
                        n8 = (n8 + 1) % 2;
                        fArray2[n8] = n13;
                        break;
                    }
                    n7 = this.vwr.ms.getFirstAtomIndexFromAtomNumber(n13, this.vwr.getVisibleFramesBitSet());
                    if (!this.chk && n7 < 0) {
                        return;
                    }
                    if (jSONEncodable != null) {
                        this.invArg();
                    }
                    if ((nArray[0] = ++n4) > 4) {
                        scriptEval.bad();
                    }
                    nArray[n4] = n7;
                    break;
                }
                case 1094713359: {
                    n6 = this.intParameter(++n12);
                    break;
                }
                case 1073742334: {
                    if (n9 != 268435538) {
                        this.invArg();
                    }
                    n9 = 1073742334;
                    break;
                }
                case 1073742335: {
                    if (n9 != 268435538) {
                        this.invArg();
                    }
                    n9 = 1073742335;
                    break;
                }
                case 1073742114: {
                    bl = true;
                    bl4 = true;
                    n7 = -1;
                    break;
                }
                case 1073741989: 
                case 1073741990: {
                    bl5 = scriptEval.theTok == 1073741989;
                    bl = true;
                    bl3 = scriptEval.theTok == 1073741990;
                    break;
                }
                case 1648363544: {
                    if (n8 >= 0) {
                        this.invArg();
                    }
                    if ((radiusData = scriptEval.encodeRadiusParameter(n12, false, true)) == null) {
                        return;
                    }
                    radiusData.values = fArray2;
                    n12 = scriptEval.iToken;
                    bl3 = true;
                    bl = true;
                    bl5 = false;
                    if (n10 != 1) break;
                    ++n10;
                    ++n4;
                    Object object = BSUtil.copy(bS);
                    BSUtil.invertInPlace((BS)object, this.vwr.ms.ac);
                    ((BS)object).and(this.vwr.ms.getAtomsWithinRadius(5.0f, bS, false, null));
                    lst.addLast(object);
                    break;
                }
                case 10: 
                case 12290: 
                case 1073742325: {
                    ++n10;
                }
                case 8: 
                case 1073742330: 
                case 1073742332: {
                    if (n7 >= 0) {
                        this.invArg();
                    }
                    Object object = new Object[1];
                    jSONEncodable = scriptEval.centerParameter(n12, (Object[])object);
                    if (object[0] instanceof BS) {
                        bS = (BS)object[0];
                        jSONEncodable = bS;
                        if (!this.chk && bS.length() == 0) {
                            return;
                        }
                    }
                    if (jSONEncodable instanceof P3) {
                        Point3fi point3fi = new Point3fi();
                        point3fi.setT((T3)jSONEncodable);
                        point3fi.mi = (short)n6;
                        jSONEncodable = point3fi;
                    }
                    if ((n4 = ++n5) > 4) {
                        scriptEval.bad();
                    }
                    n12 = scriptEval.iToken;
                    lst.addLast(jSONEncodable);
                    break;
                }
                case 4: {
                    string3 = this.stringParameter(n12);
                    break;
                }
                case 1073742164: {
                    tickInfo = scriptEval.tickParamAsStr(n12, false, true, true);
                    n12 = scriptEval.iToken;
                    n9 = 12290;
                }
            }
            ++n12;
        }
        if (radiusData != null && (n8 >= 0 || n4 != 2) || n4 < 2 && string == null && (tickInfo == null || n4 == 1)) {
            scriptEval.bad();
        }
        if (string3 != null && string3.indexOf(String.valueOf(n4) + ":") != 0) {
            string3 = String.valueOf(n4) + ":" + string3;
        }
        if (bl4 && fArray2[1] < fArray2[0]) {
            fArray2[1] = fArray2[0];
            float f = fArray2[0] = fArray2[1] == Float.MAX_VALUE ? Float.MAX_VALUE : -200.0f;
        }
        if (this.chk) {
            return;
        }
        if (jSONEncodable != null || tickInfo != null) {
            if (radiusData == null) {
                radiusData = new RadiusData(fArray2, 0.0f, null, null);
            }
            if (jSONEncodable == null) {
                tickInfo.id = "default";
            }
            if (jSONEncodable != null && string3 != null && n9 == 268435538) {
                n9 = 12290;
            }
            Text text = null;
            if (font != null || string4 != null || string3 != null && string3.indexOf(10) >= 0) {
                Text cfr_ignored_0 = (Text)Interface.getInterface("org.jmol.modelset.Text", this.vwr, "script");
                text = Text.newLabel(this.vwr, font, "", s, (short)0, 0, 0.0f);
            }
            if (text != null) {
                text.pymolOffset = fArray;
                text.setAlignmentLCR(string4);
            }
            this.setShapeProperty(6, "measure", this.vwr.newMeasurementData(string, lst).set(n9, null, radiusData, string3, null, tickInfo, bl2, bl3, bl5, bl, n11, s, text));
            return;
        }
        Object object = string == null ? nArray : (Object)string;
        switch (n9) {
            case 12291: {
                this.setShapeProperty(6, "delete", object);
                break;
            }
            case 1073742335: {
                this.setShapeProperty(6, "show", object);
                break;
            }
            case 1073742334: {
                this.setShapeProperty(6, "hide", object);
                break;
            }
            default: {
                this.setShapeProperty(6, string3 == null ? "toggle" : "toggleOn", object);
                if (string3 == null) break;
                this.setShapeProperty(6, "setFormats", string3);
            }
        }
    }

    private void connect(int n) throws ScriptException {
        Object object;
        ScriptEval scriptEval = this.e;
        float[] fArray = new float[2];
        BS[] bSArray = new BS[2];
        bSArray[0] = bSArray[1] = this.vwr.bsA();
        float f = Float.NaN;
        int[] nArray = new int[]{Integer.MIN_VALUE};
        int n2 = 0;
        int n3 = 131071;
        int n4 = 1073742026;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        float f2 = Float.MAX_VALUE;
        boolean bl4 = false;
        int n5 = 0;
        int n6 = 0;
        BS bS = new BS();
        boolean bl5 = false;
        int n7 = 0;
        int n8 = 0;
        float f3 = 0.0f;
        boolean bl6 = false;
        if (this.slen == 1) {
            if (!this.chk) {
                this.vwr.rebondState(scriptEval.isStateScript);
            }
            return;
        }
        if (this.tokAt(1) == 1073877011) {
            if (!this.chk) {
                this.vwr.connectNBO(this.e.optParameterAsString(2));
            }
            return;
        }
        int n9 = n;
        while (n9 < this.slen) {
            switch (this.getToken((int)n9).tok) {
                case 1073742334: 
                case 1073742335: {
                    this.checkLength(2);
                    if (!this.chk) {
                        this.vwr.rebondState(scriptEval.isStateScript);
                    }
                    return;
                }
                case 2: 
                case 3: {
                    int n10;
                    if (n5 > 0) {
                        if (bl2 || bl4) {
                            scriptEval.error(23);
                        }
                        if ((n10 = Edge.getBondOrderFromFloat(this.floatParameter(n9))) == 131071) {
                            this.invArg();
                        }
                        n3 = n10;
                        bl2 = true;
                        break;
                    }
                    if (++n6 > 2) {
                        scriptEval.bad();
                    }
                    float f4 = this.floatParameter(n9);
                    if (this.tokAt(n9 + 1) == 268435634) {
                        f4 = -f4 / 100.0f;
                        ++n9;
                    }
                    fArray[n2++] = f4;
                    break;
                }
                case 10: 
                case 12290: 
                case 1073742325: {
                    int n11;
                    if (n5 > 2 || bl5 && n5 > 0) {
                        scriptEval.bad();
                    }
                    if (bl2 || bl4) {
                        this.invArg();
                    }
                    bSArray[n5++] = this.atomExpressionAt(n9);
                    bl5 = scriptEval.isBondSet;
                    if (n5 == 2) {
                        n11 = scriptEval.iToken;
                        int n12 = n9;
                        while (n12 < n11) {
                            if (this.tokAt(n12) == 0x40000000 && this.paramAsStr(n12).equals("_1")) {
                                n7 = n9;
                                break;
                            }
                            ++n12;
                        }
                        scriptEval.iToken = n11;
                    }
                    n9 = scriptEval.iToken;
                    break;
                }
                case 1086324742: {
                    bl6 = true;
                    break;
                }
                case 603979967: 
                case 1073742074: 
                case 1765808134: {
                    bl4 = true;
                    f2 = this.getColorTrans(scriptEval, n9, false, nArray);
                    n9 = scriptEval.iToken;
                    break;
                }
                case 1073742086: {
                    int n11 = this.tokAt(2) == 1073741852 ? 1 : 0;
                    this.checkLength(n11 != 0 ? 3 : 2);
                    if (this.chk) {
                        return;
                    }
                    this.vwr.clearModelDependentObjects();
                    this.vwr.ms.deleteAllBonds();
                    BS bS2 = new BS();
                    this.vwr.ms.setPdbConectBonding(0, 0, bS2);
                    if (n11 != 0) {
                        boolean bl7 = scriptEval.isStateScript && this.vwr.getBoolean(603979873);
                        this.vwr.ms.autoBondBs4(null, null, bS2, null, this.vwr.getMadBond(), bl7);
                        this.vwr.addStateScript(bl7 ? "set legacyAutoBonding TRUE;connect PDB AUTO;set legacyAutoBonding FALSE;" : "connect PDB auto;", false, true);
                        return;
                    }
                    this.vwr.addStateScript("connect PDB;", false, true);
                    return;
                }
                case 0x40000006: 
                case 1073741852: 
                case 0x40000050: 
                case 1073742025: 
                case 1073742026: {
                    bl3 = true;
                    if (++n9 != this.slen) {
                        this.invArg();
                    }
                    if ((n4 = scriptEval.theTok) != 1073741852 || n3 == 131071 || n3 == 2048 || n3 == 515) break;
                    this.invArg();
                    break;
                }
                case 659482: {
                    if (!bl4) {
                        nArray[0] = 0xFFFFFF;
                        f2 = 0.5f;
                        f = this.vwr.getFloat(570425406);
                        bl4 = true;
                    }
                    if (!bl3) {
                        n4 = 1073742026;
                        bl3 = true;
                    }
                }
                case 0x40000000: {
                    if (scriptEval.isColorParam(n9)) {
                        n8 = -n9;
                        break;
                    }
                }
                case 1075838996: 
                case 1613238294: {
                    object = this.paramAsStr(n9);
                    int n10 = ScriptParam.getBondOrderFromString((String)object);
                    if (n10 == 131071) {
                        this.invArg();
                    }
                    if (bl2) {
                        scriptEval.error(18);
                    }
                    bl2 = true;
                    switch (n10) {
                        case 33: {
                            switch (this.tokAt(n9 + 1)) {
                                case 3: {
                                    n10 = ScriptParam.getPartialBondOrderFromFloatEncodedInt(this.st[++n9].intValue);
                                    break;
                                }
                                case 2: {
                                    n10 = (short)this.intParameter(++n9);
                                }
                            }
                            break;
                        }
                        case 2048: {
                            if (this.tokAt(n9 + 1) != 2) break;
                            n10 = (short)(this.intParameter(++n9) << 11);
                            f3 = this.floatParameter(++n9);
                            break;
                        }
                        case 65537: {
                            if (bl3) break;
                            n4 = 1073742025;
                            bl3 = true;
                        }
                    }
                    n3 = n10;
                    break;
                }
                case 1665140738: {
                    f = this.floatParameter(++n9);
                    bl4 = true;
                    break;
                }
                case 12291: 
                case 1073742333: {
                    if (++n9 != this.slen) {
                        this.invArg();
                    }
                    n4 = 12291;
                    bl = true;
                    bl4 = false;
                    break;
                }
                default: {
                    n8 = n9;
                }
            }
            if (n9 > 0) {
                if (n8 == -n9 || n8 == n9 && scriptEval.isColorParam(n9)) {
                    bl4 = true;
                    nArray[0] = scriptEval.getArgbParam(n9);
                    n9 = scriptEval.iToken;
                } else if (n8 == n9) {
                    this.invArg();
                }
            }
            ++n9;
        }
        if (this.chk) {
            return;
        }
        if (n2 < 2) {
            if (n2 == 0) {
                fArray[0] = 1.0E8f;
            }
            fArray[1] = fArray[0];
            fArray[0] = 0.1f;
        }
        if (bl4) {
            if (!bl2) {
                n3 = 65535;
            }
            if (!bl3) {
                n4 = 1073742025;
            }
        }
        n9 = 0;
        int n13 = 0;
        if (n7 > 0) {
            BS bS3 = new BS();
            this.vwr.definedAtomSets.put("_1", bS3);
            object = bSArray[0];
            int n14 = ((BS)object).nextSetBit(0);
            while (n14 >= 0) {
                bS3.set(n14);
                int[] nArray2 = this.vwr.makeConnections(fArray[0], fArray[1], n3, n4, bS3, this.atomExpressionAt(n7), bS, bl5, false, 0.0f);
                n9 += Math.abs(nArray2[0]);
                n13 += nArray2[1];
                bS3.clear(n14);
                n14 = ((BS)object).nextSetBit(n14 + 1);
            }
        } else {
            int[] nArray3 = this.vwr.makeConnections(fArray[0], fArray[1], n3, n4, bSArray[0], bSArray[1], bS, bl5, bl6, f3);
            n9 += Math.abs(nArray3[0]);
            n13 += nArray3[1];
        }
        boolean bl8 = scriptEval.doReport();
        if (bl) {
            if (bl8) {
                scriptEval.report(GT.i(GT.$("{0} connections deleted"), n13), false);
            }
            return;
        }
        if (bl4) {
            this.vwr.selectBonds(bS);
            if (!Float.isNaN(f)) {
                scriptEval.setShapeSizeBs(1, Math.round(f * 2000.0f), null);
            }
            this.finalizeObject(1, nArray[0], f2, 0, false, null, 0, bS);
            this.vwr.selectBonds(null);
        }
        if (bl8) {
            scriptEval.report(GT.o(GT.$("{0} new bonds; {1} modified"), new Object[]{n9, n13}), false);
        }
    }

    private void console() throws ScriptException {
        switch (this.getToken((int)1).tok) {
            case 1073742334: {
                if (this.chk) break;
                this.vwr.showConsole(false);
                break;
            }
            case 1073742335: {
                if (this.chk) break;
                this.vwr.showConsole(true);
                break;
            }
            case 1073741882: {
                if (this.chk) break;
                this.vwr.sm.clearConsole();
                break;
            }
            case 134221856: {
                this.showString(this.stringParameter(2));
                break;
            }
            default: {
                this.invArg();
            }
        }
    }

    private void data() throws ScriptException {
        int n;
        boolean bl;
        ScriptEval scriptEval = this.e;
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        scriptEval.iToken = this.slen;
        switch (scriptEval.iToken) {
            case 5: {
                string = this.paramAsStr(2);
            }
            case 2: 
            case 4: {
                string2 = this.paramAsStr(1);
                if (string2.equalsIgnoreCase("clear")) {
                    if (!this.chk) {
                        this.vwr.setData(null, null, 0, 0, 0, 0, 0);
                    }
                    return;
                }
                int n2 = string2.indexOf("@");
                if (n2 >= 0) {
                    string = "" + scriptEval.getParameter(string2.substring(n2 + 1), 4, true);
                    string2 = string2.substring(0, n2).trim();
                    break;
                }
                if (string != null || (n2 = string2.indexOf(" ")) < 0) break;
                string = string2.substring(n2 + 1).trim();
                string2 = string2.substring(0, n2).trim();
                bl2 = true;
                break;
            }
            default: {
                scriptEval.bad();
            }
        }
        String string3 = string2.substring(0, (String.valueOf(string2) + " ").indexOf(" ")).toLowerCase();
        if (string3.equals("model") || string3.equals("append")) {
            scriptEval.cmdLoad();
            return;
        }
        if (this.chk) {
            return;
        }
        boolean bl3 = bl = string2.toLowerCase().indexOf("(default)") >= 0;
        if (string3.equals("connect_atoms")) {
            this.vwr.ms.connect((float[][])this.parseDataArray(string, false));
            return;
        }
        if (string3.indexOf("ligand_") == 0) {
            this.vwr.setLigandModel(String.valueOf(string2.substring(7).toUpperCase()) + "_data", string.trim());
            return;
        }
        if (string3.indexOf("file_") == 0) {
            this.vwr.setLigandModel(String.valueOf(string2.substring(5)) + "_file", string.trim());
            return;
        }
        Object[] objectArray = new Object[4];
        if (string3.equals("element_vdw")) {
            objectArray[0] = string3;
            objectArray[1] = string.replace(';', '\n');
            int n3 = Elements.elementNumberMax;
            int[] nArray = new int[n3 + 1];
            int n4 = 1;
            while (n4 <= n3) {
                nArray[n4] = n4;
                ++n4;
            }
            objectArray[2] = nArray;
            objectArray[3] = 0;
            this.vwr.setData("element_vdw", objectArray, n3, 0, 0, 0, 0);
            return;
        }
        if (string3.indexOf("data2d_") == 0) {
            objectArray[0] = string2;
            objectArray[1] = this.parseDataArray(string, false);
            objectArray[3] = 2;
            this.vwr.setData(string2, objectArray, 0, 0, 0, 0, 0);
            return;
        }
        if (string3.indexOf("data3d_") == 0) {
            objectArray[0] = string2;
            objectArray[1] = this.parseDataArray(string, true);
            objectArray[3] = 3;
            this.vwr.setData(string2, objectArray, 0, 0, 0, 0, 0);
            return;
        }
        String[] stringArray = PT.getTokens(string2);
        if (!(string3.indexOf("property_") != 0 || stringArray.length == 2 && stringArray[1].equals("set"))) {
            int n5;
            BS bS = this.vwr.bsA();
            objectArray[0] = string3;
            int n6 = bl2 ? 0 : (Integer)this.vwr.getP("propertyAtomNumberField");
            int n7 = bl2 ? 0 : (Integer)this.vwr.getP("propertyAtomNumberColumnCount");
            int n8 = bl2 ? Integer.MIN_VALUE : (Integer)this.vwr.getP("propertyDataField");
            int n9 = n5 = bl2 ? 0 : (Integer)this.vwr.getP("propertyDataColumnCount");
            if (!bl2 && string2.indexOf(" ") >= 0) {
                if (stringArray.length == 3) {
                    string2 = stringArray[0];
                    n6 = PT.parseInt(stringArray[1]);
                    n8 = PT.parseInt(stringArray[2]);
                }
                if (stringArray.length == 5) {
                    string2 = stringArray[0];
                    n6 = PT.parseInt(stringArray[1]);
                    n7 = PT.parseInt(stringArray[2]);
                    n8 = PT.parseInt(stringArray[3]);
                    n5 = PT.parseInt(stringArray[4]);
                }
            }
            if (n6 < 0) {
                n6 = 0;
            }
            if (n8 < 0) {
                n8 = 0;
            }
            int n10 = this.vwr.ms.ac;
            int[] nArray = null;
            BS bS2 = BS.newN(n10);
            if (n6 > 0) {
                nArray = new int[n10 + 2];
                int n11 = 0;
                while (n11 <= n10) {
                    nArray[n11] = -1;
                    ++n11;
                }
                n11 = bS.nextSetBit(0);
                while (n11 >= 0) {
                    int n12 = this.vwr.ms.at[n11].getAtomNumber();
                    if (n12 <= n10 + 1 && n12 >= 0 && !bS2.get(n12)) {
                        bS2.set(n12);
                        nArray[n12] = n11;
                    }
                    n11 = bS.nextSetBit(n11 + 1);
                }
                objectArray[2] = nArray;
            } else {
                objectArray[2] = BSUtil.copy(bS);
            }
            objectArray[1] = string;
            objectArray[3] = 0;
            this.vwr.setData(string3, objectArray, n10, n6, n7, n8, n5);
            return;
        }
        if ("occupany".equals(string3)) {
            string3 = "occupancy";
        }
        if ((n = AtomCollection.getUserSettableType(string3)) > -1) {
            this.vwr.setAtomData(n, string3, string, bl);
            return;
        }
        objectArray[0] = string2;
        objectArray[1] = string;
        objectArray[3] = 0;
        this.vwr.setData(string3, objectArray, 0, 0, 0, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ellipsoid() throws ScriptException {
        ScriptEval scriptEval = this.e;
        int n = 0;
        int n2 = 1;
        float f = Float.MAX_VALUE;
        boolean bl = false;
        boolean bl2 = false;
        this.setShapeProperty(20, "thisID", null);
        switch (this.getToken((int)1).tok) {
            case 1073742335: {
                n = Integer.MAX_VALUE;
                break;
            }
            case 1073742334: {
                break;
            }
            case 2: {
                n = this.intParameter(1);
                break;
            }
            case 36867: {
                this.e.sm.loadShape(20);
                this.setShapeProperty(20, "select", this.paramAsStr(2));
                n2 = scriptEval.iToken;
                bl = true;
                bl2 = true;
                break;
            }
            case 0x100000B1: 
            case 0x40000000: 
            case 1073741974: {
                this.e.sm.loadShape(20);
                if (scriptEval.theTok == 1073741974) {
                    ++n2;
                }
                this.setShapeId(20, n2, false);
                n2 = scriptEval.iToken;
                bl = true;
                break;
            }
            default: {
                this.invArg();
            }
        }
        if (!bl) {
            scriptEval.setShapeSizeBs(20, n, null);
            return;
        }
        int[] nArray = new int[]{Integer.MIN_VALUE};
        block22: while (++n2 < this.slen) {
            String string = this.paramAsStr(n2);
            Object[] objectArray = null;
            this.getToken(n2);
            if (!bl2) {
                block7 : switch (scriptEval.theTok) {
                    case 1073742330: {
                        string = "points";
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = scriptEval.objectNameParameter(++n2);
                        if (this.chk) continue block22;
                        scriptEval.getShapePropertyData(24, "getVertices", objectArray2);
                        objectArray = objectArray2;
                        break;
                    }
                    case 1611272194: {
                        V3[] v3Array = new V3[3];
                        int n3 = 0;
                        while (true) {
                            if (n3 >= 3) {
                                objectArray = v3Array;
                                break block7;
                            }
                            v3Array[n3] = new V3();
                            v3Array[n3].setT(this.centerParameter(++n2));
                            n2 = scriptEval.iToken;
                            ++n3;
                        }
                    }
                    case 12289: {
                        objectArray = this.centerParameter(++n2);
                        n2 = scriptEval.iToken;
                        break;
                    }
                    case 1094713359: {
                        objectArray = this.intParameter(++n2);
                        break;
                    }
                    case 12291: {
                        objectArray = Boolean.TRUE;
                        this.checkLength(n2 + 1);
                    }
                }
            }
            if (objectArray == null) {
                switch (scriptEval.theTok) {
                    case 1073742335: {
                        string = "on";
                        objectArray = Boolean.TRUE;
                        break;
                    }
                    case 1073742334: {
                        string = "on";
                        objectArray = Boolean.FALSE;
                        break;
                    }
                    case 1073742138: {
                        objectArray = Float.valueOf(this.floatParameter(++n2));
                        break;
                    }
                    case 10: 
                    case 12290: 
                    case 1073742325: {
                        string = "atoms";
                        objectArray = this.atomExpressionAt(n2);
                        n2 = scriptEval.iToken;
                        break;
                    }
                    case 603979967: 
                    case 1073742074: 
                    case 1765808134: {
                        f = this.getColorTrans(scriptEval, n2, true, nArray);
                        n2 = scriptEval.iToken;
                        continue block22;
                    }
                    case 1073742075: {
                        objectArray = this.paramAsStr(++n2);
                        break;
                    }
                }
            }
            if (objectArray == null) {
                this.invArg();
            }
            this.setShapeProperty(20, string.toLowerCase(), objectArray);
        }
        this.finalizeObject(20, nArray[0], f, 0, false, null, 0, null);
        this.setShapeProperty(20, "thisID", null);
    }

    private void image() throws ScriptException {
        if (!this.chk) {
            this.vwr.getConsole();
        }
        int n = 1;
        String string = null;
        if (this.tokAt(1) == 1073741974) {
            string = this.e.optParameterAsString(++n);
            ++n;
        }
        String string2 = this.e.optParameterAsString(n);
        boolean bl = this.e.optParameterAsString(this.slen - 1).equalsIgnoreCase("close");
        if (!(bl || this.slen != n && this.slen != n + 2)) {
            int n2 = this.slen == n + 2 ? this.intParameter(n++) : -1;
            int n3 = n2 < 0 ? -1 : this.intParameter(n);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("fileName", "\u0001\u0001" + string);
            hashtable.put("backgroundColor", this.vwr.getBackgroundArgb());
            hashtable.put("type", "png");
            hashtable.put("quality", -1);
            hashtable.put("width", n2);
            hashtable.put("height", n3);
            if (!this.chk) {
                this.vwr.processWriteOrCapture(hashtable);
            }
            return;
        }
        ++n;
        if (bl) {
            switch (this.slen) {
                case 2: {
                    string2 = "closeall";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    this.checkLength(0);
                }
            }
        }
        if (!this.chk) {
            this.vwr.fm.loadImage(bl ? "\u0001close" : string2, "\u0001" + string2 + "\u0001" + ("".equals(string) || string == null ? null : string), false);
        }
    }

    private void invertSelected() throws ScriptException {
        ScriptEval scriptEval = this.e;
        P3 p3 = null;
        P4 p4 = null;
        BS bS = null;
        int n = Integer.MIN_VALUE;
        int n2 = 1;
        switch (this.tokAt(1)) {
            case 0: {
                if (this.chk) {
                    return;
                }
                bS = this.vwr.bsA();
                p3 = this.vwr.ms.getAtomSetCenter(bS);
                this.vwr.invertAtomCoordPt(p3, bS);
                return;
            }
            case 528443: 
            case 0x44000001: {
                ++n2;
            }
            case 10: 
            case 12290: 
            case 1073742325: {
                bS = this.atomExpressionAt(n2);
                if (!scriptEval.isAtomExpression(scriptEval.iToken + 1)) {
                    scriptEval.checkLengthErrorPt(scriptEval.iToken + 1, scriptEval.iToken + 1);
                    if (!this.chk) {
                        int n3 = bS.nextSetBit(0);
                        while (n3 >= 0) {
                            this.vwr.invertRingAt(n3, false);
                            n3 = bS.nextSetBit(n3 + 1);
                        }
                    }
                    return;
                }
                n = bS.nextSetBit(0);
                bS = this.atomExpressionAt(scriptEval.iToken + 1);
                break;
            }
            case 134217751: {
                p3 = scriptEval.centerParameter(2, null);
                break;
            }
            case 134217750: {
                p4 = scriptEval.planeParameter(1);
                break;
            }
            case 134219265: {
                p4 = scriptEval.hklParameter(2);
            }
        }
        scriptEval.checkLengthErrorPt(scriptEval.iToken + 1, 1);
        if (p4 == null && p3 == null && n == Integer.MIN_VALUE) {
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        if (n == -1) {
            return;
        }
        this.vwr.invertSelected(p3, p4, n, bS);
    }

    private void mapProperty() throws ScriptException {
        block23: {
            int n;
            Object object;
            Object[] objectArray;
            Object object2;
            String string;
            String string2;
            String string3;
            BS bS;
            BS bS2;
            ScriptEval scriptEval;
            int n2;
            int n3;
            int n4;
            block22: {
                block21: {
                    n4 = 0;
                    n3 = 0;
                    n2 = 0;
                    scriptEval = this.e;
                    if (this.tokAt(1) != 1113589787) break block21;
                    bS2 = this.vwr.bsA();
                    bS = this.atomExpressionAt(2);
                    string3 = "selected";
                    string2 = "selected";
                    break block22;
                }
                bS2 = this.atomExpressionAt(1);
                if (this.tokAt(++scriptEval.iToken) != 0x40000200 || !T.tokAttr(n4 = this.tokAt(++scriptEval.iToken), 0x40400000)) break block23;
                string2 = this.paramAsStr(scriptEval.iToken);
                bS = this.atomExpressionAt(++scriptEval.iToken);
                if (this.tokAt(++scriptEval.iToken) != 0x40000200 || !T.tokAttr(n3 = this.tokAt(++scriptEval.iToken), 2048)) break block23;
                string3 = this.paramAsStr(scriptEval.iToken);
            }
            n2 = this.tokAt(scriptEval.iToken + 1);
            if (T.tokAttr(n2, 0x40400000)) {
                string = this.paramAsStr(++scriptEval.iToken);
            } else {
                n2 = 1094715393;
                string = T.nameOf(1094715393);
            }
            scriptEval.checkLast(scriptEval.iToken);
            if (this.chk) {
                return;
            }
            BS bS3 = null;
            this.showString("mapping " + string2.toUpperCase() + " for " + bS2.cardinality() + " atoms to " + string3.toUpperCase() + " for " + bS.cardinality() + " atoms using " + string.toUpperCase());
            if (T.tokAttrOr(n4, 0x41400000, 0x42400000) && T.tokAttrOr(n3, 0x41400000, 0x42400000) && T.tokAttrOr(n2, 0x41400000, 0x42400000)) {
                object2 = this.getBitsetPropertyFloat(bS2, n4 | 0xE0, null, Float.NaN, Float.NaN);
                objectArray = this.getBitsetPropertyFloat(bS2, n2 | 0xE0, null, Float.NaN, Float.NaN);
                object = this.getBitsetPropertyFloat(bS, n2 | 0xE0, null, Float.NaN, Float.NaN);
                n = n3 == 1715472409 ? 1 : 0;
                float[] fArray = new float[n != 0 ? this.vwr.ms.ac : ((Object)object).length];
                bS3 = new BS();
                if (((float[])object2).length == objectArray.length) {
                    Hashtable<Float, Float> hashtable = new Hashtable<Float, Float>();
                    int n5 = 0;
                    while (n5 < ((float[])object2).length) {
                        hashtable.put(Float.valueOf(objectArray[n5]), Float.valueOf(object2[n5]));
                        ++n5;
                    }
                    n5 = -1;
                    int n6 = 0;
                    int n7 = 0;
                    while (n7 < ((Object)object).length) {
                        n5 = bS.nextSetBit(n5 + 1);
                        Float f = (Float)hashtable.get(Float.valueOf((float)object[n7]));
                        if (f != null) {
                            bS3.set(n5);
                            fArray[n != 0 ? n5 : n6] = f.floatValue();
                            ++n6;
                        }
                        ++n7;
                    }
                    if (n != 0) {
                        this.vwr.setData(string3, new Object[]{string3, fArray, bS3, 1, Boolean.TRUE}, this.vwr.ms.ac, 0, 0, Integer.MAX_VALUE, 0);
                    } else if (!T.tokAttr(n3, 2048)) {
                        this.error(56);
                    } else {
                        this.vwr.setAtomProperty(bS3, n3, 0, 0.0f, null, fArray, null);
                    }
                }
            }
            if (bS3 == null) {
                object2 = "{" + string + "=%[" + string + "]}." + string3 + " = %[" + string2 + "]";
                objectArray = (String[])this.getBitsetIdent(bS2, (String)object2, null, false, Integer.MAX_VALUE, false);
                object = new SB();
                n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n].indexOf("null") < 0) {
                        ((SB)object).append((String)objectArray[n]).appendC('\n');
                    }
                    ++n;
                }
                if (Logger.debugging) {
                    Logger.debug(((SB)object).toString());
                }
                BS bS4 = BSUtil.copy(this.vwr.slm.bsSubset);
                this.vwr.slm.setSelectionSubset(bS);
                try {
                    scriptEval.runScript(((SB)object).toString());
                }
                catch (Exception exception) {
                    this.vwr.slm.setSelectionSubset(bS4);
                    scriptEval.errorStr(-1, "Error: " + exception.getMessage());
                }
                catch (Error error) {
                    this.vwr.slm.setSelectionSubset(bS4);
                    scriptEval.errorStr(-1, "Error: " + error.toString());
                }
                this.vwr.slm.setSelectionSubset(bS4);
            }
            this.showString("DONE");
            return;
        }
        this.invArg();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void minimize() throws ScriptException {
        BS bS = null;
        int n = Integer.MAX_VALUE;
        float f = 0.0f;
        boolean bl = false;
        boolean bl2 = false;
        BS bS2 = null;
        boolean bl3 = false;
        Minimizer minimizer = this.vwr.getMinimizer(false);
        int n2 = 1;
        while (n2 < this.slen) {
            switch (this.getToken((int)n2).tok) {
                case 0x40000004: {
                    bl = true;
                    break;
                }
                case 1073741874: 
                case 1073742162: {
                    this.checkLength(2);
                    if (this.chk) return;
                    if (minimizer == null) {
                        return;
                    }
                    minimizer.setProperty(this.paramAsStr(n2), null);
                    return;
                }
                case 1073741882: {
                    this.checkLength(2);
                    if (this.chk) return;
                    if (minimizer == null) {
                        return;
                    }
                    minimizer.setProperty("clear", null);
                    return;
                }
                case 0x40000046: {
                    if (n2 != 1) {
                        this.invArg();
                    }
                    int n3 = 0;
                    float f2 = 0.0f;
                    int[] nArray = new int[5];
                    if (this.tokAt(++n2) == 1073741882) {
                        this.checkLength(3);
                    } else {
                        while (true) {
                            if (n3 >= 4 || this.isFloatParameter(n2)) {
                                nArray[0] = n3;
                                if (n3 == 1) {
                                    this.invArg();
                                }
                                f2 = this.floatParameter(this.e.checkLast(n2));
                                break;
                            }
                            nArray[++n3] = this.atomExpressionAt(n2).nextSetBit(0);
                            n2 = this.e.iToken + 1;
                        }
                    }
                    if (this.chk) return;
                    this.vwr.getMinimizer(true).setProperty("constraint", new Object[]{nArray, new int[n3], Float.valueOf(f2)});
                    return;
                }
                case 1073741905: {
                    f = this.floatParameter(++n2);
                    break;
                }
                case 1073741935: {
                    n = 0;
                    break;
                }
                case 12293: {
                    if (n2 != 1) {
                        this.invArg();
                    }
                    if ((bS2 = this.atomExpressionAt(++n2)).nextSetBit(0) < 0) {
                        bS2 = null;
                    }
                    n2 = this.e.iToken;
                    if (!this.chk) {
                        this.vwr.getMinimizer(true).setProperty("fixed", bS2);
                    }
                    if (n2 + 1 != this.slen) break;
                    return;
                }
                case 10: 
                case 1073742325: {
                    bl3 = true;
                }
                case 1275082245: {
                    if (this.e.theTok == 1275082245) {
                        ++n2;
                    }
                    bS = this.atomExpressionAt(n2);
                    n2 = this.e.iToken;
                    if (this.tokAt(n2 + 1) != 1073742072) break;
                    ++n2;
                    bl3 = true;
                    break;
                }
                case 0x40000144: {
                    bl2 = true;
                    break;
                }
                case 266298: {
                    n = this.intParameter(++n2);
                    break;
                }
                default: {
                    this.invArg();
                }
            }
            ++n2;
        }
        if (this.chk) return;
        try {
            this.vwr.minimize(this.e, n, f, bS, bS2, 0.0f, bl, bl3, bl2, false);
            return;
        }
        catch (Exception exception) {
            throw new ScriptInterruption(this.e, "minimize", 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void modulation() throws ScriptException {
        var1_1 = null;
        var2_2 = this.e;
        var3_3 = true;
        var4_4 = false;
        var5_5 = null;
        var6_6 = 1;
        switch (this.getToken((int)var6_6).tok) {
            case 1073742334: {
                var3_3 = false;
            }
            case 0: 
            case 1073742335: {
                break;
            }
            case 10: 
            case 12290: 
            case 1073742325: {
                var5_5 = this.atomExpressionAt(1);
                switch (this.tokAt(var2_2.iToken + 1)) {
                    case 0: {
                        break;
                    }
                    case 1073742334: {
                        var3_3 = false;
                    }
                    case 1073742335: {
                        var2_2.iToken = var2_2.iToken + 1;
                    }
                }
                var2_2.checkLast(var2_2.iToken);
                break;
            }
            case 8: 
            case 1073742332: {
                var1_1 = var2_2.getPoint3f(1, false, true);
                var4_4 = this.tokAt(var2_2.iToken + 1) == 1073742335;
                break;
            }
            default: {
                var7_7 = var2_2.theToken.value.toString();
                ++var6_6;
                if (!var7_7.equalsIgnoreCase("t")) ** GOTO lbl34
                var2_2.theTok = 3;
                ** GOTO lbl38
lbl34:
                // 1 sources

                if (var7_7.equalsIgnoreCase("m") || var7_7.equalsIgnoreCase("q")) {
                    var2_2.theTok = 2;
                } else {
                    this.invArg();
                }
            }
lbl38:
            // 4 sources

            case 2: 
            case 3: {
                switch (var2_2.theTok) {
                    case 3: {
                        if (this.isFloatParameter(var6_6)) {
                            var8_8 = this.floatParameter(var6_6);
                            var1_1 = P3.new3(var8_8, var8_8, var8_8);
                            break;
                        }
                        var1_1 = var2_2.getPoint3f(var6_6, false, true);
                        break;
                    }
                    case 2: {
                        if (this.tokAt(var6_6) == 2) {
                            var8_9 = this.intParameter(var6_6);
                            var1_1 = P3.new3(var8_9, var8_9, var8_9);
                        } else {
                            var1_1 = var2_2.getPoint3f(var6_6, false, true);
                        }
                        var4_4 = true;
                    }
                }
                break;
            }
            case 1073742138: {
                var8_10 = this.floatParameter(2);
                if (!this.chk) {
                    this.vwr.setFloatProperty("modulationScale", var8_10);
                }
                return;
            }
        }
        if (!this.chk) {
            this.vwr.tm.setVibrationPeriod(0.0f);
            this.vwr.setModulation(var5_5, var3_3, var1_1, var4_4);
        }
    }

    private void mutate() throws ScriptException {
        int n;
        BS bS;
        switch (this.tokAt(1)) {
            case 2: {
                this.st[1] = T.o(4, "" + this.st[1].value);
            }
            default: {
                bS = this.atomExpressionAt(1);
                n = ++this.e.iToken;
                break;
            }
            case 0x100000B1: {
                bS = this.vwr.getAllAtoms();
                n = 2;
            }
        }
        bS.and(this.vwr.getModelUndeletedAtomsBitSet(this.vwr.ms.mc - 1));
        int n2 = bS.length() - 1;
        short s = 0;
        if (n2 < 0 || (s = this.vwr.ms.at[n2].mi) != this.vwr.ms.mc - 1 || this.vwr.ms.isTrajectory(s)) {
            return;
        }
        String string = this.e.optParameterAsString(n);
        this.e.checkLast(n);
        if (this.chk || !this.vwr.ms.am[s].isBioModel) {
            return;
        }
        boolean bl = this.tokAt(n) == 4 && !string.startsWith("~");
        String[] stringArray = null;
        if (bl) {
            stringArray = new String[]{string};
            string = null;
        } else {
            boolean bl2 = (string = PT.replaceAllCharacters(string, ",; \t\n", " ").trim().toUpperCase()).startsWith("~");
            if (bl2 || string.length() != 3 || !this.vwr.getJBR().isKnownPDBGroup(string, 20)) {
                string = this.vwr.getJBR().toStdAmino3(bl2 ? string.substring(1) : string);
            }
            stringArray = PT.getTokens(string);
        }
        if (stringArray.length > 0) {
            this.vwr.ms.bioModelset.mutate(bS, string, stringArray);
        }
    }

    private void navigate() throws ScriptException {
        ScriptEval scriptEval = this.e;
        if (this.slen == 1) {
            scriptEval.setBooleanProperty("navigationMode", true);
            return;
        }
        V3 v3 = V3.new3(0.0f, 1.0f, 0.0f);
        Lst<Object[]> lst = new Lst<Object[]>();
        if (this.slen == 2) {
            switch (this.getToken((int)1).tok) {
                case 1073742334: 
                case 1073742335: {
                    if (this.chk) {
                        return;
                    }
                    scriptEval.setObjectMad10(34, "axes", 10);
                    this.setShapeProperty(34, "position", P3.new3(50.0f, 50.0f, Float.MAX_VALUE));
                    scriptEval.setBooleanProperty("navigationMode", true);
                    this.vwr.tm.setNavOn(scriptEval.theTok == 1073742335);
                    return;
                }
                case 1073742162: {
                    if (!this.chk) {
                        this.vwr.tm.setNavXYZ(0.0f, 0.0f, 0.0f);
                    }
                    return;
                }
                case 8: 
                case 1112152078: {
                    break;
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (!this.chk && !this.vwr.getBoolean(603979889)) {
            scriptEval.setBooleanProperty("navigationMode", true);
        }
        int n = 1;
        while (n < this.slen) {
            float f;
            float f2 = f = this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f;
            if (f < 0.0f) {
                this.invArg();
            }
            if (!this.chk && f > 0.0f) {
                scriptEval.refresh(false);
            }
            block5 : switch (this.getToken((int)n).tok) {
                case 8: 
                case 1073742332: {
                    P3 p3 = this.getPoint3f(n, true);
                    scriptEval.iToken = scriptEval.iToken + 1;
                    if (scriptEval.iToken != this.slen) {
                        this.invArg();
                    }
                    if (!this.chk) {
                        this.vwr.tm.setNavXYZ(p3.x, p3.y, p3.z);
                    }
                    return;
                }
                case 554176526: {
                    float f3 = this.floatParameter(++n);
                    if (this.chk) break;
                    lst.addLast(new Object[]{554176526, Float.valueOf(f), Float.valueOf(f3)});
                    break;
                }
                case 12289: {
                    P3 p3 = this.centerParameter(++n);
                    n = scriptEval.iToken;
                    if (this.chk) break;
                    lst.addLast(new Object[]{134217751, Float.valueOf(f), p3});
                    break;
                }
                case 528432: {
                    switch (this.getToken((int)(++n)).tok) {
                        case 1111492629: {
                            v3.set(1.0f, 0.0f, 0.0f);
                            ++n;
                            break;
                        }
                        case 1111492630: {
                            v3.set(0.0f, 1.0f, 0.0f);
                            ++n;
                            break;
                        }
                        case 1111492631: {
                            v3.set(0.0f, 0.0f, 1.0f);
                            ++n;
                            break;
                        }
                        case 8: 
                        case 1073742332: {
                            v3.setT(this.getPoint3f(n, true));
                            n = scriptEval.iToken + 1;
                            break;
                        }
                        case 0x40000000: {
                            this.invArg();
                        }
                    }
                    float f4 = this.floatParameter(n);
                    if (this.chk) break;
                    lst.addLast(new Object[]{528432, Float.valueOf(f), v3, Float.valueOf(f4)});
                    break;
                }
                case 4160: {
                    P3 p3;
                    float f5 = Float.NaN;
                    float f6 = Float.NaN;
                    if (this.isFloatParameter(++n)) {
                        f5 = this.floatParameter(n);
                        f6 = this.floatParameter(++n);
                    } else {
                        switch (this.tokAt(n)) {
                            case 1111492629: {
                                f5 = this.floatParameter(++n);
                                break;
                            }
                            case 1111492630: {
                                f6 = this.floatParameter(++n);
                                break;
                            }
                            default: {
                                p3 = this.centerParameter(n);
                                n = scriptEval.iToken;
                                if (this.chk) break block5;
                                lst.addLast(new Object[]{4160, Float.valueOf(f), p3});
                                break block5;
                            }
                        }
                    }
                    if (this.chk) break;
                    lst.addLast(new Object[]{268435634, Float.valueOf(f), Float.valueOf(f5), Float.valueOf(f6)});
                    break;
                }
                case 0x100000B0: {
                    break;
                }
                case 1112152078: {
                    BS bS;
                    Lst<P3[]> lst2 = new Lst<P3[]>();
                    if (scriptEval.isAtomExpression(n + 1)) {
                        bS = this.atomExpressionAt(++n);
                        n = scriptEval.iToken;
                    } else {
                        bS = this.vwr.bsA();
                    }
                    if (this.chk) {
                        return;
                    }
                    this.vwr.getPolymerPointsAndVectors(bS, lst2);
                    int n2 = lst2.size();
                    if (n2 <= 0) break;
                    P3[][] p3ArrayArray = new P3[n2][];
                    int n3 = 0;
                    while (n3 < n2) {
                        p3ArrayArray[n3] = (P3[])lst2.get(n3);
                        ++n3;
                    }
                    lst.addLast(new Object[]{1112152078, Float.valueOf(f), p3ArrayArray});
                    break;
                }
                case 0x40000104: {
                    Object object;
                    Object var16_18 = null;
                    if (this.getToken((int)(n + 1)).tok == 1073742330) {
                        ++n;
                        object = scriptEval.objectNameParameter(++n);
                        if (this.chk) {
                            return;
                        }
                        this.setShapeProperty(22, "thisID", object);
                        P3[] p3Array = (P3[])this.getShapeProperty(22, "vertices");
                        scriptEval.refresh(false);
                        if (p3Array == null) {
                            this.invArg();
                        }
                        int n4 = (int)(this.isFloatParameter(n + 1) ? this.floatParameter(++n) : 0.0f);
                        int n5 = (int)(this.isFloatParameter(n + 1) ? this.floatParameter(++n) : 2.1474836E9f);
                        lst.addLast(new Object[]{0x40000104, Float.valueOf(f), p3Array, var16_18, new int[]{n4, n5}});
                        break;
                    }
                    object = new Lst();
                    while (scriptEval.isCenterParameter(n + 1)) {
                        ((Lst)object).addLast(this.centerParameter(++n));
                        n = scriptEval.iToken;
                    }
                    if (((ArrayList)object).size() > 0) {
                        P3[] p3Array = ((ArrayList)object).toArray(new P3[((ArrayList)object).size()]);
                        if (this.chk) break;
                        Object[] objectArray = new Object[5];
                        objectArray[0] = 0x40000104;
                        objectArray[1] = Float.valueOf(f);
                        objectArray[2] = p3Array;
                        objectArray[3] = var16_18;
                        int[] nArray = new int[2];
                        nArray[1] = Integer.MAX_VALUE;
                        objectArray[4] = nArray;
                        lst.addLast(objectArray);
                        break;
                    }
                }
                default: {
                    this.invArg();
                }
            }
            ++n;
        }
        if (!this.chk && !this.vwr.isJmolDataFrame()) {
            this.vwr.tm.navigateList(scriptEval, lst);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String plot(T[] var1_1) throws ScriptException {
        var2_2 = this.e;
        var3_3 = this.vwr.am.cmi;
        if (var3_3 < 0) {
            var2_2.errorStr(30, "plot");
        }
        var3_3 = this.vwr.ms.getJmolDataSourceFrame(var3_3);
        var4_4 = var1_1.length - 1;
        var5_5 = var1_1 != this.st;
        var6_6 = true;
        var7_7 = this.st;
        if (var5_5) {
            this.st = var1_1;
            var2_2.st = var1_1;
        }
        var8_8 = var5_5 != false ? 134222350 : var1_1[0].tok;
        var9_9 = var5_5 != false || var8_8 == 134221850 || var8_8 == 4138 ? 0 : 1;
        var10_10 = null;
        var11_11 = true;
        var12_12 = false;
        switch (var8_8) {
            case 4133: 
            case 4138: 
            case 134221850: {
                break;
            }
            case 135176: {
                var11_11 = false;
                var12_12 = true;
                break;
            }
            case 134222350: {
                var11_11 = false;
                var6_6 = false;
                break;
            }
            case 134221856: {
                var11_11 = false;
                if (CmdExt.tokAtArray(var4_4, var1_1) == 4) {
                    var10_10 = this.stringParameter(var4_4--);
                } else if (CmdExt.tokAtArray(var4_4 - 1, var1_1) == 0x40000200) {
                    var10_10 = String.valueOf(this.paramAsStr(var4_4 - 2)) + "." + this.paramAsStr(var4_4);
                    var4_4 -= 3;
                } else {
                    this.st = var7_7;
                    var2_2.st = var7_7;
                    var2_2.iToken = this.st.length;
                    this.error(13);
                }
                var2_2.slen = this.slen = var4_4 + 1;
            }
        }
        var13_13 = "";
        var14_14 = null;
        var15_15 = "";
        var16_16 = false;
        var17_17 = false;
        var18_18 = false;
        var19_19 = false;
        var20_20 = new String[3];
        var21_21 = new int[3];
        var22_22 = BSUtil.copy(this.vwr.bsA());
        var23_23 = "; select " + Escape.eBS(var22_22) + ";\n ";
        var24_24 = var2_2.optParameterAsString(var4_4).toLowerCase();
        var25_25 = null;
        var26_26 = null;
        var27_27 = null;
        var28_28 = CmdExt.tokAtArray(var9_9, var1_1);
        if (var28_28 == 4) {
            var28_28 = T.getTokFromName((String)var1_1[var9_9].value);
        }
        switch (var28_28) {
            default: {
                var2_2.iToken = 1;
                this.invArg();
                break;
            }
            case 134221834: {
                var2_2.iToken = 1;
                var24_24 = "data";
                var23_23 = "";
                break;
            }
            case 1715472409: {
                var2_2.iToken = var9_9 + 1;
                var29_29 = 0;
                while (var29_29 < 3) {
                    switch (this.tokAt(var2_2.iToken)) {
                        case 4: {
                            var21_21[var29_29] = T.getTokFromName((String)var2_2.getToken((int)var2_2.iToken).value);
                            break;
                        }
                        default: {
                            var21_21[var29_29] = this.tokAt(var2_2.iToken);
                            break;
                        }
                        case 0: {
                            if (var29_29 == 0) {
                                this.invArg();
                            }
                        }
                        case 32: 
                        case 64: 
                        case 1287653388: {
                            var29_29 = 2;
                            ** GOTO lbl92
                        }
                    }
                    if (var21_21[var29_29] != 1715472409 && !T.tokAttr(var21_21[var29_29], 0x40400000)) {
                        this.invArg();
                    }
                    var20_20[var29_29] = this.getToken((int)var2_2.iToken).value.toString();
                    var2_2.iToken = var2_2.iToken + 1;
lbl92:
                    // 2 sources

                    ++var29_29;
                }
                if (this.tokAt(var2_2.iToken) == 1287653388) {
                    var27_27 = this.stringParameter(++var2_2.iToken);
                    var6_6 = false;
                    var2_2.iToken = var2_2.iToken + 1;
                }
                if (this.tokAt(var2_2.iToken) == 32) {
                    var25_25 = this.getPoint3f(++var2_2.iToken, false);
                    var2_2.iToken = var2_2.iToken + 1;
                }
                if (this.tokAt(var2_2.iToken) == 64) {
                    var26_26 = this.getPoint3f(++var2_2.iToken, false);
                    var2_2.iToken = var2_2.iToken + 1;
                }
                var24_24 = "property " + var20_20[0] + (var20_20[1] == null ? "" : " " + var20_20[1]) + (var20_20[2] == null ? "" : " " + var20_20[2]);
                if (var22_22.nextSetBit(0) < 0) {
                    var22_22 = this.vwr.getModelUndeletedAtomsBitSet(var3_3);
                }
                var15_15 = "select " + Escape.eBS(var22_22) + ";\n ";
                break;
            }
            case 4138: {
                if (var24_24.equalsIgnoreCase("draw")) {
                    var12_12 = true;
                    var24_24 = var2_2.optParameterAsString(--var4_4).toLowerCase();
                }
                var19_19 = var4_4 > var9_9 && var24_24.startsWith("r") != false;
                var24_24 = "ramachandran" + (var19_19 != false ? " r" : "") + (var8_8 == 135176 ? " draw" : "");
                break;
            }
            case 134221850: 
            case 136314895: {
                var13_13 = " \"" + this.vwr.getQuaternionFrame() + "\"";
                var15_15 = "set quaternionFrame" + var13_13 + ";\n  ";
                var16_16 = true;
                if (var24_24.equalsIgnoreCase("draw")) {
                    var12_12 = true;
                    var24_24 = var2_2.optParameterAsString(--var4_4).toLowerCase();
                }
                var17_17 = var24_24.startsWith("deriv") != false || var24_24.startsWith("diff") != false;
                v0 = var18_18 = var17_17 != false && var24_24.indexOf("2") > 0;
                if (var17_17) {
                    --var4_4;
                }
                if (var24_24.equalsIgnoreCase("helix") || var24_24.equalsIgnoreCase("axis")) {
                    var12_12 = true;
                    var17_17 = true;
                    var4_4 = -1;
                }
                if ((var24_24 = (String.valueOf(var4_4 <= var9_9 ? "" : var2_2.optParameterAsString(var4_4)) + "w").substring(0, 1)).equals("a") || var24_24.equals("r")) {
                    var17_17 = true;
                }
                if (!PT.isOneOf(var24_24, ";w;x;y;z;r;a;")) {
                    var2_2.evalError("QUATERNION [w,x,y,z,a,r] [difference][2]", null);
                }
                var24_24 = "quaternion " + var24_24 + (var17_17 != false ? " difference" : "") + (var18_18 != false ? "2" : "") + (var12_12 != false ? " draw" : "");
            }
        }
        this.st = var7_7;
        if (this.chk) {
            return "";
        }
        if (var11_11 && (var29_29 = this.vwr.ms.getJmolDataFrameIndex(var3_3, var15_15 = String.valueOf(var15_15) + "plot " + var24_24)) > 0 && var8_8 != 134221856 && var8_8 != 134222350) {
            this.vwr.setCurrentModelIndexClear(var29_29, true);
            return "";
        }
        var29_30 = null;
        var30_31 = null;
        var31_32 = null;
        var32_33 = new String[3];
        if (var28_28 == 1715472409) {
            var29_30 = this.getBitsetPropertyFloat(var22_22, var21_21[0] | 224, var21_21[0] == 1715472409 ? var20_20[0] : null, var25_25 == null ? NaNf : var25_25.x, var26_26 == null ? NaNf : var26_26.x);
            var32_33[0] = String.valueOf(var20_20[0]) + " " + Escape.eAF(var29_30);
            if (var20_20[1] != null) {
                var30_31 = this.getBitsetPropertyFloat(var22_22, var21_21[1] | 224, var21_21[1] == 1715472409 ? var20_20[1] : null, var25_25 == null ? NaNf : var25_25.y, var26_26 == null ? NaNf : var26_26.y);
                var32_33[1] = String.valueOf(var20_20[1]) + " " + Escape.eAF(var30_31);
            }
            if (var20_20[2] != null) {
                var31_32 = this.getBitsetPropertyFloat(var22_22, var21_21[2] | 224, var21_21[2] == 1715472409 ? var20_20[2] : null, var25_25 == null ? NaNf : var25_25.z, var26_26 == null ? NaNf : var26_26.z);
                var32_33[2] = String.valueOf(var20_20[2]) + " " + Escape.eAF(var31_32);
            }
            if (var25_25 == null) {
                var25_25 = P3.new3(this.getPlotMinMax(var29_30, false, var21_21[0]), this.getPlotMinMax(var30_31, false, var21_21[1]), this.getPlotMinMax(var31_32, false, var21_21[2]));
            }
            if (var26_26 == null) {
                var26_26 = P3.new3(this.getPlotMinMax(var29_30, true, var21_21[0]), this.getPlotMinMax(var30_31, true, var21_21[1]), this.getPlotMinMax(var31_32, true, var21_21[2]));
            }
            Logger.info("plot min/max: " + var25_25 + " " + var26_26);
            var33_34 = null;
            var34_35 = null;
            if (var6_6) {
                var34_35 = P3.new3(1.0f, 1.0f, 1.0f);
                var33_34 = new P3();
                var33_34.ave(var26_26, var25_25);
                var34_35.sub2(var26_26, var25_25);
                var34_35.set(var34_35.x / 200.0f, var34_35.y / 200.0f, var34_35.z / 200.0f);
                if (T.tokAttr(var21_21[0], 0x41400000)) {
                    var34_35.x = 1.0f;
                    var33_34.x = 0.0f;
                } else if ((double)var34_35.x > 0.1 && var34_35.x <= 10.0f) {
                    var34_35.x = 1.0f;
                }
                if (T.tokAttr(var21_21[1], 0x41400000)) {
                    var34_35.y = 1.0f;
                    var33_34.y = 0.0f;
                } else if ((double)var34_35.y > 0.1 && var34_35.y <= 10.0f) {
                    var34_35.y = 1.0f;
                }
                if (T.tokAttr(var21_21[2], 0x41400000)) {
                    var34_35.z = 1.0f;
                    var33_34.z = 0.0f;
                } else if ((double)var34_35.z > 0.1 && var34_35.z <= 10.0f) {
                    var34_35.z = 1.0f;
                }
                if (var20_20[2] == null || var20_20[1] == null) {
                    var34_35.z = 0.0f;
                    var26_26.z = 0.0f;
                    var25_25.z = 0.0f;
                    var33_34.z = 0.0f;
                }
                var35_36 = 0;
                while (var35_36 < var29_30.length) {
                    var29_30[var35_36] = (var29_30[var35_36] - var33_34.x) / var34_35.x;
                    ++var35_36;
                }
                if (var20_20[1] != null) {
                    var35_36 = 0;
                    while (var35_36 < var30_31.length) {
                        var30_31[var35_36] = (var30_31[var35_36] - var33_34.y) / var34_35.y;
                        ++var35_36;
                    }
                }
                if (var20_20[2] != null) {
                    var35_36 = 0;
                    while (var35_36 < var31_32.length) {
                        var31_32[var35_36] = (var31_32[var35_36] - var33_34.z) / var34_35.z;
                        ++var35_36;
                    }
                }
            }
            var14_14 = new Object[]{var22_22, var29_30, var30_31, var31_32, var25_25, var26_26, var34_35, var33_34, var27_27, var32_33};
        }
        if (var8_8 == 134221856) {
            return this.vwr.writeFileData(var10_10, "PLOT_" + var24_24, var3_3, var14_14);
        }
        v1 = var33_34 = var24_24.equals("data") != false ? "1 0 H 0 0 0 # Jmol PDB-encoded data" : this.vwr.getPdbData(var3_3, var24_24, null, var14_14, null, true);
        if (var8_8 == 134222350) {
            return var33_34;
        }
        if (Logger.debugging) {
            Logger.debug((String)var33_34);
        }
        if (var8_8 == 135176) {
            var2_2.runScript((String)var33_34);
            return "";
        }
        var34_35 = this.vwr.fm.getFileInfo();
        var35_36 = this.vwr.getBoolean(603979792);
        this.vwr.g.appendNew = true;
        var36_37 = var33_34 != null && this.vwr.openStringInlineParamsAppend((String)var33_34, null, true) == null;
        this.vwr.g.appendNew = var35_36;
        this.vwr.fm.setFileInfo((String[])var34_35);
        if (!var36_37) {
            return "";
        }
        var37_38 = this.vwr.ms.mc;
        this.vwr.ms.setJmolDataFrame(var15_15, var3_3, var37_38 - 1);
        if (var28_28 != 1715472409) {
            var15_15 = String.valueOf(var15_15) + ";\n" + var23_23;
        }
        var38_39 = this.vwr.addStateScript(var15_15, true, false);
        var39_40 = 150.0f;
        switch (var28_28) {
            default: {
                var40_41 = "frame 0.0; frame last; reset;select visible;wireframe only;";
                var39_40 = 10.0f;
                break;
            }
            case 1715472409: {
                this.vwr.setFrameTitle(var37_38 - 1, String.valueOf(var24_24) + " plot for model " + this.vwr.getModelNumberDotted(var3_3));
                var40_41 = "frame 0.0; frame last; reset;select visible; spacefill 3.0; wireframe 0;draw plotAxisX" + var37_38 + " {100 -100 -100} {-100 -100 -100} \"" + var20_20[0] + "\";" + "draw plotAxisY" + var37_38 + " {-100 100 -100} {-100 -100 -100} \"" + var20_20[1] + "\";";
                if (var20_20[2] == null) break;
                var40_41 = String.valueOf(var40_41) + "draw plotAxisZ" + var37_38 + " {-100 -100 100} {-100 -100 -100} \"" + var20_20[2] + "\";";
                break;
            }
            case 4138: {
                this.vwr.setFrameTitle(var37_38 - 1, "ramachandran plot for model " + this.vwr.getModelNumberDotted(var3_3));
                var40_41 = "frame 0.0; frame last; reset;select visible; color structure; spacefill 3.0; wireframe 0;draw ramaAxisX" + var37_38 + " {100 0 0} {-100 0 0} \"phi\";" + "draw ramaAxisY" + var37_38 + " {0 100 0} {0 -100 0} \"psi\";";
                break;
            }
            case 134221850: 
            case 136314895: {
                this.vwr.setFrameTitle(var37_38 - 1, String.valueOf(var24_24.replace('w', ' ')) + var13_13 + " for model " + this.vwr.getModelNumberDotted(var3_3));
                var41_42 = C.getHexCode(this.vwr.cm.colixBackgroundContrast);
                var40_41 = "frame 0.0; frame last; reset;select visible; wireframe 0; spacefill 3.0; isosurface quatSphere" + var37_38 + " color " + var41_42 + " sphere 100.0 mesh nofill frontonly translucent 0.8;" + "draw quatAxis" + var37_38 + "X {100 0 0} {-100 0 0} color red \"x\";" + "draw quatAxis" + var37_38 + "Y {0 100 0} {0 -100 0} color green \"y\";" + "draw quatAxis" + var37_38 + "Z {0 0 100} {0 0 -100} color blue \"z\";" + "color structure;" + "draw quatCenter" + var37_38 + "{0 0 0} scale 0.02;";
            }
        }
        var2_2.runScript(String.valueOf(var40_41) + var23_23);
        var38_39.setModelIndex(this.vwr.am.cmi);
        this.vwr.setRotationRadius(var39_40, true);
        var2_2.sm.loadShape(31);
        this.showString("frame " + this.vwr.getModelNumberDotted(var37_38 - 1) + (var24_24.length() > 0 ? " created: " + var24_24 + (var16_16 != false ? var13_13 : "") : ""));
        return "";
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void polyhedra() throws ScriptException {
        var1_1 = this.e;
        var2_2 = this.slen == 1;
        var3_3 = false;
        var4_4 = var2_2;
        var5_5 = false;
        var6_6 = false;
        var7_7 = false;
        var8_8 = NaNf;
        var9_9 = 0;
        var1_1.sm.loadShape(21);
        this.setShapeProperty(21, "init", Boolean.TRUE);
        var10_10 = 3.4028235E38f;
        var11_11 = -1.0f;
        var12_12 = new int[]{-2147483648};
        var13_13 = -1;
        var14_14 = null;
        var15_15 = null;
        var16_16 = false;
        var17_17 = null;
        var18_18 = null;
        var19_19 = 1;
        while (var19_19 < this.slen) {
            block71: {
                var20_20 = null;
                var21_21 /* !! */  = null;
                switch (this.getToken((int)var19_19).tok) {
                    case 1073742197: {
                        var8_8 = NaNf;
                    }
                    case 0x40000030: {
                        v0 = this.e.theTok == 1073742197 ? -1 : (var22_22 = this.tokAt(var19_19 + 1) == 2 ? this.intParameter(++var19_19) : 1);
                        if (!this.chk) {
                            ((BZone)Interface.getInterface("org.jmol.util.BZone", this.vwr, "script")).setViewer(this.vwr).createBZ(var22_22, null, false, var15_15, var8_8);
                        }
                        this.setShapeProperty(21, "init", Boolean.FALSE);
                        return;
                    }
                    case 6: {
                        var20_20 = "info";
                        var21_21 /* !! */  = this.e.theToken.value;
                        var4_4 = true;
                        break;
                    }
                    case 134217751: {
                        var20_20 = "points";
                        var21_21 /* !! */  = Float.valueOf(this.tokAt(++var19_19) == 1073742334 ? 0.0f : this.e.floatParameter(var19_19));
                        var16_16 = true;
                        break;
                    }
                    case 1073742138: {
                        var8_8 = this.floatParameter(++var19_19);
                        var16_16 = true;
                        break block71;
                    }
                    case 1814695966: {
                        if (var15_15 != null) {
                            this.invArg();
                        }
                        var20_20 = "unitCell";
                        var21_21 /* !! */  = Boolean.TRUE;
                        var4_4 = true;
                        break;
                    }
                    case 1073742072: {
                        this.e.restrictSelected(false, false);
                        var1_1.theTok = 1073742335;
                    }
                    case 12291: 
                    case 1073742334: 
                    case 1073742335: {
                        if (var19_19 + 1 != this.slen || var4_4 || var9_9 > 1) {
                            this.error(18);
                        }
                        var20_20 = var1_1.theTok == 1073742334 ? "off" : (var1_1.theTok == 1073742335 ? "on" : "delete");
                        var5_5 = true;
                        break;
                    }
                    case 7: {
                        if (var15_15 == null || var4_4) {
                            this.invArg();
                        }
                        var4_4 = true;
                        var17_17 = this.getIntArray2(var19_19);
                        var18_18 = this.getAllPoints(var1_1.iToken + 1);
                        var19_19 = var1_1.iToken;
                        if (var18_18[0] instanceof Atom) {
                            this.setShapeProperty(21, "model", ((Atom)var18_18[0]).getModelIndex());
                        }
                        var20_20 = "definedFaces";
                        var21_21 /* !! */  = new Object[]{var17_17, var18_18};
                        break;
                    }
                    case 1073741961: {
                        var20_20 = "full";
                        break;
                    }
                    case 2: {
                        if (var15_15 != null) {
                            this.invArg();
                        }
                        var20_20 = "nVertices";
                        var21_21 /* !! */  = this.intParameter(var19_19);
                        var4_4 = true;
                        if (this.tokAt(var19_19 + 1) != 0x10000030) break;
                        ++var19_19;
                        break;
                    }
                    case 1677721602: {
                        if (var15_15 != null) {
                            this.invArg();
                        }
                        if (var9_9 > 0) {
                            this.invPO();
                        }
                        var4_4 = true;
                        var20_20 = "bonds";
                        var2_2 = true;
                        break;
                    }
                    case 1073741852: {
                        if (var11_11 != -1.0f) {
                            this.invArg();
                        }
                        var11_11 = 0.0f;
                        --var19_19;
                    }
                    case 1665140738: {
                        ++var19_19;
                    }
                    case 3: {
                        if (var15_15 != null) {
                            this.invArg();
                        }
                        if (var9_9 > 0) {
                            this.invPO();
                        }
                        var20_20 = var11_11 <= 0.0f ? "radius" : "radius1";
                        var11_11 = var11_11 == 0.0f ? 0.0f : this.floatParameter(var19_19);
                        var21_21 /* !! */  = Float.valueOf(var11_11);
                        var4_4 = true;
                        break;
                    }
                    case 1073742066: {
                        if (this.isFloatParameter(var19_19 + 1)) ** GOTO lbl121
                        var14_14 = this.e.centerParameter(++var19_19, null);
                        var19_19 = var1_1.iToken;
                        var16_16 = true;
                        break block71;
                    }
lbl121:
                    // 2 sources

                    case 1073741937: {
                        this.setShapeProperty(21, "collapsed", null);
                    }
                    case 0x40000064: 
                    case 1073742099: {
                        var20_20 = T.nameOf(var1_1.theTok);
                        switch (this.tokAt(var19_19 + 1)) {
                            case 0x10000030: 
                            case 268435860: {
                                ++var19_19;
                            }
                        }
                        var21_21 /* !! */  = Float.valueOf(this.floatParameter(++var19_19));
                        break;
                    }
                    case 1094717454: {
                        if (var15_15 == null) {
                            this.invArg();
                        }
                        var20_20 = "model";
                        var21_21 /* !! */  = this.intParameter(++var19_19);
                        break;
                    }
                    case 1073742170: {
                        if (var9_9 > 1 || var15_15 != null && !var3_3 || var13_13 == var19_19) {
                            this.invPO();
                        }
                        var9_9 = 3;
                        if (var1_1.isAtomExpression(++var19_19)) {
                            var20_20 = var4_4 != false || var3_3 != false ? "to" : "toBitSet";
                            var21_21 /* !! */  = this.atomExpressionAt(var19_19);
                        } else if (var1_1.isArrayParameter(var19_19)) {
                            var20_20 = "toVertices";
                            var21_21 /* !! */  = var1_1.getPointArray(var19_19, -1, false);
                        } else {
                            this.error(19);
                        }
                        var19_19 = var1_1.iToken;
                        var4_4 = true;
                        break;
                    }
                    case 10: 
                    case 12290: 
                    case 1073742325: {
                        if (var6_6) {
                            this.invPO();
                        }
                        switch (++var9_9) {
                            case 1: {
                                if (var15_15 != null) {
                                    this.invArg();
                                }
                                var20_20 = "centers";
                                break;
                            }
                            case 2: {
                                var20_20 = "to";
                                var4_4 = true;
                                break;
                            }
                            default: {
                                var1_1.bad();
                            }
                        }
                        var21_21 /* !! */  = this.atomExpressionAt(var19_19);
                        var19_19 = var1_1.iToken;
                        var4_4 |= var19_19 + 1 == this.slen;
                        break;
                    }
                    case 603979967: 
                    case 1073742074: 
                    case 1765808134: {
                        var10_10 = this.getColorTrans(var1_1, var19_19, true, var12_12);
                        var19_19 = var1_1.iToken;
                        break block71;
                    }
                    case 1073741886: 
                    case 1073741948: {
                        if (var6_6) {
                            this.error(18);
                        }
                        var6_6 = true;
                        if (this.isFloatParameter(var19_19 + 1)) {
                            this.setShapeProperty(21, "faceCenterOffset", Float.valueOf(this.floatParameter(++var19_19)));
                        }
                        var20_20 = this.e.theTok == 1073741886 ? "collapsed" : null;
                        break;
                    }
                    case 1073741933: 
                    case 1073741934: 
                    case 0x40000084: 
                    case 1073742044: {
                        if (var7_7) {
                            this.error(18);
                        }
                        var7_7 = true;
                        var16_16 = true;
                        var20_20 = T.nameOf(var1_1.theTok);
                        break;
                    }
                    case 1073741861: 
                    case 1073741958: 
                    case 1073741964: 
                    case 1073742060: 
                    case 1073742182: {
                        break block71;
                    }
                    case 4: 
                    case 0x100000B1: 
                    case 0x40000000: 
                    case 1073741974: {
                        if (var1_1.isColorParam(var19_19)) ** GOTO lbl206
                        if (var19_19 != 1) {
                            this.invPO();
                        }
                        var15_15 = var1_1.theTok == 1073741974 ? this.stringParameter(++var19_19) : var1_1.optParameterAsString(var19_19);
                        this.setShapeProperty(21, "thisID", var15_15);
                        this.setShapeProperty(21, "model", this.vwr.am.cmi);
                        if (var1_1.isCenterParameter(var19_19 + 1)) {
                            var20_20 = "center";
                            var21_21 /* !! */  = this.centerParameter(++var19_19);
                            var19_19 = var1_1.iToken;
                            var3_3 = true;
                            break;
                        }
                        break block71;
                    }
lbl206:
                    // 2 sources

                    default: {
                        if (!var1_1.isColorParam(var19_19)) ** GOTO lbl213
                        var12_12[0] = var1_1.getArgbParam(var19_19);
                        if (var1_1.isCenterParameter(var19_19)) {
                            var13_13 = var1_1.iToken + 1;
                        }
                        var19_19 = var1_1.iToken;
                        break block71;
lbl213:
                        // 1 sources

                        this.invArg();
                    }
                }
                if (var20_20 != null) {
                    this.setShapeProperty(21, var20_20, var21_21 /* !! */ );
                }
                if (var5_5) {
                    return;
                }
            }
            ++var19_19;
        }
        if (var4_4) {
            if (!var6_6 && var2_2) {
                this.setShapeProperty(21, "bonds", null);
            }
            this.setShapeProperty(21, "generate", null);
        } else if (!var16_16) {
            this.error(19);
        }
        if (var14_14 != null) {
            this.setShapeProperty(21, "offset", var14_14);
        }
        if (!Float.isNaN(var8_8)) {
            this.setShapeProperty(21, "scale", Float.valueOf(var8_8));
        }
        if (var12_12[0] != -2147483648) {
            this.setShapeProperty(21, "colorThis", var12_12[0]);
        }
        if (var10_10 != 3.4028235E38f) {
            var1_1.setShapeTranslucency(21, "", "translucentThis", var10_10, null);
        }
        this.setShapeProperty(21, "init", Boolean.FALSE);
    }

    private String write(T[] tArray) throws ScriptException {
        Hashtable<String, Object> hashtable;
        boolean bl;
        Object object;
        Object object2;
        ScriptEval scriptEval = this.e;
        int n = 1;
        int n2 = 1;
        String[] stringArray = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "SPT";
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        if (tArray == null) {
            tArray = this.st;
            bl3 = this.vwr.isApplet && !this.vwr.isSignedApplet || !this.vwr.haveAccess(Viewer.ACCESS.ALL) || this.vwr.fm.getPathForAllFiles().length() > 0;
        } else {
            n2 = 0;
            n = 0;
            bl2 = false;
            bl3 = !bl2;
        }
        int n3 = CmdExt.tokAtArray(n, tArray);
        if (n3 == 4 && !bl2 && (object2 = T.getTokenFromName(SV.sValue(tArray[0]).toLowerCase())) != null) {
            n3 = ((T)object2).tok;
        }
        switch (n3) {
            case 0: {
                break;
            }
            case 4138: 
            case 134221850: 
            case 1715472409: {
                string = this.plot(tArray);
                return bl3 ? string : this.writeMsg(string);
            }
            case 134222850: {
                if (!scriptEval.isArrayParameter(n + 1)) break;
                stringArray = scriptEval.stringParameterSet(++n);
                string2 = ".";
                string3 = ".";
                n2 = n = scriptEval.iToken + 1;
                n3 = this.tokAt(n);
                break;
            }
            default: {
                string4 = SV.sValue(this.tokenAt(n, tArray)).toUpperCase();
            }
        }
        object2 = this.vwr.getExportDriverList();
        String string5 = null;
        int n4 = bl2 ? this.slen : tArray.length;
        String string6 = "";
        String string7 = null;
        SV sV = null;
        int n5 = 0;
        String string8 = null;
        boolean bl5 = false;
        BS bS = null;
        int n6 = -1;
        int n7 = -1;
        boolean bl6 = false;
        String string9 = null;
        int n8 = Integer.MIN_VALUE;
        if (n3 != 0 && bl2 && this.slen > 1 && this.tokAt(this.slen - 2) == 1073741848) {
            string4 = this.paramAsStr(this.slen - 1).toUpperCase();
            n2 = n4;
            n4 -= 2;
            n3 = 0;
        }
        switch (n3) {
            case 0: {
                break;
            }
            case 6: 
            case 15: {
                string4 = "VAR";
                sV = (SV)this.tokenAt(n++, tArray);
                break;
            }
            case 0x400000A0: {
                string4 = "INLINE";
                string5 = SV.sValue(this.tokenAt(++n, tArray));
                ++n;
                break;
            }
            case 0x8000022: {
                string4 = "PGRP";
                string6 = SV.sValue(this.tokenAt(++n, tArray)).toLowerCase();
                if (!string6.equals("draw")) break;
                ++n;
                break;
            }
            case 1073742329: {
                ++n;
                bl5 = true;
                break;
            }
            case 134222850: 
            case 1073742158: {
                string7 = SV.sValue(this.tokenAt(++n, tArray)).toLowerCase();
                while (string7.equals("localpath") || string7.equals("remotepath")) {
                    if (string7.equals("localpath")) {
                        string2 = SV.sValue(this.tokenAt(++n, tArray));
                    } else {
                        string3 = SV.sValue(this.tokenAt(++n, tArray));
                    }
                    string7 = SV.sValue(this.tokenAt(++n, tArray)).toLowerCase();
                }
                string4 = "SPT";
                break;
            }
            case 135180: 
            case 135188: 
            case 134320141: 
            case 1073742015: 
            case 1073742018: 
            case 1073877010: 
            case 1073877011: 
            case 1228935687: 
            case 1610616855: {
                ++n;
                break;
            }
            case 1073741991: {
                string4 = "ZIPALL";
                ++n;
                break;
            }
            case 36868: {
                string4 = "VAR";
                n += 2;
                break;
            }
            case 4: 
            case 4115: 
            case 4120: 
            case 4166: 
            case 0x40000000: 
            case 1073742139: {
                switch (n3) {
                    case 4115: {
                        if (n + 1 < n4 && tArray[++n].tok == 1073742325 || tArray[n].tok == 10) {
                            object = scriptEval.atomExpression(tArray, n, 0, true, false, null, true);
                            n = scriptEval.iToken + 1;
                        } else {
                            object = this.vwr.getAllAtoms();
                        }
                        if (this.chk) break;
                        bS = this.vwr.ms.getModelBS((BS)object, true);
                        break;
                    }
                    case 4120: {
                        string4 = "IMAGE";
                        ++n;
                        break;
                    }
                    case 1073742139: {
                        string7 = SV.sValue(this.tokenAt(++n, tArray)).toUpperCase();
                        if (PT.isOneOf(string7, ";PNG;PNGJ;")) {
                            string8 = string7;
                            ++n;
                            break;
                        }
                        string8 = "PNG";
                        break;
                    }
                    case 4166: {
                        n5 = scriptEval.intParameterRange(++n, 1, 10);
                        if (n5 == Integer.MAX_VALUE) {
                            return "";
                        }
                        if (!this.chk) {
                            this.vwr.tm.setVibrationPeriod(0.0f);
                            if (!scriptEval.isJS) {
                                scriptEval.delayScript(100);
                            }
                        }
                        ++n;
                        break;
                    }
                    default: {
                        n3 = 4120;
                    }
                }
                if (n3 == 4120 && n < tArray.length) {
                    object = T.getTokenFromName(SV.sValue(tArray[n]).toLowerCase());
                    if (object != null) {
                        string4 = SV.sValue((T)object).toUpperCase();
                    }
                    if (PT.isOneOf(string4, ((String)object2).toUpperCase())) {
                        ++n;
                        string4 = String.valueOf(string4.substring(0, 1).toUpperCase()) + string4.substring(1).toLowerCase();
                        bl6 = true;
                        if (!bl2) break;
                        string9 = "Jmol." + string4.toLowerCase();
                        break;
                    }
                    if (PT.isOneOf(string4, ";ZIP;ZIPALL;SPT;STATE;")) {
                        ++n;
                        break;
                    }
                    string4 = "IMAGE";
                }
                if (CmdExt.tokAtArray(n, tArray) != 2) break;
                if ((n6 = SV.iValue(this.tokenAt(n++, tArray))) <= 0) {
                    this.invArg();
                }
                if ((n7 = SV.iValue(this.tokenAt(n++, tArray))) > 0) break;
                this.invArg();
            }
        }
        if (n2 < n4) {
            string7 = SV.sValue(this.tokenAt(n, tArray));
            if (string7.equalsIgnoreCase("clipboard")) {
                if (this.chk) {
                    return "";
                }
            } else if (PT.isOneOf(string7.toLowerCase(), ";jpg;jpeg;jpg64;jpeg64;gif;gift;pdf;ppm;png;pngj;pngt;")) {
                if (CmdExt.tokAtArray(n + 1, tArray) == 2 && CmdExt.tokAtArray(n + 2, tArray) == 2) {
                    if ((n6 = SV.iValue(this.tokenAt(++n, tArray))) <= 0) {
                        this.invArg();
                    }
                    if ((n7 = SV.iValue(this.tokenAt(++n, tArray))) <= 0) {
                        this.invArg();
                    }
                }
                if (CmdExt.tokAtArray(n + 1, tArray) == 2) {
                    n8 = SV.iValue(this.tokenAt(++n, tArray));
                }
            } else if (PT.isOneOf(string7.toLowerCase(), ";xyz;xyzrn;xyzvib;mol;mol67;sdf;v2000;v3000;json;pdb;pqr;cml;cif;qcjson;")) {
                string4 = string7.toUpperCase();
                if (n + 1 == n4) {
                    ++n;
                }
            }
            if (string4.equals("IMAGE") && PT.isOneOf(string7.toLowerCase(), ";jpg;jpeg;jpg64;jpeg64;gif;gift;pdf;ppm;png;pngj;pngt;scene;")) {
                string4 = string7.toUpperCase();
                n8 = Integer.MIN_VALUE;
                ++n;
            }
        }
        if (n + 2 == n4 && ((String)(object = SV.sValue(this.tokenAt(++n, tArray)))).length() > 0 && ((String)object).charAt(0) != '.' && string7 == null) {
            System.out.println("??");
            string4 = string7.toUpperCase();
        }
        switch (CmdExt.tokAtArray(n, tArray)) {
            case 0: {
                bl3 = true;
                break;
            }
            case 1073741884: {
                break;
            }
            case 805306401: {
                string9 = string4.equals("IMAGE") ? "?jmol.png" : "?jmol." + string4.toLowerCase();
                break;
            }
            case 4: 
            case 0x40000000: {
                string9 = SV.sValue(this.tokenAt(n, tArray));
                if (!string9.equalsIgnoreCase("clipboard") && this.vwr.haveAccess(Viewer.ACCESS.ALL)) break;
                string9 = null;
                break;
            }
            default: {
                this.invArg();
            }
        }
        if (string4.equals("IMAGE") || string4.equals("FRAME") || string4.equals("VIBRATION")) {
            String string10 = string4 = string9 != null && string9.indexOf(".") >= 0 ? string9.substring(string9.lastIndexOf(".") + 1).toUpperCase() : "JPG";
        }
        if (string4.equals("ISOSURFACE") || string4.equals("CONTACT")) {
            bl4 = string4.equals("CONTACT");
            String string11 = string4 = string9 != null && string9.indexOf(".") >= 0 ? string9.substring(string9.lastIndexOf(".") + 1).toUpperCase() : "JVXL";
            if (string4.equals("PMESH")) {
                string4 = "ISOMESH";
            } else if (string4.equals("PMB")) {
                string4 = "ISOMESHBIN";
            }
        }
        if (!(bl = PT.isOneOf(string4.toLowerCase(), ";jpg;jpeg;jpg64;jpeg64;gif;gift;pdf;ppm;png;pngj;pngt;scene;"))) {
            if (string4.equals("MNU")) {
                string4 = "MENU";
            } else if (string4.equals("WRL") || string4.equals("VRML")) {
                string4 = "Vrml";
                bl6 = true;
            } else if (string4.equals("X3D")) {
                string4 = "X3d";
                bl6 = true;
            } else if (string4.equals("STL")) {
                string4 = "Stl";
                bl6 = true;
            } else if (string4.equals("IDTF")) {
                string4 = "Idtf";
                bl6 = true;
            } else if (string4.equals("MA")) {
                string4 = "Maya";
                bl6 = true;
            } else if (string4.equals("JS")) {
                string4 = "Js";
                bl6 = true;
            } else if (string4.equals("OBJ")) {
                string4 = "Obj";
                bl6 = true;
            } else if (string4.equals("JVXL")) {
                string4 = "ISOSURFACE";
            } else if (string4.equals("XJVXL")) {
                string4 = "ISOSURFACE";
            } else if (string4.equals("JMOL")) {
                string4 = "ZIPALL";
            } else if (string4.equals("HIS")) {
                string4 = "HISTORY";
            }
            if (string4.equals("COORD") || string4.equals("COORDS")) {
                String string12 = string4 = string9 != null && string9.indexOf(".") >= 0 ? string9.substring(string9.lastIndexOf(".") + 1).toUpperCase() : "XYZ";
            }
        }
        if (stringArray != null) {
            if (string4.equals("PNG")) {
                string4 = "PNGJ";
            }
            if (!(string4.equals("PNGJ") || string4.equals("ZIPALL") || string4.equals("ZIP"))) {
                this.invArg();
            }
        }
        if (!(bl || bl6 || PT.isOneOf(string4, ";SCENE;JMOL;ZIP;ZIPALL;SPT;HISTORY;MO;NBO;ISOSURFACE;MESH;PMESH;PMB;ISOMESHBIN;ISOMESH;VAR;FILE;FUNCTION;CFI;CIF;CML;JSON;XYZ;XYZRN;XYZVIB;MENU;MOL;MOL67;PDB;PGRP;PQR;QUAT;RAMA;SDF;V2000;V3000;QCJSON;INLINE;"))) {
            scriptEval.errorStr2(54, "COORDS|FILE|FUNCTIONS|HISTORY|IMAGE|INLINE|ISOSURFACE|JMOL|MENU|MO|NBO|POINTGROUP|QUATERNION [w,x,y,z] [derivative]|RAMACHANDRAN|SPT|STATE|VAR x|ZIP|ZIPALL  CLIPBOARD", "CIF|CML|CFI|GIF|GIFT|JPG|JPG64|JMOL|JVXL|MESH|MOL|PDB|PMESH|PNG|PNGJ|PNGT|PPM|PQR|SDF|CD|JSON|QCJSON|V2000|V3000|SPT|XJVXL|XYZ|XYZRN|XYZVIB|ZIP" + ((String)object2).toUpperCase().replace(';', '|'));
        }
        if (this.chk) {
            return "";
        }
        String[] stringArray2 = new String[1];
        boolean bl7 = this.vwr.getBoolean(603979934);
        if (bl6) {
            if (bl7) {
                Logger.startTimer("export");
            }
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            hashtable2.put("type", string4);
            if (string9 != null) {
                hashtable2.put("fileName", string9);
            }
            if (bl2 || string9 != null) {
                hashtable2.put("fullPath", stringArray2);
            }
            hashtable2.put("width", n6);
            hashtable2.put("height", n7);
            string5 = this.vwr.generateOutputForExport(hashtable2);
            if (string5 == null || string5.length() == 0) {
                return "";
            }
            if (bl3) {
                return string5;
            }
            if (!string4.equals("Povray") && !string4.equals("Idtf") || stringArray2[0] == null) {
                return this.writeMsg(string5);
            }
            String string13 = string4.equals("Idtf") ? ".tex" : ".ini";
            string9 = String.valueOf(stringArray2[0]) + string13;
            Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
            hashtable3.put("fileName", string9);
            hashtable3.put("type", string13);
            hashtable3.put("text", string5);
            hashtable3.put("fullPath", stringArray2);
            string = this.vwr.processWriteOrCapture(hashtable3);
            if (string4.equals("Idtf")) {
                string5 = string5.substring(0, string5.indexOf("\\begin{comment}"));
            }
            string5 = "Created " + stringArray2[0] + ":\n\n" + string5;
            if (bl7) {
                this.showString(Logger.getTimerMsg("export", 0));
            }
            if (string != null) {
                boolean bl8;
                boolean bl9 = bl8 = !string.startsWith("OK");
                if (bl8) {
                    scriptEval.evalError(string, null);
                }
                scriptEval.report(string5, bl8);
            }
            return "";
        }
        Object object3 = null;
        boolean bl10 = false;
        if (string5 == null) {
            int n9 = 0;
            string5 = string4.intern();
            if (string5 == "MENU") {
                string5 = this.vwr.getMenu("");
            } else if (string5 == "PGRP") {
                string5 = this.vwr.ms.getPointGroupAsString(this.vwr.bsA(), null, 0, 1.0f, null, null, string6.equals("draw") ? "" : null);
            } else if (string5 == "PDB" || string5 == "PQR") {
                if (bl3) {
                    string5 = this.vwr.getPdbAtomData(null, null, string5 == "PQR", bl5);
                } else {
                    bl10 = true;
                    string4 = "PDB_" + string5 + "-coord " + bl5;
                }
            } else if (string5 == "FILE") {
                if ("?".equals(string9)) {
                    string9 = "?Jmol." + this.vwr.getP("_fileType");
                }
                if (bl3) {
                    string5 = this.vwr.getCurrentFileAsString("script");
                } else {
                    bl10 = true;
                }
            } else if (string5 == "CIF" || string5 == "SDF" || string5 == "MOL" || string5 == "MOL67" || string5 == "V2000" || string5 == "V3000" || string5 == "CD" || string5 == "JSON" || string5 == "XYZ" || string5 == "XYZRN" || string5 == "XYZVIB" || string5 == "CML" || string5 == "QCJSON") {
                BS bS2;
                BS bS3 = this.vwr.bsA();
                string = " (" + bS3.cardinality() + " atoms)";
                if (this.vwr.am.cmi >= 0 && !bS3.equals(bS2 = this.vwr.getModelUndeletedAtomsBitSet(this.vwr.am.cmi))) {
                    string = String.valueOf(string) + "\nNote! Selected atom set " + bS3 + " is not the same as the current model " + bS2;
                }
                if ((string5 = this.vwr.getModelExtract(bS3, bl5, false, string5)).startsWith("ERROR:")) {
                    object3 = string5;
                }
            } else if (string5 == "CFI") {
                string5 = this.vwr.getModelFileData("selected", "cfi", false);
            } else if (string5 == "FUNCTION") {
                string5 = this.vwr.getFunctionCalls(null);
                string4 = "TXT";
            } else if (string5 == "VAR") {
                if (sV == null) {
                    sV = (SV)scriptEval.getParameter(SV.sValue(this.tokenAt(bl2 ? 2 : 1, tArray)), 1073742190, true);
                }
                Lst<byte[]> lst = null;
                if (sV.tok == 15) {
                    lst = new Lst<byte[]>();
                    lst.addLast(((BArray)sV.value).data);
                } else if (sV.tok == 6) {
                    Lst<Object> lst2 = lst = string9 == null ? new Lst() : this.prepareBinaryOutput(sV);
                }
                if (lst == null) {
                    string5 = sV.asString();
                    string4 = "TXT";
                } else if (string9 != null) {
                    hashtable = new Hashtable();
                    hashtable.put("data", lst);
                    string5 = (String)this.vwr.createZip(string9, lst.size() == 1 || string9.endsWith(".png") || string9.endsWith(".pngj") ? "BINARY" : "ZIPDATA", hashtable);
                    object3 = string5;
                    if (string5 == null) {
                        scriptEval.evalError("#CANCELED#", null);
                    }
                }
            } else if (string5 == "SPT") {
                if (bl5) {
                    BS bS4 = this.vwr.ms.getTaintedAtoms(2);
                    this.vwr.setAtomCoordsRelative(P3.new3(0.0f, 0.0f, 0.0f), null);
                    string5 = this.vwr.getStateInfo();
                    this.vwr.ms.setTaintedAtoms(bS4, 2);
                } else {
                    string5 = this.vwr.getStateInfo();
                    if (string2 != null || string3 != null) {
                        string5 = FileManager.setScriptFileReferences(string5, string2, string3, null);
                    }
                }
            } else if (string5 == "ZIP" || string5 == "ZIPALL") {
                if (string9 != null) {
                    hashtable = new Hashtable();
                    if (stringArray != null) {
                        hashtable.put("data", stringArray);
                    }
                    string5 = (String)this.vwr.createZip(string9, string4, hashtable);
                    object3 = string5;
                    if (string5 == null) {
                        scriptEval.evalError("#CANCELED#", null);
                    }
                }
            } else if (string5 == "HISTORY") {
                string5 = this.vwr.getSetHistory(Integer.MAX_VALUE);
                string4 = "SPT";
            } else if (string5 == "MO" || string5 == "NBO") {
                string5 = this.getMoJvxl(Integer.MAX_VALUE, string5 == "NBO");
                string4 = "XJVXL";
            } else if (string5 == "PMESH" || string5 == "PMB") {
                if ((string5 = (String)this.getIsosurfaceJvxl(29, string5)) == null) {
                    this.error(31);
                }
                string4 = "XJVXL";
            } else if (string5 == "ISOMESH") {
                if ((string5 = (String)this.getIsosurfaceJvxl(24, string5)) == null) {
                    this.error(31);
                }
                string4 = "PMESH";
            } else if (string5 == "ISOMESHBIN") {
                object3 = this.getIsosurfaceJvxl(24, "ISOMESHBIN");
                if (object3 == null) {
                    this.error(31);
                }
                string4 = "PMB";
            } else if (string5 == "ISOSURFACE" || string5 == "MESH") {
                string5 = (String)this.getIsosurfaceJvxl(bl4 ? 25 : 24, string5);
                if (string5 == null) {
                    this.error(31);
                }
                String string14 = string4 = string5.indexOf("<?xml") >= 0 ? "XJVXL" : "JVXL";
                if (!bl3) {
                    this.showString((String)this.getShapeProperty(bl4 ? 25 : 24, "jvxlFileInfo"));
                }
            } else {
                if (bl2 && bl3 && string9 == null) {
                    bl3 = false;
                    string9 = "\u0001";
                }
                n9 = -1;
                if (string8 == null && n8 < 0) {
                    n8 = -1;
                }
            }
            if (string5 == null) {
                string5 = "";
            }
            if (n9 == 0) {
                int n10 = object3 == null ? string5.length() : (n9 = object3 instanceof String ? ((String)object3).length() : ((byte[])object3).length);
            }
        }
        if (!bl2) {
            return string5;
        }
        if (bl3) {
            scriptEval.showStringPrint(string5, true);
            return "";
        }
        if (object3 != null && object3 instanceof String) {
            return this.writeMsg((String)object3);
        }
        if (bl10) {
            return this.writeMsg(this.vwr.writeFileData(string9, string4, 0, null));
        }
        if (string4.equals("SCENE")) {
            object3 = string8;
        } else if (!(object3 != null || bl && string9 == null)) {
            object3 = string5;
        }
        if (bl7) {
            Logger.startTimer("write");
        }
        if (bl) {
            scriptEval.refresh(false);
            if (n6 < 0) {
                n6 = this.vwr.getScreenWidth();
            }
            if (n7 < 0) {
                n7 = this.vwr.getScreenHeight();
            }
        }
        hashtable = new Hashtable<String, Object>();
        if (string9 != null) {
            hashtable.put("fileName", string9);
        }
        hashtable.put("backgroundColor", this.vwr.getBackgroundArgb());
        hashtable.put("type", string4);
        if (object3 instanceof String && n8 == Integer.MIN_VALUE) {
            hashtable.put("text", object3);
        } else if (object3 instanceof byte[]) {
            hashtable.put("bytes", object3);
        }
        if (stringArray != null) {
            hashtable.put("scripts", stringArray);
        }
        if (bS != null) {
            hashtable.put("bsFrames", bS);
        }
        hashtable.put("fullPath", stringArray2);
        hashtable.put("quality", n8);
        hashtable.put("width", n6);
        hashtable.put("height", n7);
        hashtable.put("nVibes", n5);
        String string15 = this.vwr.processWriteOrCapture(hashtable);
        if (string15 == null) {
            string15 = "canceled";
        }
        if (bl && string15.startsWith("OK")) {
            string15 = String.valueOf(string15) + "; width=" + n6 + "; height=" + n7;
        }
        if (bl7) {
            this.showString(Logger.getTimerMsg("write", 0));
        }
        return this.writeMsg(String.valueOf(string15) + (string == null ? "" : string));
    }

    public Lst<Object> prepareBinaryOutput(SV sV) {
        Map<String, SV> map = sV.getMap();
        if (map == null || !map.containsKey("$_BINARY_$")) {
            return null;
        }
        Lst<Object> lst = new Lst<Object>();
        for (Map.Entry<String, SV> entry : map.entrySet()) {
            byte[] byArray;
            String string = entry.getKey();
            if (string.equals("$_BINARY_$")) continue;
            SV sV2 = entry.getValue();
            byte[] byArray2 = byArray = sV2.tok == 15 ? ((BArray)sV2.value).data : null;
            if (byArray == null) {
                String string2 = sV2.asString();
                byte[] byArray3 = byArray = string2.startsWith(";base64,") ? Base64.decodeBase64(string2) : string2.getBytes();
            }
            if (string.equals("_DATA_")) {
                lst = new Lst();
                lst.addLast(byArray);
                return lst;
            }
            if (string.equals("_IMAGE_")) {
                lst.add(0, string);
                lst.add(1, null);
                lst.add(2, byArray);
                continue;
            }
            lst.addLast(string);
            lst.addLast((Object)null);
            lst.addLast(byArray);
        }
        return lst;
    }

    private String writeMsg(String string) throws ScriptException {
        boolean bl;
        if (this.chk || string == null) {
            return "";
        }
        boolean bl2 = bl = !string.startsWith("OK");
        if (bl) {
            this.e.evalError(string, null);
        }
        this.e.report(string, bl);
        return string;
    }

    private void show() throws ScriptException {
        int n;
        ScriptEval scriptEval = this.e;
        String string = null;
        String string2 = this.paramAsStr(1);
        String string3 = null;
        int n2 = 0;
        if (this.slen > 2 && this.tokAt(this.slen - 2) == 0x100000B0) {
            string3 = "/" + this.paramAsStr(this.slen - 1);
            this.slen -= 2;
            n2 = 2;
        } else {
            string3 = this.paramAsStr(this.slen - 1);
            if (string3.lastIndexOf("/") == 0) {
                --this.slen;
                n2 = 1;
            } else {
                string3 = null;
            }
        }
        String string4 = null;
        String string5 = null;
        int n3 = 2;
        T t = this.getToken(1);
        int n4 = n = t instanceof SV && t.tok != 0x40000000 ? 0 : t.tok;
        if (n == 4 && (t = T.getTokenFromName(string2.toLowerCase())) != null) {
            n = t.tok;
        }
        if (n != 1296041986 && n != 1073742158 && n != 1715472409 && n != 1228935687) {
            this.checkLength(-3);
        }
        if (this.slen == 2 && string2.indexOf("?") >= 0) {
            string4 = this.vwr.getAllSettings(string2.substring(0, string2.indexOf("?")));
            n = -1;
        }
        block1 : switch (n) {
            case -1: {
                break;
            }
            case 0: {
                if (this.chk) break;
                string4 = ((SV)scriptEval.theToken).escape();
                break;
            }
            case 1073741925: {
                scriptEval.checkLength23();
                n3 = this.st.length;
                if (this.chk) break;
                Object object = this.vwr.getModelInfo("domains");
                if (object instanceof SV) {
                    string4 = this.vwr.getAnnotationInfo((SV)object, scriptEval.optParameterAsString(2), 1073741925);
                    break;
                }
                string4 = "domain information has not been loaded";
                break;
            }
            case 1715472409: {
                string4 = this.plot(this.st);
                n3 = this.st.length;
                break;
            }
            case 1073742189: {
                scriptEval.checkLength23();
                n3 = this.st.length;
                if (this.chk) break;
                Object object = this.vwr.getModelInfo("validation");
                if (object instanceof SV) {
                    string4 = this.vwr.getAnnotationInfo((SV)object, scriptEval.optParameterAsString(2), 1073742189);
                    break;
                }
                string4 = "validation information has not been loaded";
                break;
            }
            case 134221829: {
                if (this.chk) break;
                string4 = Escape.e(this.vwr.fm.cacheList());
                break;
            }
            case 1111490587: {
                scriptEval.checkLength23();
                n3 = this.st.length;
                if (this.chk) break;
                Object object = this.vwr.getModelInfo("dssr");
                string4 = object == null ? "no DSSR information has been read" : (n3 > 2 ? SV.getVariable(this.vwr.extractProperty(object, this.stringParameter(2), -1)).asString() : SV.getVariable(object).asString());
                break;
            }
            case 1073741915: {
                int n5 = 2;
                if (this.slen == 3) {
                    n3 = 3;
                    n5 = (int)this.floatParameter(3 - 1);
                } else {
                    this.checkLength(2 + n2);
                }
                if (this.chk) break;
                string4 = this.vwr.calculateStructures(null, true, false, n5);
                break;
            }
            case 545259572: {
                this.checkLength(2 + n2);
                if (this.chk) break;
                string4 = this.vwr.fm.getPathForAllFiles();
                break;
            }
            case 1275203608: {
                if (this.chk) break;
                Object[] objectArray = new Object[2];
                this.vwr.shm.getShapePropertyData(21, "allInfo", objectArray);
                string4 = SV.getVariable(objectArray[1]).asString();
                break;
            }
            case 1073742038: {
                if (!this.chk) {
                    this.vwr.getNMRPredict(scriptEval.optParameterAsString(2));
                }
                return;
            }
            case 134218757: 
            case 1073741879: 
            case 1073741929: {
                this.checkLength((n == 1073741879 || n == 134218757 && this.tokAt(2) == 1073742335 ? (n3 = 3) : 2) + n2);
                if (this.chk) {
                    return;
                }
                String string6 = scriptEval.optParameterAsString(2);
                if (n == 1073741879) {
                    if ("mf".equals(string6)) {
                        string6 = "formula";
                    }
                    if ("formula".equals(string6) && (string4 = (String)this.vwr.getModelInfo("formula")) != null) {
                        string4 = PT.rep(string4, " ", "");
                    }
                }
                if (string4 != null) break;
                try {
                    if (n != 134218757) {
                        string4 = this.vwr.ms.getModelDataBaseName(this.vwr.bsA());
                        string4 = string4 != null && (string4.startsWith("$") || string4.startsWith(":")) ? string4.substring(1) : null;
                    } else if (string6.equalsIgnoreCase("true")) {
                        string4 = this.vwr.getBioSmiles(null);
                        string3 = null;
                    } else if (string3 != null) {
                        string4 = this.vwr.getSmilesOpt(null, -1, -1, 1, String.valueOf(string3) + "///");
                        string3 = null;
                    }
                    if (string4 == null) {
                        int n6 = Logger.getLogLevel();
                        Logger.setLogLevel(4);
                        string4 = n == 134218757 ? this.vwr.getSmiles(null) : this.vwr.getOpenSmiles(null);
                        Logger.setLogLevel(n6);
                    }
                }
                catch (Exception exception) {
                    string4 = exception.getMessage();
                    if (string4 == null) {
                        string4 = "";
                    }
                    exception.printStackTrace();
                }
                switch (n) {
                    case 134218757: {
                        break;
                    }
                    case 1073741929: {
                        if (string4.length() > 0) {
                            this.vwr.fm.loadImage(this.vwr.setLoadFormat("_" + string4, '2', false), "\u0001" + string4, false);
                            return;
                        }
                        string4 = "Could not show drawing -- Either insufficient atoms are selected or the model is a PDB file.";
                        break;
                    }
                    case 1073741879: {
                        n3 = 3;
                        if (string4.length() > 0) {
                            if ((string4 = this.vwr.getChemicalInfo(string4, string6, this.vwr.bsA())).indexOf("FileNotFound") < 0) break;
                            string4 = "?";
                            break;
                        }
                        string4 = "Could not show name -- Either insufficient atoms are selected or the model is a PDB file.";
                    }
                }
                break;
            }
            case 1073742152: 
            case 1296041986: {
                Object[] objectArray;
                string4 = "";
                Map<String, Object> map = null;
                n3 = this.slen;
                if (n3 == 2) {
                    if (this.chk) break;
                    map = this.vwr.getSymTemp().getSpaceGroupInfo(this.vwr.ms, null, -1, false);
                } else if (n == 1073742152) {
                    String string7 = this.paramAsStr(2);
                    n3 = 3;
                    if (this.chk) break;
                    map = this.vwr.getSymTemp().getSpaceGroupInfo(this.vwr.ms, PT.rep(string7, "''", "\""), -1, false);
                }
                if (map != null) {
                    string4 = String.valueOf(n == 1073742152 ? "" + map.get("spaceGroupInfo") + map.get("spaceGroupNote") : "") + map.get("symmetryInfo");
                    break;
                }
                int n7 = this.tokAt(2) == 2 ? this.intParameter(2) : 0;
                String string8 = this.tokAt(2) == 4 ? this.paramAsStr(2) : null;
                P3 p3 = null;
                P3 p32 = null;
                int n8 = -1;
                if (this.slen > 3 && this.tokAt(3) != 4) {
                    Object[] objectArray2 = new BS[2];
                    objectArray2[1] = this.vwr.getFrameAtoms();
                    objectArray = objectArray2;
                    p3 = scriptEval.centerParameter(2 + (n7 == 0 ? 0 : 1), objectArray);
                    if (objectArray[0] != null && ((BS)objectArray[0]).cardinality() == 0) {
                        n3 = this.slen;
                        break;
                    }
                    objectArray[0] = null;
                    if (n7 == 0) {
                        p32 = scriptEval.centerParameter(++scriptEval.iToken, objectArray);
                        if (objectArray[0] != null && ((BS)objectArray[0]).cardinality() == 0) {
                            n3 = this.slen;
                            break;
                        }
                    }
                    if (this.tokAt(scriptEval.iToken + 1) == 2) {
                        n8 = scriptEval.getToken((int)(++scriptEval.iToken)).intValue;
                    }
                }
                objectArray = scriptEval.iToken > 1 && this.tokAt(scriptEval.iToken + 1) == 4 ? this.stringParameter(++scriptEval.iToken) : null;
                n3 = ++scriptEval.iToken;
                this.checkLength(scriptEval.iToken + n2);
                if (this.chk) break;
                Object object = this.vwr.getSymTemp().getSymmetryInfoAtom(this.vwr.ms, this.vwr.getAllAtoms().nextSetBit(0), string8, n7, p3, p32, (String)objectArray, 0, 0.0f, n8);
                string4 = object instanceof Map ? SV.getVariable(object).asString() : object.toString();
                break;
            }
            case 1648363544: {
                VDW vDW = null;
                if (this.slen > 2) {
                    n3 = this.slen;
                    vDW = VDW.getVdwType(this.paramAsStr(2));
                    if (vDW == null) {
                        this.invArg();
                    }
                }
                if (this.chk) break;
                string4 = this.vwr.getDefaultVdwNameOrData(0, vDW, null);
                break;
            }
            case 134320141: {
                int n9;
                scriptEval.checkLength23();
                n3 = this.slen;
                String string9 = scriptEval.optParameterAsString(2);
                if (string3 == null && (n9 = string9.indexOf(47)) >= 0) {
                    string3 = string9.substring(n9 + 1);
                    string9 = string9.substring(0, n9);
                }
                if (this.chk) break;
                string4 = this.vwr.getFunctionCalls(string9);
                break;
            }
            case 36867: {
                this.checkLength(2 + n2);
                if (this.chk) break;
                string4 = this.vwr.getAllSettings(null);
                break;
            }
            case 1073742166: {
                string4 = this.vwr.getFrameTitle();
                break;
            }
            case 1073742184: {
                n3 = this.slen;
                if (n3 == 2) {
                    if (!this.chk) {
                        this.vwr.showUrl(scriptEval.getFullPathName());
                    }
                } else {
                    string5 = this.paramAsStr(2);
                    if (!this.chk) {
                        this.vwr.showUrl(string5);
                    }
                }
                return;
            }
            case 1765808134: {
                string2 = "defaultColorScheme";
                break;
            }
            case 0x60000004: {
                string2 = "scaleAngstromsPerInch";
                break;
            }
            case 4138: 
            case 134221850: {
                if (this.chk) {
                    return;
                }
                int n10 = this.vwr.am.cmi;
                if (n10 < 0) {
                    scriptEval.errorStr(30, "show " + scriptEval.theToken.value);
                }
                string4 = this.plot(this.st);
                n3 = this.slen;
                break;
            }
            case 14: 
            case 1112152078: {
                if (this.chk) break;
                string4 = this.getContext(false);
                break;
            }
            case 0x40000040: {
                string5 = scriptEval.optParameterAsString(2);
                if (string5.length() > 0) {
                    n3 = 3;
                }
                if (this.chk) break;
                string = this.vwr.cm.getColorSchemeList(string5);
                break;
            }
            case 1073742192: {
                if (this.chk) break;
                string4 = String.valueOf(this.vwr.getAtomDefs(this.vwr.definedAtomSets)) + this.vwr.g.getVariableList() + this.getContext(true);
                break;
            }
            case 0x2000000E: {
                if (this.chk) break;
                string4 = this.vwr.getTrajectoryState();
                break;
            }
            case 553648147: {
                string = "" + ScriptEval.commandHistoryLevelMax;
                break;
            }
            case 553648150: {
                string = "" + Logger.getLogLevel();
                break;
            }
            case 603979825: {
                string = "" + this.vwr.getBoolean(603979825);
                break;
            }
            case 553648178: {
                string4 = "set strandCountForStrands " + this.vwr.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.vwr.getStrandCount(13);
                break;
            }
            case 536875070: {
                n3 = this.slen;
                string4 = this.vwr.showTimeout(n3 == 2 ? null : this.paramAsStr(2));
                break;
            }
            case 0x20000006: {
                string = Escape.eP(this.vwr.getDefaultLattice());
                break;
            }
            case 4126: {
                if (this.chk) break;
                string4 = this.vwr.getMinimizationInfo();
                break;
            }
            case 1611272194: {
                switch (this.vwr.g.axesMode) {
                    case 0x24000020: {
                        string4 = "set axesUnitcell";
                        break block1;
                    }
                    case 603979804: {
                        string4 = "set axesMolecular";
                        break block1;
                    }
                }
                string4 = "set axesWindow";
                break;
            }
            case 0x60000001: {
                string4 = "set bondMode " + (this.vwr.getBoolean(0x24000024) ? "OR" : "AND");
                break;
            }
            case 1649022989: {
                if (this.chk) break;
                string4 = "set strandCountForStrands " + this.vwr.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.vwr.getStrandCount(13);
                break;
            }
            case 1613238294: {
                string4 = "set hbondsBackbone " + this.vwr.getBoolean(603979852) + ";set hbondsSolid " + this.vwr.getBoolean(603979854);
                break;
            }
            case 1611141175: {
                if (this.chk) break;
                string4 = this.vwr.getSpinState();
                break;
            }
            case 1611141176: {
                string4 = "set ssbondsBackbone " + this.vwr.getBoolean(603979952);
                break;
            }
            case 1610625028: 
            case 1611141171: {
                string4 = "selectionHalos " + (this.vwr.getSelectionHalosEnabled() ? "ON" : "OFF");
                break;
            }
            case 0x60200006: {
                string4 = "set selectHetero " + this.vwr.getBoolean(0x60200006);
                break;
            }
            case 0x40000004: {
                string4 = Escape.eAP(this.vwr.getAdditionalHydrogens(null, true, true, null));
                break;
            }
            case 1612709900: {
                string4 = "set selectHydrogens " + this.vwr.getBoolean(1612709900);
                break;
            }
            case 0x2000000C: 
            case 0x21000002: 
            case 553648141: 
            case 553648172: 
            case 553648176: 
            case 1073741995: {
                if (this.chk) break;
                string4 = this.vwr.getLightingState();
                break;
            }
            case 4146: 
            case 1073742136: {
                if (this.chk) break;
                string4 = this.vwr.stm.listSavedStates();
                break;
            }
            case 1814695966: {
                if (this.chk) break;
                string4 = this.vwr.getUnitCellInfoText();
                break;
            }
            case 1073742329: {
                n3 = this.slen;
                if (n3 == 2) {
                    if (this.chk) break;
                    string4 = this.vwr.getCoordinateState(this.vwr.bsA());
                    break;
                }
                String string10 = this.paramAsStr(2);
                if (this.chk) break;
                string4 = this.vwr.stm.getSavedCoordinates(string10);
                break;
            }
            case 1073742158: {
                if (!this.chk && scriptEval.outputBuffer == null) {
                    this.vwr.sm.clearConsole();
                }
                if ((n3 = this.slen) == 2) {
                    if (this.chk) break;
                    string4 = this.vwr.getStateInfo();
                    break;
                }
                if (string3 != null && this.slen == 3) {
                    if (this.chk) break;
                    string4 = this.vwr.getStateInfo();
                    break;
                }
                if (this.tokAt(2) == 1228935687 && (n3 = this.slen) == 4) {
                    if (this.chk) break;
                    string4 = this.vwr.fm.getEmbeddedFileState(this.paramAsStr(3), true, "state.spt");
                    break;
                }
                n3 = 3;
                string5 = this.paramAsStr(2);
                if (this.chk) break;
                string4 = this.vwr.stm.getSavedState(string5);
                break;
            }
            case 1639976963: {
                n3 = this.slen;
                if (n3 == 2) {
                    if (this.chk) break;
                    string4 = this.vwr.ms.getProteinStructureState(this.vwr.bsA(), 134222350);
                    break;
                }
                String string11 = this.paramAsStr(2);
                if (this.chk) break;
                string4 = this.vwr.stm.getSavedStructure(string11);
                break;
            }
            case 134221834: {
                String string12;
                n3 = this.slen;
                String string13 = string12 = n3 == 3 ? this.paramAsStr(2) : null;
                if (this.chk) break;
                Object[] objectArray = (Object[])this.vwr.getDataObj(string12, null, -2);
                string4 = objectArray == null ? "no data" : Escape.encapsulateData((String)objectArray[0], objectArray[1], (Integer)objectArray[3]);
                break;
            }
            case 1073742330: {
                n3 = 3;
                string4 = scriptEval.setObjectProperty();
                break;
            }
            case 1678381065: {
                if (this.chk) break;
                string4 = this.vwr.ms.getBoundBoxCommand(true);
                break;
            }
            case 12289: {
                if (this.chk) break;
                string4 = "center " + Escape.eP(this.vwr.tm.fixedRotationCenter);
                break;
            }
            case 135176: {
                if (this.chk) break;
                string4 = (String)this.getShapeProperty(22, "command");
                break;
            }
            case 1228935687: {
                if (this.slen == 2) {
                    if (!this.chk) {
                        if (string3 == null) {
                            this.vwr.sm.clearConsole();
                        }
                        string4 = this.vwr.getCurrentFileAsString("script");
                    }
                    if (string4 != null) break;
                    string4 = "<unavailable>";
                    break;
                }
                n3 = 3;
                string = this.paramAsStr(2);
                if (this.chk) break;
                if (string3 == null) {
                    this.vwr.sm.clearConsole();
                }
                string4 = this.vwr.getFileAsString3(string, true, null);
                break;
            }
            case 4115: {
                if (this.tokAt(2) == 1073742327) {
                    n3 = 3;
                    if (3 > 0) {
                        string4 = this.vwr.getModelFileInfoAll();
                        break;
                    }
                }
                string4 = this.vwr.getModelFileInfo();
                break;
            }
            case 1610616855: {
                int n11;
                n3 = this.slen;
                int n12 = n11 = n3 == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (n11 < 1) {
                    this.invArg();
                }
                if (this.chk) break;
                this.vwr.sm.clearConsole();
                if (scriptEval.scriptLevel == 0) {
                    this.vwr.removeCommand();
                }
                string4 = this.vwr.getSetHistory(n11);
                break;
            }
            case 135180: {
                if (this.chk) break;
                string4 = (String)this.getShapeProperty(24, "jvxlDataXml");
                break;
            }
            case 1073877010: 
            case 1073877011: {
                int n13;
                if (scriptEval.optParameterAsString(2).equalsIgnoreCase("list")) {
                    this.e.sm.loadShape(27);
                    string4 = this.chk ? "" : (String)this.getShapeProperty(27, "list -1");
                    n3 = 3;
                    break;
                }
                n3 = this.slen;
                int n14 = n13 = n3 == 2 ? Integer.MIN_VALUE : this.intParameter(2);
                if (this.chk) break;
                string4 = this.getMoJvxl(n13, n == 1073877011);
                break;
            }
            case 1094717454: {
                if (this.chk) break;
                string4 = this.vwr.ms.getModelInfoAsString();
                break;
            }
            case 0x20021010: {
                if (this.chk) break;
                string4 = this.vwr.getMeasurementInfoAsString();
                break;
            }
            case 1073741864: {
                n3 = 3;
                if (this.chk || this.slen != n3) break;
                string4 = this.paramAsStr(2);
                string4 = this.vwr.getOrientationText(T.getTokFromName(string4.equals("box") ? "volume" : (string4.equals("rotation") ? "best" : string4)), "best", null).toString();
                break;
            }
            case 1073742132: {
                n = this.tokAt(2);
                if (n == 0) {
                    n = 1073742132;
                } else {
                    n3 = 3;
                }
            }
            case 4129: 
            case 1073742178: {
                if (this.chk) break;
                string4 = this.vwr.getOrientationText(n, null, null).toString();
                break;
            }
            case 1073742077: {
                n3 = 2;
                if (this.slen > 3) break;
                n = this.tokAt(2);
                switch (n) {
                    case 0: 
                    case 4129: 
                    case 1073742132: 
                    case 1073742178: {
                        if (this.chk) break;
                        string4 = this.vwr.getOrientationText(n, null, null).toString();
                        break;
                    }
                    default: {
                        string5 = scriptEval.optParameterAsString(2);
                        string4 = this.vwr.getOrientationText(1073742034, string5, null).toString();
                    }
                }
                n3 = this.slen;
                break;
            }
            case 1073742088: {
                if (this.chk) break;
                string4 = this.vwr.ms.getPDBHeader(this.vwr.am.cmi);
                break;
            }
            case 0x8000022: {
                String string14 = scriptEval.optParameterAsString(2);
                if (string14.length() == 0) {
                    string14 = null;
                }
                n3 = this.slen;
                if (this.chk) break;
                string4 = this.vwr.ms.getPointGroupAsString(this.vwr.bsA(), "show:" + string14, 0, 0.0f, null, null, null);
                break;
            }
            case 1088421903: {
                if (this.chk) break;
                string4 = this.vwr.ms.getSymmetryInfoAsString();
                break;
            }
            case 1073742176: {
                if (this.chk) break;
                string4 = "transform:\n" + this.vwr.tm.matrixRotate.toString();
                break;
            }
            case 4168: {
                string4 = "zoom " + (this.vwr.tm.zoomEnabled ? "" + this.vwr.tm.getZoomSetting() : "off");
                break;
            }
            case 1611272202: {
                string4 = this.vwr.getShowFrank() ? "frank ON" : "frank OFF";
                break;
            }
            case 1665140738: {
                string2 = "solventProbeRadius";
                break;
            }
            case 1086324744: {
                n3 = this.slen;
                if (n3 == 3 && this.tokAt(2) == 1073742334) {
                    n = 1086324743;
                }
            }
            case 1073741863: 
            case 1073741982: 
            case 1073742120: 
            case 1086324742: 
            case 1086326788: 
            case 1113589787: 
            case 0x44000001: {
                if (this.chk) break;
                string4 = this.vwr.getChimeInfo(n);
                break;
            }
            case 20482: 
            case 537022465: 
            case 0x60000002: 
            case 1612709912: {
                string = "?";
                break;
            }
            case 1073742030: {
                String string15;
                n3 = this.slen;
                String string16 = string15 = n3 == 2 ? null : this.paramAsStr(2);
                if (this.chk) break;
                string4 = this.vwr.getBindingInfo(string15);
                break;
            }
            case 1073742015: {
                if (this.chk) break;
                string = this.vwr.getMenu("");
                break;
            }
            case 0x40000000: {
                if (!string2.equalsIgnoreCase("fileHeader") || this.chk) break;
                string4 = this.vwr.ms.getPDBHeader(this.vwr.am.cmi);
                break;
            }
            case 36868: 
            case 1073741992: {
                string2 = this.paramAsStr(n3++);
                SV sV = (SV)scriptEval.getParameter(string2, 1073742190, true);
                if (this.chk) break;
                string4 = n == 1073741992 ? sV.toJSON() : sV.escape();
            }
        }
        this.checkLength(n3 + n2);
        if (this.chk) {
            return;
        }
        if (string4 != null) {
            this.showString(this.filterShow(string4, string3));
        } else if (string != null) {
            this.showString(String.valueOf(string2) + " = " + string);
        } else if (string2 != null) {
            if (string2.indexOf(" ") >= 0) {
                this.showString(string2);
            } else {
                this.showString(String.valueOf(string2) + " = " + ((SV)scriptEval.getParameter(string2, 1073742190, true)).escape());
            }
        }
    }

    private String filterShow(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        string2 = string2.substring(1).toLowerCase();
        String[] stringArray = PT.split(string, "\n");
        SB sB = new SB();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].toLowerCase().indexOf(string2) >= 0) {
                sB.append(stringArray[n]).appendC('\n');
            }
            ++n;
        }
        return sB.toString();
    }

    private void stereo() throws ScriptException {
        STER sTER = STER.DOUBLE;
        float f = -5.0f;
        boolean bl = false;
        int[] nArray = null;
        int n = 0;
        int n2 = 1;
        while (n2 < this.slen) {
            if (this.e.isColorParam(n2)) {
                if (n > 1) {
                    this.e.bad();
                }
                if (n == 0) {
                    nArray = new int[2];
                }
                if (!bl) {
                    f = 3.0f;
                }
                nArray[n] = this.e.getArgbParam(n2);
                if (n++ == 0) {
                    nArray[1] = ~nArray[0];
                }
                n2 = this.e.iToken;
            } else {
                switch (this.getToken((int)n2).tok) {
                    case 1073742335: {
                        this.e.iToken = 1;
                        this.e.checkLast(1);
                        this.e.iToken = 1;
                        break;
                    }
                    case 1073742334: {
                        this.e.iToken = 1;
                        this.e.checkLast(1);
                        sTER = STER.NONE;
                        break;
                    }
                    case 2: 
                    case 3: {
                        f = this.floatParameter(n2);
                        bl = true;
                        break;
                    }
                    case 0x40000000: {
                        if (!bl) {
                            f = 3.0f;
                        }
                        if ((sTER = STER.getStereoMode(this.paramAsStr(n2))) != null) break;
                    }
                    default: {
                        this.invArg();
                    }
                }
            }
            ++n2;
        }
        if (this.chk) {
            return;
        }
        this.vwr.setStereoMode(nArray, sTER, f);
    }

    private boolean struts() throws ScriptException {
        ScriptEval scriptEval = this.e;
        boolean bl = this.tokAt(1) == 1073742072 || this.tokAt(1) == 1073742335 || this.slen == 1;
        int n = scriptEval.getMadParameter();
        if (n == Integer.MAX_VALUE) {
            return false;
        }
        if (bl) {
            n = Math.round(this.vwr.getFloat(570425406) * 2000.0f);
        }
        this.setShapeProperty(1, "type", 32768);
        scriptEval.setShapeSizeBs(1, n, null);
        this.setShapeProperty(1, "type", 1023);
        return true;
    }

    private void unitcell(int n) throws ScriptException {
        ScriptEval scriptEval = this.e;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        T3 t3 = null;
        TickInfo tickInfo = scriptEval.tickParamAsStr(n, true, false, false);
        n = scriptEval.iToken;
        String string = null;
        T3[] t3Array = null;
        Object object = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = this.tokAt(++n);
        switch (n4) {
            case 4141: 
            case 4142: {
                bl2 = true;
                t3 = P4.new4(0.0f, 0.0f, 0.0f, -1.0f);
                scriptEval.iToken = scriptEval.iToken + 1;
                break;
            }
            case 4: 
            case 0x40000000: {
                String string3;
                string2 = string3 = this.paramAsStr(n).toLowerCase();
                if (string3.indexOf(",") >= 0 || this.chk) {
                    object = string3;
                    break;
                }
                String string4 = null;
                scriptEval.setCurrentCagePts(null, null);
                object = this.vwr.getModelInfo("unitcell_conventional");
                if (PT.isOneOf(string2, ";parent;standard;primitive;")) {
                    if (object == null && this.vwr.getModelInfo("isprimitive") != null) {
                        this.showString("Cannot convert unit cell when file data is primitive and have no lattice information");
                        return;
                    }
                    if (string2.equals("primitive") && this.tokAt(n + 1) == 4) {
                        string4 = this.paramAsStr(++n).toUpperCase();
                    }
                }
                if (object instanceof T3[]) {
                    t3Array = (T3[])object;
                }
                if (string4 == null) {
                    string4 = (String)this.vwr.getModelInfo("latticeType");
                }
                if (object != null) {
                    scriptEval.setCurrentCagePts(this.vwr.getV0abc(object), "" + object);
                }
                if (string2.equals("conventional")) break;
                string3 = (String)this.vwr.getModelInfo("unitcell_" + string2);
                if (string3 == null) {
                    boolean bl3 = string2.equals("primitive");
                    if (bl3 || string2.equals("reciprocal")) {
                        T3[] t3Array2;
                        float f = this.slen == n + 1 ? 1.0f : (this.tokAt(n + 1) == 2 ? (float)this.intParameter(++n) * (float)Math.PI : this.floatParameter(++n));
                        SymmetryInterface symmetryInterface = this.vwr.getCurrentUnitCell();
                        string2 = String.valueOf(symmetryInterface == null ? "" : String.valueOf(symmetryInterface.getSpaceGroupName()) + " ") + string2;
                        if (symmetryInterface == null) {
                            P3[] p3Array = new P3[4];
                            p3Array[0] = P3.new3(0.0f, 0.0f, 0.0f);
                            p3Array[1] = P3.new3(1.0f, 0.0f, 0.0f);
                            p3Array[2] = P3.new3(0.0f, 1.0f, 0.0f);
                            t3Array2 = p3Array;
                            p3Array[3] = P3.new3(0.0f, 0.0f, 1.0f);
                        } else {
                            t3Array2 = t3Array = symmetryInterface.getUnitCellVectors();
                        }
                        if (string4 == null) {
                            string4 = (String)this.vwr.getSymTemp().getSymmetryInfoAtom(this.vwr.ms, this.vwr.getFrameAtoms().nextSetBit(0), null, 0, null, null, null, 0x400000AA, 0.0f, -1);
                        }
                        if (symmetryInterface == null) {
                            symmetryInterface = this.vwr.getSymTemp();
                        }
                        symmetryInterface.toFromPrimitive(true, string4.length() == 0 ? (char)'P' : (char)string4.charAt(0), t3Array, (M3)this.vwr.getCurrentModelAuxInfo().get("primitiveToCrystal"));
                        if (bl3) break;
                        SimpleUnitCell.getReciprocal(t3Array, t3Array, f);
                        break;
                    }
                } else {
                    string2 = string3;
                    if (string3.indexOf(",") >= 0) {
                        object = string3;
                    }
                }
                this.showString(string2);
                break;
            }
            case 135180: 
            case 1073742330: {
                string = scriptEval.objectNameParameter(++n);
                break;
            }
            case 1678381065: {
                P3 p3 = P3.newP(this.vwr.getBoundBoxCenter());
                t3 = this.vwr.getBoundBoxCornerVector();
                p3.sub(t3);
                t3Array = new P3[]{p3, P3.new3(t3.x * 2.0f, 0.0f, 0.0f), P3.new3(0.0f, t3.y * 2.0f, 0.0f), P3.new3(0.0f, 0.0f, t3.z * 2.0f)};
                t3 = null;
                scriptEval.iToken = n;
                break;
            }
            case 1073742176: {
                if (this.tokAt(++n) != 12) {
                    this.invArg();
                }
                object = new Object[]{this.getToken((int)n).value};
                break;
            }
            case 11: 
            case 12: {
                object = this.getToken((int)n).value;
                break;
            }
            case 12289: {
                switch (this.tokAt(++n)) {
                    case 10: 
                    case 12290: 
                    case 1073742325: {
                        t3 = this.vwr.ms.getAtomSetCenter(this.atomExpressionAt(n));
                        this.vwr.toFractional(t3, true);
                        n = scriptEval.iToken;
                        break;
                    }
                    default: {
                        if (scriptEval.isCenterParameter(n)) {
                            t3 = this.centerParameter(n);
                            n = scriptEval.iToken;
                            break;
                        }
                        this.invArg();
                    }
                }
                t3.x -= 0.5f;
                t3.y -= 0.5f;
                t3.z -= 0.5f;
                break;
            }
            case 10: 
            case 12290: 
            case 1073742325: {
                int n5 = this.atomExpressionAt(n).nextSetBit(0);
                if (!this.chk) {
                    this.vwr.am.cai = n5;
                }
                if (n5 < 0) {
                    return;
                }
                n = scriptEval.iToken;
                break;
            }
            case 1073742066: {
                bl = true;
            }
            case 1073742114: {
                t3 = (T3)scriptEval.getPointOrPlane(++n, false, true, false, true, 3, 3, true);
                t3 = P4.new4(t3.x, t3.y, t3.z, bl ? 1 : 0);
                n = scriptEval.iToken;
                break;
            }
            case 2: 
            case 3: {
                float f = this.floatParameter(n);
                if (f < 111.0f) {
                    --n;
                    break;
                }
                n2 = this.intParameter(n);
                break;
            }
            default: {
                if (scriptEval.isArrayParameter(n)) {
                    t3Array = scriptEval.getPointArray(n, 4, false);
                    n = scriptEval.iToken;
                    break;
                }
                if (this.slen > n + 1) {
                    t3 = (T3)scriptEval.getPointOrPlane(n, false, true, false, true, 3, 3, true);
                    n = scriptEval.iToken;
                    break;
                }
                --n;
            }
        }
        n3 = scriptEval.getSetAxesTypeMad10(++n);
        scriptEval.checkLast(scriptEval.iToken);
        if (this.chk || n3 == Integer.MAX_VALUE) {
            return;
        }
        if (n3 == Integer.MAX_VALUE) {
            this.vwr.am.cai = -1;
        }
        if (t3Array == null && object != null) {
            t3Array = this.vwr.getV0abc(object);
        }
        if (n2 != Integer.MAX_VALUE) {
            this.vwr.ms.setUnitCellOffset(this.vwr.getCurrentUnitCell(), null, n2);
        } else if (string != null) {
            this.vwr.setCurrentCage(string);
        } else if (bl2 || t3Array != null) {
            scriptEval.setCurrentCagePts(t3Array, string2);
        }
        scriptEval.setObjectMad10(33, "unitCell", n3);
        if (t3 != null) {
            this.vwr.ms.setUnitCellOffset(this.vwr.getCurrentUnitCell(), t3, 0);
        }
        if (tickInfo != null) {
            this.setShapeProperty(33, "tickInfo", tickInfo);
        }
    }

    private void assign() throws ScriptException {
        P3 p3;
        int n = this.tokAt(1);
        int n2 = -1;
        int n3 = -1;
        if (n == 0x44000001 && this.tokAt(2) == 4) {
            this.e.iToken = this.e.iToken + 1;
        } else {
            n2 = this.atomExpressionAt(2).nextSetBit(0);
            if (n2 < 0) {
                return;
            }
        }
        String string = null;
        if (n == 4106) {
            n3 = this.atomExpressionAt(++this.e.iToken).nextSetBit(0);
        } else {
            string = this.paramAsStr(++this.e.iToken);
        }
        P3 p32 = p3 = ++this.e.iToken < this.slen ? this.centerParameter(this.e.iToken) : null;
        if (this.chk) {
            return;
        }
        this.vwr.pushState();
        switch (n) {
            case 0x44000001: {
                this.e.clearDefinedVariableAtomSets();
                this.assignAtom(n2, p3, string);
                break;
            }
            case 1677721602: {
                this.assignBond(n2, (String.valueOf(string) + "p").charAt(0));
                break;
            }
            case 4106: {
                this.assignConnect(n2, n3);
            }
        }
    }

    private void assignAtom(int n, P3 p3, String string) {
        if (string.equals("X")) {
            this.vwr.setRotateBondIndex(-1);
        }
        if (n >= 0 && this.vwr.ms.at[n].mi != this.vwr.ms.mc - 1) {
            return;
        }
        this.vwr.clearModelDependentObjects();
        int n2 = this.vwr.ms.ac;
        if (p3 == null) {
            if (n < 0) {
                return;
            }
            this.vwr.sm.modifySend(n, this.vwr.ms.at[n].mi, 1, this.e.fullCommand);
            this.vwr.ms.assignAtom(n, string, true, true);
            if (!PT.isOneOf(string, ";Mi;Pl;X;")) {
                this.vwr.ms.setAtomNamesAndNumbers(n, -n2, null);
            }
            this.vwr.sm.modifySend(n, this.vwr.ms.at[n].mi, -1, "OK");
            this.vwr.refresh(3, "assignAtom");
            return;
        }
        Atom atom = n < 0 ? null : this.vwr.ms.at[n];
        BS bS = n < 0 ? new BS() : BSUtil.newAndSetBit(n);
        P3[] p3Array = new P3[]{p3};
        Lst<Atom> lst = new Lst<Atom>();
        int n3 = -1;
        if (atom != null) {
            lst.addLast(atom);
            n3 = atom.mi;
            this.vwr.sm.modifySend(n, n3, 3, this.e.fullCommand);
        }
        try {
            bS = this.vwr.addHydrogensInline(bS, lst, p3Array);
            int n4 = bS.nextSetBit(0);
            this.vwr.ms.assignAtom(n4, string, false, n >= 0);
            n = n4;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.vwr.ms.setAtomNamesAndNumbers(n, -n2, null);
        this.vwr.sm.modifySend(n, n3, -3, "OK");
    }

    private void assignBond(int n, char c) {
        int n2 = -1;
        try {
            n2 = this.vwr.ms.bo[n].atom1.mi;
            this.vwr.sm.modifySend(n, n2, 2, this.e.fullCommand);
            BS bS = this.vwr.ms.assignBond(n, c);
            if (bS == null || c == '0') {
                this.vwr.refresh(3, "setBondOrder");
            } else {
                this.vwr.addHydrogens(bS, false, true);
            }
            this.vwr.sm.modifySend(n, n2, -2, "" + c);
        }
        catch (Exception exception) {
            Logger.error("assignBond failed");
            this.vwr.sm.modifySend(n, n2, -2, "ERROR " + exception);
        }
    }

    private void assignConnect(int n, int n2) {
        this.vwr.clearModelDependentObjects();
        float[][] fArray = AU.newFloat2(1);
        fArray[0] = new float[]{n, n2};
        short s = this.vwr.ms.at[n].mi;
        this.vwr.sm.modifySend(n, s, 2, this.e.fullCommand);
        this.vwr.ms.connect(fArray);
        this.vwr.ms.assignAtom(n, ".", true, true);
        this.vwr.ms.assignAtom(n2, ".", true, true);
        this.vwr.sm.modifySend(n, s, -2, "OK");
        this.vwr.refresh(3, "assignConnect");
    }

    private String getContext(boolean bl) {
        SB sB = new SB();
        ScriptContext scriptContext = this.e.thisContext;
        while (scriptContext != null) {
            if (bl) {
                if (scriptContext.vars != null) {
                    sB.append(this.getScriptID(scriptContext));
                    sB.append(StateManager.getVariableList(scriptContext.vars, 80, true, false));
                }
            } else {
                sB.append(ScriptError.getErrorLineMessage(scriptContext.functionName, scriptContext.scriptFileName, this.e.getLinenumber(scriptContext), scriptContext.pc, ScriptEval.statementAsString(this.vwr, scriptContext.statement, -9999, this.e.debugHigh)));
            }
            scriptContext = scriptContext.parentContext;
        }
        if (bl) {
            if (this.e.contextVariables != null) {
                sB.append(this.getScriptID(null));
                sB.append(StateManager.getVariableList(this.e.contextVariables, 80, true, false));
            }
        } else {
            sB.append(this.e.getErrorLineMessage2());
        }
        return sB.toString();
    }

    private Object getIsosurfaceJvxl(int n, String string) {
        string = string == "PMESH" || string == "MESH" ? "jvxlMeshX" : (string == "ISOMESH" ? "pmesh" : (string == "ISOMESHBIN" || string == "PMB" ? "pmeshbin" : "jvxlDataXml"));
        return this.chk ? "" : this.getShapeProperty(n, string);
    }

    private String getMoJvxl(int n, boolean bl) throws ScriptException {
        Integer n2;
        Map map;
        int n3 = bl ? 28 : 27;
        this.e.sm.loadShape(n3);
        int n4 = this.vwr.am.cmi;
        if (n4 < 0) {
            this.e.errorStr(30, "show/write MO/NBO");
        }
        if ((map = (Map)this.vwr.ms.getInfo(n4, "moData")) == null) {
            this.error(27);
        }
        if ((n2 = (Integer)this.getShapeProperty(n3, "moNumber")) == null || n2 == 0) {
            this.setShapeProperty(n3, "init", n4);
        }
        this.setShapeProperty(n3, "moData", map);
        return (String)this.e.sm.getShapePropertyIndex(n3, "showMO", n);
    }

    private String getScriptID(ScriptContext scriptContext) {
        String string = scriptContext == null ? this.e.functionName : "function " + scriptContext.functionName;
        String string2 = scriptContext == null ? this.e.scriptFileName : scriptContext.scriptFileName;
        return "\n# " + string + " (file " + string2 + (scriptContext == null ? "" : " context " + scriptContext.id) + ")\n";
    }

    private T tokenAt(int n, T[] tArray) {
        return n < tArray.length ? tArray[n] : null;
    }

    private static int tokAtArray(int n, T[] tArray) {
        return n < tArray.length && tArray[n] != null ? tArray[n].tok : 0;
    }

    private float getPlotMinMax(float[] fArray, boolean bl, int n) {
        if (fArray == null) {
            return 0.0f;
        }
        switch (n) {
            case 1111490568: 
            case 1111490569: 
            case 1111490570: {
                return bl ? 180 : -180;
            }
            case 1111490565: 
            case 1111490576: {
                return bl ? 360 : 0;
            }
            case 1111490574: {
                return bl ? 1 : -1;
            }
        }
        float f = bl ? -1.0E10f : 1.0E10f;
        int n2 = fArray.length;
        while (--n2 >= 0) {
            float f2 = fArray[n2];
            if (Float.isNaN(f2) || bl != f2 > f) continue;
            f = f2;
        }
        return f;
    }

    private Object parseDataArray(String string, boolean bl) {
        string = Parser.fixDataString(string);
        int[] nArray = Parser.markLines(string, '\n');
        int n = nArray.length;
        if (!bl) {
            float[][] fArray = AU.newFloat2(n);
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                String[] stringArray = PT.getTokens(string.substring(n3, nArray[n2]));
                fArray[n2] = new float[stringArray.length];
                PT.parseFloatArrayData(stringArray, fArray[n2]);
                n3 = nArray[n2++];
            }
            return fArray;
        }
        String[] stringArray = PT.getTokens(string.substring(0, nArray[0]));
        if (stringArray.length != 3) {
            return new float[0][0][0];
        }
        int n4 = PT.parseInt(stringArray[0]);
        int n5 = PT.parseInt(stringArray[1]);
        int n6 = PT.parseInt(stringArray[2]);
        if (n4 < 1 || n5 < 1 || n6 < 1) {
            return new float[1][1][1];
        }
        float[][][] fArray = AU.newFloat3(n4, n5);
        int n7 = 0;
        int n8 = 0;
        int n9 = 1;
        int n10 = nArray[0];
        while (n9 < n && n7 < n4) {
            stringArray = PT.getTokens(string.substring(n10, nArray[n9]));
            if (stringArray.length >= n6) {
                float[] fArray2 = new float[stringArray.length];
                fArray[n7][n8] = fArray2;
                PT.parseFloatArrayData(stringArray, fArray2);
                if (++n8 == n5) {
                    ++n7;
                    n8 = 0;
                }
            }
            n10 = nArray[n9++];
        }
        if (n7 != n4) {
            System.out.println("Error reading 3D data -- nX = " + n4 + ", but only " + n7 + " blocks read");
            return new float[1][1][1];
        }
        return fArray;
    }

    public float[] getBitsetPropertyFloat(BS bS, int n, String string, float f, float f2) throws ScriptException {
        int n2;
        Object object;
        Object object2 = object = string == null || n == 1111490843 ? this.e.getBitsetProperty(bS, (Lst)null, n, (P3)null, (P4)null, (Object)string, (Object)null, false, Integer.MAX_VALUE, false) : this.vwr.getDataObj(string, bS, 1);
        if (object == null || !AU.isAF(object)) {
            return bS == null ? null : new float[bS.cardinality()];
        }
        float[] fArray = (float[])object;
        if (!Float.isNaN(f)) {
            n2 = 0;
            while (n2 < fArray.length) {
                if (fArray[n2] < f) {
                    fArray[n2] = Float.NaN;
                }
                ++n2;
            }
        }
        if (!Float.isNaN(f2)) {
            n2 = 0;
            while (n2 < fArray.length) {
                if (fArray[n2] > f2) {
                    fArray[n2] = Float.NaN;
                }
                ++n2;
            }
        }
        return fArray;
    }
}

