/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.symmetry.CIPChirality;
import org.jmol.symmetry.CIPData;
import org.jmol.symmetry.CIPDataSmiles;
import org.jmol.symmetry.PointGroup;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SymmetryDesc;
import org.jmol.symmetry.SymmetryInfo;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.symmetry.UnitCellIterator;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.viewer.Viewer;

public class Symmetry
implements SymmetryInterface {
    private PointGroup pointGroup;
    SpaceGroup spaceGroup;
    private SymmetryInfo symmetryInfo;
    private UnitCell unitCell;
    private boolean isBio;
    private SymmetryDesc desc;
    CIPChirality cip;

    @Override
    public boolean isBio() {
        return this.isBio;
    }

    @Override
    public SymmetryInterface setPointGroup(SymmetryInterface symmetryInterface, T3 t3, T3[] t3Array, BS bS, boolean bl, float f, float f2, boolean bl2) {
        this.pointGroup = PointGroup.getPointGroup(symmetryInterface == null ? null : ((Symmetry)symmetryInterface).pointGroup, t3, t3Array, bS, bl, f, f2, bl2);
        return this;
    }

    @Override
    public String getPointGroupName() {
        return this.pointGroup.getName();
    }

    @Override
    public Object getPointGroupInfo(int n, String string, boolean bl, String string2, int n2, float f) {
        if (string == null && !bl && this.pointGroup.textInfo != null) {
            return this.pointGroup.textInfo;
        }
        if (string == null && this.pointGroup.isDrawType(string2, n2, f)) {
            return this.pointGroup.drawInfo;
        }
        if (bl && this.pointGroup.info != null) {
            return this.pointGroup.info;
        }
        return this.pointGroup.getInfo(n, string, bl, string2, n2, f);
    }

    @Override
    public void setSpaceGroup(boolean bl) {
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true, bl, false);
        }
    }

    @Override
    public int addSpaceGroupOperation(String string, int n) {
        return this.spaceGroup.addSymmetry(string, n, false);
    }

    @Override
    public int addBioMoleculeOperation(M4 m4, boolean bl) {
        this.spaceGroup.isBio = true;
        this.isBio = true;
        return this.spaceGroup.addSymmetry(String.valueOf(bl ? "!" : "") + "[[bio" + m4, 0, false);
    }

    @Override
    public void setLattice(int n) {
        this.spaceGroup.setLatticeParam(n);
    }

    @Override
    public Object getSpaceGroup() {
        return this.spaceGroup;
    }

    @Override
    public void setSpaceGroupFrom(SymmetryInterface symmetryInterface) {
        this.spaceGroup = (SpaceGroup)symmetryInterface.getSpaceGroup();
    }

    @Override
    public boolean createSpaceGroup(int n, String string, Object object, int n2) {
        this.spaceGroup = SpaceGroup.createSpaceGroup(n, string, object, n2);
        if (this.spaceGroup != null && Logger.debugging) {
            Logger.debug("using generated space group " + this.spaceGroup.dumpInfo());
        }
        return this.spaceGroup != null;
    }

    @Override
    public Object getSpaceGroupInfoObj(String string, SymmetryInterface symmetryInterface, boolean bl) {
        return SpaceGroup.getInfo(this.spaceGroup, string, symmetryInterface, bl);
    }

    @Override
    public Object getLatticeDesignation() {
        return this.spaceGroup.getLatticeDesignation();
    }

    @Override
    public void setFinalOperations(String string, P3[] p3Array, int n, int n2, boolean bl, String string2) {
        if (string != null && (string.startsWith("bio") || string.indexOf(" *(") >= 0)) {
            this.spaceGroup.name = string;
        }
        if (string2 != null) {
            Lst<SymmetryOperation> lst = new Lst<SymmetryOperation>();
            lst.addLast(this.spaceGroup.operations[0]);
            int n3 = 1;
            while (n3 < this.spaceGroup.operationCount) {
                if (string2.contains(" " + (n3 + 1) + " ")) {
                    lst.addLast(this.spaceGroup.operations[n3]);
                }
                ++n3;
            }
            this.spaceGroup = SpaceGroup.createSpaceGroup(-1, String.valueOf(string) + " *(" + string2.trim() + ")", lst, -1);
        }
        this.spaceGroup.setFinalOperations(p3Array, n, n2, bl);
    }

    @Override
    public M4 getSpaceGroupOperation(int n) {
        return this.spaceGroup == null || this.spaceGroup.operations == null || n >= this.spaceGroup.operations.length ? null : (this.spaceGroup.finalOperations == null ? this.spaceGroup.operations[n] : this.spaceGroup.finalOperations[n]);
    }

    @Override
    public String getSpaceGroupXyz(int n, boolean bl) {
        return this.spaceGroup.getXyz(n, bl);
    }

    @Override
    public void newSpaceGroupPoint(int n, P3 p3, P3 p32, int n2, int n3, int n4, M4 m4) {
        if (m4 == null && this.spaceGroup.finalOperations == null) {
            SymmetryOperation symmetryOperation = this.spaceGroup.operations[n];
            if (!symmetryOperation.isFinalized) {
                symmetryOperation.doFinalize();
            }
            SymmetryOperation.newPoint(symmetryOperation, p3, p32, n2, n3, n4);
            return;
        }
        SymmetryOperation.newPoint(m4 == null ? this.spaceGroup.finalOperations[n] : m4, p3, p32, n2, n3, n4);
    }

    @Override
    public V3[] rotateAxes(int n, V3[] v3Array, P3 p3, M3 m3) {
        return n == 0 ? v3Array : this.spaceGroup.finalOperations[n].rotateAxes(v3Array, this.unitCell, p3, m3);
    }

    @Override
    public String getSpaceGroupOperationCode(int n) {
        return this.spaceGroup.operations[n].subsystemCode;
    }

    @Override
    public void setTimeReversal(int n, int n2) {
        this.spaceGroup.operations[n].setTimeReversal(n2);
    }

    @Override
    public float getSpinOp(int n) {
        return this.spaceGroup.operations[n].getMagneticOp();
    }

    @Override
    public boolean addLatticeVectors(Lst<float[]> lst) {
        return this.spaceGroup.addLatticeVectors(lst);
    }

    @Override
    public int getLatticeOp() {
        return this.spaceGroup.latticeOp;
    }

    @Override
    public Matrix getOperationRsVs(int n) {
        return (this.spaceGroup.finalOperations == null ? this.spaceGroup.operations : this.spaceGroup.finalOperations)[n].rsvs;
    }

    @Override
    public int getSiteMultiplicity(P3 p3) {
        return this.spaceGroup.getSiteMultiplicity(p3, this.unitCell);
    }

    @Override
    public String addOp(String string, Matrix matrix, Matrix matrix2, Matrix matrix3) {
        this.spaceGroup.isSSG = true;
        String string2 = SymmetryOperation.getXYZFromRsVs(matrix, matrix2, false);
        int n = this.spaceGroup.addSymmetry(string2, -1, true);
        this.spaceGroup.operations[n].setSigma(string, matrix3);
        return string2;
    }

    @Override
    public String getMatrixFromString(String string, float[] fArray, boolean bl, int n) {
        return SymmetryOperation.getMatrixFromString(null, string, fArray, bl);
    }

    @Override
    public String getSpaceGroupName() {
        return this.symmetryInfo != null ? this.symmetryInfo.sgName : (this.spaceGroup != null ? this.spaceGroup.getName() : (this.unitCell != null && this.unitCell.name.length() > 0 ? "cell=" + this.unitCell.name : ""));
    }

    @Override
    public void setSpaceGroupName(String string) {
        if (this.spaceGroup != null) {
            this.spaceGroup.setName(string);
        }
    }

    @Override
    public int getSpaceGroupOperationCount() {
        return this.symmetryInfo != null ? this.symmetryInfo.symmetryOperations.length : (this.spaceGroup != null && this.spaceGroup.finalOperations != null ? this.spaceGroup.finalOperations.length : 0);
    }

    @Override
    public String getLatticeType() {
        return this.symmetryInfo != null ? this.symmetryInfo.latticeType : (this.spaceGroup == null ? "P" : this.spaceGroup.latticeType);
    }

    @Override
    public void setLatticeType(String string) {
        if (this.spaceGroup != null) {
            this.spaceGroup.latticeType = string;
        }
    }

    @Override
    public String getIntTableNumber() {
        return this.symmetryInfo != null ? this.symmetryInfo.intlTableNo : (this.spaceGroup == null ? null : this.spaceGroup.intlTableNumber);
    }

    @Override
    public boolean getCoordinatesAreFractional() {
        return this.symmetryInfo == null || this.symmetryInfo.coordinatesAreFractional;
    }

    @Override
    public int[] getCellRange() {
        return this.symmetryInfo == null ? null : this.symmetryInfo.cellRange;
    }

    @Override
    public String getSymmetryInfoStr() {
        return this.symmetryInfo == null ? "" : this.symmetryInfo.infoStr;
    }

    @Override
    public M4[] getSymmetryOperations() {
        if (this.symmetryInfo != null) {
            return this.symmetryInfo.symmetryOperations;
        }
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true, false, true);
        }
        return this.spaceGroup.finalOperations;
    }

    @Override
    public boolean isSimple() {
        return this.symmetryInfo == null || this.symmetryInfo.symmetryOperations == null;
    }

    @Override
    public SymmetryInterface setSymmetryInfo(int n, Map<String, Object> map, float[] fArray) {
        this.symmetryInfo = new SymmetryInfo();
        float[] fArray2 = this.symmetryInfo.setSymmetryInfo(map, fArray);
        if (fArray2 != null) {
            this.setUnitCell(fArray2, map.containsKey("jmolData"));
            this.unitCell.moreInfo = (Lst)map.get("moreUnitCellInfo");
            map.put("infoUnitCell", this.getUnitCellAsArray(false));
            this.setOffsetPt((T3)map.get("unitCellOffset"));
            M3 m3 = (M3)map.get("matUnitCellOrientation");
            if (m3 != null) {
                this.initializeOrientation(m3);
            }
            if (Logger.debugging) {
                Logger.debug("symmetryInfos[" + n + "]:\n" + this.unitCell.dumpInfo(true));
            }
        }
        return this;
    }

    @Override
    public boolean haveUnitCell() {
        return this.unitCell != null;
    }

    @Override
    public boolean checkUnitCell(SymmetryInterface symmetryInterface, P3 p3, P3 p32, boolean bl) {
        symmetryInterface.toFractional(p32, bl);
        return p32.x >= p3.x - 1.0f - 0.02f && p32.x <= p3.x + 0.02f && p32.y >= p3.y - 1.0f - 0.02f && p32.y <= p3.y + 0.02f && p32.z >= p3.z - 1.0f - 0.02f && p32.z <= p3.z + 0.02f;
    }

    @Override
    public void setUnitCell(float[] fArray, boolean bl) {
        this.unitCell = UnitCell.fromParams(fArray, bl);
    }

    @Override
    public boolean unitCellEquals(SymmetryInterface symmetryInterface) {
        return ((Symmetry)symmetryInterface).unitCell.isSameAs(this.unitCell);
    }

    @Override
    public String getUnitCellState() {
        return this.unitCell == null ? "" : this.unitCell.getState();
    }

    @Override
    public Lst<String> getMoreInfo() {
        return this.unitCell.moreInfo;
    }

    public String getUnitsymmetryInfo() {
        return this.unitCell.dumpInfo(false);
    }

    @Override
    public void initializeOrientation(M3 m3) {
        this.unitCell.initOrientation(m3);
    }

    @Override
    public void unitize(T3 t3) {
        this.unitCell.unitize(t3);
    }

    @Override
    public void toUnitCell(T3 t3, T3 t32) {
        this.unitCell.toUnitCell(t3, t32);
    }

    @Override
    public P3 toSupercell(P3 p3) {
        return this.unitCell.toSupercell(p3);
    }

    @Override
    public void toFractional(T3 t3, boolean bl) {
        if (!this.isBio) {
            this.unitCell.toFractional(t3, bl);
        }
    }

    @Override
    public void toFractionalM(M4 m4) {
        if (!this.isBio) {
            this.unitCell.toFractionalM(m4);
        }
    }

    @Override
    public void toCartesian(T3 t3, boolean bl) {
        if (!this.isBio) {
            this.unitCell.toCartesian(t3, bl);
        }
    }

    @Override
    public float[] getUnitCellParams() {
        return this.unitCell.getUnitCellParams();
    }

    @Override
    public float[] getUnitCellAsArray(boolean bl) {
        return this.unitCell.getUnitCellAsArray(bl);
    }

    @Override
    public Tensor getTensor(Viewer viewer, float[] fArray) {
        if (fArray == null) {
            return null;
        }
        if (this.unitCell == null) {
            this.unitCell = UnitCell.fromParams(new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f}, true);
        }
        return this.unitCell.getTensor(viewer, fArray);
    }

    @Override
    public P3[] getUnitCellVerticesNoOffset() {
        return this.unitCell.getVertices();
    }

    @Override
    public P3 getCartesianOffset() {
        return this.unitCell.getCartesianOffset();
    }

    @Override
    public P3 getFractionalOffset() {
        return this.unitCell.getFractionalOffset();
    }

    @Override
    public void setOffsetPt(T3 t3) {
        this.unitCell.setOffset(t3);
    }

    @Override
    public void setOffset(int n) {
        P3 p3 = new P3();
        SimpleUnitCell.ijkToPoint3f(n, p3, 0, 0);
        this.unitCell.setOffset(p3);
    }

    @Override
    public T3 getUnitCellMultiplier() {
        return this.unitCell.getUnitCellMultiplier();
    }

    @Override
    public P3[] getCanonicalCopy(float f, boolean bl) {
        return this.unitCell.getCanonicalCopy(f, bl);
    }

    @Override
    public float getUnitCellInfoType(int n) {
        return this.unitCell.getInfo(n);
    }

    @Override
    public String getUnitCellInfo() {
        return this.unitCell.dumpInfo(false);
    }

    @Override
    public boolean isSlab() {
        return this.unitCell.isSlab();
    }

    @Override
    public boolean isPolymer() {
        return this.unitCell.isPolymer();
    }

    @Override
    public boolean checkDistance(P3 p3, P3 p32, float f, float f2, int n, int n2, int n3, P3 p33) {
        return this.unitCell.checkDistance(p3, p32, f, f2, n, n2, n3, p33);
    }

    @Override
    public P3[] getUnitCellVectors() {
        return this.unitCell.getUnitCellVectors();
    }

    @Override
    public SymmetryInterface getUnitCell(T3[] t3Array, boolean bl, String string) {
        if (t3Array == null) {
            return null;
        }
        this.unitCell = UnitCell.fromOABC(t3Array, bl);
        if (string != null) {
            this.unitCell.name = string;
        }
        return this;
    }

    @Override
    public boolean isSupercell() {
        return this.unitCell.isSupercell();
    }

    @Override
    public BS notInCentroid(ModelSet modelSet, BS bS, int[] nArray) {
        try {
            BS bS2 = new BS();
            int n = bS.nextSetBit(0);
            JmolMolecule[] jmolMoleculeArray = modelSet.getMolecules();
            int n2 = jmolMoleculeArray.length;
            Atom[] atomArray = modelSet.at;
            boolean bl = jmolMoleculeArray[n2 - 1].firstAtomIndex == modelSet.am[atomArray[n].mi].firstAtomIndex;
            P3 p3 = new P3();
            boolean bl2 = nArray[6] == 1;
            int n3 = n2;
            block2: while (--n3 >= 0 && bS.get(jmolMoleculeArray[n3].firstAtomIndex)) {
                BS bS3 = jmolMoleculeArray[n3].atomList;
                p3.set(0.0f, 0.0f, 0.0f);
                int n4 = 0;
                int n5 = bS3.nextSetBit(0);
                while (n5 >= 0) {
                    if (bl || bl2) {
                        p3.setT(atomArray[n5]);
                        if (this.isNotCentroid(p3, 1, nArray, bl2)) {
                            if (bl) {
                                bS2.set(n5);
                            }
                        } else if (!bl) {
                            continue block2;
                        }
                    } else {
                        p3.add(atomArray[n5]);
                        ++n4;
                    }
                    n5 = bS3.nextSetBit(n5 + 1);
                }
                if (!bl2 && (n4 <= 0 || !this.isNotCentroid(p3, n4, nArray, false))) continue;
                bS2.or(bS3);
            }
            return bS2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isNotCentroid(P3 p3, int n, int[] nArray, boolean bl) {
        p3.scale(1.0f / (float)n);
        this.toFractional(p3, false);
        if (bl) {
            return p3.x + 5.0E-6f <= (float)nArray[0] || p3.x - 5.0E-6f > (float)nArray[3] || p3.y + 5.0E-6f <= (float)nArray[1] || p3.y - 5.0E-6f > (float)nArray[4] || p3.z + 5.0E-6f <= (float)nArray[2] || p3.z - 5.0E-6f > (float)nArray[5];
        }
        return p3.x + 5.0E-6f <= (float)nArray[0] || p3.x + 5.0E-5f > (float)nArray[3] || p3.y + 5.0E-6f <= (float)nArray[1] || p3.y + 5.0E-5f > (float)nArray[4] || p3.z + 5.0E-6f <= (float)nArray[2] || p3.z + 5.0E-5f > (float)nArray[5];
    }

    private SymmetryDesc getDesc(ModelSet modelSet) {
        return (this.desc == null ? (this.desc = (SymmetryDesc)Interface.getInterface("org.jmol.symmetry.SymmetryDesc", modelSet.vwr, "eval")) : this.desc).set(modelSet);
    }

    @Override
    public Object getSymmetryInfoAtom(ModelSet modelSet, int n, String string, int n2, P3 p3, P3 p32, String string2, int n3, float f, int n4) {
        return this.getDesc(modelSet).getSymopInfo(n, string, n2, p3, p32, string2, n3, f, n4);
    }

    @Override
    public Map<String, Object> getSpaceGroupInfo(ModelSet modelSet, String string, int n, boolean bl) {
        Map<String, Object> map;
        boolean bl2;
        boolean bl3 = bl2 = string == null;
        if (string == null && (map = modelSet.getModelAuxiliaryInfo(modelSet.vwr.am.cmi)) != null) {
            string = (String)map.get("spaceGroup");
        }
        return this.getDesc(modelSet).getSpaceGroupInfo(this, n, string, 0, null, null, null, 0.0f, -1, bl, bl2);
    }

    @Override
    public String fcoord(T3 t3) {
        return SymmetryOperation.fcoord(t3);
    }

    @Override
    public T3[] getV0abc(Object object) {
        return this.unitCell == null ? null : this.unitCell.getV0abc(object);
    }

    @Override
    public Quat getQuaternionRotation(String string) {
        return this.unitCell == null ? null : this.unitCell.getQuaternionRotation(string);
    }

    @Override
    public T3 getFractionalOrigin() {
        return this.unitCell.getFractionalOrigin();
    }

    @Override
    public boolean getState(SB sB) {
        T3 t3 = this.getFractionalOffset();
        boolean bl = false;
        if (t3 != null && (t3.x != 0.0f || t3.y != 0.0f || t3.z != 0.0f)) {
            sB.append("; set unitcell ").append(Escape.eP(t3));
            bl = true;
        }
        if ((t3 = this.getUnitCellMultiplier()) != null) {
            sB.append("; set unitcell ").append(SimpleUnitCell.escapeMultiplier(t3));
            bl = true;
        }
        return bl;
    }

    @Override
    public AtomIndexIterator getIterator(Viewer viewer, Atom atom, Atom[] atomArray, BS bS, float f) {
        return ((UnitCellIterator)Interface.getInterface("org.jmol.symmetry.UnitCellIterator", viewer, "script")).set(this, atom, atomArray, bS, f);
    }

    @Override
    public boolean toFromPrimitive(boolean bl, char c, T3[] t3Array, M3 m3) {
        if (this.unitCell == null) {
            this.unitCell = UnitCell.fromOABC(t3Array, false);
        }
        return this.unitCell.toFromPrimitive(bl, c, t3Array, m3);
    }

    @Override
    public Lst<P3> generateCrystalClass(P3 p3) {
        M4[] m4Array = this.getSymmetryOperations();
        Lst<P3> lst = new Lst<P3>();
        boolean bl = p3 == null;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (bl) {
            f = (float)Math.E;
            f2 = (float)Math.PI;
            f3 = (float)Math.log10(2000.0);
            p3 = P3.new3(f + 1.0f, f2 + 2.0f, f3 + 3.0f);
        } else {
            p3 = P3.newP(p3);
        }
        if (m4Array == null || this.unitCell == null) {
            lst.addLast(p3);
        } else {
            this.unitCell.toFractional(p3, true);
            P3 p32 = null;
            P3 p33 = null;
            P3 p34 = null;
            if (bl) {
                p32 = P3.new3(f2 + 4.0f, f3 + 5.0f, f + 6.0f);
                this.unitCell.toFractional(p32, true);
                p33 = P3.new3(f3 + 7.0f, f + 8.0f, f2 + 9.0f);
                this.unitCell.toFractional(p33, true);
            }
            Bspt bspt = new Bspt(3, 0);
            CubeIterator cubeIterator = bspt.allocateCubeIterator();
            P3 p35 = new P3();
            int n = m4Array.length;
            while (--n >= 0) {
                m4Array[n].rotate2(p3, p35);
                cubeIterator.initialize(p35, 0.001f, false);
                if (cubeIterator.hasMoreElements()) continue;
                P3 p36 = P3.newP(p35);
                lst.addLast(p36);
                bspt.addTuple(p36);
                if (!bl) continue;
                if (p33 != null) {
                    p34 = new P3();
                    m4Array[n].rotate2(p33, p34);
                    lst.addLast(p34);
                }
                if (p32 == null) continue;
                p34 = new P3();
                m4Array[n].rotate2(p32, p34);
                lst.addLast(p34);
            }
            n = lst.size();
            while (--n >= 0) {
                this.unitCell.toCartesian((T3)lst.get(n), true);
            }
        }
        return lst;
    }

    @Override
    public void calculateCIPChiralityForAtoms(Viewer viewer, BS bS) {
        viewer.setCursor(3);
        CIPChirality cIPChirality = this.getCIPChirality(viewer);
        String string = viewer.getBoolean(603979960) ? "CIPData" : "CIPDataTracker";
        CIPData cIPData = ((CIPData)Interface.getInterface("org.jmol.symmetry." + string, viewer, "script")).set(viewer, bS);
        cIPData.setRule6Full(viewer.getBoolean(603979823));
        cIPChirality.getChiralityForAtoms(cIPData);
        viewer.setCursor(0);
    }

    @Override
    public String[] calculateCIPChiralityForSmiles(Viewer viewer, String string) throws Exception {
        viewer.setCursor(3);
        CIPChirality cIPChirality = this.getCIPChirality(viewer);
        CIPDataSmiles cIPDataSmiles = ((CIPDataSmiles)Interface.getInterface("org.jmol.symmetry.CIPDataSmiles", viewer, "script")).setAtomsForSmiles(viewer, string);
        cIPChirality.getChiralityForAtoms(cIPDataSmiles);
        viewer.setCursor(0);
        return cIPDataSmiles.getSmilesChiralityArray();
    }

    private CIPChirality getCIPChirality(Viewer viewer) {
        return this.cip == null ? (this.cip = (CIPChirality)Interface.getInterface("org.jmol.symmetry.CIPChirality", viewer, "script")) : this.cip;
    }

    @Override
    public T3[] getConventionalUnitCell(String string, M3 m3) {
        return this.unitCell == null || string == null ? null : this.unitCell.getConventionalUnitCell(string, m3);
    }

    @Override
    public Map<String, Object> getUnitCellInfoMap() {
        return this.unitCell == null ? null : this.unitCell.getInfo();
    }
}

