export declare class TransportConfig {
    publicKey: string;
    secretKey: string;
    appName: string;
    serverName?: string;
    sendLogs: Boolean;
}
export declare class Actions {
    action_name: string;
    action_type: string;
    opts?: Object;
}
export declare class Process {
    axm_actions: Actions[];
    axm_monitor: Object;
    axm_options: Object;
    axm_dynamic?: Object;
    interpreter?: string;
    versionning?: Object;
}
export declare class Transport {
    send: Function;
    disconnect: Function;
    on: Function;
}
export declare class Agent {
    transport: Transport;
    send: Function;
    start: Function;
    sendLogs: Boolean;
}
export default class TransportService {
    private config;
    private agent;
    private transport;
    private process;
    private isStandalone;
    private initiated;
    init(): void;
    initStandalone(config: TransportConfig): Promise<any>;
    setMetrics(metrics: any): any;
    addAction(action: any): number;
    setOptions(options: any): any;
    getFormattedPayload(channel: any, payload: any): any;
    send(channel: any, payload: any): 0 | -1;
    destroy(): void;
}
