import PMX from '../pmx';
export default class Entrypoint extends PMX {
    defaultConf: {
        metrics: {
            eventLoopActive: boolean;
            eventLoopDelay: boolean;
            network: {
                traffic: boolean;
                ports: boolean;
            };
            transaction: {
                http: boolean;
                tracing: boolean;
            };
            deepMetrics: boolean;
            v8: boolean;
        };
        actions: {
            eventLoopDump: boolean;
            profilingCpu: boolean;
            profilingHeap: boolean;
        };
    };
    private io;
    constructor();
    events(): void;
    sensors(): void;
    actuators(): void;
    onStart(cb: Function): void;
    onStop(err: Error, cb: Function, code: number, signal: string): void;
    conf(): {
        metrics: {
            eventLoopActive: boolean;
            eventLoopDelay: boolean;
            network: {
                traffic: boolean;
                ports: boolean;
            };
            transaction: {
                http: boolean;
                tracing: boolean;
            };
            deepMetrics: boolean;
            v8: boolean;
        };
        actions: {
            eventLoopDump: boolean;
            profilingCpu: boolean;
            profilingHeap: boolean;
        };
    };
}
