/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.javafx.font.FontStrike;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseContext;
import com.sun.prism.impl.BufferUtil;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.packrect.BackingStoreManager;
import com.sun.prism.impl.packrect.Rect;
import com.sun.prism.impl.packrect.RectanglePacker;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.ShapeUtil;
import com.sun.prism.paint.Color;
import com.sun.t2k.CharToGlyphMapper;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.WeakHashMap;

public class GlyphCache {
    private static final int WIDTH = 1024;
    private static final int HEIGHT = 1024;
    private static ByteBuffer emptyMask;
    private final BaseContext context;
    private final FontStrike strike;
    private static final int SEGSHIFT = 5;
    private static final int SEGSIZE = 32;
    HashMap<Integer, GlyphData[]> glyphDataMap = new HashMap();
    private RectanglePacker packer;
    private boolean isLCDCache;
    private int numAllocatedGlyphs = 0;
    static WeakHashMap<BaseContext, RectanglePacker> greyPackerMap;
    static WeakHashMap<BaseContext, RectanglePacker> lcdPackerMap;
    private char[] charData = null;
    private int[] glyphData = null;

    public GlyphCache(BaseContext baseContext, FontStrike fontStrike) {
        this.context = baseContext;
        this.strike = fontStrike;
        this.isLCDCache = fontStrike.getAAMode() == 1;
        WeakHashMap<BaseContext, RectanglePacker> weakHashMap = this.isLCDCache ? lcdPackerMap : greyPackerMap;
        this.packer = weakHashMap.get(baseContext);
        if (this.packer == null) {
            GlyphManager glyphManager = new GlyphManager();
            this.packer = new RectanglePacker(glyphManager, 1024, 1024);
            weakHashMap.put(baseContext, this.packer);
        }
    }

    int[] getGlyphCodes(String string) {
        int n = string.length();
        if (this.glyphData == null || this.glyphData.length < n) {
            this.charData = new char[n];
            this.glyphData = new int[n];
        }
        string.getChars(0, n, this.charData, 0);
        CharToGlyphMapper charToGlyphMapper = this.strike.getFontResource().getGlyphMapper();
        charToGlyphMapper.charsToGlyphs(n, this.charData, this.glyphData);
        return this.glyphData;
    }

    public boolean isLCDCache() {
        return this.isLCDCache;
    }

    public void render(BaseContext baseContext, String string, float f, float f2) {
        int n;
        int n2;
        if (this.isLCDCache) {
            n2 = baseContext.getLCDBuffer().getPhysicalWidth();
            n = baseContext.getLCDBuffer().getPhysicalHeight();
        } else {
            n2 = 1;
            n = 1;
        }
        int n3 = string.length();
        float f3 = f;
        float f4 = f2;
        Texture texture = this.getBackingStore();
        VertexBuffer vertexBuffer = baseContext.getVertexBuffer();
        int[] nArray = this.getGlyphCodes(string);
        for (int i = 0; i < n3; ++i) {
            GlyphData glyphData;
            if (nArray[i] == 65535 || (glyphData = this.getCachedGlyph(nArray[i])) == null) continue;
            this.addDataToQuad(glyphData, vertexBuffer, texture, f3, f4, n2, n);
            f3 += glyphData.getXAdvance();
            f4 += glyphData.getYAdvance();
        }
    }

    public void renderWithColorRange(BaseContext baseContext, String string, float f, float f2, int n, int n2, Color color, Color color2) {
        int n3;
        int n4;
        if (this.isLCDCache) {
            n4 = baseContext.getLCDBuffer().getPhysicalWidth();
            n3 = baseContext.getLCDBuffer().getPhysicalHeight();
        } else {
            n4 = 1;
            n3 = 1;
        }
        int n5 = string.length();
        float f3 = f;
        float f4 = f2;
        Texture texture = this.getBackingStore();
        VertexBuffer vertexBuffer = baseContext.getVertexBuffer();
        int[] nArray = this.getGlyphCodes(string);
        if (n < 0 && 0 < n2) {
            vertexBuffer.setPerVertexColor(color, 1.0f);
        }
        for (int i = 0; i < n5; ++i) {
            GlyphData glyphData;
            if (n == i) {
                vertexBuffer.setPerVertexColor(color, 1.0f);
            } else if (color2 != null && i == n2) {
                vertexBuffer.setPerVertexColor(color2, 1.0f);
            }
            if (nArray[i] == 65535 || (glyphData = this.getCachedGlyph(nArray[i])) == null) continue;
            this.addDataToQuad(glyphData, vertexBuffer, texture, f3, f4, n4, n3);
            f3 += glyphData.getXAdvance();
            f4 += glyphData.getYAdvance();
        }
    }

    private void addDataToQuad(GlyphData glyphData, VertexBuffer vertexBuffer, Texture texture, float f, float f2, float f3, float f4) {
        f2 = Math.round(f2);
        Rect rect = glyphData.getRect();
        if (rect == null) {
            return;
        }
        int n = glyphData.getBlankBoundary();
        float f5 = rect.w() - n * 2;
        float f6 = rect.h() - n * 2;
        float f7 = (float)glyphData.getOriginX() + f;
        float f8 = (float)glyphData.getOriginY() + f2;
        float f9 = f8 + f6;
        float f10 = texture.getPhysicalWidth();
        float f11 = texture.getPhysicalHeight();
        float f12 = (float)(rect.x() + n) / f10;
        float f13 = (float)(rect.y() + n) / f11;
        float f14 = f12 + f5 / f10;
        float f15 = f13 + f6 / f11;
        if (this.isLCDCache) {
            f7 = (float)Math.round(f7 * 3.0f) / 3.0f;
            float f16 = f7 + f5 / 3.0f;
            float f17 = f7 / f3;
            float f18 = f16 / f3;
            float f19 = f8 / f4;
            float f20 = f9 / f4;
            vertexBuffer.addQuad(f7, f8, f16, f9, f12, f13, f14, f15, f17, f19, f18, f20);
        } else {
            f7 = Math.round(f7);
            float f21 = f7 + f5;
            vertexBuffer.addQuad(f7, f8, f21, f9, f12, f13, f14, f15);
        }
    }

    public Texture getBackingStore() {
        return (Texture)this.packer.getBackingStore();
    }

    public void clear() {
        this.glyphDataMap.clear();
        this.numAllocatedGlyphs = 0;
    }

    public int getNumAllocatedGlyphs() {
        return this.numAllocatedGlyphs;
    }

    private void clearAll() {
        this.context.flushVertexBuffer();
        this.context.clearGlyphCaches();
        this.packer.clear();
    }

    private boolean isEmptyGlyph(FontStrike.Glyph glyph) {
        if (!this.strike.supportsGlyphImages()) {
            return glyph.getBBox().isEmpty();
        }
        return glyph.getWidth() == 0 || glyph.getHeight() == 0;
    }

    private GlyphData getCachedGlyph(int n) {
        int n2 = n >> 5;
        int n3 = n % 32;
        GlyphData[] glyphDataArray = this.glyphDataMap.get(n2);
        if (glyphDataArray != null) {
            if (glyphDataArray[n3] != null) {
                return glyphDataArray[n3];
            }
        } else {
            glyphDataArray = new GlyphData[32];
            this.glyphDataMap.put(n2, glyphDataArray);
        }
        GlyphData glyphData = null;
        FontStrike.Glyph glyph = this.strike.getGlyph(n);
        if (glyph != null) {
            if (this.isEmptyGlyph(glyph)) {
                glyphData = new GlyphData(0, 0, 0, glyph.getPixelXAdvance(), glyph.getPixelYAdvance(), null);
            } else {
                MaskData maskData = this.strike.supportsGlyphImages() ? MaskData.create(glyph.getPixelData(), glyph.getOriginX(), glyph.getOriginY(), glyph.getWidth(), glyph.getHeight()) : ShapeUtil.rasterizeGlyphOutline(glyph.getShape());
                int n4 = 1;
                int n5 = maskData.getWidth() + 2 * n4;
                int n6 = maskData.getHeight() + 2 * n4;
                int n7 = maskData.getOriginX();
                int n8 = maskData.getOriginY();
                Rect rect = new Rect(0, 0, n5, n6);
                glyphData = new GlyphData(n7, n8, n4, glyph.getPixelXAdvance(), glyph.getPixelYAdvance(), rect);
                if (!this.packer.add(rect)) {
                    this.clearAll();
                    this.packer.add(rect);
                }
                boolean bl = true;
                Texture texture = this.getBackingStore();
                int n9 = rect.w();
                int n10 = rect.h();
                int n11 = texture.getPixelFormat().getBytesPerPixelUnit();
                int n12 = n9 * n11;
                int n13 = n12 * n10;
                if (emptyMask == null || n13 > emptyMask.capacity()) {
                    emptyMask = BufferUtil.newByteBuffer(n13);
                }
                try {
                    texture.update(emptyMask, texture.getPixelFormat(), rect.x(), rect.y(), 0, 0, n9, n10, n12, bl);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
                maskData.uploadToTexture(texture, n4 + rect.x(), n4 + rect.y(), bl);
            }
            glyphDataArray[n3] = glyphData;
            ++this.numAllocatedGlyphs;
        }
        return glyphData;
    }

    static {
        greyPackerMap = new WeakHashMap();
        lcdPackerMap = new WeakHashMap();
    }

    static class GlyphData {
        private final int originX;
        private final int originY;
        private final int blankBoundary;
        private final float xAdvance;
        private final float yAdvance;
        private final Rect rect;

        GlyphData(int n, int n2, int n3, float f, float f2, Rect rect) {
            this.originX = n;
            this.originY = n2;
            this.blankBoundary = n3;
            this.xAdvance = f;
            this.yAdvance = f2;
            this.rect = rect;
        }

        int getOriginX() {
            return this.originX;
        }

        int getOriginY() {
            return this.originY;
        }

        int getBlankBoundary() {
            return this.blankBoundary;
        }

        float getXAdvance() {
            return this.xAdvance;
        }

        float getYAdvance() {
            return this.yAdvance;
        }

        Rect getRect() {
            return this.rect;
        }
    }

    class GlyphManager
    implements BackingStoreManager {
        GlyphManager() {
        }

        @Override
        public Texture allocateBackingStore(int n, int n2) {
            Texture texture = GlyphCache.this.context.getResourceFactory().createMaskTexture(n, n2);
            texture.setLinearFiltering(false);
            return texture;
        }

        @Override
        public void deleteBackingStore(Object object) {
            if (object != null) {
                ((Texture)object).dispose();
            }
        }
    }
}

