/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.Unit;

public class ScaleBar
extends JPanel {
    private int _zoomLevel = -1;
    private double _yPos = 0.0;
    private static final int LEFT_OFFSET = 20;
    private static final int Y_OFFSET = 10;
    private static final int TICK_HEIGHT = 5;
    private static final int MARGIN_WIDTH = 8;
    private static final int[] _scales = new int[]{10000, 5000, 2000, 2000, 1000, 500, 200, 100, 50, 20, 10, 5, 2, 2, 1, -2, -5, -10, -20, -50, -100, -200};
    private static final double[] _metricPixels = new double[]{64.0, 64.0, 51.0, 102.0, 102.0, 102.0, 81.0, 81.0, 81.0, 65.0, 65.0, 65.0, 52.0, 105.0, 105.0, 105.0, 83.0, 83.0, 83.0, 67.0, 67.0, 67.0};

    public ScaleBar() {
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(100, 20));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._zoomLevel > -1) {
            try {
                int n;
                double d = Config.getUnitSet().getDistanceUnit().getMultFactorFromStd();
                double d2 = 20.0 + _metricPixels[this._zoomLevel] / 1000.0 / d;
                int n2 = _scales[this._zoomLevel];
                double d3 = Math.PI * (1.0 - 2.0 * this._yPos);
                double d4 = Math.atan(Math.sinh(d3));
                double d5 = Math.cos(d4);
                for (n = (int)(d2 / d5); n > 300; n /= 2) {
                    if ((n2 /= 2) >= 1) continue;
                    return;
                }
                if (n < 1) {
                    return;
                }
                Color color = Config.getColourScheme().getColour(3);
                Color color2 = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
                graphics.setColor(color2);
                graphics.drawLine(20, 9, n + 2, 9);
                graphics.drawLine(20, 12, n + 2, 12);
                graphics.drawLine(19, 12, 19, 5);
                graphics.drawLine(22, 12, 22, 5);
                graphics.drawLine(n - 1, 12, n - 1, 5);
                graphics.drawLine(n + 2, 12, n + 2, 5);
                graphics.setColor(color);
                graphics.drawLine(20, 10, n, 10);
                graphics.drawLine(20, 11, n, 11);
                graphics.drawLine(20, 10, 20, 5);
                graphics.drawLine(21, 10, 21, 5);
                graphics.drawLine(n, 11, n, 5);
                graphics.drawLine(n + 1, 11, n + 1, 5);
                String string = ScaleBar.getScaleText(n2, Config.getUnitSet().getDistanceUnit());
                graphics.setColor(color2);
                graphics.drawString(string, n + 8 - 1, 10);
                graphics.drawString(string, n + 8 + 1, 10);
                graphics.drawString(string, n + 8, 9);
                graphics.drawString(string, n + 8, 11);
                graphics.setColor(color);
                graphics.drawString(string, n + 8, 10);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
    }

    private static String getScaleText(int n, Unit unit) {
        if (n > 0) {
            return n + " " + I18nManager.getText(unit.getShortnameKey());
        }
        return -1.0 / (double)n + " " + I18nManager.getText(unit.getShortnameKey());
    }

    public void updateScale(int n, double d) {
        this._zoomLevel = n;
        this._yPos = d;
    }
}

