/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import javajs.util.Lst;
import org.jmol.adapter.readers.more.ForceFieldReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;

public class MdTopReader
extends ForceFieldReader {
    private int nAtoms = 0;
    private int ac = 0;
    private String[] atomTypes;
    String[] group3s;

    @Override
    protected void initializeReader() throws Exception {
        this.setIsPDB();
        this.setUserAtomTypes();
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("%FLAG ") != 0) {
            return true;
        }
        this.line = this.line.substring(6).trim();
        if (this.line.equals("POINTERS")) {
            this.getPointers();
        } else if (this.line.equals("ATOM_NAME")) {
            this.getAtomNames();
        } else if (this.line.equals("CHARGE")) {
            this.getCharges();
        } else if (this.line.equals("RESIDUE_LABEL")) {
            this.getResidueLabels();
        } else if (this.line.equals("RESIDUE_POINTER")) {
            this.getResiduePointers();
        } else if (this.line.equals("AMBER_ATOM_TYPE")) {
            this.getAtomTypes();
        } else if (this.line.equals("MASS")) {
            this.getMasses();
        }
        return false;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.finalizeReaderASCR();
        Atom[] atomArray = this.asc.atoms;
        int n = 0;
        while (n < this.ac) {
            Atom atom = atomArray[n];
            atom.isHetero = this.vwr.getJBR().isHetero(atom.group3);
            String string = this.atomTypes[n];
            if (!this.getElementSymbol(atom, string)) {
                atom.elementSymbol = MdTopReader.deducePdbElementSymbol(atom.isHetero, atom.atomName, atom.group3);
            }
            ++n;
        }
        Atom[] atomArray2 = null;
        if (this.filter == null) {
            this.nAtoms = this.ac;
        } else {
            atomArray2 = new Atom[atomArray.length];
            this.nAtoms = 0;
            int n2 = 0;
            while (n2 < this.ac) {
                if (this.filterAtom(atomArray[n2], n2)) {
                    atomArray2[this.nAtoms++] = atomArray[n2];
                }
                ++n2;
            }
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < this.ac) {
            if (this.filter == null || this.bsFilter.get(n3)) {
                if (n5 % 100 == 0) {
                    ++n4;
                }
                this.setAtomCoordXYZ(atomArray[n3], n3 % 100 * 2, n4 * 2, 0.0f);
            }
            ++n3;
        }
        if (atomArray2 != null) {
            this.discardPreviousAtoms();
            n3 = 0;
            while (n3 < this.nAtoms) {
                this.asc.addAtom(atomArray2[n3]);
                ++n3;
            }
        }
        Logger.info("Total number of atoms used=" + this.nAtoms);
        this.setModelPDB(true);
        this.htParams.put("defaultType", "mdcrd");
    }

    private String[] getDataBlock() throws Exception {
        Lst<String> lst = new Lst<String>();
        this.discardLinesUntilContains("FORMAT");
        int n = (Integer)MdTopReader.getFortranFormatLengths(this.line.substring(this.line.indexOf("("))).get(0);
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n2 >= n3) {
                if (this.rd() == null) break;
                n2 = 0;
                n3 = this.line.length();
                if (n3 == 0 || this.line.indexOf("FLAG") >= 0) break;
            }
            lst.addLast(this.line.substring(n2, n2 + n).trim());
            n2 += n;
        }
        return lst.toArray(new String[lst.size()]);
    }

    private void getPointers() throws Exception {
        boolean bl;
        String[] stringArray = this.getDataBlock();
        this.ac = this.parseIntStr(stringArray[0]);
        boolean bl2 = bl = stringArray[27].charAt(0) != '0';
        if (bl) {
            Logger.info("Periodic type: " + stringArray[27]);
            this.htParams.put("isPeriodic", Boolean.TRUE);
        }
        Logger.info("Total number of atoms read=" + this.ac);
        this.htParams.put("templateAtomCount", this.ac);
        int n = 0;
        while (n < this.ac) {
            this.asc.addAtom(new Atom());
            ++n;
        }
    }

    private void getAtomTypes() throws Exception {
        this.atomTypes = this.getDataBlock();
    }

    private void getCharges() throws Exception {
        String[] stringArray = this.getDataBlock();
        if (stringArray.length != this.ac) {
            return;
        }
        Atom[] atomArray = this.asc.atoms;
        int n = this.ac;
        while (--n >= 0) {
            atomArray[n].partialCharge = this.parseFloatStr(stringArray[n]);
        }
    }

    private void getResiduePointers() throws Exception {
        String[] stringArray = this.getDataBlock();
        Logger.info("Total number of residues=" + stringArray.length);
        int n = this.ac;
        Atom[] atomArray = this.asc.atoms;
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            int n3;
            int n4 = n3 = this.parseIntStr(stringArray[n2]) - 1;
            while (n4 < n) {
                if (this.group3s != null) {
                    atomArray[n4].group3 = this.group3s[n2];
                }
                atomArray[n4++].sequenceNumber = n2 + 1;
            }
            n = n3;
        }
    }

    private void getResidueLabels() throws Exception {
        this.group3s = this.getDataBlock();
    }

    private void getAtomNames() throws Exception {
        String[] stringArray = this.getDataBlock();
        Atom[] atomArray = this.asc.atoms;
        int n = 0;
        while (n < this.ac) {
            atomArray[n].atomName = stringArray[n];
            ++n;
        }
    }

    private void getMasses() throws Exception {
    }
}

