/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.SB;
import org.jmol.jvxl.data.JvxlCoder;

public class JvxlData {
    public String msg = "";
    public boolean wasJvxl;
    public boolean wasCubic;
    public String jvxlFileTitle;
    public String jvxlFileMessage;
    public String jvxlSurfaceData;
    public String jvxlEdgeData;
    public String jvxlColorData;
    public String jvxlVolumeDataXml;
    public BS[] jvxlExcluded = new BS[4];
    public P4 jvxlPlane;
    public boolean isJvxlPrecisionColor;
    public boolean jvxlDataIsColorMapped;
    public boolean jvxlDataIs2dContour;
    public boolean jvxlDataIsColorDensity;
    public boolean isColorReversed;
    public int thisSet = Integer.MIN_VALUE;
    public int edgeFractionBase = 35;
    public int edgeFractionRange = 90;
    public int colorFractionBase = 35;
    public int colorFractionRange = 90;
    public boolean isValid = true;
    public boolean insideOut;
    public boolean isXLowToHigh;
    public boolean isContoured;
    public boolean isBicolorMap;
    public boolean isTruncated;
    public boolean isCutoffAbsolute;
    public boolean isModelConnected;
    public boolean vertexDataOnly;
    public float mappedDataMin;
    public float mappedDataMax;
    public float valueMappedToRed;
    public float valueMappedToBlue;
    public float cutoff;
    public float pointsPerAngstrom;
    public int nPointsX;
    public int nPointsY;
    public int nPointsZ;
    public long nBytes;
    public int nContours;
    public int nEdges;
    public int nSurfaceInts;
    public int vertexCount;
    public Lst<Object>[] vContours;
    public short[] contourColixes;
    public String contourColors;
    public float[] contourValues;
    public float[] contourValuesUsed;
    public int thisContour = -1;
    public float scale3d;
    public short minColorIndex = (short)-1;
    public short maxColorIndex = 0;
    public String[] title;
    public String version;
    public P3[] boundingBox;
    public int excludedTriangleCount;
    public int excludedVertexCount;
    public boolean colorDensity;
    public float pointSize;
    public String moleculeXml;
    public float dataMin;
    public float dataMax;
    public int saveVertexCount;
    public Map<String, BS> vertexColorMap;
    public int nVertexColors;
    public int[] vertexColors;
    public String color;
    public String meshColor;
    public float translucency;
    public String colorScheme;
    public String rendering;
    public int slabValue = Integer.MIN_VALUE;
    public boolean isSlabbable;
    public int diameter;
    public String slabInfo;
    public boolean allowVolumeRender;
    public float voxelVolume;
    public P3 mapLattice;
    public P3 fixedLattice;
    public String baseColor;
    public float integration = Float.NaN;

    public void clear() {
        this.allowVolumeRender = true;
        this.jvxlSurfaceData = "";
        this.jvxlEdgeData = "";
        this.jvxlColorData = "";
        this.jvxlVolumeDataXml = "";
        this.color = null;
        this.colorScheme = null;
        this.colorDensity = false;
        this.pointSize = Float.NaN;
        this.contourValues = null;
        this.contourValuesUsed = null;
        this.contourColixes = null;
        this.contourColors = null;
        this.integration = Float.NaN;
        this.isSlabbable = false;
        this.isValid = true;
        this.mapLattice = null;
        this.meshColor = null;
        this.msg = "";
        this.nPointsX = 0;
        this.nVertexColors = 0;
        this.fixedLattice = null;
        this.slabInfo = null;
        this.slabValue = Integer.MIN_VALUE;
        this.thisSet = Integer.MIN_VALUE;
        this.rendering = null;
        this.thisContour = -1;
        this.translucency = 0.0f;
        this.vContours = null;
        this.vertexColorMap = null;
        this.vertexColors = null;
        this.voxelVolume = 0.0f;
    }

    public void setSurfaceInfo(P4 p4, P3 p3, int n, String string) {
        this.jvxlSurfaceData = string;
        if (this.jvxlSurfaceData.indexOf("--") == 0) {
            this.jvxlSurfaceData = this.jvxlSurfaceData.substring(2);
        }
        this.jvxlPlane = p4;
        this.mapLattice = p3;
        this.nSurfaceInts = n;
    }

    public void setSurfaceInfoFromBitSet(BS bS, P4 p4) {
        this.setSurfaceInfoFromBitSetPts(bS, p4, null);
    }

    public void setSurfaceInfoFromBitSetPts(BS bS, P4 p4, P3 p3) {
        SB sB = new SB();
        int n = p4 != null ? 0 : JvxlCoder.jvxlEncodeBitSetBuffer(bS, this.nPointsX * this.nPointsY * this.nPointsZ, sB);
        this.setSurfaceInfo(p4, p3, n, sB.toString());
    }

    public void jvxlUpdateInfo(String[] stringArray, long l) {
        this.title = stringArray;
        this.nBytes = l;
    }

    public static String updateSurfaceData(String string, float[] fArray, int n, int n2, char c) {
        if (string.length() == 0) {
            return "";
        }
        char[] cArray = string.toCharArray();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            if (Float.isNaN(fArray[n3])) {
                cArray[n4] = c;
            }
            n3 += n2;
            ++n4;
        }
        return String.copyValueOf(cArray);
    }
}

