/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.lang.invoke.MethodHandles;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.compiler.BlockJITTask;
import org.jruby.compiler.Compilable;
import org.jruby.compiler.FullBuildTask;
import org.jruby.compiler.JITCompilerMBean;
import org.jruby.compiler.JITCounts;
import org.jruby.compiler.MethodCompiledJITTask;
import org.jruby.compiler.MethodJITTask;
import org.jruby.compiler.NotCompilableException;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.MixedModeIRBlockBody;
import org.jruby.runtime.ThreadContext;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class JITCompiler
implements JITCompilerMBean {
    private static final Logger LOG = LoggerFactory.getLogger(JITCompiler.class);
    public static final String RUBY_JIT_PREFIX = "rubyjit";
    final JITCounts counts = new JITCounts();
    private final ExecutorService executor;
    final Ruby runtime;
    final RubyInstanceConfig config;
    static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup().in(Ruby.class);

    public JITCompiler(Ruby runtime2) {
        this.runtime = runtime2;
        this.config = runtime2.getInstanceConfig();
        this.executor = new ThreadPoolExecutor(0, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("Ruby-" + runtime2.getRuntimeNumber() + "-JIT", 1));
    }

    @Override
    public long getSuccessCount() {
        return this.counts.successCount.get();
    }

    @Override
    public long getCompileCount() {
        return this.counts.compiledCount.get();
    }

    @Override
    public long getFailCount() {
        return this.counts.failCount.get();
    }

    @Override
    public long getCompileTime() {
        return this.counts.compileTime.get() / 1000L;
    }

    @Override
    public long getAbandonCount() {
        return this.counts.abandonCount.get();
    }

    @Override
    public long getCodeSize() {
        return this.counts.codeSize.get();
    }

    @Override
    public long getCodeAverageSize() {
        return this.counts.codeAverageSize.get();
    }

    @Override
    public long getCompileTimeAverage() {
        return this.counts.compileTimeAverage.get() / 1000L;
    }

    @Override
    public long getCodeLargestSize() {
        return this.counts.codeLargestSize.get();
    }

    @Override
    public long getIRSize() {
        return this.counts.irSize.get();
    }

    @Override
    public long getIRAverageSize() {
        return this.counts.irAverageSize.get();
    }

    @Override
    public long getIRLargestSize() {
        return this.counts.irLargestSize.get();
    }

    @Override
    public String[] getFrameAwareMethods() {
        Object[] frameAwareMethods = MethodIndex.FRAME_AWARE_METHODS.toArray(new String[0]);
        Arrays.sort(frameAwareMethods);
        return frameAwareMethods;
    }

    @Override
    public String[] getScopeAwareMethods() {
        Object[] scopeAwareMethods = MethodIndex.SCOPE_AWARE_METHODS.toArray(new String[0]);
        Arrays.sort(scopeAwareMethods);
        return scopeAwareMethods;
    }

    public void tearDown() {
        try {
            this.executor.shutdown();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public Runnable getTaskFor(ThreadContext context, Compilable method2) {
        if (method2 instanceof MixedModeIRMethod) {
            return new MethodJITTask(this, (MixedModeIRMethod)method2, method2.getClassName(context));
        }
        if (method2 instanceof MixedModeIRBlockBody) {
            return new BlockJITTask(this, (MixedModeIRBlockBody)method2, method2.getClassName(context));
        }
        if (method2 instanceof CompiledIRMethod) {
            return new MethodCompiledJITTask(this, (CompiledIRMethod)method2, method2.getClassName(context));
        }
        return new FullBuildTask(this, method2);
    }

    public void buildThresholdReached(ThreadContext context, Compilable method2) {
        RubyInstanceConfig config = context.runtime.getInstanceConfig();
        method2.setCallCount(-1);
        Runnable jitTask = this.getTaskFor(context, method2);
        try {
            if (config.getJitBackground() && config.getJitThreshold() > 0) {
                try {
                    this.executor.submit(jitTask);
                }
                catch (RejectedExecutionException ree) {
                    jitTask.run();
                }
            } else {
                method2.ensureInstrsReady();
                jitTask.run();
            }
        }
        catch (Exception e) {
            throw new NotCompilableException(e);
        }
    }

    public static String getHashForString(String str) {
        return JITCompiler.getHashForBytes(RubyEncoding.encodeUTF8(str));
    }

    public static String getHashForBytes(byte[] bytes2) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(bytes2);
            StringBuilder builder = new StringBuilder();
            for (byte aByte : sha1.digest()) {
                builder.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
            }
            return builder.toString().toUpperCase(Locale.ENGLISH);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    static void log(RubyModule implementationClass, String file2, int line, String name2, String message2, String ... reason2) {
        String className;
        boolean isBlock = implementationClass == null;
        String string2 = className = isBlock ? "<block>" : implementationClass.getBaseName();
        if (className == null) {
            className = "<anon class>";
        }
        StringBuilder builder = new StringBuilder(32);
        builder.append(message2).append(": ").append(className).append(' ').append(name2 == null ? "" : name2).append(" at ").append(file2).append(':').append(line);
        if (reason2.length > 0) {
            builder.append(" because of: \"");
            for (String aReason : reason2) {
                builder.append(aReason);
            }
            builder.append('\"');
        }
        LOG.info(builder.toString(), new Object[0]);
    }
}

