/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.log;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.protege.editor.core.FileUtils;
import org.protege.editor.core.log.LogRecord;
import org.protege.editor.core.log.LogRecordElement;
import org.protege.editor.core.log.LogRecordModel;
import org.protege.editor.core.log.LogRecordRenderer;
import org.protege.editor.core.log.LogView;

public class LogViewImpl
implements LogView {
    private final JComponent view = new JPanel(new BorderLayout(7, 7));
    private final LogRecordModel logRecordModel;

    public LogViewImpl() {
        this.view.setPreferredSize(new Dimension(800, 600));
        this.logRecordModel = new LogRecordModel();
        JList<LogRecordElement> list = new JList<LogRecordElement>(this.logRecordModel);
        JScrollPane sp = new JScrollPane(list);
        sp.getVerticalScrollBar().setUnitIncrement(15);
        this.view.add(sp);
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        JButton clearLogButton = new JButton("Clear log");
        clearLogButton.addActionListener(e -> this.clearView());
        JButton showLogFile = new JButton("Show log file");
        showLogFile.addActionListener(e -> FileUtils.showLogFile());
        buttonPanel.add(showLogFile);
        buttonPanel.add(clearLogButton);
        this.view.add((Component)buttonPanel, "South");
        list.setFont(new Font("monospaced", 0, 12));
        list.setCellRenderer(new LogRecordRenderer());
    }

    @Override
    public JComponent asJComponent() {
        return this.view;
    }

    @Override
    public void clearView() {
        this.logRecordModel.clear();
    }

    @Override
    public void append(LogRecord logRecord) {
        SwingUtilities.invokeLater(() -> this.logRecordModel.append(logRecord));
    }
}

