/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.functional.parser.OWLFunctionalSyntaxOWLParser;
import org.semanticweb.owlapi.functional.renderer.OWLFunctionalSyntaxRenderer;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.io.StringDocumentSource;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.UnloadableImportException;

public class OwlStringTools {
    @Nullable
    public static String translate(@Nullable Set<OWLAxiom> axioms, @Nonnull OWLOntologyManager translationManager) throws OwlStringException {
        if (axioms == null || axioms.isEmpty()) {
            return null;
        }
        try {
            OWLOntology ontology = translationManager.createOntology();
            translationManager.addAxioms(ontology, axioms);
            OWLFunctionalSyntaxRenderer r = new OWLFunctionalSyntaxRenderer();
            StringWriter writer = new StringWriter();
            r.render(ontology, writer);
            return ((Object)writer).toString();
        }
        catch (OWLRendererException e) {
            throw new OwlStringException(e);
        }
        catch (OWLOntologyCreationException e) {
            throw new OwlStringException(e);
        }
    }

    @Nullable
    public static Set<OWLAxiom> translate(@Nullable String axioms, @Nonnull OWLOntologyManager translationManager) throws OwlStringException {
        if (axioms == null || axioms.isEmpty()) {
            return null;
        }
        try {
            OWLFunctionalSyntaxOWLParser p = new OWLFunctionalSyntaxOWLParser();
            StringDocumentSource documentSource = new StringDocumentSource(axioms);
            OWLOntology ontology = translationManager.createOntology();
            p.parse(documentSource, ontology, translationManager.getOntologyLoaderConfiguration());
            return ontology.getAxioms();
        }
        catch (UnloadableImportException e) {
            throw new OwlStringException(e);
        }
        catch (OWLOntologyCreationException e) {
            throw new OwlStringException(e);
        }
        catch (OWLParserException e) {
            throw new OwlStringException(e);
        }
        catch (IOException e) {
            throw new OwlStringException(e);
        }
    }

    public static class OwlStringException
    extends Exception {
        private static final long serialVersionUID = 40000L;

        protected OwlStringException(Throwable cause) {
            super(cause);
        }
    }
}

