// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * Used by administrative clients to view,
 * update, and receive observer updates from the IceGrid
 * registry. Admin sessions are created either via the {@link Registry}
 * object or via the registry admin <tt>SessionManager</tt> object.
 *
 * @see Registry
 *
 **/
public interface AdminSessionPrx extends Glacier2.SessionPrx
{
    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @see Registry#getSessionTimeout
     *
     **/
    public void keepAlive();

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @see Registry#getSessionTimeout
     *
     * @param context The Context map to send with the invocation.
     **/
    public void keepAlive(java.util.Map<String, String> context);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive();

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> context);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(Ice.Callback cb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(Callback_AdminSession_keepAlive cb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> context, Callback_AdminSession_keepAlive cb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(IceInternal.Functional_VoidCallback responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(IceInternal.Functional_VoidCallback responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                           IceInternal.Functional_BoolCallback sentCb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> context,
                                           IceInternal.Functional_VoidCallback responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> context,
                                           IceInternal.Functional_VoidCallback responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                           IceInternal.Functional_BoolCallback sentCb);

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @param result The asynchronous result object.
     * @see Registry#getSessionTimeout
     *
     **/
    public void end_keepAlive(Ice.AsyncResult result);

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     *
     * @return The admin interface proxy.
     *
     **/
    public AdminPrx getAdmin();

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     *
     * @param context The Context map to send with the invocation.
     * @return The admin interface proxy.
     *
     **/
    public AdminPrx getAdmin(java.util.Map<String, String> context);

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdmin();

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdmin(java.util.Map<String, String> context);

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdmin(Ice.Callback cb);

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdmin(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdmin(Callback_AdminSession_getAdmin cb);

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdmin(java.util.Map<String, String> context, Callback_AdminSession_getAdmin cb);

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdmin(IceInternal.Functional_GenericCallback1<AdminPrx> responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdmin(IceInternal.Functional_GenericCallback1<AdminPrx> responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                          IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdmin(java.util.Map<String, String> context,
                                          IceInternal.Functional_GenericCallback1<AdminPrx> responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdmin(java.util.Map<String, String> context,
                                          IceInternal.Functional_GenericCallback1<AdminPrx> responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                          IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     *
     * @param result The asynchronous result object.
     * @return The admin interface proxy.
     *
     **/
    public AdminPrx end_getAdmin(Ice.AsyncResult result);

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     *
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     *
     **/
    public Ice.ObjectPrx getAdminCallbackTemplate();

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     *
     * @param context The Context map to send with the invocation.
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     *
     **/
    public Ice.ObjectPrx getAdminCallbackTemplate(java.util.Map<String, String> context);

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate();

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate(java.util.Map<String, String> context);

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate(Ice.Callback cb);

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate(Callback_AdminSession_getAdminCallbackTemplate cb);

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate(java.util.Map<String, String> context, Callback_AdminSession_getAdminCallbackTemplate cb);

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate(IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate(IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                          IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate(java.util.Map<String, String> context,
                                                          IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate(java.util.Map<String, String> context,
                                                          IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                          IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     *
     * @param result The asynchronous result object.
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     *
     **/
    public Ice.ObjectPrx end_getAdminCallbackTemplate(Ice.AsyncResult result);

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     *
     * @param registryObs The registry observer.
     *
     * @param nodeObs The node observer.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     *
     **/
    public void setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs)
        throws ObserverAlreadyRegisteredException;

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     *
     * @param registryObs The registry observer.
     *
     * @param nodeObs The node observer.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, java.util.Map<String, String> context)
        throws ObserverAlreadyRegisteredException;

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     *
     * @param registryObs The registry observer.
     *
     * @param nodeObs The node observer.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs);

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     *
     * @param registryObs The registry observer.
     *
     * @param nodeObs The node observer.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, java.util.Map<String, String> context);

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     *
     * @param registryObs The registry observer.
     *
     * @param nodeObs The node observer.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, Ice.Callback cb);

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     *
     * @param registryObs The registry observer.
     *
     * @param nodeObs The node observer.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     *
     * @param registryObs The registry observer.
     *
     * @param nodeObs The node observer.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, Callback_AdminSession_setObservers cb);

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     *
     * @param registryObs The registry observer.
     *
     * @param nodeObs The node observer.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, java.util.Map<String, String> context, Callback_AdminSession_setObservers cb);

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     *
     * @param registryObs The registry observer.
     *
     * @param nodeObs The node observer.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs,
                                              NodeObserverPrx nodeObs,
                                              ApplicationObserverPrx appObs,
                                              AdapterObserverPrx adptObs,
                                              ObjectObserverPrx objObs,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     *
     * @param registryObs The registry observer.
     *
     * @param nodeObs The node observer.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs,
                                              NodeObserverPrx nodeObs,
                                              ApplicationObserverPrx appObs,
                                              AdapterObserverPrx adptObs,
                                              ObjectObserverPrx objObs,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     *
     * @param registryObs The registry observer.
     *
     * @param nodeObs The node observer.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs,
                                              NodeObserverPrx nodeObs,
                                              ApplicationObserverPrx appObs,
                                              AdapterObserverPrx adptObs,
                                              ObjectObserverPrx objObs,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     *
     * @param registryObs The registry observer.
     *
     * @param nodeObs The node observer.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs,
                                              NodeObserverPrx nodeObs,
                                              ApplicationObserverPrx appObs,
                                              AdapterObserverPrx adptObs,
                                              ObjectObserverPrx objObs,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     *
     * @param result The asynchronous result object.
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     *
     **/
    public void end_setObservers(Ice.AsyncResult result)
        throws ObserverAlreadyRegisteredException;

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     *
     * @param registryObs The registry observer identity.
     *
     * @param nodeObs The node observer identity.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     *
     **/
    public void setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs)
        throws ObserverAlreadyRegisteredException;

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     *
     * @param registryObs The registry observer identity.
     *
     * @param nodeObs The node observer identity.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs, java.util.Map<String, String> context)
        throws ObserverAlreadyRegisteredException;

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     *
     * @param registryObs The registry observer identity.
     *
     * @param nodeObs The node observer identity.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs);

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     *
     * @param registryObs The registry observer identity.
     *
     * @param nodeObs The node observer identity.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs, java.util.Map<String, String> context);

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     *
     * @param registryObs The registry observer identity.
     *
     * @param nodeObs The node observer identity.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs, Ice.Callback cb);

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     *
     * @param registryObs The registry observer identity.
     *
     * @param nodeObs The node observer identity.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     *
     * @param registryObs The registry observer identity.
     *
     * @param nodeObs The node observer identity.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs, Callback_AdminSession_setObserversByIdentity cb);

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     *
     * @param registryObs The registry observer identity.
     *
     * @param nodeObs The node observer identity.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs, java.util.Map<String, String> context, Callback_AdminSession_setObserversByIdentity cb);

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     *
     * @param registryObs The registry observer identity.
     *
     * @param nodeObs The node observer identity.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs,
                                                        Ice.Identity nodeObs,
                                                        Ice.Identity appObs,
                                                        Ice.Identity adptObs,
                                                        Ice.Identity objObs,
                                                        IceInternal.Functional_VoidCallback responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     *
     * @param registryObs The registry observer identity.
     *
     * @param nodeObs The node observer identity.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs,
                                                        Ice.Identity nodeObs,
                                                        Ice.Identity appObs,
                                                        Ice.Identity adptObs,
                                                        Ice.Identity objObs,
                                                        IceInternal.Functional_VoidCallback responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     *
     * @param registryObs The registry observer identity.
     *
     * @param nodeObs The node observer identity.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs,
                                                        Ice.Identity nodeObs,
                                                        Ice.Identity appObs,
                                                        Ice.Identity adptObs,
                                                        Ice.Identity objObs,
                                                        java.util.Map<String, String> context,
                                                        IceInternal.Functional_VoidCallback responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     *
     * @param registryObs The registry observer identity.
     *
     * @param nodeObs The node observer identity.
     *
     * @param appObs The application observer.
     *
     * @param adptObs The adapter observer.
     *
     * @param objObs The object observer.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs,
                                                        Ice.Identity nodeObs,
                                                        Ice.Identity appObs,
                                                        Ice.Identity adptObs,
                                                        Ice.Identity objObs,
                                                        java.util.Map<String, String> context,
                                                        IceInternal.Functional_VoidCallback responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     *
     * @param result The asynchronous result object.
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     *
     **/
    public void end_setObserversByIdentity(Ice.AsyncResult result)
        throws ObserverAlreadyRegisteredException;

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     *
     * @return The current serial.
     *
     * @throws AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     *
     **/
    public int startUpdate()
        throws AccessDeniedException;

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     *
     * @param context The Context map to send with the invocation.
     * @return The current serial.
     *
     * @throws AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     *
     **/
    public int startUpdate(java.util.Map<String, String> context)
        throws AccessDeniedException;

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startUpdate();

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startUpdate(java.util.Map<String, String> context);

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startUpdate(Ice.Callback cb);

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startUpdate(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startUpdate(Callback_AdminSession_startUpdate cb);

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startUpdate(java.util.Map<String, String> context, Callback_AdminSession_startUpdate cb);

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startUpdate(IceInternal.Functional_IntCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startUpdate(IceInternal.Functional_IntCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startUpdate(java.util.Map<String, String> context,
                                             IceInternal.Functional_IntCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startUpdate(java.util.Map<String, String> context,
                                             IceInternal.Functional_IntCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     *
     * @param result The asynchronous result object.
     * @return The current serial.
     *
     * @throws AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     *
     **/
    public int end_startUpdate(Ice.AsyncResult result)
        throws AccessDeniedException;

    /**
     * Finish updating the registry and release the exclusive lock.
     *
     * @throws AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     *
     **/
    public void finishUpdate()
        throws AccessDeniedException;

    /**
     * Finish updating the registry and release the exclusive lock.
     *
     * @throws AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void finishUpdate(java.util.Map<String, String> context)
        throws AccessDeniedException;

    /**
     * Finish updating the registry and release the exclusive lock.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_finishUpdate();

    /**
     * Finish updating the registry and release the exclusive lock.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_finishUpdate(java.util.Map<String, String> context);

    /**
     * Finish updating the registry and release the exclusive lock.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_finishUpdate(Ice.Callback cb);

    /**
     * Finish updating the registry and release the exclusive lock.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_finishUpdate(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Finish updating the registry and release the exclusive lock.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_finishUpdate(Callback_AdminSession_finishUpdate cb);

    /**
     * Finish updating the registry and release the exclusive lock.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_finishUpdate(java.util.Map<String, String> context, Callback_AdminSession_finishUpdate cb);

    /**
     * Finish updating the registry and release the exclusive lock.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_finishUpdate(IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Finish updating the registry and release the exclusive lock.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_finishUpdate(IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Finish updating the registry and release the exclusive lock.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_finishUpdate(java.util.Map<String, String> context,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Finish updating the registry and release the exclusive lock.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_finishUpdate(java.util.Map<String, String> context,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Finish updating the registry and release the exclusive lock.
     *
     * @param result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     *
     **/
    public void end_finishUpdate(Ice.AsyncResult result)
        throws AccessDeniedException;

    /**
     * Get the name of the registry replica hosting this session.
     *
     * @return The replica name of the registry.
     *
     **/
    public String getReplicaName();

    /**
     * Get the name of the registry replica hosting this session.
     *
     * @param context The Context map to send with the invocation.
     * @return The replica name of the registry.
     *
     **/
    public String getReplicaName(java.util.Map<String, String> context);

    /**
     * Get the name of the registry replica hosting this session.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getReplicaName();

    /**
     * Get the name of the registry replica hosting this session.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getReplicaName(java.util.Map<String, String> context);

    /**
     * Get the name of the registry replica hosting this session.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getReplicaName(Ice.Callback cb);

    /**
     * Get the name of the registry replica hosting this session.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getReplicaName(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the name of the registry replica hosting this session.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getReplicaName(Callback_AdminSession_getReplicaName cb);

    /**
     * Get the name of the registry replica hosting this session.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getReplicaName(java.util.Map<String, String> context, Callback_AdminSession_getReplicaName cb);

    /**
     * Get the name of the registry replica hosting this session.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getReplicaName(IceInternal.Functional_GenericCallback1<String> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the name of the registry replica hosting this session.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getReplicaName(IceInternal.Functional_GenericCallback1<String> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the name of the registry replica hosting this session.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getReplicaName(java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<String> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the name of the registry replica hosting this session.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getReplicaName(java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<String> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the name of the registry replica hosting this session.
     *
     * @param result The asynchronous result object.
     * @return The replica name of the registry.
     *
     **/
    public String end_getReplicaName(Ice.AsyncResult result);

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public FileIteratorPrx openServerLog(String id, String path, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public FileIteratorPrx openServerLog(String id, String path, int count, java.util.Map<String, String> context)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerLog(String id, String path, int count);

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerLog(String id, String path, int count, java.util.Map<String, String> context);

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerLog(String id, String path, int count, Ice.Callback cb);

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerLog(String id, String path, int count, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerLog(String id, String path, int count, Callback_AdminSession_openServerLog cb);

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerLog(String id, String path, int count, java.util.Map<String, String> context, Callback_AdminSession_openServerLog cb);

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerLog(String id,
                                               String path,
                                               int count,
                                               IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerLog(String id,
                                               String path,
                                               int count,
                                               IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerLog(String id,
                                               String path,
                                               int count,
                                               java.util.Map<String, String> context,
                                               IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerLog(String id,
                                               String path,
                                               int count,
                                               java.util.Map<String, String> context,
                                               IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param result The asynchronous result object.
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public FileIteratorPrx end_openServerLog(Ice.AsyncResult result)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public FileIteratorPrx openServerStdErr(String id, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public FileIteratorPrx openServerStdErr(String id, int count, java.util.Map<String, String> context)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id, int count);

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id, int count, java.util.Map<String, String> context);

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id, int count, Ice.Callback cb);

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id, int count, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id, int count, Callback_AdminSession_openServerStdErr cb);

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id, int count, java.util.Map<String, String> context, Callback_AdminSession_openServerStdErr cb);

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id,
                                                  int count,
                                                  IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id,
                                                  int count,
                                                  IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id,
                                                  int count,
                                                  java.util.Map<String, String> context,
                                                  IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id,
                                                  int count,
                                                  java.util.Map<String, String> context,
                                                  IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param result The asynchronous result object.
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public FileIteratorPrx end_openServerStdErr(Ice.AsyncResult result)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public FileIteratorPrx openServerStdOut(String id, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public FileIteratorPrx openServerStdOut(String id, int count, java.util.Map<String, String> context)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id, int count);

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id, int count, java.util.Map<String, String> context);

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id, int count, Ice.Callback cb);

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id, int count, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id, int count, Callback_AdminSession_openServerStdOut cb);

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id, int count, java.util.Map<String, String> context, Callback_AdminSession_openServerStdOut cb);

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id,
                                                  int count,
                                                  IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id,
                                                  int count,
                                                  IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id,
                                                  int count,
                                                  java.util.Map<String, String> context,
                                                  IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param id The server id.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id,
                                                  int count,
                                                  java.util.Map<String, String> context,
                                                  IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param result The asynchronous result object.
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public FileIteratorPrx end_openServerStdOut(Ice.AsyncResult result)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     **/
    public FileIteratorPrx openNodeStdErr(String name, int count)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException;

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     **/
    public FileIteratorPrx openNodeStdErr(String name, int count, java.util.Map<String, String> context)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException;

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name, int count);

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name, int count, java.util.Map<String, String> context);

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name, int count, Ice.Callback cb);

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name, int count, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name, int count, Callback_AdminSession_openNodeStdErr cb);

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name, int count, java.util.Map<String, String> context, Callback_AdminSession_openNodeStdErr cb);

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name,
                                                int count,
                                                IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name,
                                                int count,
                                                IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name,
                                                int count,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name,
                                                int count,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param result The asynchronous result object.
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     **/
    public FileIteratorPrx end_openNodeStdErr(Ice.AsyncResult result)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException;

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     **/
    public FileIteratorPrx openNodeStdOut(String name, int count)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException;

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     **/
    public FileIteratorPrx openNodeStdOut(String name, int count, java.util.Map<String, String> context)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException;

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name, int count);

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name, int count, java.util.Map<String, String> context);

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name, int count, Ice.Callback cb);

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name, int count, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name, int count, Callback_AdminSession_openNodeStdOut cb);

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name, int count, java.util.Map<String, String> context, Callback_AdminSession_openNodeStdOut cb);

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name,
                                                int count,
                                                IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name,
                                                int count,
                                                IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name,
                                                int count,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The node name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name,
                                                int count,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param result The asynchronous result object.
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     **/
    public FileIteratorPrx end_openNodeStdOut(Ice.AsyncResult result)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException;

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     *
     **/
    public FileIteratorPrx openRegistryStdErr(String name, int count)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     *
     **/
    public FileIteratorPrx openRegistryStdErr(String name, int count, java.util.Map<String, String> context)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name, int count);

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name, int count, java.util.Map<String, String> context);

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name, int count, Ice.Callback cb);

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name, int count, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name, int count, Callback_AdminSession_openRegistryStdErr cb);

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name, int count, java.util.Map<String, String> context, Callback_AdminSession_openRegistryStdErr cb);

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name,
                                                    int count,
                                                    IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name,
                                                    int count,
                                                    IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name,
                                                    int count,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name,
                                                    int count,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param result The asynchronous result object.
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     *
     **/
    public FileIteratorPrx end_openRegistryStdErr(Ice.AsyncResult result)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     *
     **/
    public FileIteratorPrx openRegistryStdOut(String name, int count)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     *
     **/
    public FileIteratorPrx openRegistryStdOut(String name, int count, java.util.Map<String, String> context)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name, int count);

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name, int count, java.util.Map<String, String> context);

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name, int count, Ice.Callback cb);

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name, int count, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name, int count, Callback_AdminSession_openRegistryStdOut cb);

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name, int count, java.util.Map<String, String> context, Callback_AdminSession_openRegistryStdOut cb);

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name,
                                                    int count,
                                                    IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name,
                                                    int count,
                                                    IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name,
                                                    int count,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param name The registry name.
     *
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name,
                                                    int count,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_GenericCallback1<FileIteratorPrx> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     *
     * @param result The asynchronous result object.
     * @return An iterator to read the file.
     *
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     *
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     *
     **/
    public FileIteratorPrx end_openRegistryStdOut(Ice.AsyncResult result)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException;
}
