# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2018 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtMultimedia, except for defaults which are replaced by "...".
"""

# Module PySide2.QtMultimedia
import shiboken2 as Shiboken
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

Shiboken.Object = Object

import PySide2.QtMultimedia


class QAbstractAudioDeviceInfo(PySide2.QtCore.QObject):

    def __init__(self): ...
    def deviceName(self) -> str: ...
    def isFormatSupported(self, format: PySide2.QtMultimedia.QAudioFormat) -> bool: ...
    def preferredFormat(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def supportedByteOrders(self) -> PySide2.QtMultimedia.QAudioFormat.Endian: ...
    def supportedChannelCounts(self) -> int: ...
    def supportedCodecs(self) -> typing.List[str]: ...
    def supportedSampleRates(self) -> int: ...
    def supportedSampleSizes(self) -> int: ...
    def supportedSampleTypes(self) -> PySide2.QtMultimedia.QAudioFormat.SampleType: ...


class QAbstractAudioInput(PySide2.QtCore.QObject):

    def __init__(self): ...
    def bufferSize(self) -> int: ...
    def bytesReady(self) -> int: ...
    def elapsedUSecs(self) -> int: ...
    def error(self) -> PySide2.QtMultimedia.QAudio.Error: ...
    def format(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def notifyInterval(self) -> int: ...
    def periodSize(self) -> int: ...
    def processedUSecs(self) -> int: ...
    def reset(self): ...
    def resume(self): ...
    def setBufferSize(self, value: int): ...
    def setFormat(self, fmt: PySide2.QtMultimedia.QAudioFormat): ...
    def setNotifyInterval(self, milliSeconds: int): ...
    def setVolume(self, arg__1: float): ...
    @typing.overload
    def start(self) -> PySide2.QtCore.QIODevice: ...
    @typing.overload
    def start(self, device: PySide2.QtCore.QIODevice): ...
    def state(self) -> PySide2.QtMultimedia.QAudio.State: ...
    def stop(self): ...
    def suspend(self): ...
    def volume(self) -> float: ...


class QAbstractAudioOutput(PySide2.QtCore.QObject):

    def __init__(self): ...
    def bufferSize(self) -> int: ...
    def bytesFree(self) -> int: ...
    def category(self) -> str: ...
    def elapsedUSecs(self) -> int: ...
    def error(self) -> PySide2.QtMultimedia.QAudio.Error: ...
    def format(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def notifyInterval(self) -> int: ...
    def periodSize(self) -> int: ...
    def processedUSecs(self) -> int: ...
    def reset(self): ...
    def resume(self): ...
    def setBufferSize(self, value: int): ...
    def setCategory(self, arg__1: str): ...
    def setFormat(self, fmt: PySide2.QtMultimedia.QAudioFormat): ...
    def setNotifyInterval(self, milliSeconds: int): ...
    def setVolume(self, arg__1: float): ...
    @typing.overload
    def start(self) -> PySide2.QtCore.QIODevice: ...
    @typing.overload
    def start(self, device: PySide2.QtCore.QIODevice): ...
    def state(self) -> PySide2.QtMultimedia.QAudio.State: ...
    def stop(self): ...
    def suspend(self): ...
    def volume(self) -> float: ...


class QAbstractVideoBuffer(Shiboken.Object):

    def __init__(self, type: PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType): ...
    def handle(self) -> typing.Any: ...
    def handleType(self) -> PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType: ...
    def mapMode(self) -> PySide2.QtMultimedia.QAbstractVideoBuffer.MapMode: ...
    def release(self): ...
    def unmap(self): ...


class QAbstractVideoFilter(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def createFilterRunnable(self) -> PySide2.QtMultimedia.QVideoFilterRunnable: ...
    def isActive(self) -> bool: ...
    def setActive(self, v: bool): ...


class QAbstractVideoSurface(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def error(self) -> PySide2.QtMultimedia.QAbstractVideoSurface.Error: ...
    def isActive(self) -> bool: ...
    def isFormatSupported(self, format: PySide2.QtMultimedia.QVideoSurfaceFormat) -> bool: ...
    def nativeResolution(self) -> PySide2.QtCore.QSize: ...
    def nearestFormat(self, format: PySide2.QtMultimedia.QVideoSurfaceFormat) -> PySide2.QtMultimedia.QVideoSurfaceFormat: ...
    def present(self, frame: PySide2.QtMultimedia.QVideoFrame) -> bool: ...
    def setError(self, error: PySide2.QtMultimedia.QAbstractVideoSurface.Error): ...
    def setNativeResolution(self, resolution: PySide2.QtCore.QSize): ...
    def start(self, format: PySide2.QtMultimedia.QVideoSurfaceFormat) -> bool: ...
    def stop(self): ...
    def supportedPixelFormats(self, type: PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType = ...) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    def surfaceFormat(self) -> PySide2.QtMultimedia.QVideoSurfaceFormat: ...


class QAudio(Shiboken.Object):

    @staticmethod
    def convertVolume(volume: float, from_: PySide2.QtMultimedia.QAudio.VolumeScale, to: PySide2.QtMultimedia.QAudio.VolumeScale) -> float: ...


class QAudioBuffer(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, data: PySide2.QtCore.QByteArray, format: PySide2.QtMultimedia.QAudioFormat, startTime: int = ...): ...
    @typing.overload
    def __init__(self, numFrames: int, format: PySide2.QtMultimedia.QAudioFormat, startTime: int = ...): ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QAudioBuffer): ...
    def __copy__(self): ...
    def byteCount(self) -> int: ...
    def constData(self) -> int: ...
    def data(self) -> int: ...
    def duration(self) -> int: ...
    def format(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def frameCount(self) -> int: ...
    def isValid(self) -> bool: ...
    def sampleCount(self) -> int: ...
    def startTime(self) -> int: ...


class QAudioDecoder(PySide2.QtMultimedia.QMediaObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def audioFormat(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def bind(self, arg__1: PySide2.QtCore.QObject) -> bool: ...
    def bufferAvailable(self) -> bool: ...
    def duration(self) -> int: ...
    def error(self) -> PySide2.QtMultimedia.QAudioDecoder.Error: ...
    def errorString(self) -> str: ...
    @staticmethod
    def hasSupport(mimeType: str, codecs: typing.List[str] = ...) -> PySide2.QtMultimedia.QMultimedia.SupportEstimate: ...
    def position(self) -> int: ...
    def read(self) -> PySide2.QtMultimedia.QAudioBuffer: ...
    def setAudioFormat(self, format: PySide2.QtMultimedia.QAudioFormat): ...
    def setSourceDevice(self, device: PySide2.QtCore.QIODevice): ...
    def setSourceFilename(self, fileName: str): ...
    def sourceDevice(self) -> PySide2.QtCore.QIODevice: ...
    def sourceFilename(self) -> str: ...
    def start(self): ...
    def state(self) -> PySide2.QtMultimedia.QAudioDecoder.State: ...
    def stop(self): ...
    def unbind(self, arg__1: PySide2.QtCore.QObject): ...


class QAudioDecoderControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def audioFormat(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def bufferAvailable(self) -> bool: ...
    def duration(self) -> int: ...
    def position(self) -> int: ...
    def read(self) -> PySide2.QtMultimedia.QAudioBuffer: ...
    def setAudioFormat(self, format: PySide2.QtMultimedia.QAudioFormat): ...
    def setSourceDevice(self, device: PySide2.QtCore.QIODevice): ...
    def setSourceFilename(self, fileName: str): ...
    def sourceDevice(self) -> PySide2.QtCore.QIODevice: ...
    def sourceFilename(self) -> str: ...
    def start(self): ...
    def state(self) -> PySide2.QtMultimedia.QAudioDecoder.State: ...
    def stop(self): ...


class QAudioDeviceInfo(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QAudioDeviceInfo): ...
    def __copy__(self): ...
    @staticmethod
    def availableDevices(mode: PySide2.QtMultimedia.QAudio.Mode) -> PySide2.QtMultimedia.QAudioDeviceInfo: ...
    @staticmethod
    def defaultInputDevice() -> PySide2.QtMultimedia.QAudioDeviceInfo: ...
    @staticmethod
    def defaultOutputDevice() -> PySide2.QtMultimedia.QAudioDeviceInfo: ...
    def deviceName(self) -> str: ...
    def isFormatSupported(self, format: PySide2.QtMultimedia.QAudioFormat) -> bool: ...
    def isNull(self) -> bool: ...
    def nearestFormat(self, format: PySide2.QtMultimedia.QAudioFormat) -> PySide2.QtMultimedia.QAudioFormat: ...
    def preferredFormat(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def supportedByteOrders(self) -> PySide2.QtMultimedia.QAudioFormat.Endian: ...
    def supportedChannelCounts(self) -> int: ...
    def supportedCodecs(self) -> typing.List[str]: ...
    def supportedSampleRates(self) -> int: ...
    def supportedSampleSizes(self) -> int: ...
    def supportedSampleTypes(self) -> PySide2.QtMultimedia.QAudioFormat.SampleType: ...


class QAudioEncoderSettings(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QAudioEncoderSettings): ...
    def __copy__(self): ...
    def bitRate(self) -> int: ...
    def channelCount(self) -> int: ...
    def codec(self) -> str: ...
    def encodingMode(self) -> PySide2.QtMultimedia.QMultimedia.EncodingMode: ...
    def encodingOption(self, option: str) -> typing.Any: ...
    def encodingOptions(self) -> dict: ...
    def isNull(self) -> bool: ...
    def quality(self) -> PySide2.QtMultimedia.QMultimedia.EncodingQuality: ...
    def sampleRate(self) -> int: ...
    def setBitRate(self, bitrate: int): ...
    def setChannelCount(self, channels: int): ...
    def setCodec(self, codec: str): ...
    def setEncodingMode(self, arg__1: PySide2.QtMultimedia.QMultimedia.EncodingMode): ...
    def setEncodingOption(self, option: str, value: typing.Any): ...
    def setEncodingOptions(self, options: dict): ...
    def setQuality(self, quality: PySide2.QtMultimedia.QMultimedia.EncodingQuality): ...
    def setSampleRate(self, rate: int): ...


class QAudioEncoderSettingsControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def audioSettings(self) -> PySide2.QtMultimedia.QAudioEncoderSettings: ...
    def codecDescription(self, codecName: str) -> str: ...
    def setAudioSettings(self, settings: PySide2.QtMultimedia.QAudioEncoderSettings): ...
    def supportedAudioCodecs(self) -> typing.List[str]: ...


class QAudioFormat(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QAudioFormat): ...
    def __copy__(self): ...
    def byteOrder(self) -> PySide2.QtMultimedia.QAudioFormat.Endian: ...
    def bytesForDuration(self, duration: int) -> int: ...
    def bytesForFrames(self, frameCount: int) -> int: ...
    def bytesPerFrame(self) -> int: ...
    def channelCount(self) -> int: ...
    def codec(self) -> str: ...
    def durationForBytes(self, byteCount: int) -> int: ...
    def durationForFrames(self, frameCount: int) -> int: ...
    def framesForBytes(self, byteCount: int) -> int: ...
    def framesForDuration(self, duration: int) -> int: ...
    def isValid(self) -> bool: ...
    def sampleRate(self) -> int: ...
    def sampleSize(self) -> int: ...
    def sampleType(self) -> PySide2.QtMultimedia.QAudioFormat.SampleType: ...
    def setByteOrder(self, byteOrder: PySide2.QtMultimedia.QAudioFormat.Endian): ...
    def setChannelCount(self, channelCount: int): ...
    def setCodec(self, codec: str): ...
    def setSampleRate(self, sampleRate: int): ...
    def setSampleSize(self, sampleSize: int): ...
    def setSampleType(self, sampleType: PySide2.QtMultimedia.QAudioFormat.SampleType): ...


class QAudioInput(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, audioDeviceInfo: PySide2.QtMultimedia.QAudioDeviceInfo, format: PySide2.QtMultimedia.QAudioFormat = ..., parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, format: PySide2.QtMultimedia.QAudioFormat = ..., parent: PySide2.QtCore.QObject = ...): ...
    def bufferSize(self) -> int: ...
    def bytesReady(self) -> int: ...
    def elapsedUSecs(self) -> int: ...
    def error(self) -> PySide2.QtMultimedia.QAudio.Error: ...
    def format(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def notifyInterval(self) -> int: ...
    def periodSize(self) -> int: ...
    def processedUSecs(self) -> int: ...
    def reset(self): ...
    def resume(self): ...
    def setBufferSize(self, bytes: int): ...
    def setNotifyInterval(self, milliSeconds: int): ...
    def setVolume(self, volume: float): ...
    @typing.overload
    def start(self) -> PySide2.QtCore.QIODevice: ...
    @typing.overload
    def start(self, device: PySide2.QtCore.QIODevice): ...
    def state(self) -> PySide2.QtMultimedia.QAudio.State: ...
    def stop(self): ...
    def suspend(self): ...
    def volume(self) -> float: ...


class QAudioInputSelectorControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def activeInput(self) -> str: ...
    def availableInputs(self) -> str: ...
    def defaultInput(self) -> str: ...
    def inputDescription(self, name: str) -> str: ...
    def setActiveInput(self, name: str): ...


class QAudioOutput(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, audioDeviceInfo: PySide2.QtMultimedia.QAudioDeviceInfo, format: PySide2.QtMultimedia.QAudioFormat = ..., parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, format: PySide2.QtMultimedia.QAudioFormat = ..., parent: PySide2.QtCore.QObject = ...): ...
    def bufferSize(self) -> int: ...
    def bytesFree(self) -> int: ...
    def category(self) -> str: ...
    def elapsedUSecs(self) -> int: ...
    def error(self) -> PySide2.QtMultimedia.QAudio.Error: ...
    def format(self) -> PySide2.QtMultimedia.QAudioFormat: ...
    def notifyInterval(self) -> int: ...
    def periodSize(self) -> int: ...
    def processedUSecs(self) -> int: ...
    def reset(self): ...
    def resume(self): ...
    def setBufferSize(self, bytes: int): ...
    def setCategory(self, category: str): ...
    def setNotifyInterval(self, milliSeconds: int): ...
    def setVolume(self, arg__1: float): ...
    @typing.overload
    def start(self) -> PySide2.QtCore.QIODevice: ...
    @typing.overload
    def start(self, device: PySide2.QtCore.QIODevice): ...
    def state(self) -> PySide2.QtMultimedia.QAudio.State: ...
    def stop(self): ...
    def suspend(self): ...
    def volume(self) -> float: ...


class QAudioOutputSelectorControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def activeOutput(self) -> str: ...
    def availableOutputs(self) -> str: ...
    def defaultOutput(self) -> str: ...
    def outputDescription(self, name: str) -> str: ...
    def setActiveOutput(self, name: str): ...


class QAudioProbe(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def isActive(self) -> bool: ...
    @typing.overload
    def setSource(self, source: PySide2.QtMultimedia.QMediaObject) -> bool: ...
    @typing.overload
    def setSource(self, source: PySide2.QtMultimedia.QMediaRecorder) -> bool: ...


class QAudioRecorder(PySide2.QtMultimedia.QMediaRecorder):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def audioInput(self) -> str: ...
    def audioInputDescription(self, name: str) -> str: ...
    def audioInputs(self) -> typing.List[str]: ...
    def defaultAudioInput(self) -> str: ...
    def setAudioInput(self, name: str): ...


class QAudioRoleControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def audioRole(self) -> PySide2.QtMultimedia.QAudio.Role: ...
    def setAudioRole(self, role: PySide2.QtMultimedia.QAudio.Role): ...
    def supportedAudioRoles(self) -> PySide2.QtMultimedia.QAudio.Role: ...


class QCamera(PySide2.QtMultimedia.QMediaObject):

    @typing.overload
    def __init__(self, cameraInfo: PySide2.QtMultimedia.QCameraInfo, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, deviceName: PySide2.QtCore.QByteArray, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def __init__(self, position: PySide2.QtMultimedia.QCamera.Position, parent: PySide2.QtCore.QObject = ...): ...
    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...
    @staticmethod
    def availableDevices() -> PySide2.QtCore.QByteArray: ...
    def captureMode(self) -> PySide2.QtMultimedia.QCamera.CaptureModes: ...
    @staticmethod
    def deviceDescription(device: PySide2.QtCore.QByteArray) -> str: ...
    def error(self) -> PySide2.QtMultimedia.QCamera.Error: ...
    def errorString(self) -> str: ...
    def isCaptureModeSupported(self, mode: PySide2.QtMultimedia.QCamera.CaptureModes) -> bool: ...
    def load(self): ...
    @typing.overload
    def lockStatus(self) -> PySide2.QtMultimedia.QCamera.LockStatus: ...
    @typing.overload
    def lockStatus(self, lock: PySide2.QtMultimedia.QCamera.LockType) -> PySide2.QtMultimedia.QCamera.LockStatus: ...
    def requestedLocks(self) -> PySide2.QtMultimedia.QCamera.LockTypes: ...
    @typing.overload
    def searchAndLock(self): ...
    @typing.overload
    def searchAndLock(self, locks: PySide2.QtMultimedia.QCamera.LockTypes): ...
    def setCaptureMode(self, mode: PySide2.QtMultimedia.QCamera.CaptureModes): ...
    @typing.overload
    def setViewfinder(self, surface: PySide2.QtMultimedia.QAbstractVideoSurface): ...
    @typing.overload
    def setViewfinder(self, viewfinder: 'QGraphicsVideoItem'): ...
    @typing.overload
    def setViewfinder(self, viewfinder: 'QVideoWidget'): ...
    def setViewfinderSettings(self, settings: PySide2.QtMultimedia.QCameraViewfinderSettings): ...
    def start(self): ...
    def state(self) -> PySide2.QtMultimedia.QCamera.State: ...
    def status(self) -> PySide2.QtMultimedia.QCamera.Status: ...
    def stop(self): ...
    def supportedLocks(self) -> PySide2.QtMultimedia.QCamera.LockTypes: ...
    def supportedViewfinderFrameRateRanges(self, settings: PySide2.QtMultimedia.QCameraViewfinderSettings = ...) -> PySide2.QtMultimedia.QCamera.FrameRateRange: ...
    def supportedViewfinderPixelFormats(self, settings: PySide2.QtMultimedia.QCameraViewfinderSettings = ...) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    def supportedViewfinderResolutions(self, settings: PySide2.QtMultimedia.QCameraViewfinderSettings = ...) -> PySide2.QtCore.QSize: ...
    def supportedViewfinderSettings(self, settings: PySide2.QtMultimedia.QCameraViewfinderSettings = ...) -> PySide2.QtMultimedia.QCameraViewfinderSettings: ...
    def unload(self): ...
    @typing.overload
    def unlock(self): ...
    @typing.overload
    def unlock(self, locks: PySide2.QtMultimedia.QCamera.LockTypes): ...
    def viewfinderSettings(self) -> PySide2.QtMultimedia.QCameraViewfinderSettings: ...

    class FrameRateRange(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, FrameRateRange: PySide2.QtMultimedia.QCamera.FrameRateRange): ...
        @typing.overload
        def __init__(self, minimum: float, maximum: float): ...
        def __copy__(self): ...


class QCameraCaptureBufferFormatControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def bufferFormat(self) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    def setBufferFormat(self, format: PySide2.QtMultimedia.QVideoFrame.PixelFormat): ...
    def supportedBufferFormats(self) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...


class QCameraCaptureDestinationControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def captureDestination(self) -> PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations: ...
    def isCaptureDestinationSupported(self, destination: PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations) -> bool: ...
    def setCaptureDestination(self, destination: PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations): ...


class QCameraControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def canChangeProperty(self, changeType: PySide2.QtMultimedia.QCameraControl.PropertyChangeType, status: PySide2.QtMultimedia.QCamera.Status) -> bool: ...
    def captureMode(self) -> PySide2.QtMultimedia.QCamera.CaptureModes: ...
    def isCaptureModeSupported(self, mode: PySide2.QtMultimedia.QCamera.CaptureModes) -> bool: ...
    def setCaptureMode(self, arg__1: PySide2.QtMultimedia.QCamera.CaptureModes): ...
    def setState(self, state: PySide2.QtMultimedia.QCamera.State): ...
    def state(self) -> PySide2.QtMultimedia.QCamera.State: ...
    def status(self) -> PySide2.QtMultimedia.QCamera.Status: ...


class QCameraExposureControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def actualValue(self, parameter: PySide2.QtMultimedia.QCameraExposureControl.ExposureParameter) -> typing.Any: ...
    def isParameterSupported(self, parameter: PySide2.QtMultimedia.QCameraExposureControl.ExposureParameter) -> bool: ...
    def requestedValue(self, parameter: PySide2.QtMultimedia.QCameraExposureControl.ExposureParameter) -> typing.Any: ...
    def setValue(self, parameter: PySide2.QtMultimedia.QCameraExposureControl.ExposureParameter, value: typing.Any) -> bool: ...


class QCameraFeedbackControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def isEventFeedbackEnabled(self, arg__1: PySide2.QtMultimedia.QCameraFeedbackControl.EventType) -> bool: ...
    def isEventFeedbackLocked(self, arg__1: PySide2.QtMultimedia.QCameraFeedbackControl.EventType) -> bool: ...
    def resetEventFeedback(self, arg__1: PySide2.QtMultimedia.QCameraFeedbackControl.EventType): ...
    def setEventFeedbackEnabled(self, arg__1: PySide2.QtMultimedia.QCameraFeedbackControl.EventType, arg__2: bool) -> bool: ...
    def setEventFeedbackSound(self, arg__1: PySide2.QtMultimedia.QCameraFeedbackControl.EventType, filePath: str) -> bool: ...


class QCameraFocusZone(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, area: PySide2.QtCore.QRectF, status: PySide2.QtMultimedia.QCameraFocusZone.FocusZoneStatus = ...): ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QCameraFocusZone): ...
    def __copy__(self): ...
    def area(self) -> PySide2.QtCore.QRectF: ...
    def isValid(self) -> bool: ...
    def setStatus(self, status: PySide2.QtMultimedia.QCameraFocusZone.FocusZoneStatus): ...
    def status(self) -> PySide2.QtMultimedia.QCameraFocusZone.FocusZoneStatus: ...


class QCameraImageCapture(PySide2.QtCore.QObject, PySide2.QtMultimedia.QMediaBindableInterface):

    def __init__(self, mediaObject: PySide2.QtMultimedia.QMediaObject, parent: PySide2.QtCore.QObject = ...): ...
    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...
    def bufferFormat(self) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    def cancelCapture(self): ...
    def capture(self, location: str = ...) -> int: ...
    def captureDestination(self) -> PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations: ...
    def encodingSettings(self) -> PySide2.QtMultimedia.QImageEncoderSettings: ...
    def error(self) -> PySide2.QtMultimedia.QCameraImageCapture.Error: ...
    def errorString(self) -> str: ...
    def imageCodecDescription(self, codecName: str) -> str: ...
    def isAvailable(self) -> bool: ...
    def isCaptureDestinationSupported(self, destination: PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations) -> bool: ...
    def isReadyForCapture(self) -> bool: ...
    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def setBufferFormat(self, format: PySide2.QtMultimedia.QVideoFrame.PixelFormat): ...
    def setCaptureDestination(self, destination: PySide2.QtMultimedia.QCameraImageCapture.CaptureDestinations): ...
    def setEncodingSettings(self, settings: PySide2.QtMultimedia.QImageEncoderSettings): ...
    def setMediaObject(self, arg__1: PySide2.QtMultimedia.QMediaObject) -> bool: ...
    def supportedBufferFormats(self) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    def supportedImageCodecs(self) -> typing.List[str]: ...


class QCameraImageCaptureControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def cancelCapture(self): ...
    def capture(self, fileName: str) -> int: ...
    def driveMode(self) -> PySide2.QtMultimedia.QCameraImageCapture.DriveMode: ...
    def isReadyForCapture(self) -> bool: ...
    def setDriveMode(self, mode: PySide2.QtMultimedia.QCameraImageCapture.DriveMode): ...


class QCameraImageProcessingControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def isParameterSupported(self, arg__1: PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter) -> bool: ...
    def isParameterValueSupported(self, parameter: PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter, value: typing.Any) -> bool: ...
    def parameter(self, parameter: PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter) -> typing.Any: ...
    def setParameter(self, parameter: PySide2.QtMultimedia.QCameraImageProcessingControl.ProcessingParameter, value: typing.Any): ...


class QCameraInfo(Shiboken.Object):

    @typing.overload
    def __init__(self, camera: PySide2.QtMultimedia.QCamera): ...
    @typing.overload
    def __init__(self, name: PySide2.QtCore.QByteArray = ...): ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QCameraInfo): ...
    def __copy__(self): ...
    @staticmethod
    def availableCameras(position: PySide2.QtMultimedia.QCamera.Position = ...) -> PySide2.QtMultimedia.QCameraInfo: ...
    @staticmethod
    def defaultCamera() -> PySide2.QtMultimedia.QCameraInfo: ...
    def description(self) -> str: ...
    def deviceName(self) -> str: ...
    def isNull(self) -> bool: ...
    def orientation(self) -> int: ...
    def position(self) -> PySide2.QtMultimedia.QCamera.Position: ...


class QCameraInfoControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def cameraOrientation(self, deviceName: str) -> int: ...
    def cameraPosition(self, deviceName: str) -> PySide2.QtMultimedia.QCamera.Position: ...


class QCameraLocksControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def lockStatus(self, lock: PySide2.QtMultimedia.QCamera.LockType) -> PySide2.QtMultimedia.QCamera.LockStatus: ...
    def searchAndLock(self, locks: PySide2.QtMultimedia.QCamera.LockTypes): ...
    def supportedLocks(self) -> PySide2.QtMultimedia.QCamera.LockTypes: ...
    def unlock(self, locks: PySide2.QtMultimedia.QCamera.LockTypes): ...


class QCameraViewfinderSettings(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QCameraViewfinderSettings): ...
    def __copy__(self): ...
    def isNull(self) -> bool: ...
    def maximumFrameRate(self) -> float: ...
    def minimumFrameRate(self) -> float: ...
    def pixelAspectRatio(self) -> PySide2.QtCore.QSize: ...
    def pixelFormat(self) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    def resolution(self) -> PySide2.QtCore.QSize: ...
    def setMaximumFrameRate(self, rate: float): ...
    def setMinimumFrameRate(self, rate: float): ...
    @typing.overload
    def setPixelAspectRatio(self, horizontal: int, vertical: int): ...
    @typing.overload
    def setPixelAspectRatio(self, ratio: PySide2.QtCore.QSize): ...
    def setPixelFormat(self, format: PySide2.QtMultimedia.QVideoFrame.PixelFormat): ...
    @typing.overload
    def setResolution(self, arg__1: PySide2.QtCore.QSize): ...
    @typing.overload
    def setResolution(self, width: int, height: int): ...
    def swap(self, other: PySide2.QtMultimedia.QCameraViewfinderSettings): ...


class QCameraViewfinderSettingsControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def isViewfinderParameterSupported(self, parameter: PySide2.QtMultimedia.QCameraViewfinderSettingsControl.ViewfinderParameter) -> bool: ...
    def setViewfinderParameter(self, parameter: PySide2.QtMultimedia.QCameraViewfinderSettingsControl.ViewfinderParameter, value: typing.Any): ...
    def viewfinderParameter(self, parameter: PySide2.QtMultimedia.QCameraViewfinderSettingsControl.ViewfinderParameter) -> typing.Any: ...


class QCameraViewfinderSettingsControl2(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def setViewfinderSettings(self, settings: PySide2.QtMultimedia.QCameraViewfinderSettings): ...
    def supportedViewfinderSettings(self) -> PySide2.QtMultimedia.QCameraViewfinderSettings: ...
    def viewfinderSettings(self) -> PySide2.QtMultimedia.QCameraViewfinderSettings: ...


class QCameraZoomControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def currentDigitalZoom(self) -> float: ...
    def currentOpticalZoom(self) -> float: ...
    def maximumDigitalZoom(self) -> float: ...
    def maximumOpticalZoom(self) -> float: ...
    def requestedDigitalZoom(self) -> float: ...
    def requestedOpticalZoom(self) -> float: ...
    def zoomTo(self, optical: float, digital: float): ...


class QCustomAudioRoleControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def customAudioRole(self) -> str: ...
    def setCustomAudioRole(self, role: str): ...
    def supportedCustomAudioRoles(self) -> typing.List[str]: ...


class QImageEncoderControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def imageCodecDescription(self, codec: str) -> str: ...
    def imageSettings(self) -> PySide2.QtMultimedia.QImageEncoderSettings: ...
    def setImageSettings(self, settings: PySide2.QtMultimedia.QImageEncoderSettings): ...
    def supportedImageCodecs(self) -> typing.List[str]: ...


class QImageEncoderSettings(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QImageEncoderSettings): ...
    def __copy__(self): ...
    def codec(self) -> str: ...
    def encodingOption(self, option: str) -> typing.Any: ...
    def encodingOptions(self) -> dict: ...
    def isNull(self) -> bool: ...
    def quality(self) -> PySide2.QtMultimedia.QMultimedia.EncodingQuality: ...
    def resolution(self) -> PySide2.QtCore.QSize: ...
    def setCodec(self, arg__1: str): ...
    def setEncodingOption(self, option: str, value: typing.Any): ...
    def setEncodingOptions(self, options: dict): ...
    def setQuality(self, quality: PySide2.QtMultimedia.QMultimedia.EncodingQuality): ...
    @typing.overload
    def setResolution(self, arg__1: PySide2.QtCore.QSize): ...
    @typing.overload
    def setResolution(self, width: int, height: int): ...


class QMediaAudioProbeControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...


class QMediaAvailabilityControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...


class QMediaBindableInterface(Shiboken.Object):

    def __init__(self): ...
    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def setMediaObject(self, object: PySide2.QtMultimedia.QMediaObject) -> bool: ...


class QMediaContainerControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def containerDescription(self, formatMimeType: str) -> str: ...
    def containerFormat(self) -> str: ...
    def setContainerFormat(self, format: str): ...
    def supportedContainers(self) -> typing.List[str]: ...


class QMediaContent(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, contentRequest: PySide2.QtNetwork.QNetworkRequest): ...
    @typing.overload
    def __init__(self, contentResource: PySide2.QtMultimedia.QMediaResource): ...
    @typing.overload
    def __init__(self, contentUrl: PySide2.QtCore.QUrl): ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QMediaContent): ...
    @typing.overload
    def __init__(self, playlist: PySide2.QtMultimedia.QMediaPlaylist, contentUrl: PySide2.QtCore.QUrl = ..., takeOwnership: bool = ...): ...
    @typing.overload
    def __init__(self, resources: list): ...
    def __copy__(self): ...
    def canonicalRequest(self) -> PySide2.QtNetwork.QNetworkRequest: ...
    def canonicalResource(self) -> PySide2.QtMultimedia.QMediaResource: ...
    def canonicalUrl(self) -> PySide2.QtCore.QUrl: ...
    def isNull(self) -> bool: ...
    def playlist(self) -> PySide2.QtMultimedia.QMediaPlaylist: ...
    def resources(self) -> PySide2.QtMultimedia.QMediaResource: ...


class QMediaControl(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...


class QMediaGaplessPlaybackControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def crossfadeTime(self) -> float: ...
    def isCrossfadeSupported(self) -> bool: ...
    def nextMedia(self) -> PySide2.QtMultimedia.QMediaContent: ...
    def setCrossfadeTime(self, crossfadeTime: float): ...
    def setNextMedia(self, media: PySide2.QtMultimedia.QMediaContent): ...


class QMediaNetworkAccessControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def currentConfiguration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def setConfigurations(self, configuration: list): ...


class QMediaObject(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject, service: PySide2.QtMultimedia.QMediaService): ...
    def addPropertyWatch(self, name: PySide2.QtCore.QByteArray): ...
    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...
    def availableMetaData(self) -> typing.List[str]: ...
    def bind(self, arg__1: PySide2.QtCore.QObject) -> bool: ...
    def isAvailable(self) -> bool: ...
    def isMetaDataAvailable(self) -> bool: ...
    def metaData(self, key: str) -> typing.Any: ...
    def notifyInterval(self) -> int: ...
    def removePropertyWatch(self, name: PySide2.QtCore.QByteArray): ...
    def service(self) -> PySide2.QtMultimedia.QMediaService: ...
    def setNotifyInterval(self, milliSeconds: int): ...
    def unbind(self, arg__1: PySide2.QtCore.QObject): ...


class QMediaPlayer(PySide2.QtMultimedia.QMediaObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ..., flags: PySide2.QtMultimedia.QMediaPlayer.Flags = ...): ...
    def audioRole(self) -> PySide2.QtMultimedia.QAudio.Role: ...
    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...
    def bind(self, arg__1: PySide2.QtCore.QObject) -> bool: ...
    def bufferStatus(self) -> int: ...
    def currentMedia(self) -> PySide2.QtMultimedia.QMediaContent: ...
    def currentNetworkConfiguration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def customAudioRole(self) -> str: ...
    def duration(self) -> int: ...
    def error(self) -> PySide2.QtMultimedia.QMediaPlayer.Error: ...
    def errorString(self) -> str: ...
    @staticmethod
    def hasSupport(mimeType: str, codecs: typing.List[str] = ..., flags: PySide2.QtMultimedia.QMediaPlayer.Flags = ...) -> PySide2.QtMultimedia.QMultimedia.SupportEstimate: ...
    def isAudioAvailable(self) -> bool: ...
    def isMuted(self) -> bool: ...
    def isSeekable(self) -> bool: ...
    def isVideoAvailable(self) -> bool: ...
    def media(self) -> PySide2.QtMultimedia.QMediaContent: ...
    def mediaStatus(self) -> PySide2.QtMultimedia.QMediaPlayer.MediaStatus: ...
    def mediaStream(self) -> PySide2.QtCore.QIODevice: ...
    def pause(self): ...
    def play(self): ...
    def playbackRate(self) -> float: ...
    def playlist(self) -> PySide2.QtMultimedia.QMediaPlaylist: ...
    def position(self) -> int: ...
    def setAudioRole(self, audioRole: PySide2.QtMultimedia.QAudio.Role): ...
    def setCustomAudioRole(self, audioRole: str): ...
    def setMedia(self, media: PySide2.QtMultimedia.QMediaContent, stream: PySide2.QtCore.QIODevice = ...): ...
    def setMuted(self, muted: bool): ...
    def setNetworkConfigurations(self, configurations: list): ...
    def setPlaybackRate(self, rate: float): ...
    def setPlaylist(self, playlist: PySide2.QtMultimedia.QMediaPlaylist): ...
    def setPosition(self, position: int): ...
    @typing.overload
    def setVideoOutput(self, arg__1: 'QGraphicsVideoItem'): ...
    @typing.overload
    def setVideoOutput(self, arg__1: 'QVideoWidget'): ...
    @typing.overload
    def setVideoOutput(self, surface: PySide2.QtMultimedia.QAbstractVideoSurface): ...
    def setVolume(self, volume: int): ...
    def state(self) -> PySide2.QtMultimedia.QMediaPlayer.State: ...
    def stop(self): ...
    def supportedAudioRoles(self) -> PySide2.QtMultimedia.QAudio.Role: ...
    def supportedCustomAudioRoles(self) -> typing.List[str]: ...
    @staticmethod
    def supportedMimeTypes(flags: PySide2.QtMultimedia.QMediaPlayer.Flags = ...) -> typing.List[str]: ...
    def unbind(self, arg__1: PySide2.QtCore.QObject): ...
    def volume(self) -> int: ...


class QMediaPlayerControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def availablePlaybackRanges(self) -> PySide2.QtMultimedia.QMediaTimeRange: ...
    def bufferStatus(self) -> int: ...
    def duration(self) -> int: ...
    def isAudioAvailable(self) -> bool: ...
    def isMuted(self) -> bool: ...
    def isSeekable(self) -> bool: ...
    def isVideoAvailable(self) -> bool: ...
    def media(self) -> PySide2.QtMultimedia.QMediaContent: ...
    def mediaStatus(self) -> PySide2.QtMultimedia.QMediaPlayer.MediaStatus: ...
    def mediaStream(self) -> PySide2.QtCore.QIODevice: ...
    def pause(self): ...
    def play(self): ...
    def playbackRate(self) -> float: ...
    def position(self) -> int: ...
    def setMedia(self, media: PySide2.QtMultimedia.QMediaContent, stream: PySide2.QtCore.QIODevice): ...
    def setMuted(self, mute: bool): ...
    def setPlaybackRate(self, rate: float): ...
    def setPosition(self, position: int): ...
    def setVolume(self, volume: int): ...
    def state(self) -> PySide2.QtMultimedia.QMediaPlayer.State: ...
    def stop(self): ...
    def volume(self) -> int: ...


class QMediaPlaylist(PySide2.QtCore.QObject, PySide2.QtMultimedia.QMediaBindableInterface):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    @typing.overload
    def addMedia(self, content: PySide2.QtMultimedia.QMediaContent) -> bool: ...
    @typing.overload
    def addMedia(self, items: list) -> bool: ...
    def clear(self) -> bool: ...
    def currentIndex(self) -> int: ...
    def currentMedia(self) -> PySide2.QtMultimedia.QMediaContent: ...
    def error(self) -> PySide2.QtMultimedia.QMediaPlaylist.Error: ...
    def errorString(self) -> str: ...
    @typing.overload
    def insertMedia(self, index: int, content: PySide2.QtMultimedia.QMediaContent) -> bool: ...
    @typing.overload
    def insertMedia(self, index: int, items: list) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    @typing.overload
    def load(self, device: PySide2.QtCore.QIODevice, format: str = ...): ...
    @typing.overload
    def load(self, location: PySide2.QtCore.QUrl, format: str = ...): ...
    @typing.overload
    def load(self, request: PySide2.QtNetwork.QNetworkRequest, format: str = ...): ...
    def media(self, index: int) -> PySide2.QtMultimedia.QMediaContent: ...
    def mediaCount(self) -> int: ...
    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def moveMedia(self, from_: int, to: int) -> bool: ...
    def next(self): ...
    def nextIndex(self, steps: int = ...) -> int: ...
    def playbackMode(self) -> PySide2.QtMultimedia.QMediaPlaylist.PlaybackMode: ...
    def previous(self): ...
    def previousIndex(self, steps: int = ...) -> int: ...
    @typing.overload
    def removeMedia(self, pos: int) -> bool: ...
    @typing.overload
    def removeMedia(self, start: int, end: int) -> bool: ...
    @typing.overload
    def save(self, device: PySide2.QtCore.QIODevice, format: str) -> bool: ...
    @typing.overload
    def save(self, location: PySide2.QtCore.QUrl, format: str = ...) -> bool: ...
    def setCurrentIndex(self, index: int): ...
    def setMediaObject(self, object: PySide2.QtMultimedia.QMediaObject) -> bool: ...
    def setPlaybackMode(self, mode: PySide2.QtMultimedia.QMediaPlaylist.PlaybackMode): ...
    def shuffle(self): ...


class QMediaRecorder(PySide2.QtCore.QObject, PySide2.QtMultimedia.QMediaBindableInterface):

    def __init__(self, mediaObject: PySide2.QtMultimedia.QMediaObject, parent: PySide2.QtCore.QObject = ...): ...
    def actualLocation(self) -> PySide2.QtCore.QUrl: ...
    def audioCodecDescription(self, codecName: str) -> str: ...
    def audioSettings(self) -> PySide2.QtMultimedia.QAudioEncoderSettings: ...
    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...
    def availableMetaData(self) -> typing.List[str]: ...
    def containerDescription(self, format: str) -> str: ...
    def containerFormat(self) -> str: ...
    def duration(self) -> int: ...
    def error(self) -> PySide2.QtMultimedia.QMediaRecorder.Error: ...
    def errorString(self) -> str: ...
    def isAvailable(self) -> bool: ...
    def isMetaDataAvailable(self) -> bool: ...
    def isMetaDataWritable(self) -> bool: ...
    def isMuted(self) -> bool: ...
    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def metaData(self, key: str) -> typing.Any: ...
    def outputLocation(self) -> PySide2.QtCore.QUrl: ...
    def pause(self): ...
    def record(self): ...
    def setAudioSettings(self, audioSettings: PySide2.QtMultimedia.QAudioEncoderSettings): ...
    def setContainerFormat(self, container: str): ...
    def setEncodingSettings(self, audioSettings: PySide2.QtMultimedia.QAudioEncoderSettings, videoSettings: PySide2.QtMultimedia.QVideoEncoderSettings = ..., containerMimeType: str = ...): ...
    def setMediaObject(self, object: PySide2.QtMultimedia.QMediaObject) -> bool: ...
    def setMetaData(self, key: str, value: typing.Any): ...
    def setMuted(self, muted: bool): ...
    def setOutputLocation(self, location: PySide2.QtCore.QUrl) -> bool: ...
    def setVideoSettings(self, videoSettings: PySide2.QtMultimedia.QVideoEncoderSettings): ...
    def setVolume(self, volume: float): ...
    def state(self) -> PySide2.QtMultimedia.QMediaRecorder.State: ...
    def status(self) -> PySide2.QtMultimedia.QMediaRecorder.Status: ...
    def stop(self): ...
    def supportedAudioCodecs(self) -> typing.List[str]: ...
    def supportedContainers(self) -> typing.List[str]: ...
    def supportedVideoCodecs(self) -> typing.List[str]: ...
    def videoCodecDescription(self, codecName: str) -> str: ...
    def videoSettings(self) -> PySide2.QtMultimedia.QVideoEncoderSettings: ...
    def volume(self) -> float: ...


class QMediaRecorderControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def applySettings(self): ...
    def duration(self) -> int: ...
    def isMuted(self) -> bool: ...
    def outputLocation(self) -> PySide2.QtCore.QUrl: ...
    def setMuted(self, muted: bool): ...
    def setOutputLocation(self, location: PySide2.QtCore.QUrl) -> bool: ...
    def setState(self, state: PySide2.QtMultimedia.QMediaRecorder.State): ...
    def setVolume(self, volume: float): ...
    def state(self) -> PySide2.QtMultimedia.QMediaRecorder.State: ...
    def status(self) -> PySide2.QtMultimedia.QMediaRecorder.Status: ...
    def volume(self) -> float: ...


class QMediaResource(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QMediaResource): ...
    @typing.overload
    def __init__(self, request: PySide2.QtNetwork.QNetworkRequest, mimeType: str = ...): ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl, mimeType: str = ...): ...
    def __copy__(self): ...
    def audioBitRate(self) -> int: ...
    def audioCodec(self) -> str: ...
    def channelCount(self) -> int: ...
    def dataSize(self) -> int: ...
    def isNull(self) -> bool: ...
    def language(self) -> str: ...
    def mimeType(self) -> str: ...
    def request(self) -> PySide2.QtNetwork.QNetworkRequest: ...
    def resolution(self) -> PySide2.QtCore.QSize: ...
    def sampleRate(self) -> int: ...
    def setAudioBitRate(self, rate: int): ...
    def setAudioCodec(self, codec: str): ...
    def setChannelCount(self, channels: int): ...
    def setDataSize(self, size: int): ...
    def setLanguage(self, language: str): ...
    @typing.overload
    def setResolution(self, resolution: PySide2.QtCore.QSize): ...
    @typing.overload
    def setResolution(self, width: int, height: int): ...
    def setSampleRate(self, frequency: int): ...
    def setVideoBitRate(self, rate: int): ...
    def setVideoCodec(self, codec: str): ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def videoBitRate(self) -> int: ...
    def videoCodec(self) -> str: ...


class QMediaService(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject): ...
    def releaseControl(self, control: PySide2.QtMultimedia.QMediaControl): ...
    def requestControl(self, name: str) -> PySide2.QtMultimedia.QMediaControl: ...


class QMediaServiceCameraInfoInterface(Shiboken.Object):

    def __init__(self): ...
    def cameraOrientation(self, device: PySide2.QtCore.QByteArray) -> int: ...
    def cameraPosition(self, device: PySide2.QtCore.QByteArray) -> PySide2.QtMultimedia.QCamera.Position: ...


class QMediaServiceDefaultDeviceInterface(Shiboken.Object):

    def __init__(self): ...
    def defaultDevice(self, service: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...


class QMediaServiceFeaturesInterface(Shiboken.Object):

    def __init__(self): ...
    def supportedFeatures(self, service: PySide2.QtCore.QByteArray) -> PySide2.QtMultimedia.QMediaServiceProviderHint.Features: ...


class QMediaServiceProviderHint(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, device: PySide2.QtCore.QByteArray): ...
    @typing.overload
    def __init__(self, features: PySide2.QtMultimedia.QMediaServiceProviderHint.Features): ...
    @typing.overload
    def __init__(self, mimeType: str, codecs: typing.List[str]): ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QMediaServiceProviderHint): ...
    @typing.overload
    def __init__(self, position: PySide2.QtMultimedia.QCamera.Position): ...
    def __copy__(self): ...
    def cameraPosition(self) -> PySide2.QtMultimedia.QCamera.Position: ...
    def codecs(self) -> typing.List[str]: ...
    def device(self) -> PySide2.QtCore.QByteArray: ...
    def features(self) -> PySide2.QtMultimedia.QMediaServiceProviderHint.Features: ...
    def isNull(self) -> bool: ...
    def mimeType(self) -> str: ...
    def type(self) -> PySide2.QtMultimedia.QMediaServiceProviderHint.Type: ...


class QMediaServiceSupportedDevicesInterface(Shiboken.Object):

    def __init__(self): ...
    def deviceDescription(self, service: PySide2.QtCore.QByteArray, device: PySide2.QtCore.QByteArray) -> str: ...
    def devices(self, service: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...


class QMediaServiceSupportedFormatsInterface(Shiboken.Object):

    def __init__(self): ...
    def hasSupport(self, mimeType: str, codecs: typing.List[str]) -> PySide2.QtMultimedia.QMultimedia.SupportEstimate: ...
    def supportedMimeTypes(self) -> typing.List[str]: ...


class QMediaStreamsControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def isActive(self, streamNumber: int) -> bool: ...
    def metaData(self, streamNumber: int, key: str) -> typing.Any: ...
    def setActive(self, streamNumber: int, state: bool): ...
    def streamCount(self) -> int: ...
    def streamType(self, streamNumber: int) -> PySide2.QtMultimedia.QMediaStreamsControl.StreamType: ...


class QMediaTimeInterval(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtMultimedia.QMediaTimeInterval): ...
    @typing.overload
    def __init__(self, start: int, end: int): ...
    def __copy__(self): ...
    def contains(self, time: int) -> bool: ...
    def end(self) -> int: ...
    def isNormal(self) -> bool: ...
    def normalized(self) -> PySide2.QtMultimedia.QMediaTimeInterval: ...
    def start(self) -> int: ...
    def translated(self, offset: int) -> PySide2.QtMultimedia.QMediaTimeInterval: ...


class QMediaTimeRange(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1: PySide2.QtMultimedia.QMediaTimeInterval): ...
    @typing.overload
    def __init__(self, range: PySide2.QtMultimedia.QMediaTimeRange): ...
    @typing.overload
    def __init__(self, start: int, end: int): ...
    def __add__(self, arg__2: PySide2.QtMultimedia.QMediaTimeRange) -> PySide2.QtMultimedia.QMediaTimeRange: ...
    def __copy__(self): ...
    @typing.overload
    def __iadd__(self, arg__1: PySide2.QtMultimedia.QMediaTimeInterval) -> PySide2.QtMultimedia.QMediaTimeRange: ...
    @typing.overload
    def __iadd__(self, arg__1: PySide2.QtMultimedia.QMediaTimeRange) -> PySide2.QtMultimedia.QMediaTimeRange: ...
    @typing.overload
    def __isub__(self, arg__1: PySide2.QtMultimedia.QMediaTimeInterval) -> PySide2.QtMultimedia.QMediaTimeRange: ...
    @typing.overload
    def __isub__(self, arg__1: PySide2.QtMultimedia.QMediaTimeRange) -> PySide2.QtMultimedia.QMediaTimeRange: ...
    def __sub__(self, arg__2: PySide2.QtMultimedia.QMediaTimeRange) -> PySide2.QtMultimedia.QMediaTimeRange: ...
    @typing.overload
    def addInterval(self, interval: PySide2.QtMultimedia.QMediaTimeInterval): ...
    @typing.overload
    def addInterval(self, start: int, end: int): ...
    def addTimeRange(self, arg__1: PySide2.QtMultimedia.QMediaTimeRange): ...
    def clear(self): ...
    def contains(self, time: int) -> bool: ...
    def earliestTime(self) -> int: ...
    def intervals(self) -> PySide2.QtMultimedia.QMediaTimeInterval: ...
    def isContinuous(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def latestTime(self) -> int: ...
    @typing.overload
    def removeInterval(self, interval: PySide2.QtMultimedia.QMediaTimeInterval): ...
    @typing.overload
    def removeInterval(self, start: int, end: int): ...
    def removeTimeRange(self, arg__1: PySide2.QtMultimedia.QMediaTimeRange): ...


class QMediaVideoProbeControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...


class QMetaDataReaderControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def availableMetaData(self) -> typing.List[str]: ...
    def isMetaDataAvailable(self) -> bool: ...
    def metaData(self, key: str) -> typing.Any: ...


class QMetaDataWriterControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def availableMetaData(self) -> typing.List[str]: ...
    def isMetaDataAvailable(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def metaData(self, key: str) -> typing.Any: ...
    def setMetaData(self, key: str, value: typing.Any): ...


class QMultimedia: ...


class QRadioData(PySide2.QtCore.QObject, PySide2.QtMultimedia.QMediaBindableInterface):

    def __init__(self, mediaObject: PySide2.QtMultimedia.QMediaObject, parent: PySide2.QtCore.QObject = ...): ...
    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...
    def error(self) -> PySide2.QtMultimedia.QRadioData.Error: ...
    def errorString(self) -> str: ...
    def isAlternativeFrequenciesEnabled(self) -> bool: ...
    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def programType(self) -> PySide2.QtMultimedia.QRadioData.ProgramType: ...
    def programTypeName(self) -> str: ...
    def radioText(self) -> str: ...
    def setAlternativeFrequenciesEnabled(self, enabled: bool): ...
    def setMediaObject(self, arg__1: PySide2.QtMultimedia.QMediaObject) -> bool: ...
    def stationId(self) -> str: ...
    def stationName(self) -> str: ...


class QRadioDataControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def error(self) -> PySide2.QtMultimedia.QRadioData.Error: ...
    def errorString(self) -> str: ...
    def isAlternativeFrequenciesEnabled(self) -> bool: ...
    def programType(self) -> PySide2.QtMultimedia.QRadioData.ProgramType: ...
    def programTypeName(self) -> str: ...
    def radioText(self) -> str: ...
    def setAlternativeFrequenciesEnabled(self, enabled: bool): ...
    def stationId(self) -> str: ...
    def stationName(self) -> str: ...


class QRadioTuner(PySide2.QtMultimedia.QMediaObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def availability(self) -> PySide2.QtMultimedia.QMultimedia.AvailabilityStatus: ...
    def band(self) -> PySide2.QtMultimedia.QRadioTuner.Band: ...
    def cancelSearch(self): ...
    def error(self) -> PySide2.QtMultimedia.QRadioTuner.Error: ...
    def errorString(self) -> str: ...
    def frequency(self) -> int: ...
    def frequencyRange(self, band: PySide2.QtMultimedia.QRadioTuner.Band) -> typing.Tuple[typing.Any, typing.Any]: ...
    def frequencyStep(self, band: PySide2.QtMultimedia.QRadioTuner.Band) -> int: ...
    def isAntennaConnected(self) -> bool: ...
    def isBandSupported(self, b: PySide2.QtMultimedia.QRadioTuner.Band) -> bool: ...
    def isMuted(self) -> bool: ...
    def isSearching(self) -> bool: ...
    def isStereo(self) -> bool: ...
    def radioData(self) -> PySide2.QtMultimedia.QRadioData: ...
    def searchAllStations(self, searchMode: PySide2.QtMultimedia.QRadioTuner.SearchMode = ...): ...
    def searchBackward(self): ...
    def searchForward(self): ...
    def setBand(self, band: PySide2.QtMultimedia.QRadioTuner.Band): ...
    def setFrequency(self, frequency: int): ...
    def setMuted(self, muted: bool): ...
    def setStereoMode(self, mode: PySide2.QtMultimedia.QRadioTuner.StereoMode): ...
    def setVolume(self, volume: int): ...
    def signalStrength(self) -> int: ...
    def start(self): ...
    def state(self) -> PySide2.QtMultimedia.QRadioTuner.State: ...
    def stereoMode(self) -> PySide2.QtMultimedia.QRadioTuner.StereoMode: ...
    def stop(self): ...
    def volume(self) -> int: ...


class QRadioTunerControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def band(self) -> PySide2.QtMultimedia.QRadioTuner.Band: ...
    def cancelSearch(self): ...
    def error(self) -> PySide2.QtMultimedia.QRadioTuner.Error: ...
    def errorString(self) -> str: ...
    def frequency(self) -> int: ...
    def frequencyRange(self, b: PySide2.QtMultimedia.QRadioTuner.Band) -> typing.Tuple[typing.Any, typing.Any]: ...
    def frequencyStep(self, b: PySide2.QtMultimedia.QRadioTuner.Band) -> int: ...
    def isAntennaConnected(self) -> bool: ...
    def isBandSupported(self, b: PySide2.QtMultimedia.QRadioTuner.Band) -> bool: ...
    def isMuted(self) -> bool: ...
    def isSearching(self) -> bool: ...
    def isStereo(self) -> bool: ...
    def searchAllStations(self, searchMode: PySide2.QtMultimedia.QRadioTuner.SearchMode = ...): ...
    def searchBackward(self): ...
    def searchForward(self): ...
    def setBand(self, b: PySide2.QtMultimedia.QRadioTuner.Band): ...
    def setFrequency(self, frequency: int): ...
    def setMuted(self, muted: bool): ...
    def setStereoMode(self, mode: PySide2.QtMultimedia.QRadioTuner.StereoMode): ...
    def setVolume(self, volume: int): ...
    def signalStrength(self) -> int: ...
    def start(self): ...
    def state(self) -> PySide2.QtMultimedia.QRadioTuner.State: ...
    def stereoMode(self) -> PySide2.QtMultimedia.QRadioTuner.StereoMode: ...
    def stop(self): ...
    def volume(self) -> int: ...


class QSound(PySide2.QtCore.QObject):

    def __init__(self, filename: str, parent: PySide2.QtCore.QObject = ...): ...
    def fileName(self) -> str: ...
    def isFinished(self) -> bool: ...
    def loops(self) -> int: ...
    def loopsRemaining(self) -> int: ...
    @typing.overload
    @staticmethod
    def play(): ...
    @typing.overload
    @staticmethod
    def play(filename: str): ...
    def setLoops(self, arg__1: int): ...
    def stop(self): ...


class QSoundEffect(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def category(self) -> str: ...
    def isLoaded(self) -> bool: ...
    def isMuted(self) -> bool: ...
    def isPlaying(self) -> bool: ...
    def loopCount(self) -> int: ...
    def loopsRemaining(self) -> int: ...
    def play(self): ...
    def setCategory(self, category: str): ...
    def setLoopCount(self, loopCount: int): ...
    def setMuted(self, muted: bool): ...
    def setSource(self, url: PySide2.QtCore.QUrl): ...
    def setVolume(self, volume: float): ...
    def source(self) -> PySide2.QtCore.QUrl: ...
    def status(self) -> PySide2.QtMultimedia.QSoundEffect.Status: ...
    def stop(self): ...
    @staticmethod
    def supportedMimeTypes() -> typing.List[str]: ...
    def volume(self) -> float: ...


class QVideoDeviceSelectorControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def defaultDevice(self) -> int: ...
    def deviceCount(self) -> int: ...
    def deviceDescription(self, index: int) -> str: ...
    def deviceName(self, index: int) -> str: ...
    def selectedDevice(self) -> int: ...
    def setSelectedDevice(self, index: int): ...


class QVideoEncoderSettings(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QVideoEncoderSettings): ...
    def __copy__(self): ...
    def bitRate(self) -> int: ...
    def codec(self) -> str: ...
    def encodingMode(self) -> PySide2.QtMultimedia.QMultimedia.EncodingMode: ...
    def encodingOption(self, option: str) -> typing.Any: ...
    def encodingOptions(self) -> dict: ...
    def frameRate(self) -> float: ...
    def isNull(self) -> bool: ...
    def quality(self) -> PySide2.QtMultimedia.QMultimedia.EncodingQuality: ...
    def resolution(self) -> PySide2.QtCore.QSize: ...
    def setBitRate(self, bitrate: int): ...
    def setCodec(self, arg__1: str): ...
    def setEncodingMode(self, arg__1: PySide2.QtMultimedia.QMultimedia.EncodingMode): ...
    def setEncodingOption(self, option: str, value: typing.Any): ...
    def setEncodingOptions(self, options: dict): ...
    def setFrameRate(self, rate: float): ...
    def setQuality(self, quality: PySide2.QtMultimedia.QMultimedia.EncodingQuality): ...
    @typing.overload
    def setResolution(self, arg__1: PySide2.QtCore.QSize): ...
    @typing.overload
    def setResolution(self, width: int, height: int): ...


class QVideoEncoderSettingsControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def setVideoSettings(self, settings: PySide2.QtMultimedia.QVideoEncoderSettings): ...
    def supportedVideoCodecs(self) -> typing.List[str]: ...
    def videoCodecDescription(self, codec: str) -> str: ...
    def videoSettings(self) -> PySide2.QtMultimedia.QVideoEncoderSettings: ...


class QVideoFilterRunnable(Shiboken.Object):

    def __init__(self): ...
    def run(self, input: PySide2.QtMultimedia.QVideoFrame, surfaceFormat: PySide2.QtMultimedia.QVideoSurfaceFormat, flags: PySide2.QtMultimedia.QVideoFilterRunnable.RunFlags) -> PySide2.QtMultimedia.QVideoFrame: ...


class QVideoFrame(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, buffer: PySide2.QtMultimedia.QAbstractVideoBuffer, size: PySide2.QtCore.QSize, format: PySide2.QtMultimedia.QVideoFrame.PixelFormat): ...
    @typing.overload
    def __init__(self, bytes: int, size: PySide2.QtCore.QSize, bytesPerLine: int, format: PySide2.QtMultimedia.QVideoFrame.PixelFormat): ...
    @typing.overload
    def __init__(self, image: PySide2.QtGui.QImage): ...
    @typing.overload
    def __init__(self, other: PySide2.QtMultimedia.QVideoFrame): ...
    def __copy__(self): ...
    def availableMetaData(self) -> dict: ...
    def bits(self) -> typing.Union[str, int]: ...
    @typing.overload
    def bytesPerLine(self) -> int: ...
    @typing.overload
    def bytesPerLine(self, plane: int) -> int: ...
    def endTime(self) -> int: ...
    def fieldType(self) -> PySide2.QtMultimedia.QVideoFrame.FieldType: ...
    def handle(self) -> typing.Any: ...
    def handleType(self) -> PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType: ...
    def height(self) -> int: ...
    @staticmethod
    def imageFormatFromPixelFormat(format: PySide2.QtMultimedia.QVideoFrame.PixelFormat) -> PySide2.QtGui.QImage.Format: ...
    def isMapped(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isValid(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def map(self, mode: PySide2.QtMultimedia.QAbstractVideoBuffer.MapMode) -> bool: ...
    def mapMode(self) -> PySide2.QtMultimedia.QAbstractVideoBuffer.MapMode: ...
    def mappedBytes(self) -> int: ...
    def metaData(self, key: str) -> typing.Any: ...
    def pixelFormat(self) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    @staticmethod
    def pixelFormatFromImageFormat(format: PySide2.QtGui.QImage.Format) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    def planeCount(self) -> int: ...
    def setEndTime(self, time: int): ...
    def setFieldType(self, arg__1: PySide2.QtMultimedia.QVideoFrame.FieldType): ...
    def setMetaData(self, key: str, value: typing.Any): ...
    def setStartTime(self, time: int): ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def startTime(self) -> int: ...
    def unmap(self): ...
    def width(self) -> int: ...


class QVideoProbe(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def isActive(self) -> bool: ...
    @typing.overload
    def setSource(self, source: PySide2.QtMultimedia.QMediaObject) -> bool: ...
    @typing.overload
    def setSource(self, source: PySide2.QtMultimedia.QMediaRecorder) -> bool: ...


class QVideoRendererControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def setSurface(self, surface: PySide2.QtMultimedia.QAbstractVideoSurface): ...
    def surface(self) -> PySide2.QtMultimedia.QAbstractVideoSurface: ...


class QVideoSurfaceFormat(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, format: PySide2.QtMultimedia.QVideoSurfaceFormat): ...
    @typing.overload
    def __init__(self, size: PySide2.QtCore.QSize, pixelFormat: PySide2.QtMultimedia.QVideoFrame.PixelFormat, handleType: PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType = ...): ...
    def __copy__(self): ...
    def frameHeight(self) -> int: ...
    def frameRate(self) -> float: ...
    def frameSize(self) -> PySide2.QtCore.QSize: ...
    def frameWidth(self) -> int: ...
    def handleType(self) -> PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType: ...
    def isMirrored(self) -> bool: ...
    def isValid(self) -> bool: ...
    def pixelAspectRatio(self) -> PySide2.QtCore.QSize: ...
    def pixelFormat(self) -> PySide2.QtMultimedia.QVideoFrame.PixelFormat: ...
    def property(self, name: str) -> typing.Any: ...
    def propertyNames(self) -> PySide2.QtCore.QByteArray: ...
    def scanLineDirection(self) -> PySide2.QtMultimedia.QVideoSurfaceFormat.Direction: ...
    def setFrameRate(self, rate: float): ...
    @typing.overload
    def setFrameSize(self, size: PySide2.QtCore.QSize): ...
    @typing.overload
    def setFrameSize(self, width: int, height: int): ...
    def setMirrored(self, mirrored: bool): ...
    @typing.overload
    def setPixelAspectRatio(self, ratio: PySide2.QtCore.QSize): ...
    @typing.overload
    def setPixelAspectRatio(self, width: int, height: int): ...
    def setProperty(self, name: str, value: typing.Any): ...
    def setScanLineDirection(self, direction: PySide2.QtMultimedia.QVideoSurfaceFormat.Direction): ...
    def setViewport(self, viewport: PySide2.QtCore.QRect): ...
    def setYCbCrColorSpace(self, colorSpace: PySide2.QtMultimedia.QVideoSurfaceFormat.YCbCrColorSpace): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def viewport(self) -> PySide2.QtCore.QRect: ...
    def yCbCrColorSpace(self) -> PySide2.QtMultimedia.QVideoSurfaceFormat.YCbCrColorSpace: ...


class QVideoWindowControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def aspectRatioMode(self) -> PySide2.QtCore.Qt.AspectRatioMode: ...
    def brightness(self) -> int: ...
    def contrast(self) -> int: ...
    def displayRect(self) -> PySide2.QtCore.QRect: ...
    def hue(self) -> int: ...
    def isFullScreen(self) -> bool: ...
    def nativeSize(self) -> PySide2.QtCore.QSize: ...
    def repaint(self): ...
    def saturation(self) -> int: ...
    def setAspectRatioMode(self, mode: PySide2.QtCore.Qt.AspectRatioMode): ...
    def setBrightness(self, brightness: int): ...
    def setContrast(self, contrast: int): ...
    def setDisplayRect(self, rect: PySide2.QtCore.QRect): ...
    def setFullScreen(self, fullScreen: bool): ...
    def setHue(self, hue: int): ...
    def setSaturation(self, saturation: int): ...
    def setWinId(self, id: int): ...
    def winId(self) -> int: ...

# eof
