/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryBlacklister;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.ArtifactNotFoundException;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentArtifactsResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resolve.result.ErroringResolveResult;

public class ErrorHandlingModuleComponentRepository
implements ModuleComponentRepository {
    private final ModuleComponentRepository delegate;
    private final ErrorHandlingModuleComponentRepositoryAccess local;
    private final ErrorHandlingModuleComponentRepositoryAccess remote;

    public ErrorHandlingModuleComponentRepository(ModuleComponentRepository delegate, RepositoryBlacklister remoteRepositoryBlacklister) {
        this.delegate = delegate;
        this.local = new ErrorHandlingModuleComponentRepositoryAccess(delegate.getLocalAccess(), this.getId(), RepositoryBlacklister.NoOpBlacklister.INSTANCE, this.getName());
        this.remote = new ErrorHandlingModuleComponentRepositoryAccess(delegate.getRemoteAccess(), this.getId(), remoteRepositoryBlacklister, this.getName());
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public ModuleComponentRepositoryAccess getLocalAccess() {
        return this.local;
    }

    @Override
    public ModuleComponentRepositoryAccess getRemoteAccess() {
        return this.remote;
    }

    @Override
    public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
        return this.delegate.getArtifactCache();
    }

    @Override
    public InstantiatingAction<ComponentMetadataSupplierDetails> getComponentMetadataSupplier() {
        return this.delegate.getComponentMetadataSupplier();
    }

    private static final class ErrorHandlingModuleComponentRepositoryAccess
    implements ModuleComponentRepositoryAccess {
        private static final Logger LOGGER = Logging.getLogger(ErrorHandlingModuleComponentRepositoryAccess.class);
        private static final String MAX_TENTATIVES_BEFORE_BLACKLISTING = "org.gradle.internal.repository.max.tentatives";
        private static final String INITIAL_BACKOFF_MS = "org.gradle.internal.repository.initial.backoff";
        private static final String BLACKLISTED_REPOSITORY_ERROR_MESSAGE = "Skipped due to earlier error";
        private final ModuleComponentRepositoryAccess delegate;
        private final String repositoryId;
        private final RepositoryBlacklister repositoryBlacklister;
        private final int maxTentativesCount;
        private final int initialBackOff;
        private final String repositoryName;

        private ErrorHandlingModuleComponentRepositoryAccess(ModuleComponentRepositoryAccess delegate, String repositoryId, RepositoryBlacklister repositoryBlacklister, String repositoryName) {
            this(delegate, repositoryId, repositoryBlacklister, Integer.getInteger(MAX_TENTATIVES_BEFORE_BLACKLISTING, 3), Integer.getInteger(INITIAL_BACKOFF_MS, 1000), repositoryName);
        }

        private ErrorHandlingModuleComponentRepositoryAccess(ModuleComponentRepositoryAccess delegate, String repositoryId, RepositoryBlacklister repositoryBlacklister, int maxTentativesCount, int initialBackoff, String repositoryName) {
            this.repositoryName = repositoryName;
            assert (maxTentativesCount > 0) : "Max tentatives must be > 0";
            assert (initialBackoff >= 0) : "Initial backoff must be >= 0";
            this.delegate = delegate;
            this.repositoryId = repositoryId;
            this.repositoryBlacklister = repositoryBlacklister;
            this.maxTentativesCount = maxTentativesCount;
            this.initialBackOff = initialBackoff;
        }

        public String toString() {
            return "error handling > " + this.delegate.toString();
        }

        @Override
        public void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
            this.performOperationWithRetries(result, () -> this.delegate.listModuleVersions(dependency, result), () -> new ModuleVersionResolveException((ComponentSelector)dependency.getSelector(), BLACKLISTED_REPOSITORY_ERROR_MESSAGE), throwable -> {
                ModuleComponentSelector selector = dependency.getSelector();
                String message = "Failed to list versions for " + selector.getGroup() + ":" + selector.getModule() + ".";
                return new ModuleVersionResolveException((ComponentSelector)selector, message, (Throwable)throwable);
            });
        }

        @Override
        public void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult result) {
            this.performOperationWithRetries(result, () -> this.delegate.resolveComponentMetaData(moduleComponentIdentifier, requestMetaData, result), () -> new ModuleVersionResolveException(moduleComponentIdentifier, BLACKLISTED_REPOSITORY_ERROR_MESSAGE), throwable -> new ModuleVersionResolveException(moduleComponentIdentifier, (Throwable)throwable));
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            this.performOperationWithRetries(result, () -> this.delegate.resolveArtifactsWithType(component, artifactType, result), () -> new ArtifactResolveException(component.getId(), BLACKLISTED_REPOSITORY_ERROR_MESSAGE), throwable -> new ArtifactResolveException(component.getId(), (Throwable)throwable));
        }

        @Override
        public void resolveArtifacts(ComponentResolveMetadata component, BuildableComponentArtifactsResolveResult result) {
            this.performOperationWithRetries(result, () -> this.delegate.resolveArtifacts(component, result), () -> new ArtifactResolveException(component.getId(), BLACKLISTED_REPOSITORY_ERROR_MESSAGE), throwable -> new ArtifactResolveException(component.getId(), (Throwable)throwable));
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
            this.performOperationWithRetries(result, () -> {
                ArtifactResolveException failure;
                this.delegate.resolveArtifact(artifact, moduleSource, result);
                if (result.hasResult() && !((failure = result.getFailure()) instanceof ArtifactNotFoundException)) {
                    return failure;
                }
                return null;
            }, () -> new ArtifactResolveException(artifact.getId(), BLACKLISTED_REPOSITORY_ERROR_MESSAGE), throwable -> new ArtifactResolveException(artifact.getId(), (Throwable)throwable));
        }

        private <E extends Throwable, R extends ErroringResolveResult<E>> void performOperationWithRetries(R result, Callable<E> operation, Factory<E> onBlacklisted, Transformer<E, Throwable> onError) {
            if (this.repositoryBlacklister.isBlacklisted(this.repositoryId)) {
                result.failed((Throwable)((Throwable)onBlacklisted.create()));
                return;
            }
            this.tryResolveAndMaybeBlacklist(result, operation, onError);
        }

        private <E extends Throwable, R extends ErroringResolveResult<E>> void performOperationWithRetries(R result, Runnable operation, Factory<E> onBlacklisted, Transformer<E, Throwable> onError) {
            if (this.repositoryBlacklister.isBlacklisted(this.repositoryId)) {
                result.failed((Throwable)((Throwable)onBlacklisted.create()));
                return;
            }
            this.tryResolveAndMaybeBlacklist(result, operation, onBlacklisted, onError);
        }

        private <E extends Throwable, R extends ErroringResolveResult<E>> void tryResolveAndMaybeBlacklist(R result, Runnable operation, Factory<E> onBlacklisted, Transformer<E, Throwable> onError) {
            this.tryResolveAndMaybeBlacklist(result, () -> {
                operation.run();
                return null;
            }, onError);
        }

        private <E extends Throwable, R extends ErroringResolveResult<E>> void tryResolveAndMaybeBlacklist(R result, Callable<E> operation, Transformer<E, Throwable> onError) {
            int retries = 0;
            int backoff = this.initialBackOff;
            while (retries < this.maxTentativesCount) {
                Throwable failure;
                ++retries;
                Exception unexpectedFailure = null;
                try {
                    failure = (Throwable)operation.call();
                    if (failure == null) {
                        if (retries > 1) {
                            LOGGER.debug("Successfully fetched external resource after {} retries", (Object)(retries - 1));
                        }
                        return;
                    }
                }
                catch (Exception throwable) {
                    unexpectedFailure = throwable;
                    failure = (Throwable)onError.transform((Object)throwable);
                }
                if (retries == this.maxTentativesCount) {
                    if (unexpectedFailure != null) {
                        this.repositoryBlacklister.blacklistRepository(this.repositoryId, unexpectedFailure);
                    }
                    result.failed((Throwable)failure);
                    break;
                }
                LOGGER.debug("Error while accessing remote repository {}. Waiting {}ms before next retry. {} retries left", new Object[]{this.repositoryName, backoff, this.maxTentativesCount - retries, failure});
                try {
                    Thread.sleep(backoff);
                    backoff *= 2;
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            return this.delegate.estimateMetadataFetchingCost(moduleComponentIdentifier);
        }
    }
}

