/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import com.google.common.collect.ImmutableList;
import java.io.EOFException;
import java.io.IOException;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataSerializer;
import org.gradle.internal.component.external.model.AbstractLazyModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AbstractRealisedModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultVirtualModuleComponentIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.VirtualComponentIdentifier;
import org.gradle.internal.component.external.model.ivy.DefaultIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ivy.RealisedIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ivy.RealisedIvyModuleResolveMetadataSerializationHelper;
import org.gradle.internal.component.external.model.maven.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.RealisedMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.RealisedMavenModuleResolveMetadataSerializationHelper;
import org.gradle.internal.resolve.caching.DesugaringAttributeContainerSerializer;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class ModuleComponentResolveMetadataSerializer
extends AbstractSerializer<ModuleComponentResolveMetadata> {
    private final RealisedIvyModuleResolveMetadataSerializationHelper ivySerializationHelper;
    private final RealisedMavenModuleResolveMetadataSerializationHelper mavenSerializationHelper;
    private final ModuleMetadataSerializer delegate;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public ModuleComponentResolveMetadataSerializer(ModuleMetadataSerializer delegate, DesugaringAttributeContainerSerializer attributeContainerSerializer, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.delegate = delegate;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.ivySerializationHelper = new RealisedIvyModuleResolveMetadataSerializationHelper(attributeContainerSerializer, moduleIdentifierFactory);
        this.mavenSerializationHelper = new RealisedMavenModuleResolveMetadataSerializationHelper(attributeContainerSerializer, moduleIdentifierFactory);
    }

    public ModuleComponentResolveMetadata read(Decoder decoder) throws EOFException, Exception {
        MutableModuleComponentResolveMetadata mutable = this.delegate.read(decoder, this.moduleIdentifierFactory);
        this.readPlatformOwners(decoder, mutable);
        AbstractLazyModuleComponentResolveMetadata resolveMetadata = (AbstractLazyModuleComponentResolveMetadata)mutable.asImmutable();
        if (resolveMetadata instanceof DefaultIvyModuleResolveMetadata) {
            return this.ivySerializationHelper.readMetadata(decoder, (DefaultIvyModuleResolveMetadata)resolveMetadata);
        }
        if (resolveMetadata instanceof DefaultMavenModuleResolveMetadata) {
            return this.mavenSerializationHelper.readMetadata(decoder, (DefaultMavenModuleResolveMetadata)resolveMetadata);
        }
        throw new IllegalStateException("Unknown resolved metadata type: " + resolveMetadata.getClass());
    }

    private void readPlatformOwners(Decoder decoder, MutableModuleComponentResolveMetadata mutable) throws IOException {
        int len = decoder.readSmallInt();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                ModuleComponentIdentifier moduleComponentIdentifier = this.readModuleIdentifier(decoder);
                mutable.belongsTo((ComponentIdentifier)moduleComponentIdentifier);
            }
        }
    }

    private ModuleComponentIdentifier readModuleIdentifier(Decoder decoder) throws IOException {
        boolean virtual = decoder.readBoolean();
        String group = decoder.readString();
        String module = decoder.readString();
        String version = decoder.readString();
        ModuleIdentifier moduleIdentifier = DefaultModuleIdentifier.newId(group, module);
        return virtual ? new DefaultVirtualModuleComponentIdentifier(moduleIdentifier, version) : DefaultModuleComponentIdentifier.newId(moduleIdentifier, version);
    }

    public void write(Encoder encoder, ModuleComponentResolveMetadata value) throws Exception {
        AbstractRealisedModuleComponentResolveMetadata transformed = this.assertRealized(value);
        this.delegate.write(encoder, transformed);
        this.writeOwners(encoder, value.getPlatformOwners());
        if (transformed instanceof RealisedIvyModuleResolveMetadata) {
            this.ivySerializationHelper.writeRealisedVariantsData(encoder, transformed);
            this.ivySerializationHelper.writeRealisedConfigurationsData(encoder, transformed);
        } else if (transformed instanceof RealisedMavenModuleResolveMetadata) {
            this.mavenSerializationHelper.writeRealisedVariantsData(encoder, transformed);
            this.mavenSerializationHelper.writeRealisedConfigurationsData(encoder, transformed);
        } else {
            throw new IllegalStateException("Unexpected realised module component resolve metadata type: " + transformed.getClass());
        }
    }

    private void writeOwners(Encoder encoder, ImmutableList<? extends ComponentIdentifier> platformOwners) throws IOException {
        encoder.writeSmallInt(platformOwners.size());
        for (ComponentIdentifier platformOwner : platformOwners) {
            this.writeComponentIdentifier(encoder, (ModuleComponentIdentifier)platformOwner);
        }
    }

    private void writeComponentIdentifier(Encoder encoder, ModuleComponentIdentifier platformOwner) throws IOException {
        encoder.writeBoolean(platformOwner instanceof VirtualComponentIdentifier);
        encoder.writeString((CharSequence)platformOwner.getGroup());
        encoder.writeString((CharSequence)platformOwner.getModule());
        encoder.writeString((CharSequence)platformOwner.getVersion());
    }

    private AbstractRealisedModuleComponentResolveMetadata assertRealized(ModuleComponentResolveMetadata metadata) {
        if (metadata instanceof AbstractRealisedModuleComponentResolveMetadata) {
            return (AbstractRealisedModuleComponentResolveMetadata)metadata;
        }
        throw new IllegalStateException("The type of metadata received is not supported - " + metadata.getClass().getName());
    }
}

