/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrFieldExpressionBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ConstAndJvmFieldPropertiesLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "substituteGetter", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetFieldImpl;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyGetterDescriptor;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "substituteSetter", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrSetFieldImpl;", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitProperty", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "backend"})
public final class ConstAndJvmFieldPropertiesLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        if (JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(declaration.getDescriptor())) {
            declaration.setGetter(null);
            declaration.setSetter(null);
        }
        return super.visitProperty(declaration);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        FunctionDescriptor functionDescriptor = expression2.getDescriptor();
        if (!(functionDescriptor instanceof PropertyAccessorDescriptor)) {
            functionDescriptor = null;
        }
        PropertyAccessorDescriptor propertyAccessorDescriptor = (PropertyAccessorDescriptor)functionDescriptor;
        if (propertyAccessorDescriptor == null) {
            return super.visitCall(expression2);
        }
        PropertyAccessorDescriptor descriptor2 = propertyAccessorDescriptor;
        PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
        PropertyDescriptor property = propertyDescriptor;
        if (JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(property)) {
            return descriptor2 instanceof PropertyGetterDescriptor ? (IrFieldExpressionBase)this.substituteGetter((PropertyGetterDescriptor)descriptor2, expression2) : (IrFieldExpressionBase)this.substituteSetter(descriptor2, expression2);
        }
        if (property instanceof SyntheticJavaPropertyDescriptor) {
            expression2.setDispatchReceiver(expression2.getExtensionReceiver());
            expression2.setExtensionReceiver(null);
        }
        return super.visitCall(expression2);
    }

    private final IrSetFieldImpl substituteSetter(PropertyAccessorDescriptor descriptor2, IrCall expression2) {
        IrClassSymbol irClassSymbol;
        int n = expression2.getStartOffset();
        int n2 = expression2.getEndOffset();
        ReferenceSymbolTable referenceSymbolTable = this.context.getIr().getSymbols().getExternalSymbolTable();
        PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
        IrFieldSymbol irFieldSymbol = referenceSymbolTable.referenceField(propertyDescriptor);
        IrExpression irExpression = expression2.getDispatchReceiver();
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.valueParameters");
        IrExpression irExpression2 = expression2.getValueArgument(CollectionsKt.getLastIndex(list2));
        if (irExpression2 == null) {
            Intrinsics.throwNpe();
        }
        IrType irType = expression2.getType();
        IrStatementOrigin irStatementOrigin = expression2.getOrigin();
        ClassDescriptor classDescriptor2 = expression2.getSuperQualifier();
        if (classDescriptor2 != null) {
            ClassDescriptor classDescriptor3 = classDescriptor2;
            IrStatementOrigin irStatementOrigin2 = irStatementOrigin;
            IrType irType2 = irType;
            IrExpression irExpression3 = irExpression2;
            IrExpression irExpression4 = irExpression;
            IrFieldSymbol irFieldSymbol2 = irFieldSymbol;
            int n3 = n2;
            int n4 = n;
            ClassDescriptor it = classDescriptor3;
            IrClassSymbol irClassSymbol2 = this.context.getIr().getSymbols().getExternalSymbolTable().referenceClass(it);
            n = n4;
            n2 = n3;
            irFieldSymbol = irFieldSymbol2;
            irExpression = irExpression4;
            irExpression2 = irExpression3;
            irType = irType2;
            irStatementOrigin = irStatementOrigin2;
            irClassSymbol = irClassSymbol2;
        } else {
            irClassSymbol = null;
        }
        IrClassSymbol irClassSymbol3 = irClassSymbol;
        IrStatementOrigin irStatementOrigin3 = irStatementOrigin;
        IrType irType3 = irType;
        IrExpression irExpression5 = irExpression2;
        IrExpression irExpression6 = irExpression;
        IrFieldSymbol irFieldSymbol3 = irFieldSymbol;
        int n5 = n2;
        int n6 = n;
        return new IrSetFieldImpl(n6, n5, irFieldSymbol3, irExpression6, irExpression5, irType3, irStatementOrigin3, irClassSymbol3);
    }

    private final IrGetFieldImpl substituteGetter(PropertyGetterDescriptor descriptor2, IrCall expression2) {
        IrClassSymbol irClassSymbol;
        int n = expression2.getStartOffset();
        int n2 = expression2.getEndOffset();
        ReferenceSymbolTable referenceSymbolTable = this.context.getIr().getSymbols().getExternalSymbolTable();
        PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
        IrFieldSymbol irFieldSymbol = referenceSymbolTable.referenceField(propertyDescriptor);
        IrType irType = expression2.getType();
        IrExpression irExpression = expression2.getDispatchReceiver();
        IrStatementOrigin irStatementOrigin = expression2.getOrigin();
        ClassDescriptor classDescriptor2 = expression2.getSuperQualifier();
        if (classDescriptor2 != null) {
            ClassDescriptor classDescriptor3 = classDescriptor2;
            IrStatementOrigin irStatementOrigin2 = irStatementOrigin;
            IrExpression irExpression2 = irExpression;
            IrType irType2 = irType;
            IrFieldSymbol irFieldSymbol2 = irFieldSymbol;
            int n3 = n2;
            int n4 = n;
            ClassDescriptor it = classDescriptor3;
            IrClassSymbol irClassSymbol2 = this.context.getIr().getSymbols().getExternalSymbolTable().referenceClass(it);
            n = n4;
            n2 = n3;
            irFieldSymbol = irFieldSymbol2;
            irType = irType2;
            irExpression = irExpression2;
            irStatementOrigin = irStatementOrigin2;
            irClassSymbol = irClassSymbol2;
        } else {
            irClassSymbol = null;
        }
        IrClassSymbol irClassSymbol3 = irClassSymbol;
        IrStatementOrigin irStatementOrigin3 = irStatementOrigin;
        IrExpression irExpression3 = irExpression;
        IrType irType3 = irType;
        IrFieldSymbol irFieldSymbol3 = irFieldSymbol;
        int n5 = n2;
        int n6 = n;
        return new IrGetFieldImpl(n6, n5, irFieldSymbol3, irType3, irExpression3, irStatementOrigin3, irClassSymbol3);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public ConstAndJvmFieldPropertiesLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

