/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsStaticContext;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.backend.js.utils.SimpleNameGenerator;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B)\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020/H\u0002J\u001a\u00100\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "", "rootScope", "Lorg/jetbrains/kotlin/js/backend/ast/JsRootScope;", "backendContext", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsRootScope;Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "parent", "block", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "func", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;Lorg/jetbrains/kotlin/js/backend/ast/JsScope;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "continuation", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getContinuation", "()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "currentBlock", "getCurrentBlock", "()Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "currentFunction", "getCurrentFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "currentScope", "getCurrentScope", "()Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "getParent", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "program", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "staticContext", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "getStaticContext", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "getNameForLoop", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "getNameForSymbol", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getNameForType", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isCoroutineDoResume", "", "newDeclaration", "backend.js"})
public final class JsGenerationContext {
    @NotNull
    private final JsBlock currentBlock;
    @NotNull
    private final JsScope currentScope;
    @Nullable
    private final IrFunction currentFunction;
    @Nullable
    private final JsGenerationContext parent;
    @NotNull
    private final JsStaticContext staticContext;
    private final JsProgram program;

    @NotNull
    public final JsGenerationContext newDeclaration(@NotNull JsScope scope, @Nullable IrFunction func) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        return new JsGenerationContext(this, func != null ? new JsBlock() : (JsBlock)new JsGlobalBlock(), scope, func);
    }

    @NotNull
    public static /* synthetic */ JsGenerationContext newDeclaration$default(JsGenerationContext jsGenerationContext, JsScope jsScope, IrFunction irFunction, int n, Object object) {
        if ((n & 2) != 0) {
            irFunction = null;
        }
        return jsGenerationContext.newDeclaration(jsScope, irFunction);
    }

    @NotNull
    public final JsBlock getCurrentBlock() {
        return this.currentBlock;
    }

    @NotNull
    public final JsScope getCurrentScope() {
        return this.currentScope;
    }

    @Nullable
    public final IrFunction getCurrentFunction() {
        return this.currentFunction;
    }

    @Nullable
    public final JsGenerationContext getParent() {
        return this.parent;
    }

    @NotNull
    public final JsStaticContext getStaticContext() {
        return this.staticContext;
    }

    @NotNull
    public final JsName getNameForSymbol(@NotNull IrSymbol symbol2) {
        Intrinsics.checkParameterIsNotNull((Object)symbol2, (String)"symbol");
        return this.staticContext.getNameForSymbol(symbol2, this);
    }

    @NotNull
    public final JsName getNameForType(@NotNull IrType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return this.staticContext.getNameForType(type2, this);
    }

    @Nullable
    public final JsName getNameForLoop(@NotNull IrLoop loop2) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        return this.staticContext.getNameForLoop(loop2, this);
    }

    @NotNull
    public final JsExpression getContinuation() {
        JsExpression jsExpression;
        if (this.isCoroutineDoResume()) {
            jsExpression = new JsThisRef();
        } else {
            JsNameRef jsNameRef;
            IrFunction irFunction = this.currentFunction;
            if (irFunction == null) {
                Intrinsics.throwNpe();
            }
            if (irFunction.getDescriptor().isSuspend()) {
                jsNameRef = new JsNameRef(this.currentScope.declareName(Namer.INSTANCE.getCONTINUATION()));
            } else {
                JsNameRef jsNameRef2 = this.getNameForSymbol((IrSymbol)((IrValueParameter)CollectionsKt.last(this.currentFunction.getValueParameters())).getSymbol()).makeRef();
                jsNameRef = jsNameRef2;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef2, (String)"getNameForSymbol(current\u2026.last().symbol).makeRef()");
            }
            jsExpression = jsNameRef;
        }
        return jsExpression;
    }

    private final boolean isCoroutineDoResume() {
        Object object;
        IrFunction irFunction = this.currentFunction;
        if (!(irFunction instanceof IrSimpleFunction)) {
            irFunction = null;
        }
        if ((object = (IrSimpleFunction)irFunction) == null || (object = object.getOverriddenSymbols()) == null) {
            return false;
        }
        Object overriddenSymbols2 = object;
        return overriddenSymbols2.contains(this.staticContext.getDoResumeFunctionSymbol());
    }

    public JsGenerationContext(@NotNull JsRootScope rootScope2, @NotNull JsIrBackendContext backendContext) {
        Intrinsics.checkParameterIsNotNull((Object)rootScope2, (String)"rootScope");
        Intrinsics.checkParameterIsNotNull((Object)backendContext, (String)"backendContext");
        this.parent = null;
        JsProgram jsProgram = rootScope2.getProgram();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsProgram, (String)"rootScope.program");
        this.program = jsProgram;
        JsGlobalBlock jsGlobalBlock = this.program.getGlobalBlock();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsGlobalBlock, (String)"program.globalBlock");
        this.staticContext = new JsStaticContext(rootScope2, jsGlobalBlock, new SimpleNameGenerator(), backendContext);
        this.currentScope = rootScope2;
        JsGlobalBlock jsGlobalBlock2 = this.program.getGlobalBlock();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsGlobalBlock2, (String)"program.globalBlock");
        this.currentBlock = jsGlobalBlock2;
        this.currentFunction = null;
    }

    public JsGenerationContext(@NotNull JsGenerationContext parent2, @NotNull JsBlock block, @NotNull JsScope scope, @Nullable IrFunction func) {
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        this.parent = parent2;
        this.program = parent2.program;
        this.staticContext = parent2.staticContext;
        this.currentBlock = block;
        this.currentScope = scope;
        this.currentFunction = func;
    }
}

