/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph;

import org.gradle.api.tasks.diagnostics.internal.graph.NodeRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.internal.logging.text.StyledTextOutput;

public class SimpleNodeRenderer
implements NodeRenderer {
    @Override
    public void renderNode(StyledTextOutput output, RenderableDependency node, boolean alreadyRendered) {
        output.text((Object)node.getName());
        switch (node.getResolutionState()) {
            case FAILED: {
                output.withStyle(StyledTextOutput.Style.Failure).text((Object)" FAILED");
                break;
            }
            case RESOLVED: {
                if (!alreadyRendered || node.getChildren().isEmpty()) break;
                output.withStyle(StyledTextOutput.Style.Info).text((Object)" (*)");
                break;
            }
            case UNRESOLVED: {
                output.withStyle(StyledTextOutput.Style.Info).text((Object)" (n)");
            }
        }
    }
}

