/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.binary;

import java.io.File;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.AbstractBuildableComponentSpec;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.component.local.model.DefaultLibraryBinaryIdentifier;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelMaps;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ModelInstantiationException;
import org.gradle.platform.base.internal.BinaryBuildAbility;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;
import org.gradle.platform.base.internal.DefaultBinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultBinaryTasksCollection;
import org.gradle.platform.base.internal.FixedBuildAbility;

@Incubating
public class BaseBinarySpec
extends AbstractBuildableComponentSpec
implements BinarySpecInternal {
    private static final ModelType<BinaryTasksCollection> BINARY_TASKS_COLLECTION = ModelType.of(BinaryTasksCollection.class);
    private static final ModelType<LanguageSourceSet> LANGUAGE_SOURCE_SET_MODELTYPE = ModelType.of(LanguageSourceSet.class);
    private static final ThreadLocal<BinaryInfo> NEXT_BINARY_INFO = new ThreadLocal();
    private final DomainObjectSet<LanguageSourceSet> inputSourceSets = new DefaultDomainObjectSet(LanguageSourceSet.class);
    private final BinaryTasksCollection tasks;
    private final MutableModelNode componentNode;
    private final MutableModelNode sources;
    private final Class<? extends BinarySpec> publicType;
    private BinaryNamingScheme namingScheme;
    private boolean disabled;

    public static <T extends BaseBinarySpec> T create(Class<? extends BinarySpec> publicType, Class<T> implementationType, ComponentSpecIdentifier componentId, MutableModelNode modelNode, @Nullable MutableModelNode componentNode, Instantiator instantiator, NamedEntityInstantiator<Task> taskInstantiator) {
        NEXT_BINARY_INFO.set(new BinaryInfo(componentId, publicType, modelNode, componentNode, taskInstantiator, instantiator));
        try {
            BaseBinarySpec baseBinarySpec = (BaseBinarySpec)DirectInstantiator.INSTANCE.newInstance(implementationType, new Object[0]);
            return (T)baseBinarySpec;
        }
        catch (ObjectInstantiationException e) {
            throw new ModelInstantiationException(String.format("Could not create binary of type %s", publicType.getSimpleName()), e.getCause());
        }
        finally {
            NEXT_BINARY_INFO.set(null);
        }
    }

    public BaseBinarySpec() {
        this(NEXT_BINARY_INFO.get());
    }

    private BaseBinarySpec(BinaryInfo info) {
        super(BaseBinarySpec.validate(info).componentId, info.publicType);
        this.publicType = info.publicType;
        this.componentNode = info.componentNode;
        this.tasks = (BinaryTasksCollection)info.instantiator.newInstance(DefaultBinaryTasksCollection.class, new Object[]{this, info.taskInstantiator});
        MutableModelNode modelNode = info.modelNode;
        this.sources = ModelMaps.addModelMapNode((MutableModelNode)modelNode, LANGUAGE_SOURCE_SET_MODELTYPE, (String)"sources");
        ModelRegistration itemRegistration = ModelRegistrations.of((ModelPath)modelNode.getPath().child("tasks")).action(ModelActionRole.Create, (Action)new Action<MutableModelNode>(){

            public void execute(MutableModelNode modelNode) {
                modelNode.setPrivateData(BINARY_TASKS_COLLECTION, (Object)BaseBinarySpec.this.tasks);
            }
        }).withProjection((ModelProjection)new UnmanagedModelProjection(BINARY_TASKS_COLLECTION)).descriptor(modelNode.getDescriptor()).build();
        modelNode.addLink(itemRegistration);
        this.namingScheme = DefaultBinaryNamingScheme.component(this.parentComponentName()).withBinaryName(this.getName()).withBinaryType(this.getTypeName());
    }

    private static BinaryInfo validate(BinaryInfo info) {
        if (info == null) {
            throw new ModelInstantiationException("Direct instantiation of a BaseBinarySpec is not permitted. Use a @ComponentType rule instead.");
        }
        return info;
    }

    @Nullable
    private String parentComponentName() {
        ComponentSpec component = this.getComponent();
        return component != null ? component.getName() : null;
    }

    @Override
    public LibraryBinaryIdentifier getId() {
        ComponentSpec component = this.getComponent();
        return new DefaultLibraryBinaryIdentifier(component.getProjectPath(), component.getName(), this.getName());
    }

    @Override
    public Class<? extends BinarySpec> getPublicType() {
        return this.publicType;
    }

    @Override
    @Nullable
    public ComponentSpec getComponent() {
        return this.getComponentAs(ComponentSpec.class);
    }

    @Nullable
    protected <T extends ComponentSpec> T getComponentAs(Class<T> componentType) {
        if (this.componentNode == null) {
            return null;
        }
        ModelType modelType = ModelType.of(componentType);
        return (T)(this.componentNode.canBeViewedAs(modelType) ? (ComponentSpec)this.componentNode.asImmutable(modelType, this.componentNode.getDescriptor()).getInstance() : null);
    }

    @Override
    public String getProjectScopedName() {
        return this.getIdentifier().getProjectScopedName();
    }

    @Override
    public void setBuildable(boolean buildable) {
        this.disabled = !buildable;
    }

    @Override
    public final boolean isBuildable() {
        return this.getBuildAbility().isBuildable();
    }

    @Override
    public DomainObjectSet<LanguageSourceSet> getInputs() {
        return this.inputSourceSets;
    }

    @Override
    public ModelMap<LanguageSourceSet> getSources() {
        return ModelMaps.toView((MutableModelNode)this.sources, LANGUAGE_SOURCE_SET_MODELTYPE);
    }

    @Override
    public BinaryTasksCollection getTasks() {
        return this.tasks;
    }

    @Override
    public boolean isLegacyBinary() {
        return false;
    }

    @Override
    public BinaryNamingScheme getNamingScheme() {
        return this.namingScheme;
    }

    @Override
    public void setNamingScheme(BinaryNamingScheme namingScheme) {
        this.namingScheme = namingScheme;
    }

    @Override
    public boolean hasCodependentSources() {
        return false;
    }

    @Override
    public final BinaryBuildAbility getBuildAbility() {
        if (this.disabled) {
            return new FixedBuildAbility(false);
        }
        return this.getBinaryBuildAbility();
    }

    protected BinaryBuildAbility getBinaryBuildAbility() {
        return new FixedBuildAbility(true);
    }

    public static void replaceSingleDirectory(Set<File> dirs, File dir) {
        switch (dirs.size()) {
            case 0: {
                dirs.add(dir);
                break;
            }
            case 1: {
                dirs.clear();
                dirs.add(dir);
                break;
            }
            default: {
                throw new IllegalStateException("Can't replace multiple directories.");
            }
        }
    }

    private static class BinaryInfo {
        private final Class<? extends BinarySpec> publicType;
        private final MutableModelNode modelNode;
        private final MutableModelNode componentNode;
        private final NamedEntityInstantiator<Task> taskInstantiator;
        private final Instantiator instantiator;
        private final ComponentSpecIdentifier componentId;

        private BinaryInfo(ComponentSpecIdentifier componentId, Class<? extends BinarySpec> publicType, MutableModelNode modelNode, MutableModelNode componentNode, NamedEntityInstantiator<Task> taskInstantiator, Instantiator instantiator) {
            this.componentId = componentId;
            this.publicType = publicType;
            this.modelNode = modelNode;
            this.componentNode = componentNode;
            this.taskInstantiator = taskInstantiator;
            this.instantiator = instantiator;
        }
    }
}

