/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.input;

import java.util.Arrays;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.apache.tools.ant.util.ReflectUtil;

public class SecureInputHandler
extends DefaultInputHandler {
    public void handleInput(InputRequest request) throws BuildException {
        boolean nullInput = false;
        String prompt = this.getPrompt(request);
        try {
            Object console = ReflectUtil.invokeStatic(System.class, "console");
            do {
                char[] input;
                if ((input = (char[])ReflectUtil.invoke(console, "readPassword", String.class, prompt, Object[].class, null)) == null) {
                    nullInput = true;
                    break;
                }
                request.setInput(new String(input));
                Arrays.fill(input, ' ');
            } while (!request.isInputValid());
        }
        catch (Exception e) {
            super.handleInput(request);
        }
        if (nullInput) {
            throw new BuildException("unexpected end of stream while reading input");
        }
    }
}

