/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.DefaultProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.ProductionCppComponent;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.internal.DefaultCppComponent;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.plugins.NativeBasePlugin;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.plugins.StandardToolChainsPlugin;
import org.gradle.swiftpm.internal.SwiftPmTarget;

@Incubating
@NonNullApi
public class CppBasePlugin
implements Plugin<ProjectInternal> {
    private final ProjectPublicationRegistry publicationRegistry;

    @Inject
    public CppBasePlugin(ProjectPublicationRegistry publicationRegistry) {
        this.publicationRegistry = publicationRegistry;
    }

    public void apply(final ProjectInternal project) {
        project.getPluginManager().apply(NativeBasePlugin.class);
        project.getPluginManager().apply(StandardToolChainsPlugin.class);
        final TaskContainerInternal tasks = project.getTasks();
        final DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        ((FeaturePreviews)project.getGradle().getServices().get(FeaturePreviews.class)).enableFeature(FeaturePreviews.Feature.GRADLE_METADATA);
        project.getComponents().withType(DefaultCppBinary.class, (Action)new Action<DefaultCppBinary>(){

            public void execute(final DefaultCppBinary binary) {
                final Names names = binary.getNames();
                String language = "cpp";
                final CppPlatform currentPlatform = binary.getTargetPlatform();
                final NativeToolChainInternal toolChain = binary.getToolChain();
                final Callable<List<File>> systemIncludes = new Callable<List<File>>(){

                    @Override
                    public List<File> call() {
                        PlatformToolProvider platformToolProvider = binary.getPlatformToolProvider();
                        return platformToolProvider.getSystemLibraries(ToolType.CPP_COMPILER).getIncludeDirs();
                    }
                };
                TaskProvider compile = tasks.register(names.getCompileTaskName(language), CppCompile.class, (Action)new Action<CppCompile>(){

                    public void execute(CppCompile compile) {
                        compile.includes(binary.getCompileIncludePath());
                        compile.getSystemIncludes().from(new Object[]{systemIncludes});
                        compile.source(binary.getCppSource());
                        if (binary.isDebuggable()) {
                            compile.setDebuggable(true);
                        }
                        if (binary.isOptimized()) {
                            compile.setOptimized(true);
                        }
                        compile.getTargetPlatform().set((Object)currentPlatform);
                        compile.getToolChain().set((Object)toolChain);
                        compile.getObjectFileDir().set(buildDirectory.dir("obj/" + names.getDirName()));
                        if (binary instanceof CppSharedLibrary) {
                            compile.setPositionIndependentCode(true);
                        }
                    }
                });
                binary.getObjectsDir().set(compile.flatMap((Transformer)new Transformer<Provider<? extends Directory>, CppCompile>(){

                    public Provider<? extends Directory> transform(CppCompile cppCompile) {
                        return cppCompile.getObjectFileDir();
                    }
                }));
                binary.getCompileTask().set((Provider)compile);
            }
        });
        project.getComponents().withType(ProductionCppComponent.class, (Action)new Action<ProductionCppComponent>(){

            public void execute(final ProductionCppComponent component) {
                project.afterEvaluate((Action)new Action<Project>(){

                    public void execute(Project project) {
                        DefaultCppComponent componentInternal = (DefaultCppComponent)((Object)component);
                        CppBasePlugin.this.publicationRegistry.registerPublication(project.getPath(), (ProjectPublication)new DefaultProjectPublication(componentInternal.getDisplayName(), (Object)new SwiftPmTarget((String)component.getBaseName().get()), false));
                    }
                });
            }
        });
    }
}

