/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.T4;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

class UnitCell
extends SimpleUnitCell {
    private P3[] vertices;
    private P3 fractionalOffset;
    private boolean allFractionalRelative;
    protected final P3 cartesianOffset = new P3();
    protected T3 unitCellMultiplier;
    public Lst<String> moreInfo;
    public String name = "";
    private static final double twoP2 = 19.739208802178716;
    private static final V3[] unitVectors = new V3[]{JC.axisX, JC.axisY, JC.axisZ};

    private UnitCell() {
    }

    static UnitCell fromOABC(T3[] t3Array, boolean bl) {
        UnitCell unitCell = new UnitCell();
        if (t3Array.length == 3) {
            t3Array = new T3[]{new P3(), t3Array[0], t3Array[1], t3Array[2]};
        }
        float[] fArray = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, t3Array[1].x, t3Array[1].y, t3Array[1].z, t3Array[2].x, t3Array[2].y, t3Array[2].z, t3Array[3].x, t3Array[3].y, t3Array[3].z};
        unitCell.init(fArray);
        unitCell.allFractionalRelative = bl;
        unitCell.initUnitcellVertices();
        unitCell.setCartesianOffset(t3Array[0]);
        return unitCell;
    }

    public static UnitCell fromParams(float[] fArray, boolean bl) {
        UnitCell unitCell = new UnitCell();
        unitCell.init(fArray);
        unitCell.initUnitcellVertices();
        unitCell.allFractionalRelative = bl;
        return unitCell;
    }

    void initOrientation(M3 m3) {
        if (m3 == null) {
            return;
        }
        M4 m4 = new M4();
        m4.setToM3(m3);
        this.matrixFractionalToCartesian.mul2(m4, this.matrixFractionalToCartesian);
        this.matrixCartesianToFractional.setM4(this.matrixFractionalToCartesian).invert();
        this.initUnitcellVertices();
    }

    final void toUnitCell(T3 t3, T3 t32) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        if (t32 == null) {
            this.matrixCartesianToFractional.rotTrans(t3);
            this.unitize(t3);
            this.matrixFractionalToCartesian.rotTrans(t3);
        } else {
            this.matrixCtoFNoOffset.rotTrans(t3);
            this.unitize(t3);
            t3.add(t32);
            this.matrixFtoCNoOffset.rotTrans(t3);
        }
    }

    public void unitize(T3 t3) {
        switch (this.dimension) {
            case 3: {
                t3.z = UnitCell.toFractionalX(t3.z);
            }
            case 2: {
                t3.y = UnitCell.toFractionalX(t3.y);
            }
            case 1: {
                t3.x = UnitCell.toFractionalX(t3.x);
            }
        }
    }

    public void reset() {
        this.unitCellMultiplier = null;
        this.setOffset(P3.new3(0.0f, 0.0f, 0.0f));
    }

    void setOffset(T3 t3) {
        boolean bl;
        if (t3 == null) {
            return;
        }
        T4 t4 = t3 instanceof T4 ? (T4)t3 : null;
        boolean bl2 = bl = t4 != null && t4.w > 999999.0f;
        if (t4 != null ? t4.w <= 0.0f || bl : t3.x >= 100.0f || t3.y >= 100.0f) {
            T3 t32 = t3.z == 0.0f && t3.x == t3.y && !bl ? null : (this.unitCellMultiplier = bl ? P4.newPt((P4)t4) : P3.newP(t3));
            if (t4 == null || t4.w == 0.0f || bl) {
                return;
            }
        }
        if (this.hasOffset() || t3.lengthSquared() > 0.0f) {
            this.fractionalOffset = new P3();
            this.fractionalOffset.setT(t3);
        }
        this.matrixCartesianToFractional.m03 = -t3.x;
        this.matrixCartesianToFractional.m13 = -t3.y;
        this.matrixCartesianToFractional.m23 = -t3.z;
        this.cartesianOffset.setT(t3);
        this.matrixFractionalToCartesian.m03 = 0.0f;
        this.matrixFractionalToCartesian.m13 = 0.0f;
        this.matrixFractionalToCartesian.m23 = 0.0f;
        this.matrixFractionalToCartesian.rotTrans(this.cartesianOffset);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFNoOffset.setM4(this.matrixCartesianToFractional);
            this.matrixFtoCNoOffset.setM4(this.matrixFractionalToCartesian);
        }
    }

    private void setCartesianOffset(T3 t3) {
        this.cartesianOffset.setT(t3);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        boolean bl = this.hasOffset();
        this.fractionalOffset = new P3();
        this.fractionalOffset.setT(this.cartesianOffset);
        this.matrixCartesianToFractional.m03 = 0.0f;
        this.matrixCartesianToFractional.m13 = 0.0f;
        this.matrixCartesianToFractional.m23 = 0.0f;
        this.matrixCartesianToFractional.rotTrans(this.fractionalOffset);
        this.matrixCartesianToFractional.m03 = -this.fractionalOffset.x;
        this.matrixCartesianToFractional.m13 = -this.fractionalOffset.y;
        this.matrixCartesianToFractional.m23 = -this.fractionalOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFNoOffset.setM4(this.matrixCartesianToFractional);
            this.matrixFtoCNoOffset.setM4(this.matrixFractionalToCartesian);
        }
        if (!bl && this.fractionalOffset.lengthSquared() == 0.0f) {
            this.fractionalOffset = null;
        }
    }

    Map<String, Object> getInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("params", this.unitCellParams);
        hashtable.put("vectors", this.getUnitCellVectors());
        hashtable.put("volume", this.volume);
        hashtable.put("matFtoC", this.matrixFractionalToCartesian);
        hashtable.put("matCtoF", this.matrixCartesianToFractional);
        return hashtable;
    }

    String dumpInfo(boolean bl) {
        return "a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", alpha=" + this.alpha + ", beta=" + this.beta + ", gamma=" + this.gamma + "\n" + Escape.eAP(this.getUnitCellVectors()) + "\nvolume=" + this.volume + (bl ? "\nfractional to cartesian: " + this.matrixFractionalToCartesian + "\ncartesian to fractional: " + this.matrixCartesianToFractional : "");
    }

    P3[] getVertices() {
        return this.vertices;
    }

    P3 getCartesianOffset() {
        return this.cartesianOffset;
    }

    P3 getFractionalOffset() {
        return this.fractionalOffset;
    }

    Tensor getTensor(Viewer viewer, float[] fArray) {
        Tensor tensor = (Tensor)Interface.getUtil("Tensor", viewer, "file");
        if (fArray[0] == 0.0f && fArray[1] == 0.0f && fArray[2] == 0.0f) {
            float f = fArray[7];
            float[] fArray2 = new float[]{f, f, f};
            return tensor.setFromEigenVectors(unitVectors, fArray2, "iso", "Uiso=" + f, null);
        }
        tensor.parBorU = fArray;
        double[] dArray = new double[6];
        int n = (int)fArray[6];
        if (n == 12) {
            dArray[0] = (double)fArray[0] * 19.739208802178716;
            dArray[1] = (double)fArray[1] * 19.739208802178716;
            dArray[2] = (double)fArray[2] * 19.739208802178716;
            dArray[3] = (double)fArray[3] * 19.739208802178716 * 2.0;
            dArray[4] = (double)fArray[4] * 19.739208802178716 * 2.0;
            dArray[5] = (double)fArray[5] * 19.739208802178716 * 2.0;
            fArray[7] = (fArray[0] + fArray[1] + fArray[3]) / 3.0f;
        } else {
            boolean bl = n == 4 || n == 5 || n == 8 || n == 9;
            double d = 2 - n % 2;
            double d2 = n == 8 || n == 9 || n == 10 ? 19.739208802178716 : (n == 4 || n == 5 ? 0.25 : (n == 2 || n == 3 ? Math.log(2.0) : 1.0));
            double d3 = (double)fArray[0] * d2 * (bl ? this.a_ * this.a_ : 1.0);
            double d4 = (double)fArray[1] * d2 * (bl ? this.b_ * this.b_ : 1.0);
            double d5 = (double)fArray[2] * d2 * (bl ? this.c_ * this.c_ : 1.0);
            double d6 = (double)fArray[3] * d2 * (bl ? this.a_ * this.b_ : 1.0) * d;
            double d7 = (double)fArray[4] * d2 * (bl ? this.a_ * this.c_ : 1.0) * d;
            double d8 = (double)fArray[5] * d2 * (bl ? this.b_ * this.c_ : 1.0) * d;
            fArray[7] = (float)Math.pow(d3 / 19.739208802178716 / this.a_ / this.a_ * d4 / 19.739208802178716 / this.b_ / this.b_ * d5 / 19.739208802178716 / this.c_ / this.c_, 0.3333);
            dArray[0] = (double)(this.a * this.a) * d3 + (double)(this.b * this.b) * this.cosGamma * this.cosGamma * d4 + (double)(this.c * this.c) * this.cosBeta * this.cosBeta * d5 + (double)(this.a * this.b) * this.cosGamma * d6 + (double)(this.b * this.c) * this.cosGamma * this.cosBeta * d8 + (double)(this.a * this.c) * this.cosBeta * d7;
            dArray[1] = (double)(this.b * this.b) * this.sinGamma * this.sinGamma * d4 + (double)(this.c * this.c) * this.cA_ * this.cA_ * d5 + (double)(this.b * this.c) * this.cA_ * this.sinGamma * d8;
            dArray[2] = (double)(this.c * this.c) * this.cB_ * this.cB_ * d5;
            dArray[3] = (double)(2.0f * this.b * this.b) * this.cosGamma * this.sinGamma * d4 + (double)(2.0f * this.c * this.c) * this.cA_ * this.cosBeta * d5 + (double)(this.a * this.b) * this.sinGamma * d6 + (double)(this.b * this.c) * (this.cA_ * this.cosGamma + this.sinGamma * this.cosBeta) * d8 + (double)(this.a * this.c) * this.cA_ * d7;
            dArray[4] = (double)(2.0f * this.c * this.c) * this.cB_ * this.cosBeta * d5 + (double)(this.b * this.c) * this.cosGamma * d8 + (double)(this.a * this.c) * this.cB_ * d7;
            dArray[5] = (double)(2.0f * this.c * this.c) * this.cA_ * this.cB_ * d5 + (double)(this.b * this.c) * this.cB_ * this.sinGamma * d8;
        }
        return tensor.setFromThermalEquation(dArray, Escape.eAF(fArray));
    }

    P3[] getCanonicalCopy(float f, boolean bl) {
        P3[] p3Array = new P3[8];
        P3 p3 = null;
        P3 p32 = null;
        if (bl && this.unitCellMultiplier != null) {
            p3 = new P3();
            p32 = new P3();
            UnitCell.ijkToPoint3f((int)this.unitCellMultiplier.x, p3, 0, 0);
            UnitCell.ijkToPoint3f((int)this.unitCellMultiplier.y, p32, 0, 0);
            p32.sub(p3);
        }
        int n = 0;
        while (n < 8) {
            P3 p33 = p3Array[n] = P3.newP(BoxInfo.unitCubePoints[n]);
            if (p3 != null) {
                f *= this.unitCellMultiplier.z == 0.0f ? 1.0f : this.unitCellMultiplier.z;
                p3Array[n].add3(p3.x + p32.x * p33.x, p3.y + p32.y * p33.y, p3.z + p32.z * p33.z);
            }
            this.matrixFractionalToCartesian.rotTrans(p33);
            if (!bl) {
                p33.sub(this.cartesianOffset);
            }
            ++n;
        }
        return BoxInfo.getCanonicalCopy(p3Array, f);
    }

    private static float toFractionalX(float f) {
        if ((f = (float)((double)f - Math.floor(f))) > 0.9999f || f < 1.0E-4f) {
            f = 0.0f;
        }
        return f;
    }

    private void initUnitcellVertices() {
        if (this.matrixFractionalToCartesian == null) {
            return;
        }
        this.matrixCtoFNoOffset = M4.newM4(this.matrixCartesianToFractional);
        this.matrixFtoCNoOffset = M4.newM4(this.matrixFractionalToCartesian);
        this.vertices = new P3[8];
        int n = 8;
        while (--n >= 0) {
            this.vertices[n] = (P3)this.matrixFractionalToCartesian.rotTrans2(BoxInfo.unitCubePoints[n], new P3());
        }
    }

    public boolean checkDistance(P3 p3, P3 p32, float f, float f2, int n, int n2, int n3, P3 p33) {
        P3 p34 = P3.newP(p3);
        this.toCartesian(p34, true);
        int n4 = -n;
        while (n4 <= n) {
            int n5 = -n2;
            while (n5 <= n2) {
                int n6 = -n3;
                while (n6 <= n3) {
                    p33.set(p32.x + (float)n4, p32.y + (float)n5, p32.z + (float)n6);
                    this.toCartesian(p33, true);
                    float f3 = p34.distance(p33);
                    if (f2 > 0.0f ? Math.abs(f3 - f) <= f2 : f3 <= f && f3 > 0.1f) {
                        p33.set(n4, n5, n6);
                        return true;
                    }
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        return false;
    }

    public T3 getUnitCellMultiplier() {
        return this.unitCellMultiplier;
    }

    public P3[] getUnitCellVectors() {
        M4 m4 = this.matrixFractionalToCartesian;
        return new P3[]{P3.newP(this.cartesianOffset), P3.new3(this.fix(m4.m00), this.fix(m4.m10), this.fix(m4.m20)), P3.new3(this.fix(m4.m01), this.fix(m4.m11), this.fix(m4.m21)), P3.new3(this.fix(m4.m02), this.fix(m4.m12), this.fix(m4.m22))};
    }

    private float fix(float f) {
        return Math.abs(f) < 0.001f ? 0.0f : f;
    }

    public boolean isSameAs(UnitCell unitCell) {
        if (unitCell.unitCellParams.length != this.unitCellParams.length) {
            return false;
        }
        int n = this.unitCellParams.length;
        while (--n >= 0) {
            if (this.unitCellParams[n] == unitCell.unitCellParams[n] || Float.isNaN(this.unitCellParams[n]) && Float.isNaN(unitCell.unitCellParams[n])) continue;
            return false;
        }
        return this.fractionalOffset == null ? !unitCell.hasOffset() : (unitCell.fractionalOffset == null ? !this.hasOffset() : this.fractionalOffset.distanceSquared(unitCell.fractionalOffset) == 0.0f);
    }

    public boolean hasOffset() {
        return this.fractionalOffset != null && this.fractionalOffset.lengthSquared() != 0.0f;
    }

    public String getState() {
        String string = "";
        if (this.fractionalOffset != null && this.fractionalOffset.lengthSquared() != 0.0f) {
            string = String.valueOf(string) + "  unitcell offset " + Escape.eP(this.fractionalOffset) + ";\n";
        }
        if (this.unitCellMultiplier != null) {
            string = String.valueOf(string) + "  unitcell range " + UnitCell.escapeMultiplier(this.unitCellMultiplier) + ";\n";
        }
        return string;
    }

    public Quat getQuaternionRotation(String string) {
        V3 v3;
        V3 v32;
        int n;
        V3 v33 = V3.newVsub(this.vertices[4], this.vertices[0]);
        V3 v34 = V3.newVsub(this.vertices[2], this.vertices[0]);
        V3 v35 = V3.newVsub(this.vertices[1], this.vertices[0]);
        V3 v36 = new V3();
        V3 v37 = new V3();
        int n2 = n = string.charAt(0) == '-' ? -1 : 1;
        if (n < 0) {
            string = string.substring(1);
        }
        int n3 = 0;
        if (string.length() == 2) {
            n3 = string.charAt(1) - 48;
            string = string.substring(0, 1);
        }
        boolean bl = n3 % 2 == 0;
        int n4 = "abc".indexOf(string);
        switch (n4) {
            default: {
                v32 = v33;
                v3 = v35;
                if (n3 <= 0 || n > 0 != bl) break;
                v3 = v34;
                v32.scale(-1.0f);
                break;
            }
            case 1: {
                v32 = v34;
                v3 = v33;
                if (n3 <= 0 || n > 0 != bl) break;
                v3 = v35;
                v32.scale(-1.0f);
                break;
            }
            case 2: {
                v32 = v35;
                v3 = v33;
                if (n3 <= 0) break;
                n3 = 5 - n3;
                if (n > 0 == bl) break;
                v3 = v34;
                v32.scale(-1.0f);
            }
        }
        switch (n3) {
            default: {
                break;
            }
            case 2: {
                v32.scale(-1.0f);
                v3.scale(-1.0f);
                break;
            }
            case 3: {
                v3.scale(-1.0f);
                break;
            }
            case 4: {
                v32.scale(-1.0f);
            }
        }
        v36.cross(v32, v3);
        v37.cross(v36, v32);
        return Quat.getQuaternionFrame(null, v37, v36).inv();
    }

    public T3[] getV0abc(Object object) {
        M4 m4;
        if (object instanceof T3[]) {
            return (T3[])object;
        }
        boolean bl = false;
        T3[] t3Array = new V3[4];
        V3 v3 = t3Array[0] = V3.new3(0.0f, 0.0f, 0.0f);
        t3Array[1] = V3.new3(1.0f, 0.0f, 0.0f);
        t3Array[2] = V3.new3(0.0f, 1.0f, 0.0f);
        t3Array[3] = V3.new3(0.0f, 0.0f, 1.0f);
        M3 m3 = new M3();
        if (object instanceof String) {
            String string = (String)object;
            String string2 = "0,0,0";
            if (string.indexOf("a=") == 0) {
                return UnitCell.setOabc(string, null, t3Array);
            }
            int n = string.indexOf(";");
            if (n >= 0) {
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            if (bl = (string = String.valueOf(string) + ";0,0,0").startsWith("!")) {
                string = string.substring(1);
            }
            Symmetry symmetry = new Symmetry();
            symmetry.setSpaceGroup(false);
            int n2 = symmetry.addSpaceGroupOperation("=" + string, 0);
            if (n2 < 0) {
                return null;
            }
            m4 = symmetry.getSpaceGroupOperation(n2);
            ((SymmetryOperation)m4).doFinalize();
            if (string2 != null) {
                String[] stringArray = PT.split(String.valueOf(string2) + "0,0,0", ",");
                float[] fArray = new float[3];
                int n3 = 0;
                while (n3 < 3) {
                    String string3 = stringArray[n3];
                    int n4 = string3.indexOf("/");
                    fArray[n3] = n4 >= 0 ? PT.parseFloat(string3.substring(0, n4)) / PT.parseFloat(string3.substring(n4 + 1)) : PT.parseFloat(string3);
                    ++n3;
                }
                P3 p3 = P3.new3(fArray[0], fArray[1], fArray[2]);
                m4.setTranslation(p3);
            }
        } else if (object instanceof M3) {
            m4 = M4.newMV((M3)object, new P3());
        } else if (object instanceof M4) {
            m4 = (M4)object;
        } else {
            M4 m42 = (M4)((Object[])object)[0];
            m42.getRotationScale(m3);
            this.toCartesian(v3, false);
            m42.rotTrans(v3);
            int n = 1;
            while (n < 4) {
                this.toCartesian(t3Array[n], true);
                m3.rotate(t3Array[n]);
                ++n;
            }
            return t3Array;
        }
        m4.getRotationScale(m3);
        m4.getTranslation(v3);
        if (bl) {
            m3.invert();
            m3.transpose();
            m3.rotate(v3);
            v3.scale(-1.0f);
        } else {
            m3.transpose();
        }
        this.toCartesian(v3, false);
        int n = 1;
        while (n < 4) {
            m3.rotate(t3Array[n]);
            this.toCartesian(t3Array[n], true);
            ++n;
        }
        return t3Array;
    }

    public boolean toFromPrimitive(boolean bl, char c, T3[] t3Array, M3 m3) {
        int n = t3Array.length - 3;
        M3 m32 = null;
        if (c == 'r' || m3 == null) {
            switch (c) {
                default: {
                    return false;
                }
                case 'r': {
                    UnitCell.getReciprocal(t3Array, t3Array, 1.0f);
                    return true;
                }
                case 'P': {
                    bl = true;
                    m32 = M3.newA9(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
                    break;
                }
                case 'A': {
                    m32 = M3.newA9(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.0f, -0.5f, 0.5f});
                    break;
                }
                case 'B': {
                    m32 = M3.newA9(new float[]{0.5f, 0.0f, 0.5f, 0.0f, 1.0f, 0.0f, -0.5f, 0.0f, 0.5f});
                    break;
                }
                case 'C': {
                    m32 = M3.newA9(new float[]{0.5f, 0.5f, 0.0f, -0.5f, 0.5f, 0.0f, 0.0f, 0.0f, 1.0f});
                    break;
                }
                case 'R': {
                    m32 = M3.newA9(new float[]{0.6666667f, -0.33333334f, -0.33333334f, 0.33333334f, 0.33333334f, -0.6666667f, 0.33333334f, 0.33333334f, 0.33333334f});
                    break;
                }
                case 'I': {
                    m32 = M3.newA9(new float[]{-0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, -0.5f});
                    break;
                }
                case 'F': {
                    m32 = M3.newA9(new float[]{0.0f, 0.5f, 0.5f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 0.0f});
                }
            }
            if (!bl) {
                m32.invert();
            }
        } else {
            m32 = M3.newM3(m3);
            if (bl) {
                m32.invert();
            }
        }
        int n2 = t3Array.length;
        while (--n2 >= n) {
            T3 t3 = t3Array[n2];
            this.toFractional(t3, false);
            m32.rotate(t3);
            this.toCartesian(t3, false);
        }
        return true;
    }

    public T3[] getConventionalUnitCell(String string, M3 m3) {
        T3[] t3Array = this.getUnitCellVectors();
        if (!string.equals("P") || m3 != null) {
            this.toFromPrimitive(false, string.charAt(0), t3Array, m3);
        }
        return t3Array;
    }
}

