/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.plugins.report.ReportOutputter;
import org.apache.ivy.util.filter.Filter;

public class ResolveReport {
    private ModuleDescriptor md;
    private Map confReports = new LinkedHashMap();
    private List problemMessages = new ArrayList();
    private List dependencies = new ArrayList();
    private List artifacts = new ArrayList();
    private long resolveTime;
    private long downloadTime;
    private String resolveId;
    private long downloadSize;

    public ResolveReport(ModuleDescriptor md, String resolveId) {
        this.md = md;
        this.resolveId = resolveId;
    }

    public void addReport(String conf, ConfigurationResolveReport report) {
        this.confReports.put(conf, report);
    }

    public ConfigurationResolveReport getConfigurationReport(String conf) {
        return (ConfigurationResolveReport)this.confReports.get(conf);
    }

    public String[] getConfigurations() {
        return this.confReports.keySet().toArray(new String[this.confReports.size()]);
    }

    public void output(ReportOutputter[] outputters, ResolutionCacheManager cacheMgr, ResolveOptions options) throws IOException {
        for (int i = 0; i < outputters.length; ++i) {
            outputters[i].output(this, cacheMgr, options);
        }
    }

    public IvyNode[] getEvictedNodes() {
        LinkedHashSet<IvyNode> all = new LinkedHashSet<IvyNode>();
        for (ConfigurationResolveReport report : this.confReports.values()) {
            all.addAll(Arrays.asList(report.getEvictedNodes()));
        }
        return all.toArray(new IvyNode[all.size()]);
    }

    public IvyNode[] getUnresolvedDependencies() {
        LinkedHashSet<IvyNode> all = new LinkedHashSet<IvyNode>();
        for (ConfigurationResolveReport report : this.confReports.values()) {
            all.addAll(Arrays.asList(report.getUnresolvedDependencies()));
        }
        return all.toArray(new IvyNode[all.size()]);
    }

    public ArtifactDownloadReport[] getFailedArtifactsReports() {
        return ConfigurationResolveReport.filterOutMergedArtifacts(this.getArtifactsReports(DownloadStatus.FAILED, true));
    }

    public ArtifactDownloadReport[] getAllArtifactsReports() {
        return this.getArtifactsReports(null, true);
    }

    public ArtifactDownloadReport[] getArtifactsReports(DownloadStatus downloadStatus, boolean withEvicted) {
        LinkedHashSet<ArtifactDownloadReport> all = new LinkedHashSet<ArtifactDownloadReport>();
        for (ConfigurationResolveReport report : this.confReports.values()) {
            ArtifactDownloadReport[] reports = report.getArtifactsReports(downloadStatus, withEvicted);
            all.addAll(Arrays.asList(reports));
        }
        return all.toArray(new ArtifactDownloadReport[all.size()]);
    }

    public void checkIfChanged() {
        for (ConfigurationResolveReport report : this.confReports.values()) {
            report.checkIfChanged();
        }
    }

    public void setProblemMessages(List problems) {
        this.problemMessages = problems;
    }

    public void setDependencies(List dependencies, Filter artifactFilter) {
        this.dependencies = dependencies;
        this.artifacts = new ArrayList();
        for (IvyNode dependency : dependencies) {
            if (!dependency.isCompletelyEvicted() && !dependency.hasProblem()) {
                this.artifacts.addAll(Arrays.asList(dependency.getSelectedArtifacts(artifactFilter)));
            }
            String[] dconfs = dependency.getRootModuleConfigurations();
            for (int j = 0; j < dconfs.length; ++j) {
                ConfigurationResolveReport configurationReport = this.getConfigurationReport(dconfs[j]);
                if (configurationReport == null) continue;
                configurationReport.addDependency(dependency);
            }
        }
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public List getArtifacts() {
        return this.artifacts;
    }

    public void setResolveTime(long elapsedTime) {
        this.resolveTime = elapsedTime;
    }

    public long getResolveTime() {
        return this.resolveTime;
    }

    public void setDownloadTime(long elapsedTime) {
        this.downloadTime = elapsedTime;
    }

    public long getDownloadTime() {
        return this.downloadTime;
    }

    public void setDownloadSize(long size) {
        this.downloadSize = size;
    }

    public long getDownloadSize() {
        return this.downloadSize;
    }

    public String getResolveId() {
        return this.resolveId;
    }
}

