/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.host;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.api.ScriptSourceNamedFragment;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.FileScriptSource;
import kotlin.script.experimental.host.StringScriptSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\n\u0010\u0006\u001a\u00020\u0003*\u00020\u0007\u001a\n\u0010\u0006\u001a\u00020\u0003*\u00020\u0001\u00a8\u0006\b"}, d2={"getMergedScriptText", "", "script", "Lkotlin/script/experimental/api/SourceCode;", "configuration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "toScriptSource", "Ljava/io/File;", "kotlin-scripting-common"})
public final class ScriptHostUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getMergedScriptText(@NotNull SourceCode script, @Nullable ScriptCompilationConfiguration configuration) {
        String string;
        List<ScriptSourceNamedFragment> sourceFragments;
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        String originalScriptText = script.getText();
        ScriptCompilationConfiguration scriptCompilationConfiguration = configuration;
        List<ScriptSourceNamedFragment> list = sourceFragments = scriptCompilationConfiguration != null ? scriptCompilationConfiguration.get(ScriptCompilationKt.getSourceFragments(ScriptCompilationConfiguration.Companion)) : null;
        if (sourceFragments == null || sourceFragments.isEmpty()) {
            string = originalScriptText;
        } else {
            StringBuilder sb = new StringBuilder(originalScriptText.length());
            ScriptSourceNamedFragment prevFragment = null;
            for (ScriptSourceNamedFragment fragment : sourceFragments) {
                int curPos;
                int n;
                Integer fragmentStartPos = fragment.getRange().getStart().getAbsolutePos();
                Integer fragmentEndPos = fragment.getRange().getEnd().getAbsolutePos();
                if (fragmentStartPos == null || fragmentEndPos == null) {
                    throw (Throwable)new RuntimeException("Script fragments require absolute positions (received: " + fragment + ')');
                }
                if (prevFragment == null) {
                    n = 0;
                } else {
                    Integer n2 = prevFragment.getRange().getEnd().getAbsolutePos();
                    if (n2 == null) {
                        Intrinsics.throwNpe();
                    }
                    n = curPos = n2.intValue();
                }
                if (prevFragment != null) {
                    Integer n3 = prevFragment.getRange().getEnd().getAbsolutePos();
                    if (n3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (Intrinsics.compare((int)n3, (int)fragmentStartPos) > 0) {
                        throw (Throwable)new RuntimeException("Unsorted or overlapping fragments: previous: " + prevFragment + ", current: " + fragment);
                    }
                }
                if (Intrinsics.compare((int)curPos, (int)fragmentStartPos) < 0) {
                    Collection<Character> collection;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    CharSequence charSequence = originalScriptText.subSequence(curPos, fragmentStartPos);
                    StringBuilder stringBuilder = sb;
                    void var12_12 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList($receiver$iv.length());
                    void var14_14 = $receiver$iv$iv;
                    for (int i = 0; i < var14_14.length(); ++i) {
                        int it;
                        char item$iv$iv;
                        char c = item$iv$iv = var14_14.charAt(i);
                        collection = destination$iv$iv;
                        Character c2 = Character.valueOf((char)(it == 13 || it == 10 ? it : 32));
                        collection.add(c2);
                    }
                    collection = (List)destination$iv$iv;
                    stringBuilder.append(collection);
                }
                sb.append(originalScriptText.subSequence(fragmentStartPos, fragmentEndPos));
                prevFragment = fragment;
            }
            String string2 = sb.toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sb.toString()");
        }
        return string;
    }

    @NotNull
    public static final SourceCode toScriptSource(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return new FileScriptSource($receiver);
    }

    @NotNull
    public static final SourceCode toScriptSource(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return new StringScriptSource($receiver);
    }
}

