/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_az_Cyrl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "\u0414\u04af\u043d\u0458\u0430" },
            { "002", "\u0410\u0444\u0440\u0438\u043a\u0430" },
            { "003", "\u0428\u0438\u043c\u0430\u043b\u0438 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "005", "\u04b8\u04d9\u043d\u0443\u0431\u0438 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "009", "\u041e\u043a\u0435\u0430\u043d\u0438\u0458\u0430" },
            { "011", "\u0413\u04d9\u0440\u0431\u0438 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "013", "\u041c\u04d9\u0440\u043a\u04d9\u0437\u0438 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "014", "\u0428\u04d9\u0440\u0433\u0438 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "015", "\u0428\u0438\u043c\u0430\u043b\u0438 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "017", "\u041c\u04d9\u0440\u043a\u04d9\u0437\u0438 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "018", "\u04b8\u04d9\u043d\u0443\u0431\u0438 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "019", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "021", "\u0428\u0438\u043c\u0430\u043b \u0410\u043c\u0435\u0440\u0438\u043a\u0430\u0441\u044b" },
            { "029", "\u041a\u0430\u0440\u0438\u0431" },
            { "030", "\u0428\u04d9\u0440\u0433\u0438 \u0410\u0441\u0438\u0458\u0430" },
            { "034", "\u04b8\u04d9\u043d\u0443\u0431\u0438 \u0410\u0441\u0438\u0458\u0430" },
            { "035", "\u04b8\u04d9\u043d\u0443\u0431-\u0428\u04d9\u0440\u0433\u0438 \u0410\u0441\u0438\u0458\u0430" },
            { "039", "\u04b8\u04d9\u043d\u0443\u0431\u0438 \u0410\u0432\u0440\u043e\u043f\u0430" },
            { "053", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0430\u0437\u0438\u0458\u0430" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "057", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0458\u0430 \u0420\u0435\u049d\u0438\u043e\u043d\u0443" },
            { "061", "\u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "142", "\u0410\u0441\u0438\u0458\u0430" },
            { "143", "\u041c\u04d9\u0440\u043a\u04d9\u0437\u0438 \u0410\u0441\u0438\u0458\u0430" },
            { "145", "\u0413\u04d9\u0440\u0431\u0438 \u0410\u0441\u0438\u0458\u0430" },
            { "150", "\u0410\u0432\u0440\u043e\u043f\u0430" },
            { "151", "\u0428\u04d9\u0440\u0433\u0438 \u0410\u0432\u0440\u043e\u043f\u0430" },
            { "154", "\u0428\u0438\u043c\u0430\u043b\u0438 \u0410\u0432\u0440\u043e\u043f\u0430" },
            { "155", "\u0413\u04d9\u0440\u0431\u0438 \u0410\u0432\u0440\u043e\u043f\u0430" },
            { "419", "\u041b\u0430\u0442\u044b\u043d \u0410\u043c\u0435\u0440\u0438\u043a\u0430\u0441\u044b" },
            { "AC", "\u0410\u0441\u043a\u0435\u043d\u0441\u043e\u043d \u0430\u0434\u0430\u0441\u044b" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0440\u0430" },
            { "AE", "\u0411\u0438\u0440\u043b\u04d9\u0448\u043c\u0438\u0448 \u04d8\u0440\u04d9\u0431 \u04d8\u043c\u0438\u0440\u043b\u0438\u043a\u043b\u04d9\u0440\u0438" },
            { "AF", "\u04d8\u0444\u0433\u0430\u043d\u044b\u0441\u0442\u0430\u043d" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0432\u04d9 \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "AI", "\u0410\u043d\u049d\u0438\u043b\u0458\u0430" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438\u0458\u0430" },
            { "AM", "\u0415\u0440\u043c\u04d9\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u043a\u0430" },
            { "AR", "\u0410\u0440\u049d\u0435\u043d\u0442\u0438\u043d\u0430" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0421\u0430\u043c\u043e\u0430\u0441\u044b" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438\u0458\u0430" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0430" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434 \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "AZ", "\u0410\u0437\u04d9\u0440\u0431\u0430\u0458\u04b9\u0430\u043d" },
            { "BA", "\u0411\u043e\u0441\u043d\u0438\u0458\u0430 \u0432\u04d9 \u04ba\u0435\u0440\u0441\u0435\u0433\u043e\u0432\u0438\u043d\u0430" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "BE", "\u0411\u0435\u043b\u0447\u0438\u043a\u0430" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430 \u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u043e\u043b\u0433\u0430\u0440\u044b\u0441\u0442\u0430\u043d" },
            { "BH", "\u0411\u04d9\u04bb\u0440\u0435\u0458\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u0421\u0435\u043d\u0442-\u0411\u0430\u0440\u0442\u0435\u043b\u0435\u043c\u0438" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434 \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0458" },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438\u0458\u0430" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u0458\u0430" },
            { "BS", "\u0411\u0430\u04bb\u0430\u043c \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u0411\u0443\u0432\u0435 \u0430\u0434\u0430\u0441\u044b" },
            { "BW", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "BY", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441" },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441 (\u041a\u0438\u043b\u0438\u043d\u0433) \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "CD", "\u041a\u043e\u043d\u0433\u043e-\u041a\u0438\u043d\u0448\u0430\u0441\u0430" },
            { "CF", "\u041c\u04d9\u0440\u043a\u04d9\u0437\u0438 \u0410\u0444\u0440\u0438\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b" },
            { "CG", "\u041a\u043e\u043d\u0433\u043e-\u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b" },
            { "CH", "\u0418\u0441\u0432\u0435\u0447\u0440\u04d9" },
            { "CI", "K\u043e\u0442\u0434\u2019\u0438\u0432\u0443\u0430\u0440" },
            { "CK", "\u041a\u0443\u043a \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "CL", "\u0427\u0438\u043b\u0438" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u0427\u0438\u043d" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430" },
            { "CP", "\u041a\u043b\u0438\u043f\u043f\u0435\u0440\u0442\u043e\u043d \u0430\u0434\u0430\u0441\u044b" },
            { "CR", "\u041a\u043e\u0441\u0442\u0430 \u0420\u0438\u043a\u0430" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "CW", "\u041a\u0443\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u041c\u0438\u043b\u0430\u0434 \u0430\u0434\u0430\u0441\u044b" },
            { "CY", "\u041a\u0438\u043f\u0440" },
            { "CZ", "\u0427\u0435\u0445\u0438\u0458\u0430" },
            { "DE", "\u0410\u043b\u043c\u0430\u043d\u0438\u0458\u0430" },
            { "DG", "\u0414\u0438\u0435\u0433\u043e \u0413\u0430\u0440\u0441\u0438\u0458\u0430" },
            { "DJ", "\u04b8\u0438\u0431\u0443\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0438\u043c\u0430\u0440\u043a\u0430" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430" },
            { "DO", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b" },
            { "DZ", "\u04d8\u043b\u04b9\u04d9\u0437\u0430\u0438\u0440" },
            { "EA", "\u0421\u0435\u0443\u0442\u0430 \u0432\u04d9 \u041c\u0435\u043b\u0438\u043b\u0458\u0430" },
            { "EC", "\u0415\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "EE", "\u0415\u0441\u0442\u043e\u043d\u0438\u0458\u0430" },
            { "EG", "\u041c\u0438\u0441\u0438\u0440" },
            { "ER", "\u0415\u0440\u0438\u0442\u0440\u0435\u0458\u0430" },
            { "ES", "\u0418\u0441\u043f\u0430\u043d\u0438\u0458\u0430" },
            { "ET", "\u0415\u0444\u0438\u043e\u043f\u0438\u0458\u0430" },
            { "EU", "\u0410\u0432\u0440\u043e\u043f\u0430 \u0411\u0438\u0440\u043b\u0438\u0458\u0438" },
            { "FI", "\u0424\u0438\u043d\u043b\u0430\u043d\u0434\u0438\u0458\u0430" },
            { "FJ", "\u0424\u0438\u04b9\u0438" },
            { "FK", "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434 \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "FM", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "FO", "\u0424\u0430\u0440\u0435\u0440 \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "FR", "\u0424\u0440\u0430\u043d\u0441\u0430" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "GB", "\u0411\u0438\u0440\u043b\u04d9\u0448\u043c\u0438\u0448 \u041a\u0440\u0430\u043b\u043b\u044b\u0433" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "GE", "\u049c\u04af\u0440\u04b9\u04af\u0441\u0442\u0430\u043d" },
            { "GF", "\u0424\u0440\u0430\u043d\u0441\u0430 \u0413\u0432\u0438\u0430\u043d\u0430\u0441\u044b" },
            { "GG", "\u049c\u0435\u0440\u043d\u0441\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u04b8\u04d9\u0431\u04d9\u043b\u043b\u04af\u0442\u0430\u0440\u0438\u0433" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0438\u0458\u0430" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438\u0458\u0430" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u0458\u0430" },
            { "GP", "\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0430" },
            { "GQ", "\u0415\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b \u0413\u0432\u0438\u043d\u0435\u0458\u0430" },
            { "GR", "\u0408\u0443\u043d\u0430\u043d\u044b\u0441\u0442\u0430\u043d" },
            { "GS", "\u04b8\u04d9\u043d\u0443\u0431\u0438 \u04b8\u043e\u0440\u04b9\u0438\u0458\u0430 \u0432\u04d9 \u04b8\u04d9\u043d\u0443\u0431\u0438 \u0421\u0435\u043d\u0434\u0432\u0438\u0447 \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u0458\u0430-\u0411\u0438\u0441\u0430\u0443" },
            { "GY", "\u0413\u0430\u0458\u0430\u043d\u0430" },
            { "HK", "\u04ba\u043e\u043d\u043a \u041a\u043e\u043d\u0433 \u0425\u04af\u0441\u0443\u0441\u0438 \u0418\u043d\u0437\u0438\u0431\u0430\u0442\u0438 \u04d8\u0440\u0430\u0437\u0438 \u0427\u0438\u043d" },
            { "HM", "\u04ba\u0435\u0440\u0434 \u0432\u04d9 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u0434 \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "HN", "\u04ba\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u043e\u0440\u0432\u0430\u0442\u0438\u0458\u0430" },
            { "HT", "\u04ba\u0430\u0438\u0442\u0438" },
            { "HU", "\u041c\u0430\u04b9\u0430\u0440\u044b\u0441\u0442\u0430\u043d" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440 \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "IE", "\u0418\u0440\u043b\u0430\u043d\u0434\u0438\u0458\u0430" },
            { "IL", "\u0418\u0441\u0440\u0430\u0438\u043b" },
            { "IM", "\u041c\u0435\u043d \u0430\u0434\u0430\u0441\u044b" },
            { "IN", "\u04ba\u0438\u043d\u0434\u0438\u0441\u0442\u0430\u043d" },
            { "IO", "\u0411\u0440\u0438\u0442\u0430\u043d\u0442\u0458\u0430\u043d\u044b\u043d \u04ba\u0438\u043d\u0434 \u041e\u043a\u0435\u0430\u043d\u044b \u04d8\u0440\u0430\u0437\u0438\u0441\u0438" },
            { "IQ", "\u0418\u0440\u0430\u0433" },
            { "IR", "\u0418\u0440\u0430\u043d" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434\u0438\u0458\u0430" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438\u0458\u0430" },
            { "JE", "\u04b8\u0435\u0440\u0441\u0438" },
            { "JM", "\u0408\u0430\u043c\u0430\u0458\u043a\u0430" },
            { "JO", "\u0418\u043e\u0440\u0434\u0430\u043d\u0438\u0458\u0430" },
            { "JP", "\u0408\u0430\u043f\u043e\u043d\u0438\u0458\u0430" },
            { "KE", "\u041a\u0435\u043d\u0438\u0458\u0430" },
            { "KG", "\u0413\u044b\u0440\u0493\u044b\u0437\u044b\u0441\u0442\u0430\u043d" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u04b9\u0430" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440 \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u0432\u04d9 \u041d\u0435\u0432\u0438\u0441" },
            { "KP", "\u0428\u0438\u043c\u0430\u043b\u0438 \u041a\u043e\u0440\u0435\u0458\u0430" },
            { "KR", "\u04b8\u04d9\u043d\u0443\u0431\u0438 \u041a\u043e\u0440\u0435\u0458\u0430" },
            { "KW", "\u041a\u04af\u0432\u0435\u0458\u0442" },
            { "KY", "\u041a\u0430\u0458\u043c\u0430\u043d \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "KZ", "\u0413\u0430\u0437\u0430\u0445\u044b\u0441\u0442\u0430\u043d" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0438\u0432\u0430\u043d" },
            { "LC", "\u0421\u0435\u043d\u0442-\u041b\u0443\u0441\u0438\u0458\u0430" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0458\u043d" },
            { "LK", "\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430" },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438\u0458\u0430" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430" },
            { "LU", "\u041b\u04af\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438\u0458\u0430" },
            { "LY", "\u041b\u0438\u0432\u0438\u0458\u0430" },
            { "MA", "\u041c\u04d9\u0440\u0430\u043a\u0435\u0448" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u043e\u0432\u0430" },
            { "ME", "\u041c\u043e\u043d\u0442\u0435\u043d\u0435\u0433\u0440\u043e" },
            { "MF", "\u0421\u0435\u043d\u0442 \u041c\u0430\u0440\u0442\u0438\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "MM", "\u041c\u0458\u0430\u043d\u043c\u0430" },
            { "MN", "\u041c\u043e\u043d\u0433\u043e\u043b\u0443\u0441\u0442\u0430\u043d" },
            { "MO", "\u041c\u0430\u043a\u0430\u043e \u0425\u04af\u0441\u0443\u0441\u0438 \u0418\u043d\u0437\u0438\u0431\u0430\u0442\u0438 \u04d8\u0440\u0430\u0437\u0438 \u0427\u0438\u043d" },
            { "MP", "\u0428\u0438\u043c\u0430\u043b\u0438 \u041c\u0430\u0440\u0438\u0430\u043d \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u0458\u0430" },
            { "MS", "\u041c\u043e\u043d\u0441\u0435\u0440\u0430\u0442" },
            { "MT", "\u041c\u0430\u043b\u0442\u0430" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u043a\u0438" },
            { "MV", "\u041c\u0430\u043b\u0434\u0438\u0432 \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430" },
            { "MY", "\u041c\u0430\u043b\u0430\u0458\u0437\u0438\u0458\u0430" },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438\u0458\u0430" },
            { "NC", "\u0408\u0435\u043d\u0438 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u0458\u0430" },
            { "NE", "\u041d\u0438\u049d\u0435\u0440" },
            { "NF", "\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u0430\u0434\u0430\u0441\u044b" },
            { "NG", "\u041d\u0438\u049d\u0435\u0440\u0438\u0458\u0430" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "NL", "\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0447" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0438\u0443\u0435" },
            { "NZ", "\u0408\u0435\u043d\u0438 \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u0458\u0430" },
            { "OM", "\u041e\u043c\u0430\u043d" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0441\u0430 \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u0458\u0430\u0441\u044b" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430-\u0408\u0435\u043d\u0438 \u0413\u0432\u0438\u043d\u0435\u0458\u0430" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d" },
            { "PK", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u0448\u0430" },
            { "PM", "\u041c\u04af\u0433\u04d9\u0434\u0434\u04d9\u0441 \u041f\u0458\u0435\u0440 \u0432\u04d9 \u041c\u0438\u043a\u0435\u043b\u043e\u043d" },
            { "PN", "\u041f\u0438\u0442\u043a\u0435\u0440\u043d \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "PR", "\u041f\u0443\u0435\u0440\u0442\u043e \u0420\u0438\u043a\u043e" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u0458\u0430" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458" },
            { "QA", "\u0413\u04d9\u0442\u04d9\u0440" },
            { "QO", "\u0423\u0437\u0430\u0433 \u041e\u043a\u0435\u0430\u043d\u0438\u0458\u0430" },
            { "RE", "\u0420\u0435\u0458\u0443\u043d\u0458\u043e\u043d" },
            { "RO", "\u0420\u0443\u043c\u044b\u043d\u0438\u0458\u0430" },
            { "RS", "\u0421\u0435\u0440\u0431\u0438\u0458\u0430" },
            { "RU", "\u0420\u0443\u0441\u0438\u0458\u0430" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "SA", "\u0421\u04d9\u0443\u0434\u0438\u0458\u0458\u04d9 \u04d8\u0440\u04d9\u0431\u0438\u0441\u0442\u0430\u043d\u044b" },
            { "SB", "\u0421\u043e\u043b\u043e\u043c\u043e\u043d \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "SC", "\u0421\u0435\u0458\u0448\u0435\u043b \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "SE", "\u0418\u0441\u0432\u0435\u0447" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SH", "\u041c\u04af\u0433\u04d9\u0434\u0434\u04d9\u0441 \u0408\u0435\u043b\u0435\u043d\u0430" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u0458\u0430" },
            { "SJ", "\u0421\u0432\u0430\u043b\u0431\u0430\u0440\u0434 \u0432\u04d9 \u0408\u0430\u043d-\u041c\u0430\u0458\u0435\u043d" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u043a\u0438\u0458\u0430" },
            { "SL", "\u0421\u0458\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0438" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "SS", "\u04b8\u04d9\u043d\u0443\u0431\u0438 \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0432\u04d9 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438" },
            { "SV", "\u0421\u0430\u043b\u0432\u0430\u0434\u043e\u0440" },
            { "SX", "\u0421\u0438\u043d\u0442-\u041c\u0430\u0440\u0442\u0435\u043d" },
            { "SY", "\u0421\u0443\u0440\u0438\u0458\u0430" },
            { "SZ", "\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434" },
            { "TA", "\u0422\u0440\u0438\u0441\u0442\u0430\u043d \u0434\u0430 \u041a\u0443\u043d\u0458\u0430" },
            { "TC", "\u0422\u04e9\u0440\u043a\u0441 \u0432\u04d9 \u041a\u0430\u0458\u043a\u043e\u0441 \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "TD", "\u0427\u0430\u0434" },
            { "TF", "\u0424\u0440\u0430\u043d\u0441\u0430\u043d\u044b\u043d \u04b8\u04d9\u043d\u0443\u0431 \u04d8\u0440\u0430\u0437\u0438\u043b\u04d9\u0440\u0438" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "TH", "\u0422\u0430\u0438\u043b\u0430\u043d\u0434" },
            { "TJ", "\u0422\u0430\u04b9\u0438\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "TL", "\u0428\u04d9\u0440\u0433\u0438 \u0422\u0438\u043c\u043e\u0440" },
            { "TM", "\u0422\u04af\u0440\u043a\u043c\u04d9\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "TR", "\u0422\u04af\u0440\u043a\u0438\u0458\u04d9" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0432\u04d9 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0458\u0432\u0430\u043d" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u0458\u0430" },
            { "UA", "\u0423\u043a\u0440\u0430\u0458\u043d\u0430" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "UM", "\u0410\u0411\u0428-\u0430 \u0431\u0430\u0493\u043b\u044b \u043a\u0438\u0447\u0438\u043a \u0430\u0434\u0430\u04b9\u044b\u0433\u043b\u0430\u0440" },
            { "US", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0411\u0438\u0440\u043b\u04d9\u0448\u043c\u0438\u0448 \u0428\u0442\u0430\u0442\u043b\u0430\u0440\u044b" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0458" },
            { "UZ", "\u04e8\u0437\u0431\u04d9\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "VA", "\u0412\u0430\u0442\u0438\u043a\u0430\u043d" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0432\u04d9 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d\u043b\u04d9\u0440" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u0435\u043b\u0430" },
            { "VG", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u0458\u0430\u043d\u044b\u043d \u0412\u0438\u0440\u049d\u0438\u043d \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "VI", "\u0410\u0411\u0428 \u0412\u0438\u0440\u049d\u0438\u043d \u0430\u0434\u0430\u043b\u0430\u0440\u044b" },
            { "VN", "\u0412\u0458\u0435\u0442\u043d\u0430\u043c" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "WF", "\u0423\u043e\u043b\u043b\u0438\u0441 \u0432\u04d9 \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "YE", "\u0408\u04d9\u043c\u04d9\u043d" },
            { "YT", "\u041c\u0430\u0458\u043e\u0442" },
            { "ZA", "\u04b8\u04d9\u043d\u0443\u0431 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438\u0458\u0430" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "ZZ", "\u041d\u0430\u043c\u04d9\u043b\u0443\u043c \u0420\u0435\u049d\u0438\u043e\u043d" },
            { "aa", "\u0430\u0444\u0430\u0440" },
            { "ab", "\u0430\u0431\u0445\u0430\u0437" },
            { "af", "\u0430\u0444\u0440\u0438\u043a\u0430\u0430\u043d\u0441" },
            { "ak", "\u0430\u043a\u0430\u043d" },
            { "am", "\u0430\u043c\u04bb\u0430\u0440" },
            { "an", "\u0430\u0440\u0430\u0433\u043e\u043d" },
            { "ar", "\u04d9\u0440\u04d9\u0431" },
            { "as", "\u0430\u0441\u0441\u0430\u043c" },
            { "av", "\u0430\u0432\u0430\u0440" },
            { "ay", "\u0430\u0458\u043c\u0430\u0440\u0430" },
            { "az", "\u0430\u0437\u04d9\u0440\u0431\u0430\u0458\u04b9\u0430\u043d" },
            { "ba", "\u0431\u0430\u0448\u0433\u044b\u0440\u0434" },
            { "be", "\u0431\u0435\u043b\u0430\u0440\u0443\u0441" },
            { "bg", "\u0431\u0443\u043b\u0433\u0430\u0440" },
            { "bi", "\u0431\u0438\u0441\u043b\u0430\u043c\u0430" },
            { "bm", "\u0431\u0430\u043c\u0431\u0430\u0440\u0430" },
            { "bn", "\u0431\u0435\u043d\u0433\u0430\u043b" },
            { "bo", "\u0442\u0438\u0431\u0435\u0442" },
            { "br", "\u0431\u0440\u0435\u0442\u043e\u043d" },
            { "bs", "\u0431\u043e\u0441\u043d\u0438\u0430\u043a" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u0430\u043d" },
            { "ce", "\u0447\u0435\u0447\u0435\u043d" },
            { "ch", "\u0447\u0430\u043c\u043e\u0440\u043e" },
            { "co", "\u043a\u043e\u0440\u0441\u0438\u043a\u0430" },
            { "cs", "\u0447\u0435\u0445" },
            { "cu", "\u0441\u043b\u0430\u0432\u0458\u0430\u043d" },
            { "cv", "\u0447\u0443\u0432\u0430\u0448" },
            { "cy", "\u0443\u0435\u043b\u0441" },
            { "da", "\u0434\u0430\u043d\u0438\u043c\u0430\u0440\u043a\u0430" },
            { "de", "\u0430\u043b\u043c\u0430\u043d" },
            { "dv", "\u043c\u0430\u043b\u0434\u0438\u0432" },
            { "dz", "\u0434\u0437\u043e\u043d\u0433\u0430" },
            { "ee", "\u0435\u0432\u0435" },
            { "el", "\u0458\u0443\u043d\u0430\u043d" },
            { "en", "\u0438\u043d\u049d\u0438\u043b\u0438\u0441" },
            { "eo", "\u0435\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "es", "\u0438\u0441\u043f\u0430\u043d" },
            { "et", "\u0435\u0441\u0442\u043e\u043d" },
            { "eu", "\u0431\u0430\u0441\u043a" },
            { "fa", "\u0444\u0430\u0440\u0441" },
            { "ff", "\u0444\u0443\u043b\u0430" },
            { "fi", "\u0444\u0438\u043d" },
            { "fj", "\u0444\u0438\u04b9\u0438" },
            { "fo", "\u0444\u0430\u0440\u0435\u0440" },
            { "fr", "\u0444\u0440\u0430\u043d\u0441\u044b\u0437" },
            { "fy", "\u0433\u04d9\u0440\u0431\u0438 \u0444\u0440\u0438\u0437" },
            { "ga", "\u0438\u0440\u043b\u0430\u043d\u0434" },
            { "gd", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434 \u043a\u0435\u043b\u0442" },
            { "gl", "\u0433\u0430\u043b\u0438\u0441\u0438\u0458\u0430" },
            { "gn", "\u0433\u0443\u0430\u0440\u0430\u043d\u0438" },
            { "gu", "\u0433\u0443\u04b9\u0430\u0440\u0430\u0442" },
            { "gv", "\u043c\u0430\u043d\u043a\u0441" },
            { "ha", "\u04bb\u0430\u0443\u0441\u0430" },
            { "he", "\u0438\u0432\u0440\u0438\u0442" },
            { "hi", "\u04bb\u0438\u043d\u0434" },
            { "hr", "\u0445\u043e\u0440\u0432\u0430\u0442" },
            { "ht", "\u04bb\u0430\u0438\u0442\u0438 \u043a\u0440\u0435\u043e\u043b" },
            { "hu", "\u043c\u0430\u04b9\u0430\u0440" },
            { "hy", "\u0435\u0440\u043c\u04d9\u043d\u0438" },
            { "hz", "\u04bb\u0435\u0440\u0435\u0440\u043e" },
            { "ia", "\u0438\u043d\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u0432\u0435" },
            { "id", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "ig", "\u0438\u0433\u0431\u043e" },
            { "io", "\u0438\u0434\u043e" },
            { "is", "\u0438\u0441\u043b\u0430\u043d\u0434" },
            { "it", "\u0438\u0442\u0430\u043b\u0458\u0430\u043d" },
            { "iu", "\u0438\u043d\u0443\u043a\u0442\u0438\u0442\u0443\u0442" },
            { "ja", "\u0458\u0430\u043f\u043e\u043d" },
            { "jv", "\u0458\u0430\u0432\u0430" },
            { "ka", "\u049d\u04af\u0440\u04b9\u04af" },
            { "ki", "\u043a\u0438\u043a\u0443\u0458\u0443" },
            { "kj", "\u043a\u0443\u0430\u043d\u0458\u0430\u043c\u0430" },
            { "kk", "\u0433\u0430\u0437\u0430\u0445" },
            { "kl", "\u043a\u0430\u043b\u0430\u0430\u043b\u043b\u0438\u0441\u0443\u0442" },
            { "km", "\u043a\u0445\u043c\u0435\u0440" },
            { "kn", "\u043a\u0430\u043d\u043d\u0430\u0434\u0430" },
            { "ko", "\u043a\u043e\u0440\u0435\u0458\u0430" },
            { "kr", "\u043a\u0430\u043d\u0443\u0440\u0438" },
            { "ks", "\u043a\u04d9\u0448\u043c\u0438\u0440" },
            { "ku", "\u043a\u04af\u0440\u0434" },
            { "kv", "\u043a\u043e\u043c\u0438" },
            { "kw", "\u043a\u043e\u0440\u043d" },
            { "ky", "\u0433\u044b\u0440\u0493\u044b\u0437" },
            { "la", "\u043b\u0430\u0442\u044b\u043d" },
            { "lb", "\u043b\u04af\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "lg", "\u0433\u0430\u043d\u0434\u0430" },
            { "li", "\u043b\u0438\u043c\u0431\u0443\u0440\u0433" },
            { "ln", "\u043b\u0438\u043d\u0433\u0430\u043b\u0430" },
            { "lo", "\u043b\u0430\u043e\u0441" },
            { "lt", "\u043b\u0438\u0442\u0432\u0430" },
            { "lu", "\u043b\u0443\u0431\u0430-\u043a\u0430\u0442\u0430\u043d\u0433\u0430" },
            { "lv", "\u043b\u0430\u0442\u044b\u0448" },
            { "mg", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441" },
            { "mh", "\u043c\u0430\u0440\u0448\u0430\u043b" },
            { "mi", "\u043c\u0430\u043e\u0440\u0438" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d" },
            { "ml", "\u043c\u0430\u043b\u0430\u0458\u0430\u043b\u0430\u043c" },
            { "mn", "\u043c\u043e\u043d\u0433\u043e\u043b" },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u04bb\u0438" },
            { "ms", "\u043c\u0430\u043b\u0430\u0458" },
            { "mt", "\u043c\u0430\u043b\u0442\u0430" },
            { "my", "\u0431\u0438\u0440\u043c\u0430\u043d" },
            { "na", "\u043d\u0430\u0443\u0440\u0443" },
            { "nb", "\u0431\u043e\u043a\u043c\u0430\u043b \u043d\u043e\u0440\u0432\u0435\u0447" },
            { "nd", "\u0448\u0438\u043c\u0430\u043b\u0438 \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "ne", "\u043d\u0435\u043f\u0430\u043b" },
            { "ng", "\u043d\u0434\u043e\u043d\u0433\u0430" },
            { "nl", "\u04bb\u043e\u043b\u043b\u0430\u043d\u0434" },
            { "nn", "\u043d\u04af\u043d\u043e\u0440\u0441\u043a \u043d\u043e\u0440\u0432\u0435\u0447" },
            { "nr", "\u04b9\u04d9\u043d\u0443\u0431\u0438 \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "nv", "\u043d\u0430\u0432\u0430\u0458\u043e" },
            { "ny", "\u043d\u0458\u0430\u043d\u04b9\u0430" },
            { "oc", "\u043e\u043a\u0441\u0438\u0442\u0430\u043d" },
            { "om", "\u043e\u0440\u043e\u043c\u043e" },
            { "or", "\u043e\u0434\u0438\u0458\u0430" },
            { "os", "\u043e\u0441\u0435\u0442\u0438\u043d" },
            { "pa", "\u043f\u04d9\u043d\u04b9\u0430\u0431" },
            { "pl", "\u043f\u043e\u043b\u0458\u0430\u043a" },
            { "ps", "\u043f\u0443\u0448\u0442\u0443" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430" },
            { "rm", "\u0440\u043e\u043c\u0430\u043d\u0448" },
            { "rn", "\u0440\u0443\u043d\u0434\u0438" },
            { "ro", "\u0440\u0443\u043c\u044b\u043d" },
            { "ru", "\u0440\u0443\u0441" },
            { "rw", "\u043a\u0438\u043d\u0458\u0430\u0440\u0432\u0430\u043d\u0434\u0430" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u0438\u0442" },
            { "sc", "\u0441\u0430\u0440\u0434\u0438\u043d" },
            { "sd", "\u0441\u0438\u043d\u0434\u04bb\u0438" },
            { "se", "\u0448\u0438\u043c\u0430\u043b\u0438 \u0441\u0430\u043c\u0438" },
            { "sg", "\u0441\u0430\u043d\u0433\u043e" },
            { "si", "\u0441\u0438\u043d\u04bb\u0430\u043b\u0430" },
            { "sk", "\u0441\u043b\u043e\u0432\u0430\u043a" },
            { "sl", "\u0441\u043b\u043e\u0432\u0435\u043d" },
            { "sm", "\u0441\u0430\u043c\u043e\u0430" },
            { "sn", "\u0448\u043e\u043d\u0430" },
            { "so", "\u0441\u043e\u043c\u0430\u043b\u0438" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d" },
            { "sr", "\u0441\u0435\u0440\u0431" },
            { "ss", "\u0441\u0432\u0430\u0442\u0438" },
            { "st", "\u0441\u0435\u0441\u043e\u0442\u043e" },
            { "su", "\u0441\u0443\u043d\u0434\u0430\u043d" },
            { "sv", "\u0438\u0441\u0432\u0435\u0447" },
            { "sw", "\u0441\u0443\u0430\u04bb\u0438\u043b\u0438" },
            { "ta", "\u0442\u0430\u043c\u0438\u043b" },
            { "te", "\u0442\u0435\u043b\u0443\u0433\u0443" },
            { "tg", "\u0442\u0430\u04b9\u0438\u043a" },
            { "th", "\u0442\u0430\u0458" },
            { "ti", "\u0442\u0438\u0433\u0440\u0438\u043d" },
            { "tk", "\u0442\u04af\u0440\u043a\u043c\u04d9\u043d" },
            { "tn", "\u0441\u0432\u0430\u043d\u0430" },
            { "to", "\u0442\u043e\u043d\u0433\u0430\u043d" },
            { "tr", "\u0442\u04af\u0440\u043a" },
            { "ts", "\u0441\u043e\u043d\u0433\u0430" },
            { "tt", "\u0442\u0430\u0442\u0430\u0440" },
            { "ty", "\u0442\u0430\u0445\u0438\u0442\u0438" },
            { "ug", "\u0443\u0458\u0493\u0443\u0440" },
            { "uk", "\u0443\u043a\u0440\u0430\u0458\u043d\u0430" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "uz", "\u04e9\u0437\u0431\u04d9\u043a" },
            { "ve", "\u0432\u0435\u043d\u0434\u0430" },
            { "vi", "\u0432\u0458\u0435\u0442\u043d\u0430\u043c" },
            { "vo", "\u0432\u043e\u043b\u0430\u043f\u04af\u043a" },
            { "wa", "\u0432\u0430\u043b\u0443\u043d" },
            { "wo", "\u0432\u043e\u043b\u043e\u0444" },
            { "xh", "\u0445\u043e\u0441\u0430" },
            { "yi", "\u0438\u0434\u0438\u0448" },
            { "yo", "\u0458\u043e\u0440\u0443\u0431\u0430" },
            { "zh", "\u0447\u0438\u043d" },
            { "zu", "\u0437\u0443\u043b\u0443" },
            { "ace", "\u0430\u043a\u0438\u043d" },
            { "ada", "\u0430\u0434\u0430\u043d\u0433\u043c\u0435" },
            { "ady", "\u0430\u0434\u0443\u049d\u0435" },
            { "agq", "\u0430\u0433\u04bb\u0435\u043c" },
            { "ain", "\u0430\u0458\u043d\u0443" },
            { "ale", "\u0430\u043b\u0435\u0443\u0442" },
            { "alt", "\u04b9\u04d9\u043d\u0443\u0431\u0438 \u0430\u043b\u0442\u0430\u0458" },
            { "anp", "\u0430\u043d\u049d\u0438\u043a\u0430" },
            { "arn", "\u0430\u0440\u0430\u0443\u043a\u0430\u043d\u04b9\u0430" },
            { "arp", "\u0430\u0440\u0430\u043f\u0430\u04bb\u043e" },
            { "asa", "\u0430\u0441\u0443" },
            { "ast", "\u0430\u0441\u0442\u0443\u0440\u0438\u0458\u0430" },
            { "awa", "\u0430\u0432\u0430\u0434\u04bb\u0438" },
            { "ban", "\u0431\u0430\u043b\u043b\u0438" },
            { "bas", "\u0431\u0430\u0441\u0430" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "bez", "\u0431\u0435\u043d\u0430" },
            { "bho", "\u0431\u0445\u043e\u0447\u043f\u0443\u0440\u0438" },
            { "bin", "\u0431\u0438\u043d\u0438" },
            { "bla", "\u0441\u0438\u043a\u0441\u0438\u043a\u04d9" },
            { "brx", "\u0431\u043e\u0434\u043e" },
            { "bug", "\u0431\u0443\u049d\u0438\u043d" },
            { "byn", "\u0431\u043b\u0438\u043d" },
            { "ceb", "\u0441\u0435\u0431\u0443\u0430\u043d" },
            { "cgg", "\u0447\u0438\u0433\u0430" },
            { "chk", "\u0447\u0443\u043a\u0438\u0437" },
            { "chm", "\u043c\u0430\u0440\u0438" },
            { "cho", "\u0447\u043e\u043a\u0442\u0430\u0443" },
            { "chr", "\u0447\u0435\u0440\u043e\u043a\u0438" },
            { "chy", "\u0447\u0435\u0458\u0435\u043d" },
            { "ckb", "\u0441\u043e\u0440\u0430\u043d" },
            { "crs", "\u0441\u0435\u0458\u0448\u0435\u043b \u043a\u0440\u0435\u043e\u043b\u0443" },
            { "dak", "\u0434\u0430\u043a\u043e\u0442\u0430" },
            { "dar", "\u0434\u0430\u0440\u0433\u0432\u0430" },
            { "dav", "\u0442\u0430\u0438\u0442\u0430" },
            { "dgr", "\u0434\u043e\u0433\u0440\u0438\u0431" },
            { "dje", "\u0437\u0430\u0440\u043c\u0430" },
            { "dsb", "\u0430\u0448\u0430\u0493\u044b \u0441\u043e\u0440\u0431" },
            { "dua", "\u0434\u0443\u0430\u043b\u0430" },
            { "dyo", "\u0434\u0438\u043e\u043b\u0430" },
            { "dzg", "\u0434\u0430\u0437\u0430\u0433\u0430" },
            { "ebu", "\u0435\u043c\u0431\u0443" },
            { "efi", "\u0435\u0444\u0438\u043a" },
            { "eka", "\u0435\u043a\u0430\u04b9\u0443\u043a" },
            { "ewo", "\u0435\u0432\u043e\u043d\u0434\u043e" },
            { "fil", "\u0444\u0438\u043b\u0438\u043f\u043f\u0438\u043d" },
            { "fon", "\u0444\u043e\u043d" },
            { "fur", "\u0444\u0440\u0438\u0443\u043b" },
            { "gaa", "\u0433\u0430" },
            { "gez", "\u0433\u0435\u0437" },
            { "gil", "\u0433\u0438\u043b\u0431\u0435\u0440\u0442" },
            { "gor", "\u0433\u043e\u0440\u043e\u043d\u0442\u0430\u043b\u043e" },
            { "gsw", "\u0418\u0441\u0432\u0435\u0447\u0440\u04d9 \u0430\u043b\u043c\u0430\u043d\u04b9\u0430\u0441\u044b" },
            { "guz", "\u0433\u0443\u0441\u0438" },
            { "gwi", "\u0433\u0432\u0438\u0447\u0438\u043d" },
            { "haw", "\u04bb\u0430\u0432\u0430\u0458" },
            { "hil", "\u04bb\u0438\u043b\u0438\u0433\u0430\u0458\u043d\u043e\u043d" },
            { "hmn", "\u043c\u043e\u043d\u0433" },
            { "hsb", "\u0458\u0443\u0445\u0430\u0440\u044b \u0441\u043e\u0440\u0431" },
            { "hup", "\u04bb\u0443\u043f\u0430" },
            { "iba", "\u0438\u0431\u0430\u043d" },
            { "ibb", "\u0438\u0431\u0438\u0431\u0438\u043e" },
            { "ilo", "\u0438\u043b\u043e\u043a\u043e" },
            { "inh", "\u0438\u043d\u0433\u0443\u0448" },
            { "jbo", "\u043b\u043e\u0493\u0431\u0430\u043d" },
            { "jgo", "\u043d\u0433\u043e\u043c\u0431\u0430" },
            { "jmc", "\u043c\u0430\u0447\u0430\u043c" },
            { "kab", "\u043a\u0430\u0431\u0438\u043b\u0435" },
            { "kac", "\u043a\u0430\u0447\u0438\u043d" },
            { "kaj", "\u0436\u0443" },
            { "kam", "\u043a\u0430\u043c\u0431\u0430" },
            { "kbd", "\u043a\u0430\u0431\u0430\u0440\u0434\u0430-\u0447\u04d9\u0440\u043a\u04d9\u0437" },
            { "kcg", "\u0442\u0432\u0438" },
            { "kde", "\u043c\u0430\u043a\u043e\u043d\u0434\u0435" },
            { "kea", "\u043a\u0430\u0431\u0443\u0432\u0435\u0440\u0434\u0438\u0430\u043d" },
            { "kfo", "\u043a\u043e\u0440\u043e" },
            { "kha", "\u0445\u0430\u0437\u0438" },
            { "khq", "\u043a\u043e\u0458\u0440\u0430 \u0447\u0438\u0438\u043d\u0438" },
            { "kkj", "\u043a\u0430\u043a\u043e" },
            { "kln", "\u043a\u0430\u043b\u0435\u043d\u04b9\u0438\u043d" },
            { "kmb", "\u043a\u0438\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u0438" },
            { "kpe", "\u043a\u043f\u0435\u043b\u043b\u0435" },
            { "krc", "\u0433\u0430\u0440\u0430\u0447\u0430\u0458-\u0431\u0430\u043b\u043a\u0430\u0440" },
            { "krl", "\u043a\u0430\u0440\u0435\u043b" },
            { "kru", "\u043a\u0443\u0440\u0443\u0445" },
            { "ksb", "\u0448\u0430\u043c\u0431\u0430\u043b\u0430" },
            { "ksf", "\u0431\u0430\u0444\u0438\u0430" },
            { "ksh", "\u043a\u04e9\u043b\u043d" },
            { "kum", "\u043a\u0443\u043c\u044b\u043a" },
            { "lad", "\u0441\u0435\u0444\u0430\u0440\u0434" },
            { "lag", "\u043b\u0430\u043d\u049d\u0438" },
            { "lez", "\u043b\u04d9\u0437\u049d\u0438" },
            { "lkt", "\u043b\u0430\u043a\u043e\u0442\u0430" },
            { "loz", "\u043b\u043e\u0437\u0438" },
            { "lrc", "\u0448\u0438\u043c\u0430\u043b\u0438 \u043b\u0443\u0440\u0438" },
            { "lua", "\u043b\u0443\u0431\u0430-\u043b\u0443\u043b\u0443\u0430" },
            { "lun", "\u043b\u0443\u043d\u0434\u0430" },
            { "luo", "\u043b\u0443\u043e" },
            { "lus", "\u043c\u0438\u0437\u043e" },
            { "luy", "\u043b\u0443\u0458\u0438\u0430" },
            { "mad", "\u043c\u0430\u0434\u0443\u0440\u0438\u0437" },
            { "mag", "\u043c\u0430\u0433\u0430\u04bb\u0438" },
            { "mai", "\u043c\u0430\u0438\u0442\u0438\u043b\u0438" },
            { "mak", "\u043c\u0430\u043a\u0430\u0441\u0430\u0440" },
            { "mas", "\u043c\u0430\u0441\u0430\u0458" },
            { "mdf", "\u043c\u043e\u043a\u0448\u0430" },
            { "men", "\u043c\u0435\u043d\u0434\u0435" },
            { "mer", "\u043c\u0435\u0440\u0443" },
            { "mfe", "\u043c\u043e\u0440\u0438\u0441\u0438\u0435\u043d" },
            { "mgh", "\u043c\u0430\u0445\u0443\u0432\u0430-\u043c\u0435\u0435\u0442\u0442\u043e" },
            { "mgo", "\u043c\u0435\u0442\u0430\u02bc" },
            { "mic", "\u043c\u0438\u043a\u043c\u0430\u043a" },
            { "min", "\u043c\u0438\u043d\u0430\u043d\u0433\u043a\u0430\u0431\u0430\u043d" },
            { "mni", "\u043c\u0430\u043d\u0438\u043f\u04af\u0440\u0438" },
            { "moh", "\u043c\u043e\u04bb\u0430\u0432\u043a" },
            { "mos", "\u043c\u043e\u0441\u0438" },
            { "mua", "\u043c\u0443\u043d\u0434\u0430\u043d\u0433" },
            { "mul", "\u0447\u043e\u0445\u0441\u0430\u0458\u043b\u044b \u0434\u0438\u043b\u043b\u04d9\u0440" },
            { "mus", "\u043a\u0440\u0438\u043a" },
            { "mwl", "\u043c\u0438\u0440\u0430\u043d\u0434" },
            { "myv", "\u0435\u0440\u0437\u0458\u0430" },
            { "mzn", "\u043c\u0430\u0437\u0430\u043d\u0434\u0430\u0440\u0430\u043d" },
            { "nap", "\u043d\u0435\u0430\u043f\u043e\u043b\u0438\u0442\u0430\u043d" },
            { "naq", "\u043d\u0430\u043c\u0430" },
            { "new", "\u043d\u0435\u0432\u0430\u0440\u0438" },
            { "nia", "\u043d\u0438\u0430\u0441" },
            { "niu", "\u043d\u0438\u0458\u0443\u0430\u043d" },
            { "nmg", "\u043a\u0432\u0430\u0441\u0438\u043e" },
            { "nnh", "\u043d\u049d\u0438\u0435\u043c\u0431\u043e\u043e\u043d" },
            { "nog", "\u043d\u043e\u0433\u0430\u0458" },
            { "nqo", "\u043d\u0433\u043e" },
            { "nso", "\u0448\u0438\u043c\u0430\u043b\u0438 \u0441\u043e\u0442\u043e" },
            { "nus", "\u043d\u0443\u0435\u0440" },
            { "nyn", "\u043d\u0458\u0430\u043d\u043a\u043e\u043b" },
            { "pag", "\u043f\u0430\u043d\u0433\u0430\u0441\u0438\u043d\u0430\u043d" },
            { "pam", "\u043f\u0430\u043c\u043f\u0430\u043d\u0433\u0430" },
            { "pap", "\u043f\u0430\u043f\u0458\u0430\u043c\u0435\u043d\u0442\u043e" },
            { "pau", "\u043f\u0430\u043b\u0430\u0458\u0430\u043d" },
            { "pcm", "\u043d\u0438\u049d\u0435\u0440 \u043a\u0440\u0435\u043e\u043b" },
            { "prg", "\u043f\u0440\u0443\u0441\u0441" },
            { "quc", "\u043a\u0438\u0447\u0435" },
            { "rap", "\u0440\u0430\u043f\u0430\u043d\u0443\u0438" },
            { "rar", "\u0440\u0430\u0440\u043e\u0442\u043e\u043d\u0433\u0430\u043d" },
            { "rof", "\u0440\u043e\u043c\u0431\u043e" },
            { "rup", "\u0430\u0440\u043e\u043c\u0430\u043d" },
            { "rwk", "\u0440\u0443\u0430" },
            { "sad", "\u0441\u0430\u043d\u0434\u0430\u0432\u0435" },
            { "sah", "\u0441\u0430\u0445\u0430" },
            { "saq", "\u0441\u0430\u043c\u0431\u0443\u0440\u0443" },
            { "sat", "\u0441\u0430\u043d\u0442\u0430\u043b" },
            { "sba", "\u043d\u0433\u0430\u043c\u0431\u0430\u0458" },
            { "sbp", "\u0441\u0430\u043d\u0433\u0443" },
            { "scn", "\u0441\u0438\u04b9\u0438\u043b\u0438\u0458\u0430" },
            { "sco", "\u0441\u043a\u043e\u0442\u0441" },
            { "seh", "\u0441\u0435\u043d\u0430" },
            { "ses", "\u043a\u043e\u0458\u0440\u0430\u0431\u043e\u0440\u043e \u0441\u0435\u043d\u043d\u0438" },
            { "shi", "\u0442\u0430\u0447\u0435\u043b\u0438\u0442" },
            { "shn", "\u0448\u0430\u043d" },
            { "sma", "\u04b9\u04d9\u043d\u0443\u0431\u0438 \u0441\u0430\u043c\u0438" },
            { "smj", "\u043b\u0443\u043b\u0435 \u0441\u0430\u043c\u0438" },
            { "smn", "\u0438\u043d\u0430\u0440\u0438 \u0441\u0430\u043c\u0438" },
            { "sms", "\u0441\u043a\u043e\u043b\u0442 \u0441\u0430\u043c\u0438" },
            { "snk", "\u0441\u043e\u043d\u0438\u043d\u043a\u0435" },
            { "srn", "\u0441\u0440\u0430\u043d\u0430\u043d \u0442\u043e\u043d\u0433\u043e" },
            { "ssy", "\u0441\u0430\u04bb\u043e" },
            { "suk", "\u0441\u0443\u043a\u0443\u043c\u0430" },
            { "swb", "\u043a\u043e\u043c\u043e\u0440" },
            { "syr", "\u0441\u0443\u0440\u0438\u0458\u0430" },
            { "tem", "\u0442\u0438\u043c\u043d\u0435" },
            { "teo", "\u0442\u0435\u0441\u043e" },
            { "tet", "\u0442\u0435\u0442\u0443\u043c" },
            { "tig", "\u0442\u0438\u0433\u0440\u0435" },
            { "tlh", "\u043a\u043b\u0438\u043d\u0433\u043e\u043d" },
            { "tpi", "\u0442\u043e\u043a \u043f\u0438\u0441\u0438\u043d" },
            { "trv", "\u0442\u0430\u0440\u043e\u043a\u043e" },
            { "tum", "\u0442\u0443\u043c\u0431\u0443\u043a\u0430" },
            { "tvl", "\u0442\u0443\u0432\u0430\u043b\u0443" },
            { "twq", "\u0442\u0430\u0441\u0430\u0432\u0430\u0433" },
            { "tyv", "\u0442\u0443\u0432\u0438\u043d\u0458\u0430\u043d" },
            { "tzm", "\u041c\u04d9\u0440\u043a\u04d9\u0437\u0438 \u0410\u0442\u043b\u0430\u0441 \u0442\u0430\u043c\u0430\u0437\u0438\u04b9\u04d9\u0441\u0438" },
            { "udm", "\u0443\u0434\u043c\u0443\u0440\u0442" },
            { "umb", "\u0443\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "und", "\u043d\u0430\u043c\u04d9\u043b\u0443\u043c \u0434\u0438\u043b" },
            { "vai", "\u0432\u0430\u0438" },
            { "vun", "\u0432\u0443\u043d\u0458\u043e" },
            { "wae", "\u0432\u0430\u043b\u043b\u0435\u0441" },
            { "wal", "\u0432\u0430\u043b\u0430\u043c\u043e" },
            { "war", "\u0432\u0430\u0440\u0430\u0458" },
            { "xal", "\u043a\u0430\u043b\u043c\u044b\u043a" },
            { "xog", "\u0441\u043e\u0433\u0430" },
            { "yav", "\u0458\u0430\u043d\u0433\u0431\u0435\u043d" },
            { "ybb", "\u0458\u0435\u043c\u0431\u0430" },
            { "yue", "\u043a\u0430\u043d\u0442\u043e\u043d" },
            { "zgh", "\u0442\u0430\u043c\u0430\u0437\u0438" },
            { "zun", "\u0437\u0443\u043d\u0438" },
            { "zxx", "\u0434\u0438\u043b \u043c\u04d9\u0437\u043c\u0443\u043d\u0443 \u0458\u043e\u0445\u0434\u0443\u0440" },
            { "zza", "\u0437\u0430\u0437\u0430" },
            { "Cyrl", "\u041a\u0438\u0440\u0438\u043b" },
            { "root", "\u0440\u0443\u0442" },
            { "de_AT", "\u0410\u0432\u0441\u0442\u0440\u0438\u0458\u0430 \u0430\u043b\u043c\u0430\u043d\u04b9\u0430\u0441\u044b" },
            { "de_CH", "\u0418\u0441\u0432\u0435\u0447\u0440\u04d9 \u0458\u04af\u043a\u0441\u04d9\u043a \u0430\u043b\u043c\u0430\u043d\u04b9\u0430\u0441\u044b" },
            { "en_AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0430 \u0438\u043d\u049d\u0438\u043b\u0438\u0441\u04b9\u04d9\u0441\u0438" },
            { "en_CA", "\u041a\u0430\u043d\u0430\u0434\u0430 \u0438\u043d\u049d\u0438\u043b\u0438\u0441\u04b9\u04d9\u0441\u0438" },
            { "en_GB", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u0458\u0430 \u0438\u043d\u049d\u0438\u043b\u0438\u0441\u04b9\u04d9\u0441\u0438" },
            { "en_US", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0438\u043d\u049d\u0438\u043b\u0438\u0441\u04b9\u04d9\u0441\u0438" },
            { "es_ES", "\u041a\u0430\u0441\u0442\u0438\u043b\u0438\u0458\u0430 \u0438\u0441\u043f\u0430\u043d\u04b9\u0430\u0441\u044b" },
            { "es_MX", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430 \u0438\u0441\u043f\u0430\u043d\u04b9\u0430\u0441\u044b" },
            { "fr_CA", "\u041a\u0430\u043d\u0430\u0434\u0430 \u0444\u0440\u0430\u043d\u0441\u044b\u0437\u04b9\u0430\u0441\u044b" },
            { "fr_CH", "\u0418\u0441\u0432\u0435\u0447\u0440\u04d9 \u0444\u0440\u0430\u043d\u0441\u044b\u0437\u04b9\u0430\u0441\u044b" },
            { "nl_BE", "\u0444\u043b\u0430\u043c\u0430\u043d\u0434" },
            { "pt_BR", "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u0458\u0430 \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u04b9\u0430\u0441\u044b" },
            { "pt_PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u0458\u0430 \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u04b9\u0430\u0441\u044b" },
            { "sw_CD", "\u041a\u043e\u043d\u0433\u043e \u0441\u0443\u0430\u04bb\u0438\u043b\u0438\u04b9\u04d9\u0441\u0438" },
            { "ar_001", "\u043c\u04af\u0430\u0441\u0438\u0440 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u04d9\u0440\u04d9\u0431" },
            { "es_419", "\u041b\u0430\u0442\u044b\u043d \u0410\u043c\u0435\u0440\u0438\u043a\u0430\u0441\u044b \u0438\u0441\u043f\u0430\u043d\u04b9\u0430\u0441\u044b" },
            { "nds_NL", "\u0430\u0448\u0430\u0493\u044b \u0441\u0430\u043a\u0441\u043e\u043d" },
            { "zh_Hans", "\u0441\u0430\u0434\u04d9\u043b\u04d9\u0448\u043c\u0438\u0448 \u0447\u0438\u043d" },
            { "zh_Hant", "\u04d9\u043d\u04d9\u043d\u04d9\u0432\u0438 \u0447\u0438\u043d" },
        };
        return data;
    }
}
