/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.awt.Window;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.netbeans.core.execution.AccController;
import org.netbeans.core.execution.ExecutionEngine;
import org.netbeans.core.execution.ExitSecurityException;
import org.netbeans.core.execution.IOPermissionCollection;
import org.netbeans.core.execution.TaskThreadGroup;
import org.openide.execution.NbClassLoader;

public class SecMan
extends SecurityManager {
    public static SecurityManager DEFAULT = new SecMan();
    private static Class nbClassLoaderClass = NbClassLoader.class;
    private ThreadGroup base = ExecutionEngine.base;

    public SecMan() {
        PrivilegedCheck.init();
        AccController.init();
    }

    @Override
    public void checkExit(int n) throws SecurityException {
        PrivilegedCheck.checkExit(n, this);
    }

    final void checkExitImpl(int n, AccessControlContext accessControlContext) throws SecurityException {
        IOPermissionCollection iOPermissionCollection = AccController.getIOPermissionCollection(accessControlContext);
        if (iOPermissionCollection != null && iOPermissionCollection.grp != null) {
            ExecutionEngine.getTaskIOs().free(iOPermissionCollection.grp, iOPermissionCollection.getIO());
            ExecutionEngine.closeGroup(iOPermissionCollection.grp);
            this.stopTaskThreadGroup(iOPermissionCollection.grp);
            throw new ExitSecurityException("Exit from within execution engine, normal");
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        if (threadGroup instanceof TaskThreadGroup) {
            throw new ExitSecurityException("Exit from within execution engine, normal");
        }
        if (this.isNbClassLoader()) {
            throw new ExitSecurityException("Exit from within user-loaded code");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTaskThreadGroup(TaskThreadGroup taskThreadGroup) {
        TaskThreadGroup taskThreadGroup2 = taskThreadGroup;
        synchronized (taskThreadGroup2) {
            int n = taskThreadGroup.activeCount();
            int n2 = -1;
            Thread thread = Thread.currentThread();
            Thread[] threadArray = new Thread[n];
            taskThreadGroup.enumerate(threadArray, true);
            for (int i = 0; i < threadArray.length && threadArray[i] != null; ++i) {
                if (threadArray[i] == thread) {
                    n2 = i;
                    continue;
                }
                threadArray[i].stop();
            }
            if (n2 != -1) {
                threadArray[n2].stop();
            }
        }
    }

    public boolean checkTopLevelWindow(Object object) {
        IOPermissionCollection iOPermissionCollection = AccController.getIOPermissionCollection();
        if (iOPermissionCollection != null && iOPermissionCollection.grp != null && object instanceof Window) {
            ExecutionEngine.putWindow((Window)object, iOPermissionCollection.grp);
        }
        return true;
    }

    protected boolean isNbClassLoader() {
        Class<?>[] classArray = this.getClassContext();
        for (int i = 0; i < classArray.length; ++i) {
            if (!nbClassLoaderClass.isInstance(classArray[i].getClassLoader()) || classArray[i].getProtectionDomain().getCodeSource() == null) continue;
            return true;
        }
        return false;
    }

    private static final class PrivilegedCheck
    implements PrivilegedExceptionAction<Object> {
        private final int action;
        private final SecMan sm;
        private int status;
        private AccessControlContext acc;

        public PrivilegedCheck(int n, SecMan secMan) {
            this.action = n;
            this.sm = secMan;
            if (n == 0) {
                this.acc = AccessController.getContext();
            }
        }

        static void init() {
        }

        @Override
        public Object run() throws Exception {
            switch (this.action) {
                case 0: {
                    this.sm.checkExitImpl(this.status, this.acc);
                    break;
                }
            }
            return null;
        }

        static void checkExit(int n, SecMan secMan) {
            PrivilegedCheck privilegedCheck = new PrivilegedCheck(0, secMan);
            privilegedCheck.status = n;
            PrivilegedCheck.check(privilegedCheck);
        }

        private static void check(PrivilegedCheck privilegedCheck) {
            try {
                AccessController.doPrivileged(privilegedCheck);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                exception.printStackTrace();
            }
        }
    }
}

