/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceData;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceSupport;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeTemplate;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DelegatedTypeSubstitution;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.TypeCheckerContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020!J\"\u0010\"\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020!H\u0002JL\u0010+\u001a\u00020\u00172\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030,26\u0010-\u001a2\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(1\u0012\u0013\u0012\u00110!\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00170.H\u0002J\u001c\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030,H\u0002J\u0010\u00107\u001a\u00020)2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020)2\u0006\u00108\u001a\u000209H\u0002J\f\u0010;\u001a\u00020)*\u00020!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/CoroutineInferenceSupport;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;)V", "getArgumentTypeResolver", "()Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "<set-?>", "Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "callCompleter", "getCallCompleter", "()Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "setCallCompleter", "(Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;)V", "getExpressionTypingServices", "()Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "analyzeCoroutine", "", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunction;", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;", "lambdaExpectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "checkCoroutineCalls", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "tracingStrategy", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "overloadResults", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "checkExpectedTypeForArgument", "", "expectedType", "forceInferenceForArguments", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "callback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "argument", "argumentType", "getArgumentTypeInfo", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isGoodCall", "resultingDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isGoodCallForOldCoroutines", "containsTypeTemplate", "CoroutineTypeCheckerContext", "frontend"})
public final class CoroutineInferenceSupport {
    @NotNull
    public CallCompleter callCompleter;
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;

    @NotNull
    public final CallCompleter getCallCompleter() {
        CallCompleter callCompleter = this.callCompleter;
        if (callCompleter == null) {
            Intrinsics.throwUninitializedPropertyAccessException("callCompleter");
        }
        return callCompleter;
    }

    @Inject
    public final void setCallCompleter(@NotNull CallCompleter callCompleter) {
        Intrinsics.checkParameterIsNotNull(callCompleter, "<set-?>");
        this.callCompleter = callCompleter;
    }

    private final LanguageVersionSettings getLanguageVersionSettings() {
        LanguageVersionSettings languageVersionSettings = this.expressionTypingServices.getLanguageVersionSettings();
        Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings, "expressionTypingServices.languageVersionSettings");
        return languageVersionSettings;
    }

    /*
     * WARNING - void declaration
     */
    public final void analyzeCoroutine(@NotNull KtFunction functionLiteral, @NotNull ValueArgument valueArgument, @NotNull ConstraintSystem.Builder csBuilder, @NotNull CallCandidateResolutionContext<?> context, @NotNull KotlinType lambdaExpectedType) {
        Collection<KotlinType> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(functionLiteral, "functionLiteral");
        Intrinsics.checkParameterIsNotNull(valueArgument, "valueArgument");
        Intrinsics.checkParameterIsNotNull(csBuilder, "csBuilder");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(lambdaExpectedType, "lambdaExpectedType");
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        if (!this.checkExpectedTypeForArgument(lambdaExpectedType)) {
            return;
        }
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(lambdaExpectedType);
        if (kotlinType == null) {
            return;
        }
        KotlinType lambdaReceiverType = kotlinType;
        CoroutineInferenceData inferenceData = new CoroutineInferenceData();
        ConstraintSystem constraintSystem = csBuilder.build();
        TypeSubstitution typeSubstitution = constraintSystem.getCurrentSubstitutor().getSubstitution();
        Intrinsics.checkExpressionValueIsNotNull(typeSubstitution, "constraintSystem.currentSubstitutor.substitution");
        DelegatedTypeSubstitution newSubstitution2 = new DelegatedTypeSubstitution(constraintSystem, inferenceData, typeSubstitution){
            final /* synthetic */ ConstraintSystem $constraintSystem;
            final /* synthetic */ CoroutineInferenceData $inferenceData;

            @Nullable
            public TypeProjection get(@NotNull KotlinType key) {
                Object v1;
                TypeProjection substitutedType;
                block3: {
                    Intrinsics.checkParameterIsNotNull(key, "key");
                    TypeProjection typeProjection = substitutedType = super.get(key);
                    if (Intrinsics.areEqual(typeProjection != null ? typeProjection.getType() : null, TypeUtils.DONT_CARE) ^ true) {
                        return substitutedType;
                    }
                    Iterable $receiver$iv = this.$constraintSystem.getTypeVariables();
                    for (T element$iv : $receiver$iv) {
                        TypeVariable it = (TypeVariable)element$iv;
                        if (!Intrinsics.areEqual(it.getOriginalTypeParameter().getDefaultType(), key)) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                TypeVariable typeVariable2 = v1;
                if (typeVariable2 == null) {
                    return substitutedType;
                }
                TypeVariable typeVariable3 = typeVariable2;
                return TypeUtilsKt.asTypeProjection(this.$inferenceData.getTypeTemplate(typeVariable3));
            }

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
            {
                this.$constraintSystem = $captured_local_variable$0;
                this.$inferenceData = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        KotlinType kotlinType2 = newSubstitution2.buildSubstitutor().substitute(lambdaReceiverType, Variance.INVARIANT);
        if (kotlinType2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "newSubstitution.buildSub\u2026ance.INVARIANT) ?: return");
        KotlinType newReceiverType = kotlinType2;
        TypeSubstitution typeSubstitution2 = constraintSystem.getCurrentSubstitutor().getSubstitution();
        Intrinsics.checkExpressionValueIsNotNull(typeSubstitution2, "constraintSystem.currentSubstitutor.substitution");
        DelegatedTypeSubstitution approximationSubstitutor2 = new DelegatedTypeSubstitution(constraintSystem, typeSubstitution2){
            final /* synthetic */ ConstraintSystem $constraintSystem;

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
            {
                this.$constraintSystem = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
        KotlinType kotlinType3 = approximationSubstitutor2.buildSubstitutor().substitute(lambdaExpectedType, Variance.IN_VARIANCE);
        if (kotlinType3 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "approximationSubstitutor\u2026ce.IN_VARIANCE) ?: return");
        KotlinType approximatedLambdaType = kotlinType3;
        Iterable iterable = FunctionTypesKt.getValueParameterTypesFromFunctionType(approximatedLambdaType);
        KotlinType kotlinType4 = newReceiverType;
        Annotations annotations2 = approximatedLambdaType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(newReceiverType);
        void var16_18 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            KotlinType kotlinType5 = p1.getType();
            collection.add(kotlinType5);
        }
        collection = (List)destination$iv$iv;
        SimpleType newExpectedType = FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType4, (List<? extends KotlinType>)collection, null, FunctionTypesKt.getReturnTypeFromFunctionType(approximatedLambdaType), true);
        if (CallResolverUtilKt.hasUnknownFunctionParameter(newExpectedType)) {
            return;
        }
        inferenceData.initSystem();
        TemporaryTraceAndCache temporaryForCoroutine = TemporaryTraceAndCache.create(context, "trace for type argument inference for coroutine", functionLiteral);
        CallCandidateResolutionContext callCandidateResolutionContext = (CallCandidateResolutionContext)context.replaceExpectedType(newExpectedType);
        MutableResolvedCall mutableResolvedCall = context.candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(mutableResolvedCall, "context.candidateCall");
        Object Context2 = ((CallCandidateResolutionContext)((CallCandidateResolutionContext)callCandidateResolutionContext.replaceDataFlowInfo(mutableResolvedCall.getDataFlowInfoForArguments().getInfo(valueArgument))).replaceContextDependency(ContextDependency.INDEPENDENT)).replaceTraceAndCache(temporaryForCoroutine);
        Intrinsics.checkExpressionValueIsNotNull(Context2, "context.replaceExpectedT\u2026he(temporaryForCoroutine)");
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context2;
        this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteral, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, true);
        inferenceData.reportInferenceResult(csBuilder);
    }

    private final boolean checkExpectedTypeForArgument(KotlinType expectedType) {
        return this.getLanguageVersionSettings().supportsFeature(LanguageFeature.ExperimentalBuilderInference) ? FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType) : FunctionTypesKt.isSuspendFunctionType(expectedType);
    }

    public final void checkCoroutineCalls(@NotNull BasicCallResolutionContext context, @NotNull TracingStrategy tracingStrategy, @NotNull OverloadResolutionResultsImpl<?> overloadResults) {
        block5: {
            NewKotlinTypeChecker newKotlinTypeChecker;
            ReceiverValue receiverValue;
            Object resultingDescriptor;
            Intrinsics.checkParameterIsNotNull(context, "context");
            Intrinsics.checkParameterIsNotNull(tracingStrategy, "tracingStrategy");
            Intrinsics.checkParameterIsNotNull(overloadResults, "overloadResults");
            CoroutineInferenceData coroutineInferenceData = CoroutineInferenceUtilKt.access$getCoroutineInferenceData(overloadResults);
            if (coroutineInferenceData == null) {
                return;
            }
            CoroutineInferenceData inferenceData = coroutineInferenceData;
            ResolvedCall resolvedCall2 = overloadResults.getResultingCall();
            Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, "overloadResults.resultingCall");
            ResolvedCall resultingCall = resolvedCall2;
            this.forceInferenceForArguments(context, checkCoroutineCalls.1.INSTANCE);
            CallCompleter callCompleter = this.callCompleter;
            if (callCompleter == null) {
                Intrinsics.throwUninitializedPropertyAccessException("callCompleter");
            }
            callCompleter.completeCall(context, overloadResults, tracingStrategy);
            if (!ArgumentMappingKt.isReallySuccess(resultingCall)) {
                return;
            }
            Object d = resultingDescriptor = resultingCall.getResultingDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(d, "resultingDescriptor");
            if (!this.isGoodCall((CallableDescriptor)d)) {
                inferenceData.badCallHappened();
            }
            this.forceInferenceForArguments(context, (Function2<? super ValueArgument, ? super KotlinType, Unit>)new Function2<ValueArgument, KotlinType, Unit>((MutableResolvedCall)resultingCall, context){
                final /* synthetic */ MutableResolvedCall $resultingCall;
                final /* synthetic */ BasicCallResolutionContext $context;

                public final void invoke(@NotNull ValueArgument valueArgument, @NotNull KotlinType kotlinType) {
                    NewKotlinTypeChecker newKotlinTypeChecker;
                    Intrinsics.checkParameterIsNotNull(valueArgument, "valueArgument");
                    Intrinsics.checkParameterIsNotNull(kotlinType, "kotlinType");
                    ArgumentMapping argumentMapping = this.$resultingCall.getArgumentMapping(valueArgument);
                    if (!(argumentMapping instanceof ArgumentMatch)) {
                        argumentMapping = null;
                    }
                    ArgumentMatch argumentMatch = (ArgumentMatch)argumentMapping;
                    if (argumentMatch == null) {
                        return;
                    }
                    ArgumentMatch argumentMatch2 = argumentMatch;
                    NewKotlinTypeChecker $receiver = newKotlinTypeChecker = NewKotlinTypeChecker.INSTANCE;
                    KotlinType parameterType = CallResolverUtilKt.getEffectiveExpectedType(argumentMatch2.getValueParameter(), valueArgument, this.$context);
                    $receiver.isSubtypeOf(new CoroutineTypeCheckerContext(false), kotlinType.unwrap(), parameterType.unwrap());
                }
                {
                    this.$resultingCall = mutableResolvedCall;
                    this.$context = basicCallResolutionContext;
                    super(2);
                }
            });
            ReceiverParameterDescriptor receiverParameterDescriptor = resultingDescriptor.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor, "resultingDescriptor.exte\u2026ceiverParameter ?: return");
            ReceiverParameterDescriptor extensionReceiver2 = receiverParameterDescriptor;
            boolean allowOnlyTrivialConstraintsForReceiver = this.getLanguageVersionSettings().supportsFeature(LanguageFeature.ExperimentalBuilderInference) ? !AnnotationsForResolveKt.hasBuilderInferenceAnnotation(resultingDescriptor) : false;
            ReceiverValue receiverValue2 = resultingCall.getExtensionReceiver();
            if (receiverValue2 == null) break block5;
            ReceiverValue actualReceiver = receiverValue = receiverValue2;
            NewKotlinTypeChecker $receiver = newKotlinTypeChecker = NewKotlinTypeChecker.INSTANCE;
            TypeCheckerContext typeCheckerContext = new CoroutineTypeCheckerContext(allowOnlyTrivialConstraintsForReceiver);
            ReceiverValue receiverValue3 = actualReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue3, "actualReceiver");
            UnwrappedType unwrappedType = receiverValue3.getType().unwrap();
            ReceiverValue receiverValue4 = extensionReceiver2.getValue();
            Intrinsics.checkExpressionValueIsNotNull(receiverValue4, "extensionReceiver.value");
            $receiver.isSubtypeOf(typeCheckerContext, unwrappedType, receiverValue4.getType().unwrap());
        }
    }

    private final boolean containsTypeTemplate(@NotNull KotlinType $receiver) {
        return TypeUtilsKt.contains($receiver, containsTypeTemplate.1.INSTANCE);
    }

    private final boolean isGoodCall(CallableDescriptor resultingDescriptor) {
        if (!this.getLanguageVersionSettings().supportsFeature(LanguageFeature.ExperimentalBuilderInference)) {
            return this.isGoodCallForOldCoroutines(resultingDescriptor);
        }
        if (DescriptorUtilsKt.isExtension(resultingDescriptor) && !AnnotationsForResolveKt.hasBuilderInferenceAnnotation(resultingDescriptor)) {
            Annotated annotated = resultingDescriptor.getExtensionReceiverParameter();
            return annotated != null && (annotated = annotated.getType()) != null && !this.containsTypeTemplate((KotlinType)annotated);
        }
        KotlinType kotlinType = resultingDescriptor.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "resultingDescriptor.returnType ?: return false");
        KotlinType returnType2 = kotlinType;
        return !this.containsTypeTemplate(returnType2);
    }

    private final boolean isGoodCallForOldCoroutines(CallableDescriptor resultingDescriptor) {
        boolean bl;
        block6: {
            KotlinType kotlinType = resultingDescriptor.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "resultingDescriptor.returnType ?: return false");
            KotlinType returnType2 = kotlinType;
            if (this.containsTypeTemplate(returnType2)) {
                return false;
            }
            if (!(resultingDescriptor instanceof FunctionDescriptor) || ((FunctionDescriptor)resultingDescriptor).isSuspend()) {
                return true;
            }
            List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)resultingDescriptor).getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "resultingDescriptor.valueParameters");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ValueParameterDescriptor it;
                    ValueParameterDescriptor valueParameterDescriptor = it = (ValueParameterDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "it");
                    KotlinType kotlinType2 = valueParameterDescriptor.getType();
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "it.type");
                    if (!this.containsTypeTemplate(kotlinType2)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return !bl;
    }

    private final void forceInferenceForArguments(CallResolutionContext<?> context, Function2<? super ValueArgument, ? super KotlinType, Unit> callback) {
        MutableDataFlowInfoForArguments mutableDataFlowInfoForArguments = context.dataFlowInfoForArguments;
        Intrinsics.checkExpressionValueIsNotNull(mutableDataFlowInfoForArguments, "context.dataFlowInfoForArguments");
        MutableDataFlowInfoForArguments infoForArguments = mutableDataFlowInfoForArguments;
        Call call2 = context.call;
        Intrinsics.checkExpressionValueIsNotNull(call2, "context.call");
        Call call3 = call2;
        CallResolutionContext baseContext = (CallResolutionContext)((CallResolutionContext)context.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        for (ValueArgument valueArgument : call3.getValueArguments()) {
            KotlinType kotlinType;
            KtExpression expression2;
            if (valueArgument.getArgumentExpression() == null) {
                continue;
            }
            Object Context2 = baseContext.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            Intrinsics.checkExpressionValueIsNotNull(Context2, "baseContext.replaceDataF\u2026uments.getInfo(argument))");
            KotlinTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression2, (CallResolutionContext)Context2);
            if (typeInfoForCall.getType() == null) continue;
            KotlinType it = kotlinType;
            ValueArgument valueArgument2 = valueArgument;
            Intrinsics.checkExpressionValueIsNotNull(valueArgument2, "argument");
            callback.invoke(valueArgument2, it);
        }
    }

    private final KotlinTypeInfo getArgumentTypeInfo(KtExpression expression2, CallResolutionContext<?> context) {
        KtFunction ktFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context);
        if (ktFunction != null) {
            KtFunction ktFunction2;
            KtFunction it = ktFunction2 = ktFunction;
            KotlinTypeInfo kotlinTypeInfo = this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression2, it, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, false);
            Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "argumentTypeResolver.get\u2026UNCTION_ARGUMENTS, false)");
            return kotlinTypeInfo;
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context);
        if (ktCallableReferenceExpression != null) {
            KtCallableReferenceExpression ktCallableReferenceExpression2;
            KtCallableReferenceExpression it = ktCallableReferenceExpression2 = ktCallableReferenceExpression;
            KotlinTypeInfo kotlinTypeInfo = this.argumentTypeResolver.getCallableReferenceTypeInfo(expression2, it, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
            Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "argumentTypeResolver.get\u2026SOLVE_FUNCTION_ARGUMENTS)");
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, context);
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "expressionTypingServices\u2026Info(expression, context)");
        return kotlinTypeInfo;
    }

    @NotNull
    public final ArgumentTypeResolver getArgumentTypeResolver() {
        return this.argumentTypeResolver;
    }

    @NotNull
    public final ExpressionTypingServices getExpressionTypingServices() {
        return this.expressionTypingServices;
    }

    public CoroutineInferenceSupport(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull(expressionTypingServices, "expressionTypingServices");
        this.argumentTypeResolver = argumentTypeResolver;
        this.expressionTypingServices = expressionTypingServices;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/CoroutineInferenceSupport$CoroutineTypeCheckerContext;", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext;", "allowOnlyTrivialConstraints", "", "(Z)V", "addSubtypeConstraint", "subType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "superType", "(Lorg/jetbrains/kotlin/types/UnwrappedType;Lorg/jetbrains/kotlin/types/UnwrappedType;)Ljava/lang/Boolean;", "frontend"})
    private static final class CoroutineTypeCheckerContext
    extends TypeCheckerContext {
        private final boolean allowOnlyTrivialConstraints;

        @Override
        @Nullable
        public Boolean addSubtypeConstraint(@NotNull UnwrappedType subType, @NotNull UnwrappedType superType) {
            block3: {
                TypeTemplate typeTemplate;
                Object object;
                TypeTemplate typeTemplate2;
                Intrinsics.checkParameterIsNotNull(subType, "subType");
                Intrinsics.checkParameterIsNotNull(superType, "superType");
                UnwrappedType unwrappedType = subType;
                if (!(unwrappedType instanceof TypeTemplate)) {
                    unwrappedType = null;
                }
                if ((typeTemplate2 = (TypeTemplate)unwrappedType) == null) {
                    UnwrappedType unwrappedType2 = superType;
                    if (!(unwrappedType2 instanceof TypeTemplate)) {
                        unwrappedType2 = null;
                    }
                    typeTemplate2 = (TypeTemplate)unwrappedType2;
                }
                if ((object = (typeTemplate = typeTemplate2)) == null || (object = ((TypeTemplate)object).getCoroutineInferenceData()) == null) break block3;
                ((CoroutineInferenceData)object).addConstraint$frontend(subType, superType, this.allowOnlyTrivialConstraints);
            }
            return null;
        }

        public CoroutineTypeCheckerContext(boolean allowOnlyTrivialConstraints) {
            super(true, false, 2, null);
            this.allowOnlyTrivialConstraints = allowOnlyTrivialConstraints;
        }
    }
}

