/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

public class ObjectCache {
    public Object[] keyTable;
    public int[] valueTable;
    int elementSize = 0;
    int threshold;

    public ObjectCache() {
        this(13);
    }

    public ObjectCache(int n) {
        this.threshold = (int)((float)n * 0.66f);
        this.keyTable = new Object[n];
        this.valueTable = new int[n];
    }

    public void clear() {
        int n = this.keyTable.length;
        while (--n >= 0) {
            this.keyTable[n] = null;
            this.valueTable[n] = 0;
        }
        this.elementSize = 0;
    }

    public boolean containsKey(Object object) {
        int n = this.hashCode(object);
        int n2 = this.keyTable.length;
        while (this.keyTable[n] != null) {
            if (this.keyTable[n] == object) {
                return true;
            }
            if (++n != n2) continue;
            n = 0;
        }
        return false;
    }

    public int get(Object object) {
        int n = this.hashCode(object);
        int n2 = this.keyTable.length;
        while (this.keyTable[n] != null) {
            if (this.keyTable[n] == object) {
                return this.valueTable[n];
            }
            if (++n != n2) continue;
            n = 0;
        }
        return -1;
    }

    public int hashCode(Object object) {
        return (object.hashCode() & Integer.MAX_VALUE) % this.keyTable.length;
    }

    public int put(Object object, int n) {
        int n2 = this.hashCode(object);
        int n3 = this.keyTable.length;
        while (this.keyTable[n2] != null) {
            if (this.keyTable[n2] == object) {
                this.valueTable[n2] = n;
                return this.valueTable[n2];
            }
            if (++n2 != n3) continue;
            n2 = 0;
        }
        this.keyTable[n2] = object;
        this.valueTable[n2] = n;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return n;
    }

    private void rehash() {
        ObjectCache objectCache = new ObjectCache(this.keyTable.length * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            if (this.keyTable[n] == null) continue;
            objectCache.put(this.keyTable[n], this.valueTable[n]);
        }
        this.keyTable = objectCache.keyTable;
        this.valueTable = objectCache.valueTable;
        this.threshold = objectCache.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        int n = this.size();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < n; ++i) {
            if (this.keyTable[i] != null) {
                stringBuffer.append(this.keyTable[i]).append("->").append(this.valueTable[i]);
            }
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

