/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.mail.internet.SharedInputStream;

public class SharedByteArrayInputStream
extends ByteArrayInputStream
implements SharedInputStream {
    private int off;

    public SharedByteArrayInputStream(byte[] buf) {
        super(buf);
        this.off = 0;
    }

    public SharedByteArrayInputStream(byte[] buf, int off, int len) {
        super(buf, off, len);
        this.off = off;
    }

    @Override
    public long getPosition() {
        return this.pos - this.off;
    }

    @Override
    public InputStream newStream(long start, long end) {
        int len = (int)(end - start);
        return new SharedByteArrayInputStream(this.buf, this.off + (int)start, len);
    }
}

