/*
 * Decompiled with CFR 0.152.
 */
package com.sun.inputmethods.internal.codepointim;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodContext;
import java.io.IOException;
import java.text.AttributedString;
import java.util.Locale;

public class CodePointInputMethod
implements InputMethod {
    private static final int UNSET = 0;
    private static final int ESCAPE = 1;
    private static final int SPECIAL_ESCAPE = 2;
    private static final int SURROGATE_PAIR = 3;
    private InputMethodContext context;
    private Locale locale;
    private StringBuffer buffer;
    private int insertionPoint;
    private int format = 0;

    @Override
    public void dispatchEvent(AWTEvent event) {
        boolean notInCompositionMode;
        if (!(event instanceof KeyEvent)) {
            return;
        }
        KeyEvent e = (KeyEvent)event;
        int eventID = event.getID();
        boolean bl = notInCompositionMode = this.buffer.length() == 0;
        if (eventID == 401) {
            if (notInCompositionMode) {
                return;
            }
            switch (e.getKeyCode()) {
                case 37: {
                    this.moveCaretLeft();
                    break;
                }
                case 39: {
                    this.moveCaretRight();
                }
            }
        } else if (eventID == 400) {
            char c = e.getKeyChar();
            if (notInCompositionMode) {
                if (c != '\\') {
                    return;
                }
                this.startComposition();
            } else {
                switch (c) {
                    case ' ': {
                        this.finishComposition();
                        break;
                    }
                    case '\u007f': {
                        this.deleteCharacter();
                        break;
                    }
                    case '\b': {
                        this.deletePreviousCharacter();
                        break;
                    }
                    case '\u001b': {
                        this.cancelComposition();
                        break;
                    }
                    case '\t': 
                    case '\n': {
                        this.sendCommittedText();
                        break;
                    }
                    default: {
                        this.composeUnicodeEscape(c);
                    }
                }
            }
        } else if (notInCompositionMode) {
            return;
        }
        e.consume();
    }

    private void composeUnicodeEscape(char c) {
        switch (this.buffer.length()) {
            case 1: {
                this.waitEscapeCharacter(c);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.waitDigit(c);
                break;
            }
            case 5: {
                if (this.format == 2) {
                    this.waitDigit(c);
                    break;
                }
                this.waitDigit2(c);
                break;
            }
            case 6: {
                if (this.format == 2) {
                    this.waitDigit(c);
                    break;
                }
                if (this.format == 3) {
                    this.waitBackSlashOrLowSurrogate(c);
                    break;
                }
                CodePointInputMethod.beep();
                break;
            }
            case 7: {
                this.waitDigit(c);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (this.format == 3) {
                    this.waitDigit(c);
                    break;
                }
                CodePointInputMethod.beep();
                break;
            }
            default: {
                CodePointInputMethod.beep();
            }
        }
    }

    private void waitEscapeCharacter(char c) {
        if (c == 'u' || c == 'U') {
            this.buffer.append(c);
            ++this.insertionPoint;
            this.sendComposedText();
            this.format = c == 'u' ? 1 : 2;
        } else {
            if (c != '\\') {
                this.buffer.append(c);
                ++this.insertionPoint;
            }
            this.sendCommittedText();
        }
    }

    private void waitDigit(char c) {
        if (Character.digit(c, 16) != -1) {
            this.buffer.insert(this.insertionPoint++, c);
            this.sendComposedText();
        } else {
            CodePointInputMethod.beep();
        }
    }

    private void waitDigit2(char c) {
        if (Character.digit(c, 16) != -1) {
            this.buffer.insert(this.insertionPoint++, c);
            char codePoint = (char)this.getCodePoint(this.buffer, 2, 5);
            if (Character.isHighSurrogate(codePoint)) {
                this.format = 3;
                this.buffer.append("\\u");
                this.insertionPoint = 8;
            } else {
                this.format = 1;
            }
            this.sendComposedText();
        } else {
            CodePointInputMethod.beep();
        }
    }

    private void waitBackSlashOrLowSurrogate(char c) {
        if (this.insertionPoint == 6) {
            if (c == '\\') {
                this.buffer.append(c);
                this.buffer.append('u');
                this.insertionPoint = 8;
                this.sendComposedText();
            } else if (Character.digit(c, 16) != -1) {
                this.buffer.append("\\u");
                this.buffer.append(c);
                this.insertionPoint = 9;
                this.sendComposedText();
            } else {
                CodePointInputMethod.beep();
            }
        } else {
            CodePointInputMethod.beep();
        }
    }

    private void sendComposedText() {
        AttributedString as = new AttributedString(this.buffer.toString());
        as.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT);
        this.context.dispatchInputMethodEvent(1100, as.getIterator(), 0, TextHitInfo.leading(this.insertionPoint), null);
    }

    private void sendCommittedText() {
        AttributedString as = new AttributedString(this.buffer.toString());
        this.context.dispatchInputMethodEvent(1100, as.getIterator(), this.buffer.length(), TextHitInfo.leading(this.insertionPoint), null);
        this.buffer.setLength(0);
        this.insertionPoint = 0;
        this.format = 0;
    }

    private void moveCaretLeft() {
        int len = this.buffer.length();
        if (--this.insertionPoint < 2) {
            ++this.insertionPoint;
            CodePointInputMethod.beep();
        } else if (this.format == 3 && this.insertionPoint == 7) {
            this.insertionPoint = 8;
            CodePointInputMethod.beep();
        }
        this.context.dispatchInputMethodEvent(1101, null, 0, TextHitInfo.leading(this.insertionPoint), null);
    }

    private void moveCaretRight() {
        int len = this.buffer.length();
        if (++this.insertionPoint > len) {
            this.insertionPoint = len;
            CodePointInputMethod.beep();
        }
        this.context.dispatchInputMethodEvent(1101, null, 0, TextHitInfo.leading(this.insertionPoint), null);
    }

    private void deletePreviousCharacter() {
        if (this.insertionPoint == 2) {
            if (this.buffer.length() == 2) {
                this.cancelComposition();
            } else {
                CodePointInputMethod.beep();
            }
        } else if (this.insertionPoint == 8) {
            if (this.buffer.length() == 8) {
                if (this.format == 3) {
                    this.buffer.deleteCharAt(--this.insertionPoint);
                }
                this.buffer.deleteCharAt(--this.insertionPoint);
                this.sendComposedText();
            } else {
                CodePointInputMethod.beep();
            }
        } else {
            this.buffer.deleteCharAt(--this.insertionPoint);
            if (this.buffer.length() == 0) {
                this.sendCommittedText();
            } else {
                this.sendComposedText();
            }
        }
    }

    private void deleteCharacter() {
        if (this.insertionPoint < this.buffer.length()) {
            this.buffer.deleteCharAt(this.insertionPoint);
            this.sendComposedText();
        } else {
            CodePointInputMethod.beep();
        }
    }

    private void startComposition() {
        this.buffer.append('\\');
        this.insertionPoint = 1;
        this.sendComposedText();
    }

    private void cancelComposition() {
        this.buffer.setLength(0);
        this.insertionPoint = 0;
        this.sendCommittedText();
    }

    private void finishComposition() {
        char[] codePoint;
        int len = this.buffer.length();
        if (len == 6 && this.format != 2) {
            char codePoint2 = (char)this.getCodePoint(this.buffer, 2, 5);
            if (Character.isValidCodePoint(codePoint2) && codePoint2 != '\uffff') {
                this.buffer.setLength(0);
                this.buffer.append(codePoint2);
                this.sendCommittedText();
                return;
            }
        } else if (len == 8 && this.format == 2) {
            int codePoint3 = this.getCodePoint(this.buffer, 2, 7);
            if (Character.isValidCodePoint(codePoint3) && codePoint3 != 65535) {
                this.buffer.setLength(0);
                this.buffer.appendCodePoint(codePoint3);
                this.sendCommittedText();
                return;
            }
        } else if (len == 12 && this.format == 3 && Character.isHighSurrogate((codePoint = new char[]{(char)this.getCodePoint(this.buffer, 2, 5), (char)this.getCodePoint(this.buffer, 8, 11)})[0]) && Character.isLowSurrogate(codePoint[1])) {
            this.buffer.setLength(0);
            this.buffer.append(codePoint);
            this.sendCommittedText();
            return;
        }
        CodePointInputMethod.beep();
    }

    private int getCodePoint(StringBuffer sb, int from, int to) {
        int value = 0;
        for (int i = from; i <= to; ++i) {
            value = (value << 4) + Character.digit(sb.charAt(i), 16);
        }
        return value;
    }

    private static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void activate() {
        if (this.buffer == null) {
            this.buffer = new StringBuffer(12);
            this.insertionPoint = 0;
        }
    }

    @Override
    public void deactivate(boolean isTemporary) {
        if (!isTemporary) {
            this.buffer = null;
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public Object getControlObject() {
        return null;
    }

    @Override
    public void endComposition() {
        this.sendCommittedText();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void hideWindows() {
    }

    @Override
    public boolean isCompositionEnabled() {
        return true;
    }

    @Override
    public void notifyClientWindowChange(Rectangle location) {
    }

    @Override
    public void reconvert() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNotify() {
    }

    @Override
    public void setCharacterSubsets(Character.Subset[] subsets) {
    }

    @Override
    public void setCompositionEnabled(boolean enable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInputMethodContext(InputMethodContext context) {
        this.context = context;
    }

    @Override
    public boolean setLocale(Locale locale) {
        this.locale = locale;
        return true;
    }
}

