/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.P3;
import javajs.util.T3;
import org.jmol.adapter.readers.simple.InputReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;

public class MopacArchiveReader
extends InputReader {
    private String energyWithUnits;

    protected void initializeReader() {
        this.asc.newAtomSet();
        if (!this.checkFilterKey("NOCENTER")) {
            this.doCentralize = true;
        }
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("=") == 34) {
            return this.getMyValue();
        }
        if (this.line.indexOf("FINAL GEOMETRY OBTAINED") >= 0) {
            return this.readCoordinates();
        }
        return true;
    }

    private boolean getMyValue() {
        if (this.line.substring(0, 10).trim().length() != 0) {
            return true;
        }
        String key = this.line.substring(0, 34).trim().replace(' ', '_');
        String value = this.line.substring(35).trim();
        this.asc.setCurrentModelInfo(key, (Object)value);
        if (this.line.indexOf("TOTAL ENERGY") >= 0) {
            String[] tokens = this.getTokens();
            this.energyWithUnits = " (" + tokens[3] + " " + tokens[4] + ")";
            this.asc.setAtomSetEnergy(tokens[3], this.parseFloatStr(tokens[3]));
        }
        return true;
    }

    private boolean readCoordinates() throws Exception {
        this.rd();
        this.line = this.rd().trim();
        this.asc.setAtomSetName(this.line + (this.energyWithUnits == null ? "" : this.energyWithUnits));
        this.rd();
        Atom atom = null;
        String sym = null;
        this.setFractionalCoordinates(false);
        while (this.rd() != null && this.line.length() >= 50) {
            atom = new Atom();
            this.vAtoms.addLast((Object)atom);
            atom.x = this.parseFloatRange(this.line, 5, 18);
            atom.y = this.parseFloatRange(this.line, 21, 34);
            atom.z = this.parseFloatRange(this.line, 37, 50);
            if (this.line.length() > 58 && this.line.charAt(58) != ' ') {
                switch (this.ac) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        atom.sub((T3)this.vAtoms.get(0));
                        break;
                    }
                    case 2: {
                        this.setAtom(atom, 0, 1, 0, atom.x, atom.y, Float.MAX_VALUE);
                        break;
                    }
                    default: {
                        this.setAtom(atom, this.parseIntRange(this.line, 54, 59) - 1, this.parseIntRange(this.line, 60, 65) - 1, this.parseIntRange(this.line, 66, 71) - 1, atom.x, atom.y, atom.z);
                    }
                }
            }
            atom.elementSymbol = sym = this.line.substring(1, 3).trim();
            if (sym.equals("Tv")) continue;
            ++this.ac;
            if (this.line.length() >= 84) {
                atom.partialCharge = this.parseFloatRange(this.line, 76, 84);
            }
            if (JmolAdapter.getElementNumber((String)sym) != 0) {
                this.asc.addAtom(atom);
            }
            this.setAtomCoord(atom);
        }
        if (sym.equals("Tv")) {
            int i;
            int nTv;
            this.setSpaceGroupName("P1");
            for (int i2 = nTv = this.vAtoms.size() - this.ac; i2 < 3; ++i2) {
                this.vAtoms.addLast((Object)new Atom());
            }
            float[] xyz = new float[9];
            for (i = 0; i < 3; ++i) {
                int j = i * 3;
                atom = (Atom)this.vAtoms.get(this.ac + i);
                if (!Float.isNaN(atom.x)) {
                    xyz[j] = atom.x;
                    xyz[j + 1] = atom.y;
                    xyz[j + 2] = atom.z;
                }
                this.addExplicitLatticeVector(i, xyz, j);
            }
            i = this.ac;
            while (--i >= 0) {
                this.setAtomCoord((Atom)this.vAtoms.get(i));
            }
            P3 ptMax = P3.new3((float)-3.4028235E38f, (float)-3.4028235E38f, (float)-3.4028235E38f);
            P3 ptMin = P3.new3((float)Float.MAX_VALUE, (float)Float.MAX_VALUE, (float)Float.MAX_VALUE);
            if (this.doCentralize) {
                int i3 = this.ac;
                while (--i3 >= 0) {
                    atom = (Atom)this.vAtoms.get(i3);
                    ptMax.x = Math.max(ptMax.x, atom.x);
                    ptMax.y = Math.max(ptMax.y, atom.y);
                    ptMax.z = Math.max(ptMax.z, atom.z);
                    ptMin.x = Math.min(ptMin.x, atom.x);
                    ptMin.y = Math.min(ptMin.y, atom.y);
                    ptMin.z = Math.min(ptMin.z, atom.z);
                }
                P3 ptCenter = new P3();
                switch (nTv) {
                    case 3: {
                        ptCenter.x = 0.5f;
                    }
                    case 2: {
                        ptCenter.y = 0.5f;
                    }
                    case 1: {
                        ptCenter.z = 0.5f;
                    }
                }
                ptCenter.scaleAdd2(-0.5f, (T3)ptMin, (T3)ptCenter);
                ptCenter.scaleAdd2(-0.5f, (T3)ptMax, (T3)ptCenter);
                int i4 = this.ac;
                while (--i4 >= 0) {
                    ((Atom)this.vAtoms.get(i4)).add((T3)ptCenter);
                }
            }
            this.doCentralize = false;
        }
        return true;
    }
}

